/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.editors;

import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.extractors.FormatterCreator;
import com.intellij.database.extractors.ObjectFormatterConfig;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.grid.editors.BoundaryValueResolver;
import com.intellij.database.run.ui.grid.editors.FormatsCache;
import com.intellij.database.run.ui.grid.editors.Formatter;
import com.intellij.database.run.ui.grid.editors.GridCellEditorHelper;
import com.intellij.database.settings.DataGridSettings;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ObjectUtils;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.util.TimeZone;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DataGridFormattersUtilCore {
    public static final LocalDate START_DATE = LocalDate.of(1970, 1, 1);
    private static final Logger LOG = Logger.getInstance(DataGridFormattersUtilCore.class);
    private static final double START_JULIAN_DATE = 2440587.5;
    private static final int MS_PER_DAY = 86400000;
    private static final int DEFAULT_ERA = 1;

    private DataGridFormattersUtilCore() {
    }

    public static int getEra(@NotNull TemporalAccessor date) {
        if (date == null) {
            DataGridFormattersUtilCore.$$$reportNull$$$0(0);
        }
        return date.isSupported(ChronoField.ERA) ? date.get(ChronoField.ERA) : 1;
    }

    @NotNull
    public static Timestamp fromOffsetDateTime(@NotNull OffsetDateTime offsetDateTime, @NotNull FormatsCache formatsCache, @NotNull FormatterCreator creator, @Nullable ObjectFormatterConfig config) {
        Timestamp timestamp;
        if (offsetDateTime == null) {
            DataGridFormattersUtilCore.$$$reportNull$$$0(1);
        }
        if (formatsCache == null) {
            DataGridFormattersUtilCore.$$$reportNull$$$0(2);
        }
        if (creator == null) {
            DataGridFormattersUtilCore.$$$reportNull$$$0(3);
        }
        DateFormat format = formatsCache.get(FormatsCache.SIMPLE_TIMESTAMP_FORMAT_PROVIDER, creator);
        format.setTimeZone(DataGridFormattersUtilCore.getTimeZoneOrDefault(config));
        try {
            DateTimeFormatter offsetDateTimeFormatter = formatsCache.get(FormatsCache.OFFSET_DATE_TIME_FORMAT_PROVIDER, creator);
            java.util.Date date = (java.util.Date)format.parseObject(offsetDateTimeFormatter.format(offsetDateTime));
            Timestamp timestamp2 = new Timestamp(date.getTime());
            timestamp2.setNanos(offsetDateTime.getNano());
            timestamp = timestamp2;
        }
        catch (ParseException e) {
            LOG.warn((Throwable)e);
            Timestamp timestamp3 = Timestamp.valueOf(offsetDateTime.atZoneSameInstant(DataGridFormattersUtilCore.getZoneIdOrDefault(config)).toLocalDateTime());
            if (timestamp3 == null) {
                DataGridFormattersUtilCore.$$$reportNull$$$0(5);
            }
            return timestamp3;
        }
        if (timestamp == null) {
            DataGridFormattersUtilCore.$$$reportNull$$$0(4);
        }
        return timestamp;
    }

    @NotNull
    public static TimeZone getDefaultTimeZone() {
        TimeZone timeZone = TimeZone.getTimeZone("UTC");
        if (timeZone == null) {
            DataGridFormattersUtilCore.$$$reportNull$$$0(6);
        }
        return timeZone;
    }

    @NotNull
    public static ZoneOffset getLocalTimeOffset() {
        ZoneOffset zoneOffset = ZonedDateTime.of(LocalDateTime.of(1970, 1, 1, 0, 0, 1), ZoneId.systemDefault()).getOffset();
        if (zoneOffset == null) {
            DataGridFormattersUtilCore.$$$reportNull$$$0(7);
        }
        return zoneOffset;
    }

    @NotNull
    public static ZoneOffset getDefaultOffset() {
        ZoneOffset zoneOffset = ZoneOffset.UTC;
        if (zoneOffset == null) {
            DataGridFormattersUtilCore.$$$reportNull$$$0(8);
        }
        return zoneOffset;
    }

    @NotNull
    public static OffsetDateTime fromTimestamp(@NotNull Timestamp timestamp, @NotNull FormatsCache formatsCache, @NotNull FormatterCreator formatterCreator, @Nullable ObjectFormatterConfig config) {
        OffsetDateTime offsetDateTime;
        if (timestamp == null) {
            DataGridFormattersUtilCore.$$$reportNull$$$0(9);
        }
        if (formatsCache == null) {
            DataGridFormattersUtilCore.$$$reportNull$$$0(10);
        }
        if (formatterCreator == null) {
            DataGridFormattersUtilCore.$$$reportNull$$$0(11);
        }
        DateFormat format = formatsCache.get(FormatsCache.SIMPLE_TIMESTAMP_FORMAT_PROVIDER, formatterCreator);
        format.setTimeZone(DataGridFormattersUtilCore.getDefaultTimeZone());
        ZoneOffset zoneOffset = DataGridFormattersUtilCore.getZoneOffsetOrDefault(config, timestamp.toInstant());
        try {
            offsetDateTime = formatsCache.get(FormatsCache.OFFSET_DATE_TIME_FORMAT_PROVIDER, formatterCreator).parse((CharSequence)format.format(timestamp), OffsetDateTime::from).withNano(timestamp.getNanos()).withOffsetSameInstant(zoneOffset);
        }
        catch (DateTimeParseException e) {
            LOG.warn((Throwable)e);
            OffsetDateTime offsetDateTime2 = timestamp.toLocalDateTime().atZone(ZoneId.systemDefault()).toOffsetDateTime().withOffsetSameInstant(zoneOffset);
            if (offsetDateTime2 == null) {
                DataGridFormattersUtilCore.$$$reportNull$$$0(13);
            }
            return offsetDateTime2;
        }
        if (offsetDateTime == null) {
            DataGridFormattersUtilCore.$$$reportNull$$$0(12);
        }
        return offsetDateTime;
    }

    @NotNull
    public static LocalDateTime fromDateToLocalDateTime(@NotNull java.util.Date date, @NotNull FormatsCache formatsCache, @NotNull FormatterCreator formatterCreator, @Nullable ObjectFormatterConfig config) {
        LocalDateTime localDateTime;
        if (date == null) {
            DataGridFormattersUtilCore.$$$reportNull$$$0(14);
        }
        if (formatsCache == null) {
            DataGridFormattersUtilCore.$$$reportNull$$$0(15);
        }
        if (formatterCreator == null) {
            DataGridFormattersUtilCore.$$$reportNull$$$0(16);
        }
        DateFormat format = formatsCache.get(FormatsCache.TIMESTAMP_WITH_MILLI_FORMAT_PROVIDER, formatterCreator);
        format.setTimeZone(DataGridFormattersUtilCore.getTimeZoneOrDefault(config));
        try {
            localDateTime = formatsCache.get(FormatsCache.LOCAL_DATE_WITH_MILLI_FORMAT_PROVIDER, formatterCreator).parse((CharSequence)formatsCache.get(FormatsCache.TIMESTAMP_WITH_MILLI_FORMAT_PROVIDER, formatterCreator).format(date), LocalDateTime::from);
        }
        catch (DateTimeParseException e) {
            LOG.warn((Throwable)e);
            Instant instant = date.toInstant();
            LocalDateTime localDateTime2 = LocalDateTime.ofInstant(instant, ZoneOffset.UTC).atOffset(DataGridFormattersUtilCore.getZoneOffsetOrDefault(config, instant)).toLocalDateTime();
            if (localDateTime2 == null) {
                DataGridFormattersUtilCore.$$$reportNull$$$0(18);
            }
            return localDateTime2;
        }
        if (localDateTime == null) {
            DataGridFormattersUtilCore.$$$reportNull$$$0(17);
        }
        return localDateTime;
    }

    public static boolean isEmptyTime(@NotNull TemporalAccessor temporalAccessor) {
        if (temporalAccessor == null) {
            DataGridFormattersUtilCore.$$$reportNull$$$0(19);
        }
        return !(temporalAccessor.isSupported(ChronoField.HOUR_OF_DAY) && temporalAccessor.get(ChronoField.HOUR_OF_DAY) != 0 || temporalAccessor.isSupported(ChronoField.MINUTE_OF_HOUR) && temporalAccessor.get(ChronoField.MINUTE_OF_HOUR) != 0 || temporalAccessor.isSupported(ChronoField.SECOND_OF_MINUTE) && temporalAccessor.get(ChronoField.SECOND_OF_MINUTE) != 0 || temporalAccessor.isSupported(ChronoField.MILLI_OF_SECOND) && temporalAccessor.get(ChronoField.MILLI_OF_SECOND) != 0);
    }

    @NotNull
    public static LocalDate fromDate(@NotNull java.util.Date date, @NotNull FormatsCache formatsCache, @NotNull FormatterCreator formatterCreator) {
        LocalDate localDate;
        if (date == null) {
            DataGridFormattersUtilCore.$$$reportNull$$$0(20);
        }
        if (formatsCache == null) {
            DataGridFormattersUtilCore.$$$reportNull$$$0(21);
        }
        if (formatterCreator == null) {
            DataGridFormattersUtilCore.$$$reportNull$$$0(22);
        }
        DateFormat format = formatsCache.get(FormatsCache.SIMPLE_DATE_FORMAT_PROVIDER, formatterCreator);
        format.setTimeZone(DataGridFormattersUtilCore.getDefaultTimeZone());
        try {
            localDate = formatsCache.get(FormatsCache.LOCAL_DATE_FORMAT_PROVIDER, formatterCreator).parse((CharSequence)format.format(date), LocalDate::from);
        }
        catch (DateTimeParseException e) {
            LOG.warn((Throwable)e);
            LocalDate localDate2 = date instanceof Date ? ((Date)date).toLocalDate() : LocalDateTime.ofInstant(date.toInstant(), ZoneOffset.UTC).atOffset(DataGridFormattersUtilCore.getDefaultOffset()).toLocalDate();
            if (localDate2 == null) {
                DataGridFormattersUtilCore.$$$reportNull$$$0(24);
            }
            return localDate2;
        }
        if (localDate == null) {
            DataGridFormattersUtilCore.$$$reportNull$$$0(23);
        }
        return localDate;
    }

    @NotNull
    public static java.util.Date fromLocalDateTime(@NotNull LocalDateTime dateTime, @NotNull FormatsCache formatsCache, @NotNull FormatterCreator formatterCreator, @Nullable ObjectFormatterConfig config) {
        java.util.Date date;
        if (dateTime == null) {
            DataGridFormattersUtilCore.$$$reportNull$$$0(25);
        }
        if (formatsCache == null) {
            DataGridFormattersUtilCore.$$$reportNull$$$0(26);
        }
        if (formatterCreator == null) {
            DataGridFormattersUtilCore.$$$reportNull$$$0(27);
        }
        DateFormat format = formatsCache.get(FormatsCache.TIMESTAMP_WITH_MILLI_FORMAT_PROVIDER, formatterCreator);
        format.setTimeZone(DataGridFormattersUtilCore.getTimeZoneOrDefault(config));
        try {
            date = (java.util.Date)format.parseObject(formatsCache.get(FormatsCache.LOCAL_DATE_WITH_MILLI_FORMAT_PROVIDER, formatterCreator).format(dateTime));
        }
        catch (ParseException e) {
            LOG.warn((Throwable)e);
            java.util.Date date2 = java.util.Date.from(dateTime.atZone(DataGridFormattersUtilCore.getZoneIdOrDefault(config)).toInstant());
            if (date2 == null) {
                DataGridFormattersUtilCore.$$$reportNull$$$0(29);
            }
            return date2;
        }
        if (date == null) {
            DataGridFormattersUtilCore.$$$reportNull$$$0(28);
        }
        return date;
    }

    @NotNull
    public static java.util.Date fromLocalDate(@NotNull LocalDate date, @NotNull FormatsCache formatsCache, @NotNull FormatterCreator formatterCreator) {
        java.util.Date date2;
        if (date == null) {
            DataGridFormattersUtilCore.$$$reportNull$$$0(30);
        }
        if (formatsCache == null) {
            DataGridFormattersUtilCore.$$$reportNull$$$0(31);
        }
        if (formatterCreator == null) {
            DataGridFormattersUtilCore.$$$reportNull$$$0(32);
        }
        DateFormat format = formatsCache.get(FormatsCache.SIMPLE_DATE_FORMAT_PROVIDER, formatterCreator);
        format.setTimeZone(DataGridFormattersUtilCore.getDefaultTimeZone());
        try {
            date2 = (java.util.Date)format.parseObject(formatsCache.get(FormatsCache.LOCAL_DATE_FORMAT_PROVIDER, formatterCreator).format(date));
        }
        catch (ParseException e) {
            LOG.warn((Throwable)e);
            java.util.Date date3 = java.util.Date.from(date.atStartOfDay().toInstant(ZoneOffset.UTC));
            if (date3 == null) {
                DataGridFormattersUtilCore.$$$reportNull$$$0(34);
            }
            return date3;
        }
        if (date2 == null) {
            DataGridFormattersUtilCore.$$$reportNull$$$0(33);
        }
        return date2;
    }

    @Nullable
    private static java.util.Date parseDateFromNumber(@NotNull String s) {
        if (s == null) {
            DataGridFormattersUtilCore.$$$reportNull$$$0(35);
        }
        try {
            return new java.util.Date(Long.parseLong(s));
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return new java.util.Date(DataGridFormattersUtilCore.fromJulian(Double.parseDouble(s)));
            }
            catch (NumberFormatException numberFormatException2) {
                return null;
            }
        }
    }

    private static long fromJulian(double d) {
        return (long)(d - 2440587.5) * 86400000L;
    }

    @NotNull
    private static java.util.Date getUtcDate(@NotNull FormatsCache formatsCache, @NotNull FormatterCreator formatterCreator) {
        java.util.Date date;
        if (formatsCache == null) {
            DataGridFormattersUtilCore.$$$reportNull$$$0(36);
        }
        if (formatterCreator == null) {
            DataGridFormattersUtilCore.$$$reportNull$$$0(37);
        }
        java.util.Date currentDate = new java.util.Date();
        DateFormat format = formatsCache.get(FormatsCache.SHORT_TIMESTAMP_FORMAT_PROVIDER, formatterCreator);
        format.setTimeZone(TimeZone.getDefault());
        String formattedInLocalTz = format.format(currentDate);
        format.setTimeZone(DataGridFormattersUtilCore.getDefaultTimeZone());
        try {
            date = format.parse(formattedInLocalTz);
        }
        catch (ParseException e) {
            LOG.warn((Throwable)e);
            java.util.Date date2 = currentDate;
            if (date2 == null) {
                DataGridFormattersUtilCore.$$$reportNull$$$0(39);
            }
            return date2;
        }
        if (date == null) {
            DataGridFormattersUtilCore.$$$reportNull$$$0(38);
        }
        return date;
    }

    @NotNull
    public static java.util.Date getDateFrom(@Nullable Object o, @NotNull CoreGrid<GridRow, GridColumn> grid, @NotNull ModelIndex<GridColumn> column, @NotNull FormatsCache formatsCache, @NotNull FormatterCreator formatterCreator) {
        if (grid == null) {
            DataGridFormattersUtilCore.$$$reportNull$$$0(40);
        }
        if (column == null) {
            DataGridFormattersUtilCore.$$$reportNull$$$0(41);
        }
        if (formatsCache == null) {
            DataGridFormattersUtilCore.$$$reportNull$$$0(42);
        }
        if (formatterCreator == null) {
            DataGridFormattersUtilCore.$$$reportNull$$$0(43);
        }
        if (o instanceof String) {
            java.util.Date date;
            java.util.Date fromNumber = DataGridFormattersUtilCore.parseDateFromNumber((String)o);
            if (fromNumber != null) {
                java.util.Date date2 = fromNumber;
                if (date2 == null) {
                    DataGridFormattersUtilCore.$$$reportNull$$$0(44);
                }
                return date2;
            }
            GridColumn c = grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getColumn(column);
            Formatter format = formatterCreator.create(FormatterCreator.getTimestampKey(c, null, formatsCache));
            try {
                java.util.Date res = (java.util.Date)ObjectUtils.tryCast((Object)format.parse((String)o), java.util.Date.class);
                date = (java.util.Date)ObjectUtils.notNull((Object)res, (Object)DataGridFormattersUtilCore.getUtcDate(formatsCache, formatterCreator));
            }
            catch (ParseException e) {
                DataGridFormattersUtilCore.getUtcDate(formatsCache, formatterCreator);
            }
            if (date == null) {
                DataGridFormattersUtilCore.$$$reportNull$$$0(45);
            }
            return date;
        }
        return o instanceof Double ? new java.util.Date(DataGridFormattersUtilCore.fromJulian((Double)o)) : (o instanceof Number ? new java.util.Date(((Number)o).longValue()) : (o instanceof java.util.Date ? (java.util.Date)o : DataGridFormattersUtilCore.getUtcDate(formatsCache, formatterCreator)));
    }

    @NotNull
    public static java.util.Date getBoundedValue(@NotNull Object value, @NotNull ModelIndex<GridColumn> column, @NotNull CoreGrid<GridRow, GridColumn> grid) {
        if (value == null) {
            DataGridFormattersUtilCore.$$$reportNull$$$0(46);
        }
        if (column == null) {
            DataGridFormattersUtilCore.$$$reportNull$$$0(47);
        }
        if (grid == null) {
            DataGridFormattersUtilCore.$$$reportNull$$$0(48);
        }
        BoundaryValueResolver resolver = GridCellEditorHelper.get(grid).getResolver(grid, column);
        java.util.Date date = resolver.bound(value);
        if (date == null) {
            DataGridFormattersUtilCore.$$$reportNull$$$0(49);
        }
        return date;
    }

    @Nullable
    public static ZoneId getZoneId(@Nullable ObjectFormatterConfig config) {
        if (config == null) {
            return null;
        }
        DataGridSettings settings = config.getSettings();
        if (settings == null) {
            return null;
        }
        return settings.getEffectiveZoneId();
    }

    @NotNull
    public static ZoneId getZoneIdOrDefault(@Nullable ObjectFormatterConfig config) {
        ZoneId zoneId = (ZoneId)ObjectUtils.notNull((Object)DataGridFormattersUtilCore.getZoneId(config), (Object)ZoneId.systemDefault());
        if (zoneId == null) {
            DataGridFormattersUtilCore.$$$reportNull$$$0(50);
        }
        return zoneId;
    }

    @NotNull
    public static ZoneOffset getLocalTimeOffset(@Nullable ObjectFormatterConfig config) {
        ZoneId zoneId = DataGridFormattersUtilCore.getZoneIdOrDefault(config);
        LocalDateTime referenceDateTime = LocalDateTime.of(1970, 1, 1, 0, 0, 1);
        ZoneOffset zoneOffset = ZonedDateTime.of(referenceDateTime, zoneId).getOffset();
        if (zoneOffset == null) {
            DataGridFormattersUtilCore.$$$reportNull$$$0(51);
        }
        return zoneOffset;
    }

    @Nullable
    public static TimeZone getTimeZoneOrDefault(@Nullable ObjectFormatterConfig config) {
        ZoneId zoneId = DataGridFormattersUtilCore.getZoneId(config);
        return zoneId != null ? TimeZone.getTimeZone(zoneId) : DataGridFormattersUtilCore.getDefaultTimeZone();
    }

    @NotNull
    public static ZoneOffset getZoneOffsetOrDefault(@Nullable ObjectFormatterConfig config, @NotNull Instant instant) {
        ZoneId zoneId;
        if (instant == null) {
            DataGridFormattersUtilCore.$$$reportNull$$$0(52);
        }
        return (zoneId = DataGridFormattersUtilCore.getZoneId(config)) != null ? zoneId.getRules().getOffset(instant) : DataGridFormattersUtilCore.getDefaultOffset();
    }

    @NotNull
    public static ZoneOffset getZoneOffsetByEpochOrDefault(@Nullable ObjectFormatterConfig config) {
        return DataGridFormattersUtilCore.getZoneOffsetOrDefault(config, Instant.now());
    }

    @NotNull
    public static OffsetTime adjustOffset(@NotNull OffsetTime time, @Nullable ZoneId zoneId) {
        if (time == null) {
            DataGridFormattersUtilCore.$$$reportNull$$$0(53);
        }
        if (zoneId != null) {
            ZoneOffset offset = zoneId.getRules().getOffset(time.toLocalTime().atDate(LocalDate.now()));
            OffsetTime offsetTime = time.withOffsetSameInstant(offset);
            if (offsetTime == null) {
                DataGridFormattersUtilCore.$$$reportNull$$$0(54);
            }
            return offsetTime;
        }
        OffsetTime offsetTime = time;
        if (offsetTime == null) {
            DataGridFormattersUtilCore.$$$reportNull$$$0(55);
        }
        return offsetTime;
    }

    @NotNull
    public static Temporal adjustTimeZone(@NotNull OffsetDateTime dateTime, @Nullable ZoneId zoneId) {
        if (dateTime == null) {
            DataGridFormattersUtilCore.$$$reportNull$$$0(56);
        }
        Comparable<OffsetDateTime> comparable = zoneId != null ? dateTime.atZoneSameInstant(zoneId) : dateTime;
        if (comparable == null) {
            DataGridFormattersUtilCore.$$$reportNull$$$0(57);
        }
        return comparable;
    }

    @NotNull
    public static OffsetDateTime adjustOffset(@NotNull OffsetDateTime dateTime, @Nullable ZoneId zoneId) {
        if (dateTime == null) {
            DataGridFormattersUtilCore.$$$reportNull$$$0(58);
        }
        OffsetDateTime offsetDateTime = zoneId != null ? dateTime.atZoneSameInstant(zoneId).toOffsetDateTime() : dateTime;
        if (offsetDateTime == null) {
            DataGridFormattersUtilCore.$$$reportNull$$$0(59);
        }
        return offsetDateTime;
    }

    @NotNull
    public static OffsetDateTime toOffsetDateTime(@NotNull LocalDateTime dateTime, @Nullable ZoneId zoneId) {
        if (dateTime == null) {
            DataGridFormattersUtilCore.$$$reportNull$$$0(60);
        }
        OffsetDateTime offsetDateTime = dateTime.atZone((ZoneId)ObjectUtils.notNull((Object)zoneId, (Object)ZoneId.systemDefault())).toOffsetDateTime();
        if (offsetDateTime == null) {
            DataGridFormattersUtilCore.$$$reportNull$$$0(61);
        }
        return offsetDateTime;
    }

    @NotNull
    public static OffsetDateTime toOffsetDateTime(@NotNull TemporalAccessor value, @Nullable ZoneId zoneId) {
        OffsetDateTime offsetDateTime;
        if (value == null) {
            DataGridFormattersUtilCore.$$$reportNull$$$0(62);
        }
        if (value instanceof LocalDateTime) {
            LocalDateTime dateTime = (LocalDateTime)value;
            offsetDateTime = DataGridFormattersUtilCore.toOffsetDateTime(dateTime, zoneId);
        } else {
            offsetDateTime = DataGridFormattersUtilCore.adjustOffset((OffsetDateTime)value, zoneId);
        }
        return offsetDateTime;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7, 8, 12, 13, 17, 18, 23, 24, 28, 29, 33, 34, 38, 39, 44, 45, 49, 50, 51, 54, 55, 57, 59, 61 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "date";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "offsetDateTime";
                break;
            }
            case 2: 
            case 10: 
            case 15: 
            case 21: 
            case 26: 
            case 31: 
            case 36: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formatsCache";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "creator";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 17: 
            case 18: 
            case 23: 
            case 24: 
            case 28: 
            case 29: 
            case 33: 
            case 34: 
            case 38: 
            case 39: 
            case 44: 
            case 45: 
            case 49: 
            case 50: 
            case 51: 
            case 54: 
            case 55: 
            case 57: 
            case 59: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/grid/editors/DataGridFormattersUtilCore";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timestamp";
                break;
            }
            case 11: 
            case 16: 
            case 22: 
            case 27: 
            case 32: 
            case 37: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formatterCreator";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "temporalAccessor";
                break;
            }
            case 25: 
            case 56: 
            case 58: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dateTime";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 40: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 41: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 46: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instant";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "time";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/grid/editors/DataGridFormattersUtilCore";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "fromOffsetDateTime";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultTimeZone";
                break;
            }
            case 7: 
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalTimeOffset";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultOffset";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "fromTimestamp";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "fromDateToLocalDateTime";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "fromDate";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "fromLocalDateTime";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "fromLocalDate";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getUtcDate";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getDateFrom";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getBoundedValue";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getZoneIdOrDefault";
                break;
            }
            case 54: 
            case 55: 
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustOffset";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustTimeZone";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "toOffsetDateTime";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getEra";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "fromOffsetDateTime";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 17: 
            case 18: 
            case 23: 
            case 24: 
            case 28: 
            case 29: 
            case 33: 
            case 34: 
            case 38: 
            case 39: 
            case 44: 
            case 45: 
            case 49: 
            case 50: 
            case 51: 
            case 54: 
            case 55: 
            case 57: 
            case 59: 
            case 61: {
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "fromTimestamp";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "fromDateToLocalDateTime";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isEmptyTime";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "fromDate";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "fromLocalDateTime";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "fromLocalDate";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "parseDateFromNumber";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getUtcDate";
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getDateFrom";
                break;
            }
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getBoundedValue";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getZoneOffsetOrDefault";
                break;
            }
            case 53: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "adjustOffset";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "adjustTimeZone";
                break;
            }
            case 60: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "toOffsetDateTime";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7, 8, 12, 13, 17, 18, 23, 24, 28, 29, 33, 34, 38, 39, 44, 45, 49, 50, 51, 54, 55, 57, 59, 61 -> new IllegalStateException(string);
        };
    }
}

