/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.extensions;

import com.intellij.database.extensions.ExtensionsService;
import com.intellij.database.extensions.ExtractorScripts;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.containers.JBIterable;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.digest.DigestUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ScriptsCleanup {
    private static final Logger LOG = Logger.getInstance(ScriptsCleanup.class);
    private static final Pattern BACKUP_FILE_PATTERN = Pattern.compile("(.*)\\.old(_\\w+)?");
    private static final String LAST_CLEANUP_VERSION = "LAST_EXTRACTOR_SCRIPTS_CLEANUP_VERSION";

    @NotNull
    static Future<?> startScriptsCleanup(@NotNull Path scriptDir, @NotNull String dirName) {
        if (scriptDir == null) {
            ScriptsCleanup.$$$reportNull$$$0(0);
        }
        if (dirName == null) {
            ScriptsCleanup.$$$reportNull$$$0(1);
        }
        Future future = ApplicationManager.getApplication().executeOnPooledThread(() -> ScriptsCleanup.doCleanupScripts(scriptDir, dirName));
        if (future == null) {
            ScriptsCleanup.$$$reportNull$$$0(2);
        }
        return future;
    }

    private static synchronized void doCleanupScripts(@NotNull Path scriptDir, @NotNull String dirName) {
        if (scriptDir == null) {
            ScriptsCleanup.$$$reportNull$$$0(3);
        }
        if (dirName == null) {
            ScriptsCleanup.$$$reportNull$$$0(4);
        }
        String key = "LAST_EXTRACTOR_SCRIPTS_CLEANUP_VERSION/" + dirName;
        String lastCleanupVersion = PropertiesComponent.getInstance().getValue(key);
        String version = ApplicationInfo.getInstance().getBuild().asString();
        if (!ApplicationManager.getApplication().isUnitTestMode() && version.equals(lastCleanupVersion)) {
            return;
        }
        PropertiesComponent.getInstance().setValue(key, version);
        Object[] files = scriptDir.toFile().listFiles();
        if (files == null) {
            return;
        }
        JBIterable backupFilesWithNormalizedNames = JBIterable.of((Object[])files).map(file -> {
            Matcher matcher = BACKUP_FILE_PATTERN.matcher(file.getName());
            return matcher.matches() ? new Pair(file, (Object)matcher.group(1)) : null;
        }).filterNotNull();
        if (backupFilesWithNormalizedNames.isEmpty()) {
            return;
        }
        Map<String, Set<String>> nameToHashes = ScriptsCleanup.getHashes(dirName);
        if (nameToHashes.isEmpty()) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> WriteAction.run(() -> {
            JBIterable filesToDelete = ScriptsCleanup.getFilesToDelete((JBIterable<Pair<File, String>>)backupFilesWithNormalizedNames, nameToHashes).map(file -> {
                VirtualFile virtualFile = VirtualFileManager.getInstance().refreshAndFindFileByNioPath(file.toPath());
                if (virtualFile == null) {
                    LOG.warn("Cannot find virtual file for " + file);
                }
                return virtualFile;
            }).filterNotNull();
            ScriptsCleanup.deleteFiles((JBIterable<VirtualFile>)filesToDelete);
        }));
    }

    @NotNull
    private static Map<String, Set<String>> getHashes(@NotNull String name) {
        VirtualFile bundledResourcesDir;
        HashMap<String, Set<String>> nameToHashes;
        block17: {
            Enumeration<URL> resources;
            block16: {
                if (name == null) {
                    ScriptsCleanup.$$$reportNull$$$0(5);
                }
                nameToHashes = new HashMap<String, Set<String>>();
                PluginId id = ExtractorScripts.getPluginId();
                IdeaPluginDescriptor plugin = PluginManagerCore.getPlugin((PluginId)id);
                if (plugin == null) {
                    Map<String, Set<String>> map = Collections.emptyMap();
                    if (map == null) {
                        ScriptsCleanup.$$$reportNull$$$0(6);
                    }
                    return map;
                }
                ClassLoader pluginClassLoader = plugin.getClassLoader();
                resources = pluginClassLoader.getResources("extensions_old/" + name);
                if (resources.hasMoreElements()) break block16;
                LOG.warn("Cannot find " + id + " resource");
                Map<String, Set<String>> map = Collections.emptyMap();
                if (map == null) {
                    ScriptsCleanup.$$$reportNull$$$0(7);
                }
                return map;
            }
            URL dirUrl = resources.nextElement();
            bundledResourcesDir = VfsUtil.findFileByURL((URL)dirUrl);
            if (bundledResourcesDir != null && bundledResourcesDir.isDirectory()) break block17;
            Map<String, Set<String>> map = Collections.emptyMap();
            if (map == null) {
                ScriptsCleanup.$$$reportNull$$$0(8);
            }
            return map;
        }
        try {
            for (VirtualFile child : bundledResourcesDir.getChildren()) {
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(child.getInputStream(), StandardCharsets.UTF_8));){
                    nameToHashes.put(child.getName(), JBIterable.from((Iterable)FileUtil.loadLines((BufferedReader)reader)).filter(line -> !line.isEmpty()).toSet());
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        HashMap<String, Set<String>> hashMap = nameToHashes;
        if (hashMap == null) {
            ScriptsCleanup.$$$reportNull$$$0(9);
        }
        return hashMap;
    }

    private static void deleteFiles(@NotNull JBIterable<VirtualFile> filesToDelete) {
        if (filesToDelete == null) {
            ScriptsCleanup.$$$reportNull$$$0(10);
        }
        try {
            for (VirtualFile file : filesToDelete) {
                file.delete(ExtensionsService.class);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static JBIterable<File> getFilesToDelete(@NotNull JBIterable<Pair<File, String>> backupFilesWithNormalizedNames, @NotNull Map<String, Set<String>> nameToHashes) {
        if (backupFilesWithNormalizedNames == null) {
            ScriptsCleanup.$$$reportNull$$$0(11);
        }
        if (nameToHashes == null) {
            ScriptsCleanup.$$$reportNull$$$0(12);
        }
        return backupFilesWithNormalizedNames.filter(pair -> {
            Set hashes = (Set)nameToHashes.get(pair.getSecond());
            return hashes != null && hashes.contains(ScriptsCleanup.getMd5Hex((File)pair.getFirst()));
        }).map(pair -> (File)pair.getFirst());
    }

    @Nullable
    public static String getMd5Hex(@NotNull File file) {
        if (file == null) {
            ScriptsCleanup.$$$reportNull$$$0(13);
        }
        try {
            return DigestUtils.md5Hex((String)FileUtil.loadFile((File)file).trim());
        }
        catch (IOException ignored) {
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 6, 7, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptDir";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirName";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/extensions/ScriptsCleanup";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesToDelete";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "backupFilesWithNormalizedNames";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameToHashes";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/extensions/ScriptsCleanup";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "startScriptsCleanup";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getHashes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "startScriptsCleanup";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doCleanupScripts";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getHashes";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "deleteFiles";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getFilesToDelete";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getMd5Hex";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 6, 7, 8, 9 -> new IllegalStateException(string);
        };
    }
}

