/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.extensions;

import com.intellij.database.extensions.ExtensionsService;
import com.intellij.database.extensions.ExtractorScripts;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LoaderScripts {
    private static final String SCRIPT_DIR = "data/loaders";
    private static final Pattern FILE_PATTERN = Pattern.compile("(.+?)(?:\\.(\\w+))?\\.\\w+");

    private LoaderScripts() {
    }

    @Nullable
    public static File getScriptsDirectory() {
        Path result = LoaderScripts.getScriptDirectoryImpl(true);
        return result == null ? null : result.toFile();
    }

    /*
     * Loose catch block
     */
    @NotNull
    public static List<Path> getScriptFiles() {
        List<Path> list;
        Stream<Path> stream;
        block12: {
            Path directory = LoaderScripts.getScriptDirectoryImpl(false);
            if (directory == null) {
                List<Path> list2 = Collections.emptyList();
                if (list2 == null) {
                    LoaderScripts.$$$reportNull$$$0(0);
                }
                return list2;
            }
            stream = Files.list(directory);
            list = stream.filter(ExtensionsService.getInstance().extensionsRootTypeRegularFileFilter()).filter(o -> FILE_PATTERN.matcher(o.getFileName().toString()).matches()).collect(Collectors.toList());
            if (stream == null) break block12;
            stream.close();
        }
        List<Path> list3 = list;
        if (list3 == null) {
            LoaderScripts.$$$reportNull$$$0(1);
        }
        return list3;
        {
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ignore) {
                    List<Path> list4 = Collections.emptyList();
                    if (list4 == null) {
                        LoaderScripts.$$$reportNull$$$0(2);
                    }
                    return list4;
                }
            }
        }
    }

    @Nullable
    public static Path findScript(String name) {
        try {
            return ExtensionsService.getInstance().extensionsRootTypeFindResource(ExtractorScripts.getPluginId(), "data/loaders/" + name);
        }
        catch (IOException e) {
            return null;
        }
    }

    @NotNull
    public static String getOutputFileExtension(@NotNull String scriptFileName) {
        if (scriptFileName == null) {
            LoaderScripts.$$$reportNull$$$0(3);
        }
        return LoaderScripts.getNamePart(scriptFileName, 2, "txt");
    }

    @NotNull
    private static String getNamePart(String name, int namePart, String def) {
        String string;
        Matcher matcher = FILE_PATTERN.matcher(name);
        try {
            string = matcher.matches() ? StringUtil.notNullize((String)matcher.group(namePart), (String)def) : def;
        }
        catch (Exception ignore) {
            String string2 = def;
            if (string2 == null) {
                LoaderScripts.$$$reportNull$$$0(5);
            }
            return string2;
        }
        if (string == null) {
            LoaderScripts.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    private static Path getScriptDirectoryImpl(boolean createIfMissing) {
        PluginId pluginId = ExtractorScripts.getPluginId();
        if (pluginId == null) {
            return null;
        }
        try {
            return ExtensionsService.getInstance().extensionsRootTypeFindResourceDirectory(pluginId, SCRIPT_DIR, createIfMissing);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/extensions/LoaderScripts";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptFileName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getScriptFiles";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/extensions/LoaderScripts";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamePart";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getOutputFileExtension";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3 -> new IllegalArgumentException(string);
        };
    }
}

