/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridListModelBase;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridModelUtil;
import com.intellij.database.datagrid.GridModelWithNestedTables;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.GridWrapperNestedTable;
import com.intellij.database.datagrid.HierarchicalColumnsDataGridModel;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.datagrid.NestedTable;
import com.intellij.database.datagrid.mutating.CellMutation;
import com.intellij.openapi.Disposable;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NestedTablesDataGridModel
extends GridListModelBase<GridRow, GridColumn>
implements GridModelWithNestedTables {
    private final GridListModelBase<GridRow, GridColumn> myModel;
    private final List<NestedTableCellCoordinate> myPathToSelectedNestedTable = new ArrayList<NestedTableCellCoordinate>();
    private NestedTable myCurrentlySelectedNestedTable;
    private final NestedTableCache<GridColumn> myColumnsCache = new NestedTableCache<GridColumn>(new ColumnCacheStrategy());
    private final NestedTableCache<GridRow> myRowsCache = new NestedTableCache<GridRow>(new RowCacheStrategy());

    public NestedTablesDataGridModel(GridListModelBase<GridRow, GridColumn> model) {
        this.myModel = model;
        this.myCurrentlySelectedNestedTable = new GridWrapperNestedTable(this.myModel);
    }

    public void appendSelectedCellCoordinate(@NotNull NestedTableCellCoordinate coord) {
        Object cellValue;
        if (coord == null) {
            NestedTablesDataGridModel.$$$reportNull$$$0(0);
        }
        if (!((cellValue = coord.myColumn.getValue(coord.myRow)) instanceof NestedTable)) {
            throw new IllegalArgumentException("Cell at coordinate [" + coord.getRowIdx() + ", " + coord.getColumnIdx() + "] is not an instance of NestedTable");
        }
        NestedTable nestedTable = (NestedTable)cellValue;
        this.myPathToSelectedNestedTable.add(coord);
        this.myCurrentlySelectedNestedTable = nestedTable;
    }

    @NotNull
    public NestedTableCellCoordinate removeLastNCellCoordinates(int numCellsToRemove) {
        NestedTablesDataGridModel.removeTail(this.myPathToSelectedNestedTable, numCellsToRemove - 1);
        int lastIndex = this.myPathToSelectedNestedTable.size() - 1;
        NestedTableCellCoordinate cellCoordinateToRestoreScrollPosition = this.myPathToSelectedNestedTable.remove(lastIndex);
        this.updateNestedTableSelection();
        NestedTableCellCoordinate nestedTableCellCoordinate = cellCoordinateToRestoreScrollPosition;
        if (nestedTableCellCoordinate == null) {
            NestedTablesDataGridModel.$$$reportNull$$$0(1);
        }
        return nestedTableCellCoordinate;
    }

    @Override
    @NotNull
    public List<NestedTableCellCoordinate> getPathToSelectedNestedTable() {
        List<NestedTableCellCoordinate> list = this.myPathToSelectedNestedTable;
        if (list == null) {
            NestedTablesDataGridModel.$$$reportNull$$$0(2);
        }
        return list;
    }

    public HierarchicalColumnsDataGridModel.ColumnNamesHierarchyNode getColumnsHierarchyOfSelectedNestedTable() {
        return this.myCurrentlySelectedNestedTable.getColumnsHierarchy();
    }

    private void updateNestedTableSelection() {
        NestedTable currentNestedTable = new GridWrapperNestedTable(this.myModel);
        ArrayList<NestedTableCellCoordinate> validCellCoordinate = new ArrayList<NestedTableCellCoordinate>(this.myPathToSelectedNestedTable.size());
        for (NestedTableCellCoordinate cellCoordinate : this.myPathToSelectedNestedTable) {
            Object cellValue;
            try {
                cellValue = cellCoordinate.myColumn.getValue(cellCoordinate.myRow);
            }
            catch (RuntimeException e) {
                cellValue = null;
            }
            if (!(cellValue instanceof NestedTable)) {
                this.myPathToSelectedNestedTable.clear();
                this.myPathToSelectedNestedTable.addAll(validCellCoordinate);
                break;
            }
            validCellCoordinate.add(cellCoordinate);
            currentNestedTable = (NestedTable)cellValue;
        }
        this.myCurrentlySelectedNestedTable = currentNestedTable;
    }

    private static void removeTail(@NotNull List<?> list, int k) {
        if (list == null) {
            NestedTablesDataGridModel.$$$reportNull$$$0(3);
        }
        list.subList(Math.max(0, list.size() - k), list.size()).clear();
    }

    @Override
    public boolean hasListeners() {
        return this.myModel.hasListeners();
    }

    @Override
    @Nullable
    public Object getValueAt(ModelIndex<GridRow> rowIdx, ModelIndex<GridColumn> columnIdx) {
        if (this.isTopLevelGrid()) {
            return this.myModel.getValueAt((GridRow)((Object)rowIdx), (GridColumn)((Object)columnIdx));
        }
        if (!this.isValidRowIdx(rowIdx) || !this.isValidColumnIdx(columnIdx)) {
            return null;
        }
        return this.myCurrentlySelectedNestedTable.getValueAt(rowIdx.asInteger(), columnIdx.asInteger());
    }

    @Override
    public boolean allValuesEqualTo(@NotNull ModelIndexSet<GridRow> rowIndices, @NotNull ModelIndexSet<GridColumn> columnIndices, @Nullable Object what) {
        if (rowIndices == null) {
            NestedTablesDataGridModel.$$$reportNull$$$0(4);
        }
        if (columnIndices == null) {
            NestedTablesDataGridModel.$$$reportNull$$$0(5);
        }
        if (!this.isTopLevelGrid()) {
            throw new IllegalStateException("Operation is not permitted for nested grids.");
        }
        return this.myModel.allValuesEqualTo(rowIndices, columnIndices, what);
    }

    @Override
    @Nullable
    public GridRow getRow(@NotNull ModelIndex<GridRow> row) {
        if (row == null) {
            NestedTablesDataGridModel.$$$reportNull$$$0(6);
        }
        if (this.isTopLevelGrid()) {
            return this.myModel.getRow(row);
        }
        return new NestedTableRow(row.asInteger(), this.myCurrentlySelectedNestedTable);
    }

    @Override
    @Nullable
    public GridColumn getColumn(@NotNull ModelIndex<GridColumn> column) {
        if (column == null) {
            NestedTablesDataGridModel.$$$reportNull$$$0(7);
        }
        if (this.isTopLevelGrid()) {
            return this.myModel.getColumn(column);
        }
        return new NestedTableColumn(column.asInteger(), this.myCurrentlySelectedNestedTable);
    }

    @Override
    @NotNull
    public JBIterable<GridColumn> getColumnsAsIterable() {
        JBIterable jBIterable = JBIterable.from(this.getGridColumns());
        if (jBIterable == null) {
            NestedTablesDataGridModel.$$$reportNull$$$0(8);
        }
        return jBIterable;
    }

    @Override
    @NotNull
    public List<GridColumn> getColumns() {
        return this.getGridColumns();
    }

    @NotNull
    private List<GridColumn> getGridColumns() {
        if (this.isTopLevelGrid()) {
            List<GridColumn> list = this.myModel.getColumns();
            if (list == null) {
                NestedTablesDataGridModel.$$$reportNull$$$0(9);
            }
            return list;
        }
        List<GridColumn> list = this.myColumnsCache.getOrCreateNestedTableItems(this.myCurrentlySelectedNestedTable);
        if (list == null) {
            NestedTablesDataGridModel.$$$reportNull$$$0(10);
        }
        return list;
    }

    @Override
    @NotNull
    public List<GridRow> getRows() {
        if (this.isTopLevelGrid()) {
            List<GridRow> list = this.myModel.getRows();
            if (list == null) {
                NestedTablesDataGridModel.$$$reportNull$$$0(11);
            }
            return list;
        }
        List<GridRow> list = this.myRowsCache.getOrCreateNestedTableItems(this.myCurrentlySelectedNestedTable);
        if (list == null) {
            NestedTablesDataGridModel.$$$reportNull$$$0(12);
        }
        return list;
    }

    @Override
    public int getColumnCount() {
        return this.isTopLevelGrid() ? this.myModel.getColumnCount() : this.getNumberOfColumns();
    }

    @Override
    public int getRowCount() {
        return this.isTopLevelGrid() ? this.myModel.getRowCount() : this.myCurrentlySelectedNestedTable.getRowsNum();
    }

    @Override
    public boolean isUpdatingNow() {
        return this.myModel.isUpdatingNow();
    }

    @Override
    public boolean isValidRowIdx(@NotNull ModelIndex<GridRow> rowIdx) {
        if (rowIdx == null) {
            NestedTablesDataGridModel.$$$reportNull$$$0(13);
        }
        return this.isTopLevelGrid() ? this.myModel.isValidRowIdx(rowIdx) : this.isValidRowIdx(rowIdx.asInteger());
    }

    private boolean isValidRowIdx(int rowIdx) {
        return this.myCurrentlySelectedNestedTable.isValidRowIdx(rowIdx);
    }

    @Override
    public boolean isValidColumnIdx(@NotNull ModelIndex<GridColumn> columnIdx) {
        if (columnIdx == null) {
            NestedTablesDataGridModel.$$$reportNull$$$0(14);
        }
        return this.isTopLevelGrid() ? this.myModel.isValidColumnIdx(columnIdx) : this.isValidColumnIdx(columnIdx.asInteger());
    }

    private boolean isValidColumnIdx(int columnIdx) {
        return columnIdx > -1 && columnIdx < this.getNumberOfColumns();
    }

    private int getNumberOfColumns() {
        return this.myCurrentlySelectedNestedTable.getColumnsNum();
    }

    @Override
    public void addListener(@NotNull GridModel.Listener<GridRow, GridColumn> l, @NotNull Disposable disposable) {
        if (l == null) {
            NestedTablesDataGridModel.$$$reportNull$$$0(15);
        }
        if (disposable == null) {
            NestedTablesDataGridModel.$$$reportNull$$$0(16);
        }
        this.myModel.addListener(l, disposable);
    }

    @Override
    @Nullable
    protected Object getValueAt(@NotNull GridRow row, @NotNull GridColumn column) {
        if (row == null) {
            NestedTablesDataGridModel.$$$reportNull$$$0(17);
        }
        if (column == null) {
            NestedTablesDataGridModel.$$$reportNull$$$0(18);
        }
        if (this.isTopLevelGrid()) {
            return this.myModel.getValueAt(row, column);
        }
        return this.myCurrentlySelectedNestedTable.getValueAt(row, column);
    }

    @Override
    public boolean allValuesEqualTo(@NotNull List<CellMutation> mutations) {
        if (mutations == null) {
            NestedTablesDataGridModel.$$$reportNull$$$0(19);
        }
        return this.myModel.allValuesEqualTo(mutations);
    }

    @Override
    public void setUpdatingNow(boolean updatingNow) {
        this.myModel.setUpdatingNow(updatingNow);
    }

    @Override
    public void addRows(@NotNull List<? extends GridRow> rows) {
        if (rows == null) {
            NestedTablesDataGridModel.$$$reportNull$$$0(20);
        }
        rows.forEach(row -> this.myCurrentlySelectedNestedTable.addRow((GridRow)row));
        this.myRowsCache.clearCache(this.myCurrentlySelectedNestedTable);
    }

    @Override
    public void addRow(@NotNull GridRow row) {
        if (row == null) {
            NestedTablesDataGridModel.$$$reportNull$$$0(21);
        }
        this.myCurrentlySelectedNestedTable.addRow(row);
        this.myRowsCache.clearCache(this.myCurrentlySelectedNestedTable);
    }

    @Override
    public void removeRows(int firstRowIndex, int rowCount) {
        if (this.isTopLevelGrid()) {
            this.myModel.removeRows(firstRowIndex, rowCount);
            return;
        }
        for (int i = firstRowIndex + rowCount - 1; i >= firstRowIndex; --i) {
            this.myCurrentlySelectedNestedTable.removeRow(i);
        }
        this.myRowsCache.clearCache(this.myCurrentlySelectedNestedTable);
        this.updateNestedTableSelection();
    }

    @Override
    public void setColumns(@NotNull List<? extends GridColumn> columns) {
        if (columns == null) {
            NestedTablesDataGridModel.$$$reportNull$$$0(22);
        }
        if (!this.isTopLevelGrid()) {
            throw new IllegalStateException("The setColumns operation can only be performed on top-level tables. Nested tables do not support this operation because the column structure of nested tables is encapsulated within the nested table object.");
        }
        this.myModel.setColumns(columns);
        this.clearCaches();
    }

    @Override
    public void clearColumns() {
        if (!this.isTopLevelGrid()) {
            throw new IllegalStateException("The setColumns operation can only be performed on top-level tables. Nested tables do not support this operation because the column structure of nested tables is encapsulated within the nested table object.");
        }
        this.myModel.clearColumns();
        this.clearCaches();
    }

    @Override
    public void set(int i, GridRow objects) {
        if (this.isTopLevelGrid()) {
            this.myModel.set(i, objects);
            return;
        }
        this.myCurrentlySelectedNestedTable.setRow(i, objects);
        this.updateNestedTableSelection();
        this.myRowsCache.clearCache(this.myCurrentlySelectedNestedTable);
    }

    private void clearCaches() {
        this.myColumnsCache.clearCache();
        this.myRowsCache.clearCache();
    }

    @Override
    @NotNull
    public List<GridRow> getRows(@NotNull ModelIndexSet<GridRow> indexSet) {
        if (indexSet == null) {
            NestedTablesDataGridModel.$$$reportNull$$$0(23);
        }
        if (this.isTopLevelGrid()) {
            List<GridRow> list = this.myModel.getRows(indexSet);
            if (list == null) {
                NestedTablesDataGridModel.$$$reportNull$$$0(24);
            }
            return list;
        }
        ArrayList<GridRow> result = new ArrayList<GridRow>();
        for (ModelIndex index : indexSet.asIterable()) {
            result.add(this.getRow(index.asInteger()));
        }
        ArrayList<GridRow> arrayList = result;
        if (arrayList == null) {
            NestedTablesDataGridModel.$$$reportNull$$$0(25);
        }
        return arrayList;
    }

    @Nullable
    private GridRow getRow(int rowIdx) {
        return this.isValidRowIdx(rowIdx) ? new NestedTableRow(rowIdx, this.myCurrentlySelectedNestedTable) : null;
    }

    @Override
    public boolean isNestedTablesSupportEnabled() {
        return true;
    }

    @Override
    public boolean isTopLevelGrid() {
        return this.myPathToSelectedNestedTable.isEmpty();
    }

    @Override
    public void navigateIntoNestedTable(@NotNull NestedTableCellCoordinate cellCoordinate) {
        if (cellCoordinate == null) {
            NestedTablesDataGridModel.$$$reportNull$$$0(26);
        }
        this.appendSelectedCellCoordinate(cellCoordinate);
    }

    @Override
    public boolean isColumnContainsNestedTable(@NotNull GridColumn column) {
        if (column == null) {
            NestedTablesDataGridModel.$$$reportNull$$$0(27);
        }
        Object columnValue = GridModelUtil.tryToFindNonNullValueInColumn(this, column, 20);
        return columnValue instanceof NestedTable;
    }

    @Override
    public NestedTable getSelectedNestedTable() {
        return this.myCurrentlySelectedNestedTable;
    }

    @Override
    @NotNull
    public NestedTableCellCoordinate navigateBackFromNestedTable(int numSteps) {
        NestedTableCellCoordinate nestedTableCellCoordinate = this.removeLastNCellCoordinates(numSteps);
        if (nestedTableCellCoordinate == null) {
            NestedTablesDataGridModel.$$$reportNull$$$0(28);
        }
        return nestedTableCellCoordinate;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 8, 9, 10, 11, 12, 24, 25, 28 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coord";
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 24: 
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/datagrid/NestedTablesDataGridModel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rowIndices";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnIndices";
                break;
            }
            case 6: 
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 7: 
            case 18: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rowIdx";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnIdx";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "l";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mutations";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rows";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexSet";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cellCoordinate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/datagrid/NestedTablesDataGridModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "removeLastNCellCoordinates";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathToSelectedNestedTable";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumnsAsIterable";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getGridColumns";
                break;
            }
            case 11: 
            case 12: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getRows";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "navigateBackFromNestedTable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "appendSelectedCellCoordinate";
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 24: 
            case 25: 
            case 28: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "removeTail";
                break;
            }
            case 4: 
            case 5: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "allValuesEqualTo";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getRow";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getColumn";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isValidRowIdx";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isValidColumnIdx";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getValueAt";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "addRows";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addRow";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "setColumns";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getRows";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "navigateIntoNestedTable";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isColumnContainsNestedTable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 8, 9, 10, 11, 12, 24, 25, 28 -> new IllegalStateException(string);
        };
    }

    private static class NestedTableCache<T> {
        private static final int MAX_CACHE_SIZE = 3;
        private final CacheStrategy<T> cacheStrategy;
        private final Map<NestedTable, List<T>> myNestedTableItems = new LinkedHashMap<NestedTable, List<T>>(4, 0.75f, true){

            @Override
            public boolean removeEldestEntry(Map.Entry eldest) {
                return this.size() > 3;
            }
        };

        NestedTableCache(CacheStrategy<T> cacheStrategy) {
            this.cacheStrategy = cacheStrategy;
        }

        public List<T> getOrCreateNestedTableItems(NestedTable currentNestedTable) {
            this.myNestedTableItems.computeIfAbsent(currentNestedTable, this::createNestedItems);
            return this.myNestedTableItems.get(currentNestedTable);
        }

        public void clearCache() {
            this.myNestedTableItems.clear();
        }

        public void clearCache(NestedTable currentNestedTable) {
            this.myNestedTableItems.remove(currentNestedTable);
        }

        @NotNull
        private List<T> createNestedItems(NestedTable currentNestedTable) {
            int itemCount = this.cacheStrategy.getItemCount();
            ArrayList<T> result = new ArrayList<T>(itemCount);
            for (int i = 0; i < itemCount; ++i) {
                result.add(this.cacheStrategy.createNestedItem(i));
            }
            ArrayList<T> arrayList = result;
            if (arrayList == null) {
                NestedTableCache.$$$reportNull$$$0(0);
            }
            return arrayList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/NestedTablesDataGridModel$NestedTableCache", "createNestedItems"));
        }
    }

    private class ColumnCacheStrategy
    implements CacheStrategy<GridColumn> {
        private ColumnCacheStrategy() {
        }

        @Override
        @Contract(value="_ -> new")
        @NotNull
        public GridColumn createNestedItem(int index) {
            return new NestedTableColumn(index, NestedTablesDataGridModel.this.myCurrentlySelectedNestedTable);
        }

        @Override
        public int getItemCount() {
            return NestedTablesDataGridModel.this.getNumberOfColumns();
        }
    }

    private static interface CacheStrategy<T> {
        public T createNestedItem(int var1);

        public int getItemCount();
    }

    private class RowCacheStrategy
    implements CacheStrategy<GridRow> {
        private RowCacheStrategy() {
        }

        @Override
        @Contract(value="_ -> new")
        @NotNull
        public GridRow createNestedItem(int index) {
            return new NestedTableRow(index, NestedTablesDataGridModel.this.myCurrentlySelectedNestedTable);
        }

        @Override
        public int getItemCount() {
            return NestedTablesDataGridModel.this.getRowCount();
        }
    }

    public static class NestedTableCellCoordinate {
        private final GridRow myRow;
        private final GridColumn myColumn;

        public NestedTableCellCoordinate(@NotNull GridRow row, @NotNull GridColumn column) {
            if (row == null) {
                NestedTableCellCoordinate.$$$reportNull$$$0(0);
            }
            if (column == null) {
                NestedTableCellCoordinate.$$$reportNull$$$0(1);
            }
            this.myRow = row;
            this.myColumn = column;
        }

        public int getRowIdx() {
            return GridRow.toRealIdx(this.myRow);
        }

        public int getRowNum() {
            return this.myRow.getRowNum();
        }

        public GridRow getRow() {
            return this.myRow;
        }

        public int getColumnIdx() {
            return this.myColumn.getColumnNumber();
        }

        public ModelIndex<GridColumn> getColumnIdx(CoreGrid<?, GridColumn> grid) {
            return ModelIndex.forColumn(grid, this.myColumn.getColumnNumber());
        }

        public GridColumn getColumn() {
            return this.myColumn;
        }

        public String getColumnName() {
            return this.myColumn.getName();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "row";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "column";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/datagrid/NestedTablesDataGridModel$NestedTableCellCoordinate";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class NestedTableRow
    implements GridRow {
        private final int myRowIdx;
        private final NestedTable myNestedTable;

        NestedTableRow(int rowIdx, NestedTable table) {
            this.myNestedTable = table;
            if (!this.myNestedTable.isValidRowIdx(rowIdx)) {
                throw new IllegalStateException(String.format("Row index: %d. Error during nested table row creation: row index is invalid.", rowIdx));
            }
            this.myRowIdx = rowIdx;
        }

        @Override
        @Nullable
        public Object getValue(int columnNum) {
            if (!this.myNestedTable.isValidColumnIdx(columnNum)) {
                throw new IllegalStateException(String.format("Column number: %d. Error during retrieving value from nested table row: column number is out of bounds.", columnNum));
            }
            return this.myNestedTable.getValueAt(this.myRowIdx, columnNum);
        }

        @Override
        public int getSize() {
            return this.myNestedTable.getColumnsNum();
        }

        @Override
        public void setValue(int i, @Nullable Object object) {
            if (!this.myNestedTable.isValidColumnIdx(i)) {
                throw new IllegalStateException(String.format("Column number: %d. Error during setting value in nested table row: column number is out of bounds.", i));
            }
            this.myNestedTable.setValueAt(this.myRowIdx, i, object);
        }

        @Override
        public int getRowNum() {
            return this.myNestedTable.getRowNum(this.myRowIdx);
        }
    }

    public static class NestedTableColumn
    implements GridColumn {
        private final int myColumnIdx;
        private final NestedTable myNestedTable;
        private int myType = Integer.MAX_VALUE;
        private String myTypeName = null;

        NestedTableColumn(int columnIdx, NestedTable table) {
            this.myNestedTable = table;
            if (!this.myNestedTable.isValidColumnIdx(columnIdx)) {
                throw new IllegalStateException(String.format("Column index: %d. Error during nested table column creation: column index is out of bounds.", columnIdx));
            }
            this.myColumnIdx = columnIdx;
        }

        @Override
        public int getColumnNumber() {
            return this.myColumnIdx;
        }

        @Override
        public int getType() {
            if (this.myType == Integer.MAX_VALUE) {
                this.myType = this.myNestedTable.getColumnType(this.myColumnIdx);
            }
            return this.myType;
        }

        @Override
        public String getName() {
            return this.myNestedTable.getColumnName(this.myColumnIdx);
        }

        @Override
        @Nullable
        public String getTypeName() {
            if (this.myTypeName == null) {
                this.myTypeName = this.myNestedTable.getColumnTypeName(this.myColumnIdx);
            }
            return this.myTypeName;
        }
    }
}

