/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.datagrid.MutationType;
import com.intellij.database.datagrid.mutating.CellMutation;
import com.intellij.database.datagrid.mutating.MutationData;
import com.intellij.util.containers.JBIterable;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface GridMutator<Row, Column> {
    public boolean isUpdateSafe(@NotNull ModelIndexSet<Row> var1, @NotNull ModelIndexSet<Column> var2, @Nullable Object var3);

    public boolean hasPendingChanges();

    public boolean hasUnparsedValues();

    public boolean isUpdateImmediately();

    public void mutate(@NotNull GridRequestSource var1, @NotNull ModelIndexSet<Row> var2, @NotNull ModelIndexSet<Column> var3, @Nullable Object var4, boolean var5);

    public void mutate(@NotNull GridRequestSource var1, @NotNull List<CellMutation> var2, boolean var3);

    public static interface ColumnsMutator<Row, Column>
    extends GridMutator<Row, Column> {
        public void deleteColumns(@NotNull GridRequestSource var1, @NotNull ModelIndexSet<Column> var2);

        public void insertColumn(@NotNull GridRequestSource var1, @Nullable String var2);

        default public void moveColumn(@NotNull GridRequestSource source, @NotNull ModelIndex<Column> from, @NotNull ModelIndex<Column> to) {
            if (source == null) {
                ColumnsMutator.$$$reportNull$$$0(0);
            }
            if (from == null) {
                ColumnsMutator.$$$reportNull$$$0(1);
            }
            if (to == null) {
                ColumnsMutator.$$$reportNull$$$0(2);
            }
        }

        public void cloneColumn(@NotNull GridRequestSource var1, @NotNull ModelIndex<Column> var2);

        public int getInsertedColumnsCount();

        @NotNull
        public JBIterable<ModelIndex<Column>> getInsertedColumns();

        public boolean isInsertedColumn(@NotNull ModelIndex<Column> var1);

        public boolean isDeletedColumn(@NotNull ModelIndex<Column> var1);

        @Nullable
        public Column getInsertedColumn(@NotNull ModelIndex<Column> var1);

        public void renameColumn(@NotNull GridRequestSource var1, @NotNull ModelIndex<Column> var2, @NotNull String var3);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "source";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "from";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "to";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/datagrid/GridMutator$ColumnsMutator";
            objectArray[2] = "moveColumn";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface DatabaseMutator<Row, Column>
    extends RowsMutator<Row, Column>,
    ColumnsMutator<Row, Column> {
        public void submit(@NotNull GridRequestSource var1, boolean var2);

        @NotNull
        public String getPendingChanges();

        @Nullable
        public MutationType getMutationType(@NotNull ModelIndex<Row> var1);

        public boolean hasUnparsedValues(@NotNull ModelIndex<Row> var1);

        @Nullable
        public MutationData getMutation(@NotNull ModelIndex<Row> var1, @NotNull ModelIndex<Column> var2);

        @Nullable
        public MutationType getMutationType(@NotNull ModelIndex<Row> var1, @NotNull ModelIndex<Column> var2);

        public boolean isFailed();

        public boolean hasMutatedRows(@NotNull ModelIndexSet<Row> var1, @NotNull ModelIndexSet<Column> var2);

        public void revert(@NotNull GridRequestSource var1, @NotNull ModelIndexSet<Row> var2, @NotNull ModelIndexSet<Column> var3);
    }

    public static interface RowsMutator<Row, Column>
    extends GridMutator<Row, Column> {
        public void deleteRows(@NotNull GridRequestSource var1, @NotNull ModelIndexSet<Row> var2);

        public void insertRow(@NotNull GridRequestSource var1);

        public void cloneRow(@NotNull GridRequestSource var1, @NotNull ModelIndex<Row> var2);

        public boolean isDeletedRow(@NotNull ModelIndex<Row> var1);

        public boolean isDeletedRows(@NotNull ModelIndexSet<Row> var1);

        public boolean isInsertedRow(@NotNull ModelIndex<Row> var1);

        public int getInsertedRowsCount();

        @Nullable
        public ModelIndex<Row> getLastInsertedRow();

        @NotNull
        public ModelIndexSet<Row> getAffectedRows();

        @NotNull
        public JBIterable<ModelIndex<Row>> getInsertedRows();
    }
}

