/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.ui.diagrams.model.searchers;

import com.google.common.graph.MutableNetwork;
import com.google.common.graph.Network;
import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.microservices.endpoints.EndpointType;
import com.intellij.microservices.endpoints.EndpointTypes;
import com.intellij.microservices.ui.MicroservicesUiBundle;
import com.intellij.microservices.ui.diagrams.MsDiagramRelationship;
import com.intellij.microservices.ui.diagrams.MsDiagramRelationshipsKt;
import com.intellij.microservices.ui.diagrams.model.MsDiagramEndpoint;
import com.intellij.microservices.ui.diagrams.model.MsDiagramRequest;
import com.intellij.microservices.ui.diagrams.model.MsDiagramWebservice;
import com.intellij.microservices.ui.diagrams.model.RequestToWebservice;
import com.intellij.microservices.ui.diagrams.model.RequestsSearcher;
import com.intellij.microservices.ui.diagrams.model.searchers.RequestsToEndpointUrlsSearcher;
import com.intellij.microservices.ui.diagrams.presentation.MsDiagramEdge;
import com.intellij.microservices.ui.diagrams.utils.GraphUtilsKt;
import com.intellij.microservices.ui.diagrams.utils.TaperingScope;
import com.intellij.microservices.url.UrlTargetInfo;
import com.intellij.microservices.url.references.UrlPathReference;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchRequestCollector;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.SearchSession;
import com.intellij.psi.search.searches.ReferencesSearch;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 !2\u00020\u0001:\u0002!\"B\u0005\u00a2\u0006\u0002\u0010\u0002JJ\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0018\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\fH\u0002JV\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\u00102\u0018\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00100\f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\rH\u0016J\r\u0010\u001b\u001a\u00070\u001c\u00a2\u0006\u0002\b\u001dH\u0016J(\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00060\b2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016\u00a8\u0006#"}, d2={"Lcom/intellij/microservices/ui/diagrams/model/searchers/RequestsToInternalEndpointsSearcher;", "Lcom/intellij/microservices/ui/diagrams/model/searchers/RequestsToEndpointUrlsSearcher;", "()V", "createRequestsGraph", "Lcom/google/common/graph/Network;", "Lcom/intellij/microservices/ui/diagrams/model/MsDiagramEndpoint;", "Lcom/intellij/microservices/ui/diagrams/model/MsDiagramRequest;", "clientModules", "", "Lcom/intellij/openapi/module/Module;", "serverModules", "moduleToRequests", "", "", "Lcom/intellij/microservices/ui/diagrams/model/searchers/RequestsToInternalEndpointsSearcher$RequestToModule;", "findRequestsToEndpointUrls", "", "moduleToEndpoints", "Lcom/intellij/microservices/url/UrlTargetInfo;", "project", "Lcom/intellij/openapi/project/Project;", "searchParams", "Lcom/intellij/microservices/ui/diagrams/model/RequestsSearcher$SearchParams;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "getEndpointTypesToSearch", "Lcom/intellij/microservices/endpoints/EndpointType;", "getIndicatorText", "", "Lorg/jetbrains/annotations/Nls;", "searchForRequestsFormingAnEdge", "edge", "Lcom/intellij/microservices/ui/diagrams/presentation/MsDiagramEdge;", "Companion", "RequestToModule", "intellij.microservices.ui"})
@SourceDebugExtension(value={"SMAP\nRequestsToInternalEndpointsSearcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RequestsToInternalEndpointsSearcher.kt\ncom/intellij/microservices/ui/diagrams/model/searchers/RequestsToInternalEndpointsSearcher\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,136:1\n1208#2,2:137\n1238#2,4:139\n1549#2:149\n1620#2,3:150\n1208#2,2:155\n1238#2,4:157\n1549#2:161\n1620#2,3:162\n89#3:143\n111#3,5:144\n37#4,2:153\n72#5,2:165\n1#6:167\n1#6:168\n*S KotlinDebug\n*F\n+ 1 RequestsToInternalEndpointsSearcher.kt\ncom/intellij/microservices/ui/diagrams/model/searchers/RequestsToInternalEndpointsSearcher\n*L\n56#1:137,2\n56#1:139,4\n62#1:149\n62#1:150,3\n101#1:155,2\n101#1:157,4\n102#1:161\n102#1:162,3\n57#1:143\n57#1:144,5\n62#1:153,2\n78#1:165,2\n78#1:167\n*E\n"})
public final class RequestsToInternalEndpointsSearcher
extends RequestsToEndpointUrlsSearcher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Set<EndpointType> SERVER_ENDPOINT_TYPES;
    @NotNull
    private static final Set<MsDiagramRelationship> SUPPORTED_RELATIONSHIPS;

    @Override
    @NotNull
    public String getIndicatorText() {
        return MicroservicesUiBundle.message("microservices.diagrams.webservices.searching.internal.http.requests", new Object[0]);
    }

    @Override
    @NotNull
    public Set<EndpointType> getEndpointTypesToSearch() {
        return SERVER_ENDPOINT_TYPES;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Network<MsDiagramEndpoint, MsDiagramRequest> findRequestsToEndpointUrls(@NotNull List<? extends Module> clientModules, @NotNull Map<Module, ? extends List<? extends UrlTargetInfo>> moduleToEndpoints, @NotNull Project project, @NotNull RequestsSearcher.SearchParams searchParams, @Nullable ProgressIndicator indicator) {
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        Module target;
        void $this$flatMapTo$iv$iv;
        Object it;
        boolean bl;
        Map<Module, ? extends List<? extends UrlTargetInfo>> $this$associateByTo$iv$iv;
        Intrinsics.checkNotNullParameter(clientModules, (String)"clientModules");
        Intrinsics.checkNotNullParameter(moduleToEndpoints, (String)"moduleToEndpoints");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)searchParams, (String)"searchParams");
        Iterable $this$associateBy$iv = moduleToEndpoints.keySet();
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Object destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        Iterator<Object> iterator = $this$associateByTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object t = iterator.next();
            Module module = (Module)t;
            Map map = destination$iv$iv;
            bl = false;
            it = (Module)t;
            void var20_28 = it;
            boolean bl2 = false;
            TaperingScope taperingScope = new TaperingScope(project, (Iterable<? extends Module>)clientModules);
            map.put(var20_28, taperingScope);
        }
        Map scopes = destination$iv$iv;
        Map<Module, ? extends List<? extends UrlTargetInfo>> $this$flatMap$iv = moduleToEndpoints;
        boolean $i$f$flatMapSequence232 = false;
        $this$associateByTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapSequenceTo232 = false;
        for (Map.Entry entry : $this$flatMapTo$iv$iv.entrySet()) {
            it = entry;
            bl = false;
            target = (Module)it.getKey();
            List declarations = (List)it.getValue();
            Sequence list$iv$iv = SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)declarations), (Function1)((Function1)new Function1<UrlTargetInfo, Triple<? extends NavigatablePsiElement, ? extends Module, ? extends UrlTargetInfo>>(project, target){
                final /* synthetic */ Project $project;
                final /* synthetic */ Module $target;
                {
                    this.$project = $project;
                    this.$target = $target;
                    super(1);
                }

                @Nullable
                public final Triple<NavigatablePsiElement, Module, UrlTargetInfo> invoke(@NotNull UrlTargetInfo declaration) {
                    Triple triple;
                    Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                    NavigatablePsiElement navigatablePsiElement = (NavigatablePsiElement)ActionsKt.runReadAction((Function0)((Function0)new Function0<NavigatablePsiElement>(this.$project, declaration){
                        final /* synthetic */ Project $project;
                        final /* synthetic */ UrlTargetInfo $declaration;
                        {
                            this.$project = $project;
                            this.$declaration = $declaration;
                            super(0);
                        }

                        @Nullable
                        public final NavigatablePsiElement invoke() {
                            return UrlPathReference.Companion.createSearchableElement(this.$project, this.$declaration);
                        }
                    }));
                    if (navigatablePsiElement != null) {
                        NavigatablePsiElement navigatablePsiElement2 = navigatablePsiElement;
                        Module module = this.$target;
                        NavigatablePsiElement it = navigatablePsiElement2;
                        boolean bl = false;
                        triple = new Triple((Object)it, (Object)module, (Object)declaration);
                    } else {
                        triple = null;
                    }
                    return triple;
                }
            }));
            CollectionsKt.addAll((Collection)destination$iv$iv, (Sequence)list$iv$iv);
        }
        List elementsToSearchFor2 = (List)destination$iv$iv;
        Iterable $this$map$iv = elementsToSearchFor2;
        boolean $i$f$map = false;
        Iterable $i$f$flatMapSequenceTo232 = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean bl2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            target = (Triple)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl3 = false;
            collection.add((NavigatablePsiElement)it2.getFirst());
        }
        $this$map$iv = (List)destination$iv$iv2;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        NavigatablePsiElement[] $i$f$flatMapSequence232 = thisCollection$iv.toArray(new NavigatablePsiElement[0]);
        PsiElement[] psiElementArray = (PsiElement[])Arrays.copyOf($i$f$flatMapSequence232, $i$f$flatMapSequence232.length);
        SearchSession searchSession = new SearchSession(psiElementArray);
        SearchRequestCollector searchRequestCollector = new SearchRequestCollector(searchSession);
        ConcurrentMap concurrentMap = ConcurrentCollectionFactory.createConcurrentMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createConcurrentMap(...)");
        ConcurrentMap moduleToRequests = concurrentMap;
        for (Triple triple : elementsToSearchFor2) {
            NavigatablePsiElement searchable = (NavigatablePsiElement)triple.component1();
            Module target2 = (Module)triple.component2();
            UrlTargetInfo urlTargetInfo2 = (UrlTargetInfo)triple.component3();
            Object v = scopes.get(target2);
            Intrinsics.checkNotNull(v);
            TaperingScope searchScope = (TaperingScope)((Object)v);
            ReferencesSearch.searchOptimized((PsiElement)((PsiElement)searchable), (SearchScope)((SearchScope)searchScope), (boolean)true, (SearchRequestCollector)searchRequestCollector, (boolean)false, (arg_0, arg_1) -> RequestsToInternalEndpointsSearcher.findRequestsToEndpointUrls$lambda$6(this, searchParams, moduleToRequests, urlTargetInfo2, target2, searchScope, arg_0, arg_1));
        }
        PsiSearchHelper.getInstance((Project)project).processRequests(searchRequestCollector, RequestsToInternalEndpointsSearcher::findRequestsToEndpointUrls$lambda$7);
        return this.createRequestsGraph((Iterable<? extends Module>)clientModules, (Iterable<? extends Module>)moduleToEndpoints.keySet(), moduleToRequests);
    }

    /*
     * WARNING - void declaration
     */
    private final Network<MsDiagramEndpoint, MsDiagramRequest> createRequestsGraph(Iterable<? extends Module> clientModules, Iterable<? extends Module> serverModules, Map<Module, ? extends Set<RequestToModule>> moduleToRequests) {
        void $this$mapTo$iv$iv;
        Module it;
        boolean bl;
        Object object;
        Iterable<? extends Module> $this$associateByTo$iv$iv;
        Iterable $this$associateBy$iv = CollectionsKt.plus(clientModules, serverModules);
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Object destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object requestToModule : $this$associateByTo$iv$iv) {
            Module module = (Module)requestToModule;
            object = destination$iv$iv;
            bl = false;
            it = (Module)requestToModule;
            void var18_24 = it;
            boolean bl2 = false;
            MsDiagramWebservice msDiagramWebservice = new MsDiagramWebservice(it);
            object.put(var18_24, msDiagramWebservice);
        }
        Map moduleToWebservice = destination$iv$iv;
        Iterable<? extends Module> $this$map$iv = serverModules;
        boolean $i$f$map = false;
        $this$associateByTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object t : $this$mapTo$iv$iv) {
            it = (Module)t;
            object = destination$iv$iv;
            bl = false;
            object.add((MsDiagramWebservice)MapsKt.getValue((Map)moduleToWebservice, (Object)it));
        }
        MutableNetwork requestsGraph = GraphUtilsKt.mutableNetworkOf((List)destination$iv$iv);
        for (Map.Entry<Module, ? extends Set<RequestToModule>> entry : moduleToRequests.entrySet()) {
            Module sourceModule = entry.getKey();
            Set<RequestToModule> requests = entry.getValue();
            MsDiagramWebservice source2 = (MsDiagramWebservice)MapsKt.getValue((Map)moduleToWebservice, (Object)sourceModule);
            for (RequestToModule requestToModule : requests) {
                UrlPathReference ref = requestToModule.component1();
                UrlTargetInfo url = requestToModule.component2();
                Module targetModule = requestToModule.component3();
                MsDiagramWebservice target = (MsDiagramWebservice)MapsKt.getValue((Map)moduleToWebservice, (Object)targetModule);
                requestsGraph.addEdge((Object)source2, (Object)target, (Object)new RequestToWebservice(source2, target, url, ref));
            }
        }
        return (Network)requestsGraph;
    }

    @Override
    @NotNull
    public Iterable<MsDiagramRequest> searchForRequestsFormingAnEdge(@NotNull MsDiagramEdge edge, @NotNull RequestsSearcher.SearchParams searchParams, @Nullable ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)((Object)edge), (String)"edge");
        Intrinsics.checkNotNullParameter((Object)searchParams, (String)"searchParams");
        MsDiagramEndpoint source2 = edge.getSource().getIdentifyingElement();
        MsDiagramEndpoint target = edge.getTarget().getIdentifyingElement();
        if (!(source2 instanceof MsDiagramWebservice && target instanceof MsDiagramWebservice && SUPPORTED_RELATIONSHIPS.contains((Object)edge.getRelationship()))) {
            return CollectionsKt.emptyList();
        }
        ProgressIndicator progressIndicator = indicator;
        if (progressIndicator != null) {
            progressIndicator.setIndeterminate(true);
        }
        ProgressIndicator progressIndicator2 = indicator;
        if (progressIndicator2 != null) {
            progressIndicator2.setText(this.getIndicatorText());
        }
        Project project = ((MsDiagramWebservice)target).getModule().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        Map<Module, List<UrlTargetInfo>> moduleToRequestDeclarations = this.findModulesEndpointUrls(CollectionsKt.listOf((Object)((MsDiagramWebservice)target).getModule()), this.getEndpointTypesToSearch(), project2, searchParams);
        Set set = this.findRequestsToEndpointUrls(CollectionsKt.listOf((Object)((MsDiagramWebservice)source2).getModule()), moduleToRequestDeclarations, project2, searchParams, indicator).edges();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"edges(...)");
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final boolean findRequestsToEndpointUrls$lambda$6(RequestsToInternalEndpointsSearcher this$0, RequestsSearcher.SearchParams $searchParams, ConcurrentMap $moduleToRequests, UrlTargetInfo $mapping, Module $target, TaperingScope $searchScope, PsiReference reference, SearchRequestCollector searchRequestCollector) {
        Module source2;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$searchParams, (String)"$searchParams");
        Intrinsics.checkNotNullParameter((Object)$moduleToRequests, (String)"$moduleToRequests");
        Intrinsics.checkNotNullParameter((Object)$mapping, (String)"$mapping");
        Intrinsics.checkNotNullParameter((Object)$target, (String)"$target");
        Intrinsics.checkNotNullParameter((Object)((Object)$searchScope), (String)"$searchScope");
        Intrinsics.checkNotNull((Object)reference);
        if (this$0.isAppropriateReference(reference, $searchParams) && (source2 = (Module)ActionsKt.runReadAction((Function0)((Function0)new Function0<Module>(reference){
            final /* synthetic */ PsiReference $reference;
            {
                this.$reference = $reference;
                super(0);
            }

            @Nullable
            public final Module invoke() {
                return ModuleUtil.findModuleForPsiElement((PsiElement)this.$reference.getElement());
            }
        }))) != null) {
            void $this$getOrPut$iv;
            Object object = $moduleToRequests;
            boolean $i$f$getOrPut = false;
            Object object2 = $this$getOrPut$iv.get(source2);
            if (object2 == null) {
                boolean bl = false;
                Set default$iv = ConcurrentCollectionFactory.createConcurrentIdentitySet();
                boolean bl2 = false;
                object2 = $this$getOrPut$iv.putIfAbsent(source2, default$iv);
                if (object2 == null) {
                    object2 = default$iv;
                }
            }
            ((Set)object2).add(new RequestToModule((UrlPathReference)reference, $mapping, $target));
            object = $searchScope;
            synchronized (object) {
                boolean bl = false;
                $searchScope.removeFromConsideration(source2);
                Unit unit = Unit.INSTANCE;
            }
        }
        return true;
    }

    private static final boolean findRequestsToEndpointUrls$lambda$7(PsiReference it) {
        return true;
    }

    static {
        Object[] objectArray = new EndpointType[]{EndpointTypes.HTTP_SERVER_TYPE, EndpointTypes.WEBSOCKET_SERVER_TYPE};
        SERVER_ENDPOINT_TYPES = SetsKt.setOf((Object[])objectArray);
        objectArray = new MsDiagramRelationship[]{MsDiagramRelationshipsKt.BASE_HTTP_REQUEST_RELATIONSHIP, MsDiagramRelationshipsKt.WEBSOCKET_REQUEST_RELATIONSHIP};
        SUPPORTED_RELATIONSHIPS = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/microservices/ui/diagrams/model/searchers/RequestsToInternalEndpointsSearcher$Companion;", "", "()V", "SERVER_ENDPOINT_TYPES", "", "Lcom/intellij/microservices/endpoints/EndpointType;", "SUPPORTED_RELATIONSHIPS", "Lcom/intellij/microservices/ui/diagrams/MsDiagramRelationship;", "intellij.microservices.ui"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lcom/intellij/microservices/ui/diagrams/model/searchers/RequestsToInternalEndpointsSearcher$RequestToModule;", "", "reference", "Lcom/intellij/microservices/url/references/UrlPathReference;", "targetInfo", "Lcom/intellij/microservices/url/UrlTargetInfo;", "target", "Lcom/intellij/openapi/module/Module;", "(Lcom/intellij/microservices/url/references/UrlPathReference;Lcom/intellij/microservices/url/UrlTargetInfo;Lcom/intellij/openapi/module/Module;)V", "getReference", "()Lcom/intellij/microservices/url/references/UrlPathReference;", "getTarget", "()Lcom/intellij/openapi/module/Module;", "getTargetInfo", "()Lcom/intellij/microservices/url/UrlTargetInfo;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.microservices.ui"})
    private static final class RequestToModule {
        @NotNull
        private final UrlPathReference reference;
        @NotNull
        private final UrlTargetInfo targetInfo;
        @NotNull
        private final Module target;

        public RequestToModule(@NotNull UrlPathReference reference, @NotNull UrlTargetInfo targetInfo, @NotNull Module target) {
            Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
            Intrinsics.checkNotNullParameter((Object)targetInfo, (String)"targetInfo");
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            this.reference = reference;
            this.targetInfo = targetInfo;
            this.target = target;
        }

        @NotNull
        public final UrlPathReference getReference() {
            return this.reference;
        }

        @NotNull
        public final UrlTargetInfo getTargetInfo() {
            return this.targetInfo;
        }

        @NotNull
        public final Module getTarget() {
            return this.target;
        }

        @NotNull
        public final UrlPathReference component1() {
            return this.reference;
        }

        @NotNull
        public final UrlTargetInfo component2() {
            return this.targetInfo;
        }

        @NotNull
        public final Module component3() {
            return this.target;
        }

        @NotNull
        public final RequestToModule copy(@NotNull UrlPathReference reference, @NotNull UrlTargetInfo targetInfo, @NotNull Module target) {
            Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
            Intrinsics.checkNotNullParameter((Object)targetInfo, (String)"targetInfo");
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            return new RequestToModule(reference, targetInfo, target);
        }

        public static /* synthetic */ RequestToModule copy$default(RequestToModule requestToModule, UrlPathReference urlPathReference, UrlTargetInfo urlTargetInfo2, Module module, int n, Object object) {
            if ((n & 1) != 0) {
                urlPathReference = requestToModule.reference;
            }
            if ((n & 2) != 0) {
                urlTargetInfo2 = requestToModule.targetInfo;
            }
            if ((n & 4) != 0) {
                module = requestToModule.target;
            }
            return requestToModule.copy(urlPathReference, urlTargetInfo2, module);
        }

        @NotNull
        public String toString() {
            return "RequestToModule(reference=" + this.reference + ", targetInfo=" + this.targetInfo + ", target=" + this.target + ")";
        }

        public int hashCode() {
            int result = this.reference.hashCode();
            result = result * 31 + this.targetInfo.hashCode();
            result = result * 31 + this.target.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RequestToModule)) {
                return false;
            }
            RequestToModule requestToModule = (RequestToModule)other;
            if (!Intrinsics.areEqual((Object)this.reference, (Object)requestToModule.reference)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.targetInfo, (Object)requestToModule.targetInfo)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.target, (Object)requestToModule.target);
        }
    }
}

