/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.ui.diagrams.model.searchers;

import com.google.common.graph.MutableNetwork;
import com.google.common.graph.Network;
import com.google.common.graph.NetworkBuilder;
import com.intellij.microservices.endpoints.EndpointType;
import com.intellij.microservices.endpoints.EndpointsFilter;
import com.intellij.microservices.endpoints.EndpointsProvider;
import com.intellij.microservices.endpoints.EndpointsUrlTargetProvider;
import com.intellij.microservices.endpoints.ModuleEndpointsFilter;
import com.intellij.microservices.ui.diagrams.model.MsDiagramEndpoint;
import com.intellij.microservices.ui.diagrams.model.MsDiagramRequest;
import com.intellij.microservices.ui.diagrams.model.MsDiagramSeed;
import com.intellij.microservices.ui.diagrams.model.MsDiagramWholeProjectSeed;
import com.intellij.microservices.ui.diagrams.model.RequestsSearcher;
import com.intellij.microservices.ui.diagrams.model.searchers.RequestsToEndpointUrlsSearcher;
import com.intellij.microservices.ui.diagrams.utils.CollectionUtilsKt;
import com.intellij.microservices.ui.diagrams.utils.ModulesUtilsKt;
import com.intellij.microservices.url.UrlTargetInfo;
import com.intellij.microservices.url.references.UrlPathReference;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.TestSourcesFilter;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b \u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002JF\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014JV\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u00122\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00050\u00062\u0018\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H&J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH&J\r\u0010\u001a\u001a\u00070\u001b\u00a2\u0006\u0002\b\u001cH&J\u001e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00050\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u000f\u001a\u00020\u0010H\u0004J.\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u00122\u0006\u0010#\u001a\u00020$2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\\\u0010%\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00070'0&\"\b\b\u0000\u0010(*\u00020)\"\b\b\u0001\u0010**\u00020)*\u000e\u0012\u0004\u0012\u0002H(\u0012\u0004\u0012\u0002H*0+2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00050\t2\u0006\u0010-\u001a\u00020\u001f2\u0006\u0010.\u001a\u00020\u001fH\u0002\u00a8\u0006/"}, d2={"Lcom/intellij/microservices/ui/diagrams/model/searchers/RequestsToEndpointUrlsSearcher;", "Lcom/intellij/microservices/ui/diagrams/model/RequestsSearcher;", "()V", "findModulesEndpointUrls", "", "Lcom/intellij/openapi/module/Module;", "", "Lcom/intellij/microservices/url/UrlTargetInfo;", "modulesToSearch", "", "endpointTypesToSearch", "", "Lcom/intellij/microservices/endpoints/EndpointType;", "project", "Lcom/intellij/openapi/project/Project;", "searchParams", "Lcom/intellij/microservices/ui/diagrams/model/RequestsSearcher$SearchParams;", "findRequestsToEndpointUrls", "Lcom/google/common/graph/Network;", "Lcom/intellij/microservices/ui/diagrams/model/MsDiagramEndpoint;", "Lcom/intellij/microservices/ui/diagrams/model/MsDiagramRequest;", "clientModules", "moduleToEndpoints", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "getEndpointTypesToSearch", "getIndicatorText", "", "Lorg/jetbrains/annotations/Nls;", "getModulesToSearch", "isAppropriateReference", "", "reference", "Lcom/intellij/psi/PsiReference;", "search", "seed", "Lcom/intellij/microservices/ui/diagrams/model/MsDiagramSeed;", "getAllEndpointsUrlsByModules", "Lkotlin/sequences/Sequence;", "Lkotlin/Pair;", "G", "", "E", "Lcom/intellij/microservices/endpoints/EndpointsProvider;", "modules", "fromLibraries", "fromTests", "intellij.microservices.ui"})
@SourceDebugExtension(value={"SMAP\nRequestsToEndpointUrlsSearcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RequestsToEndpointUrlsSearcher.kt\ncom/intellij/microservices/ui/diagrams/model/searchers/RequestsToEndpointUrlsSearcher\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,105:1\n3792#2:106\n4307#2,2:107\n1003#3:109\n1037#3,3:110\n1040#3,3:120\n372#4,7:113\n*S KotlinDebug\n*F\n+ 1 RequestsToEndpointUrlsSearcher.kt\ncom/intellij/microservices/ui/diagrams/model/searchers/RequestsToEndpointUrlsSearcher\n*L\n54#1:106\n54#1:107,2\n72#1:109\n72#1:110,3\n72#1:120,3\n72#1:113,7\n*E\n"})
public abstract class RequestsToEndpointUrlsSearcher
implements RequestsSearcher {
    @Override
    @NotNull
    public Network<MsDiagramEndpoint, MsDiagramRequest> search(@NotNull MsDiagramSeed seed, @NotNull RequestsSearcher.SearchParams searchParams, @Nullable ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)seed, (String)"seed");
        Intrinsics.checkNotNullParameter((Object)searchParams, (String)"searchParams");
        if (!(seed instanceof MsDiagramWholeProjectSeed)) {
            MutableNetwork mutableNetwork = NetworkBuilder.directed().build();
            Intrinsics.checkNotNullExpressionValue((Object)mutableNetwork, (String)"build(...)");
            return (Network)mutableNetwork;
        }
        ProgressIndicator progressIndicator = indicator;
        if (progressIndicator != null) {
            progressIndicator.setIndeterminate(true);
        }
        ProgressIndicator progressIndicator2 = indicator;
        if (progressIndicator2 != null) {
            progressIndicator2.setText(this.getIndicatorText());
        }
        Project project = ((MsDiagramWholeProjectSeed)seed).getProject();
        List<Module> modules = this.getModulesToSearch(project, searchParams);
        Map<Module, List<UrlTargetInfo>> moduleToEndpoints = this.findModulesEndpointUrls((Iterable<? extends Module>)modules, this.getEndpointTypesToSearch(), project, searchParams);
        return this.findRequestsToEndpointUrls(modules, moduleToEndpoints, project, searchParams, indicator);
    }

    @NotNull
    public abstract String getIndicatorText();

    @NotNull
    public abstract Set<EndpointType> getEndpointTypesToSearch();

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected List<Module> getModulesToSearch(@NotNull Project project, @NotNull RequestsSearcher.SearchParams searchParams) {
        List list;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)searchParams, (String)"searchParams");
        Object[] allModules = ModuleManager.Companion.getInstance(project).getModules();
        if (searchParams.getFromTests()) {
            list = ArraysKt.toList((Object[])allModules);
        } else {
            void $this$filterTo$iv$iv;
            Object[] $this$filter$iv = allModules;
            boolean $i$f$filter = false;
            Object[] objectArray = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            int n = ((void)$this$filterTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void element$iv$iv;
                void it = element$iv$iv = $this$filterTo$iv$iv[i];
                boolean bl = false;
                if (!(!ModulesUtilsKt.getContainsTestsOnly((Module)it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected Map<Module, List<UrlTargetInfo>> findModulesEndpointUrls(@NotNull Iterable<? extends Module> modulesToSearch, @NotNull Set<EndpointType> endpointTypesToSearch, @NotNull Project project, @NotNull RequestsSearcher.SearchParams searchParams) {
        void $this$groupByTo$iv$iv;
        void $this$groupBy$iv;
        Intrinsics.checkNotNullParameter(modulesToSearch, (String)"modulesToSearch");
        Intrinsics.checkNotNullParameter(endpointTypesToSearch, (String)"endpointTypesToSearch");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)searchParams, (String)"searchParams");
        Sequence sequence = SequencesKt.flattenSequenceOfIterable((Sequence)CollectionsKt.asSequence((Iterable)CollectionUtilsKt.chunkedUnderReadAction((Sequence)ActionsKt.runReadAction((Function0)((Function0)new Function0<Sequence<? extends Pair<? extends Module, ? extends UrlTargetInfo>>>(project, endpointTypesToSearch, this, modulesToSearch, searchParams){
            final /* synthetic */ Project $project;
            final /* synthetic */ Set<EndpointType> $endpointTypesToSearch;
            final /* synthetic */ RequestsToEndpointUrlsSearcher this$0;
            final /* synthetic */ Iterable<Module> $modulesToSearch;
            final /* synthetic */ RequestsSearcher.SearchParams $searchParams;
            {
                this.$project = $project;
                this.$endpointTypesToSearch = $endpointTypesToSearch;
                this.this$0 = $receiver;
                this.$modulesToSearch = $modulesToSearch;
                this.$searchParams = $searchParams;
                super(0);
            }

            @NotNull
            public final Sequence<Pair<Module, UrlTargetInfo>> invoke() {
                return SequencesKt.flatMap((Sequence)SequencesKt.filter((Sequence)EndpointsProvider.Companion.getAvailableProviders(this.$project), (Function1)((Function1)new Function1<EndpointsProvider<?, ?>, Boolean>(this.$endpointTypesToSearch){
                    final /* synthetic */ Set<EndpointType> $endpointTypesToSearch;
                    {
                        this.$endpointTypesToSearch = $endpointTypesToSearch;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull EndpointsProvider<?, ?> it) {
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        return this.$endpointTypesToSearch.contains(it.getEndpointType());
                    }
                })), (Function1)((Function1)new Function1<EndpointsProvider<?, ?>, Sequence<? extends Pair<? extends Module, ? extends UrlTargetInfo>>>(this.this$0, this.$modulesToSearch, this.$searchParams){
                    final /* synthetic */ RequestsToEndpointUrlsSearcher this$0;
                    final /* synthetic */ Iterable<Module> $modulesToSearch;
                    final /* synthetic */ RequestsSearcher.SearchParams $searchParams;
                    {
                        this.this$0 = $receiver;
                        this.$modulesToSearch = $modulesToSearch;
                        this.$searchParams = $searchParams;
                        super(1);
                    }

                    @NotNull
                    public final Sequence<Pair<Module, UrlTargetInfo>> invoke(@NotNull EndpointsProvider<?, ?> it) {
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        return RequestsToEndpointUrlsSearcher.access$getAllEndpointsUrlsByModules(this.this$0, it, this.$modulesToSearch, this.$searchParams.getFromLibraries(), this.$searchParams.getFromTests());
                    }
                }));
            }
        })), 50, findModulesEndpointUrls.2.INSTANCE)));
        boolean $i$f$groupBy = false;
        void var7_7 = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            void it;
            Object object;
            Pair it2 = (Pair)element$iv$iv;
            boolean $i$a$-groupBy-RequestsToEndpointUrlsSearcher$findModulesEndpointUrls$52 = false;
            Module key$iv$iv = (Module)it2.getFirst();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            Pair $i$a$-groupBy-RequestsToEndpointUrlsSearcher$findModulesEndpointUrls$52 = (Pair)element$iv$iv;
            List list = list$iv$iv;
            boolean bl = false;
            list.add((UrlTargetInfo)it.getSecond());
        }
        return destination$iv$iv;
    }

    private final <G, E> Sequence<Pair<Module, UrlTargetInfo>> getAllEndpointsUrlsByModules(EndpointsProvider<G, E> $this$getAllEndpointsUrlsByModules, Iterable<? extends Module> modules, boolean fromLibraries, boolean fromTests) {
        return SequencesKt.flatMapIterable((Sequence)CollectionsKt.asSequence(modules), (Function1)((Function1)new Function1<Module, List<? extends Pair<? extends Module, ? extends UrlTargetInfo>>>($this$getAllEndpointsUrlsByModules, fromLibraries, fromTests){
            final /* synthetic */ EndpointsProvider<G, E> $this_getAllEndpointsUrlsByModules;
            final /* synthetic */ boolean $fromLibraries;
            final /* synthetic */ boolean $fromTests;
            {
                this.$this_getAllEndpointsUrlsByModules = $receiver;
                this.$fromLibraries = $fromLibraries;
                this.$fromTests = $fromTests;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<Pair<Module, UrlTargetInfo>> invoke(@NotNull Module module) {
                void $this$flatMapTo$iv$iv;
                void $this$flatMap$iv;
                Intrinsics.checkNotNullParameter((Object)module, (String)"module");
                Project project = module.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                Iterable iterable = this.$this_getAllEndpointsUrlsByModules.getEndpointGroups(project, (EndpointsFilter)new ModuleEndpointsFilter(module, this.$fromLibraries, this.$fromTests));
                EndpointsProvider<G, E> endpointsProvider = this.$this_getAllEndpointsUrlsByModules;
                boolean $i$f$flatMap = false;
                void var5_5 = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$flatMapTo = false;
                Iterator<T> iterator = $this$flatMapTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    void $this$flatMapTo$iv$iv2;
                    T element$iv$iv;
                    T group = element$iv$iv = iterator.next();
                    boolean bl = false;
                    Iterable $this$flatMap$iv2 = endpointsProvider.getEndpoints(group);
                    boolean $i$f$flatMap2 = false;
                    Iterable iterable2 = $this$flatMap$iv2;
                    Collection destination$iv$iv2 = new ArrayList<E>();
                    boolean $i$f$flatMapTo2 = false;
                    Iterator<T> iterator2 = $this$flatMapTo$iv$iv2.iterator();
                    while (iterator2.hasNext()) {
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        Iterable iterable3;
                        T element$iv$iv2;
                        T endpoint = element$iv$iv2 = iterator2.next();
                        boolean bl2 = false;
                        Object object = endpointsProvider instanceof EndpointsUrlTargetProvider ? (EndpointsUrlTargetProvider)endpointsProvider : null;
                        object = object != null && (iterable3 = object.getUrlTargetInfo(group, endpoint)) != null ? iterable3 : (Iterable)CollectionsKt.emptyList();
                        boolean $i$f$map = false;
                        void var23_24 = $this$map$iv;
                        Collection destination$iv$iv3 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            UrlTargetInfo urlTargetInfo2 = (UrlTargetInfo)item$iv$iv;
                            Collection collection = destination$iv$iv3;
                            boolean bl3 = false;
                            collection.add(new Pair((Object)module, (Object)it));
                        }
                        Iterable list$iv$iv = (List)destination$iv$iv3;
                        CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
                    }
                    Iterable list$iv$iv = (List)destination$iv$iv2;
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                return (List)destination$iv$iv;
            }
        }));
    }

    @NotNull
    public abstract Network<MsDiagramEndpoint, MsDiagramRequest> findRequestsToEndpointUrls(@NotNull List<? extends Module> var1, @NotNull Map<Module, ? extends List<? extends UrlTargetInfo>> var2, @NotNull Project var3, @NotNull RequestsSearcher.SearchParams var4, @Nullable ProgressIndicator var5);

    protected final boolean isAppropriateReference(@NotNull PsiReference reference, @NotNull RequestsSearcher.SearchParams searchParams) {
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        Intrinsics.checkNotNullParameter((Object)searchParams, (String)"searchParams");
        return reference instanceof UrlPathReference && !((UrlPathReference)reference).getContext().isDeclaration() && (searchParams.getFromTests() || !TestSourcesFilter.isTestSources((VirtualFile)((UrlPathReference)reference).getElement().getContainingFile().getVirtualFile(), (Project)((UrlPathReference)reference).getElement().getProject()));
    }

    public static final /* synthetic */ Sequence access$getAllEndpointsUrlsByModules(RequestsToEndpointUrlsSearcher $this, EndpointsProvider $receiver, Iterable modules, boolean fromLibraries, boolean fromTests) {
        return $this.getAllEndpointsUrlsByModules($receiver, modules, fromLibraries, fromTests);
    }
}

