/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.react.fix;

import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.psi.JSDestructuringParameter;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.JSTypedEntity;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiEditorUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.react.ReactBundle;
import com.intellij.react.ReactComponentContentUtil;
import com.intellij.react.ReactPropTypesUtil;
import com.intellij.react.fix.ReactPropUpdater;
import com.intellij.react.fix.ReactUnresolvedReferenceToPropFix;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.ApplicationKt;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0010\u001a\u00020\u0005H\u0016J\b\u0010\u0011\u001a\u00020\u0005H\u0016J)\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0096\u0002J\"\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0002J$\u0010\u001f\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010 \u001a\u0004\u0018\u00010!2\b\b\u0001\u0010\"\u001a\u00020\u0005H\u0002J\b\u0010#\u001a\u00020$H\u0016J\u001a\u0010%\u001a\u00020\u0005*\u00020\u00052\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00050'H\u0002J(\u0010(\u001a\u0004\u0018\u0001H)\"\n\b\u0000\u0010)\u0018\u0001*\u00020\u0019*\u00020\u00192\u0006\u0010*\u001a\u00020\u0005H\u0082\b\u00a2\u0006\u0002\u0010+R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\b\u001a\u0014 \n*\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\t0\u0005\u00a2\u0006\u0002\b\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/intellij/react/fix/ReactUnresolvedReferenceToPropFix;", "Lcom/intellij/codeInspection/LocalQuickFixOnPsiElement;", "unresolvedRef", "Lcom/intellij/lang/javascript/psi/JSReferenceExpression;", "componentName", "", "(Lcom/intellij/lang/javascript/psi/JSReferenceExpression;Ljava/lang/String;)V", "myComponentName", "myRefName", "Lcom/intellij/openapi/util/NlsSafe;", "kotlin.jvm.PlatformType", "createReactPropFromReference", "Lcom/intellij/lang/javascript/psi/JSProperty;", "ref", "propsType", "Lcom/intellij/lang/javascript/psi/JSRecordType;", "getFamilyName", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "startElement", "Lcom/intellij/psi/PsiElement;", "endElement", "preProcessReference", "componentSource", "parameterList", "Lcom/intellij/lang/javascript/psi/JSParameterList;", "showError", "editor", "Lcom/intellij/openapi/editor/Editor;", "errorText", "startInWriteAction", "", "getUniqueFor", "existed", "", "replaceWith", "T", "text", "(Lcom/intellij/psi/PsiElement;Ljava/lang/String;)Lcom/intellij/psi/PsiElement;", "intellij.react"})
@SourceDebugExtension(value={"SMAP\nReactUnresolvedReferenceToPropFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReactUnresolvedReferenceToPropFix.kt\ncom/intellij/react/fix/ReactUnresolvedReferenceToPropFix\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,97:1\n82#1,2:98\n84#1:101\n82#1,2:102\n84#1:105\n1#2:100\n1#2:104\n1#2:106\n*S KotlinDebug\n*F\n+ 1 ReactUnresolvedReferenceToPropFix.kt\ncom/intellij/react/fix/ReactUnresolvedReferenceToPropFix\n*L\n61#1:98,2\n61#1:101\n66#1:102,2\n66#1:105\n61#1:100\n66#1:104\n*E\n"})
public final class ReactUnresolvedReferenceToPropFix
extends LocalQuickFixOnPsiElement {
    @NotNull
    private final String myComponentName;
    private String myRefName;

    public ReactUnresolvedReferenceToPropFix(@NotNull JSReferenceExpression unresolvedRef, @NotNull String componentName) {
        Intrinsics.checkNotNullParameter((Object)unresolvedRef, (String)"unresolvedRef");
        Intrinsics.checkNotNullParameter((Object)componentName, (String)"componentName");
        super((PsiElement)unresolvedRef);
        this.myComponentName = componentName;
        this.myRefName = unresolvedRef.getText();
    }

    @NotNull
    public String getFamilyName() {
        return ReactBundle.message("react.inspection.unresolved.prop.quick.fix.family.name", new Object[0]);
    }

    @NotNull
    public String getText() {
        Object[] objectArray = new Object[2];
        Intrinsics.checkNotNullExpressionValue((Object)this.myRefName, (String)"myRefName");
        objectArray[1] = this.myComponentName;
        return ReactBundle.message("react.inspection.unresolved.ref.to.prop.fix.text", objectArray);
    }

    public boolean startInWriteAction() {
        return ApplicationKt.getApplication().isUnitTestMode();
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
        Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
        if (file.getVirtualFile() == null) {
            return;
        }
        JSReferenceExpression unresolvedRef = (JSReferenceExpression)startElement;
        GlobalSearchScope globalSearchScope = GlobalSearchScope.projectScope((Project)unresolvedRef.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"projectScope(...)");
        GlobalSearchScope scope = globalSearchScope;
        Editor editor = PsiEditorUtil.findEditor((PsiElement)startElement);
        JSPsiElementBase jSPsiElementBase = ReactComponentContentUtil.getContainingComponent((JSExpression)startElement);
        if (jSPsiElementBase == null) {
            return;
        }
        JSPsiElementBase component = jSPsiElementBase;
        String defaultPropsObjectName = this.myComponentName + "Props";
        JSRecordType propsRecordType = ReactPropTypesUtil.getResultPropsFromPsiElement((PsiElement)component);
        JSTypedEntity propsTypeObject = ReactComponentContentUtil.INSTANCE.findOrCreateWritablePropsTypeObject((PsiElement)component, scope, defaultPropsObjectName, propsRecordType);
        if (propsRecordType == null || propsTypeObject == null) {
            this.showError(project, editor, ReactBundle.message("react.inspection.unresolved.prop.validation.message.writable.props.not.found", new Object[0]));
            return;
        }
        JSProperty property = this.createReactPropFromReference(unresolvedRef, propsRecordType);
        ReactPropUpdater.Companion.create((PsiElement)component, property, propsTypeObject, defaultPropsObjectName).withResultCallback((Function1<? super PsiElement, Unit>)((Function1)invoke.1.INSTANCE)).withParameterPreProcessor((Function1<? super JSParameterList, Unit>)((Function1)new Function1<JSParameterList, Unit>(this, component, unresolvedRef){
            final /* synthetic */ ReactUnresolvedReferenceToPropFix this$0;
            final /* synthetic */ JSPsiElementBase $component;
            final /* synthetic */ JSReferenceExpression $unresolvedRef;
            {
                this.this$0 = $receiver;
                this.$component = $component;
                this.$unresolvedRef = $unresolvedRef;
                super(1);
            }

            public final void invoke(@Nullable JSParameterList it) {
                ReactUnresolvedReferenceToPropFix.access$preProcessReference(this.this$0, (PsiElement)this.$component, this.$unresolvedRef, it);
            }
        })).updateProps();
    }

    /*
     * WARNING - void declaration
     */
    private final void preProcessReference(PsiElement componentSource, JSReferenceExpression unresolvedRef, JSParameterList parameterList) {
        block6: {
            void $this$replaceWith$iv;
            if (componentSource instanceof JSClass) {
                void $this$replaceWith$iv2;
                ReactUnresolvedReferenceToPropFix reactUnresolvedReferenceToPropFix = this;
                PsiElement psiElement = (PsiElement)unresolvedRef;
                String text$iv = "this.props." + this.myRefName;
                boolean $i$f$replaceWith = false;
                Project project = $this$replaceWith$iv2.getProject();
                Language language = $this$replaceWith$iv2.getLanguage();
                Intrinsics.checkNotNull((Object)language, (String)"null cannot be cast to non-null type com.intellij.lang.javascript.JSLanguageDialect");
                JSElement it$iv = JSChangeUtil.createJSContentFromText((Project)project, (String)text$iv, (JSLanguageDialect)((JSLanguageDialect)language));
                boolean bl = false;
                it$iv = PsiTreeUtil.findChildOfType((PsiElement)((PsiElement)it$iv), JSReferenceExpression.class);
                boolean bl2 = false;
                JSElement jSElement = it$iv;
                if (jSElement != null) {
                    PsiElement psiElement2 = $this$replaceWith$iv2.replace((PsiElement)jSElement);
                    if (!(psiElement2 instanceof JSReferenceExpression)) {
                        psiElement2 = null;
                    }
                    PsiElement cfr_ignored_0 = (PsiElement)((JSReferenceExpression)psiElement2);
                }
                return;
            }
            JSParameterListElement jSParameterListElement = parameterList;
            if (jSParameterListElement == null || (jSParameterListElement = jSParameterListElement.getParameters()) == null || (jSParameterListElement = (JSParameterListElement)ArraysKt.firstOrNull((Object[])jSParameterListElement)) == null) {
                return;
            }
            JSParameterListElement firstParameter = jSParameterListElement;
            if (firstParameter instanceof JSDestructuringParameter) break block6;
            ReactUnresolvedReferenceToPropFix $this$replaceWith$iv2 = this;
            PsiElement text$iv = (PsiElement)unresolvedRef;
            String text$iv2 = firstParameter.getName() + "." + this.myRefName;
            boolean $i$f$replaceWith = false;
            Project project = $this$replaceWith$iv.getProject();
            Language language = $this$replaceWith$iv.getLanguage();
            Intrinsics.checkNotNull((Object)language, (String)"null cannot be cast to non-null type com.intellij.lang.javascript.JSLanguageDialect");
            JSElement it$iv = JSChangeUtil.createJSContentFromText((Project)project, (String)text$iv2, (JSLanguageDialect)((JSLanguageDialect)language));
            boolean bl = false;
            it$iv = PsiTreeUtil.findChildOfType((PsiElement)((PsiElement)it$iv), JSReferenceExpression.class);
            boolean bl3 = false;
            JSElement jSElement = it$iv;
            if (jSElement != null) {
                PsiElement psiElement = $this$replaceWith$iv.replace((PsiElement)jSElement);
                if (!(psiElement instanceof JSReferenceExpression)) {
                    psiElement = null;
                }
                PsiElement cfr_ignored_1 = (PsiElement)((JSReferenceExpression)psiElement);
            }
        }
    }

    private final JSProperty createReactPropFromReference(JSReferenceExpression ref, JSRecordType propsType) {
        String string = this.myRefName;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"myRefName");
        Set set = propsType.getPropertyNames();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getPropertyNames(...)");
        this.myRefName = this.getUniqueFor(string, set);
        JSType refType = ReactComponentContentUtil.INSTANCE.findStateOrPropType(ref);
        Object object = refType;
        if (object == null || (object = object.getTypeText(JSType.TypeTextFormat.CODE)) == null) {
            object = "unknown";
        }
        Object refTypeText = object;
        PsiElement psiElement = JSChangeUtil.createObjectLiteralPropertyFromText((String)(this.myRefName + "?: " + (String)refTypeText), (PsiElement)((PsiElement)ref));
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.intellij.lang.javascript.psi.JSProperty");
        return (JSProperty)psiElement;
    }

    private final void showError(Project project, Editor editor, @NlsSafe String errorText) {
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)errorText, (String)"", null);
    }

    private final /* synthetic */ <T extends PsiElement> T replaceWith(PsiElement $this$replaceWith, String text) {
        PsiElement psiElement;
        boolean $i$f$replaceWith = false;
        Project project = $this$replaceWith.getProject();
        Language language = $this$replaceWith.getLanguage();
        Intrinsics.checkNotNull((Object)language, (String)"null cannot be cast to non-null type com.intellij.lang.javascript.JSLanguageDialect");
        JSElement it = JSChangeUtil.createJSContentFromText((Project)project, (String)text, (JSLanguageDialect)((JSLanguageDialect)language));
        boolean bl = false;
        PsiElement psiElement2 = (PsiElement)it;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        it = PsiTreeUtil.findChildOfType((PsiElement)psiElement2, PsiElement.class);
        boolean bl2 = false;
        JSElement jSElement = it;
        if (jSElement != null) {
            PsiElement psiElement3 = $this$replaceWith.replace((PsiElement)jSElement);
            Intrinsics.reifiedOperationMarker((int)2, (String)"T");
            psiElement = psiElement3;
        } else {
            psiElement = null;
        }
        return (T)psiElement;
    }

    private final String getUniqueFor(String $this$getUniqueFor, Collection<String> existed) {
        Object resultName = $this$getUniqueFor;
        int i = 1;
        while (existed.contains(resultName)) {
            resultName = $this$getUniqueFor + i;
            ++i;
        }
        return resultName;
    }

    public static final /* synthetic */ void access$preProcessReference(ReactUnresolvedReferenceToPropFix $this, PsiElement componentSource, JSReferenceExpression unresolvedRef, JSParameterList parameterList) {
        $this.preProcessReference(componentSource, unresolvedRef, parameterList);
    }
}

