/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.react;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.frameworks.jsx.JSXComponent;
import com.intellij.lang.javascript.frameworks.jsx.JSXXmlExtension;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.evaluable.JSEvaluableOnlyType;
import com.intellij.lang.javascript.psi.types.recordImpl.PropertySignatureImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlTag;
import com.intellij.react.ReactPropTypesUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ReactComponent
implements JSXComponent {
    private static final String DEFAULT_PROPS = "default.props";
    @NotNull
    private final String myNamespace;
    @NotNull
    private final XmlTag myTag;
    @NotNull
    private final Collection<? extends PsiElement> myElements;
    private final boolean myIsWeakResolve;
    private final boolean myIsResolvedComponent;
    @NotNull
    private final NullableLazyValue<JSRecordType> myProps;

    public ReactComponent(@NotNull XmlTag tag, @NotNull Collection<? extends PsiElement> elements, @NotNull String namespace, boolean isWeakResolve, boolean isResolvedComponent) {
        if (tag == null) {
            ReactComponent.$$$reportNull$$$0(0);
        }
        if (elements == null) {
            ReactComponent.$$$reportNull$$$0(1);
        }
        if (namespace == null) {
            ReactComponent.$$$reportNull$$$0(2);
        }
        this.myProps = NullableLazyValue.lazyNullable(() -> this.overrideOptional(this.resolvePropsNoCache()));
        this.myTag = tag;
        this.myElements = elements;
        this.myNamespace = namespace;
        this.myIsWeakResolve = isWeakResolve;
        this.myIsResolvedComponent = isResolvedComponent;
    }

    public boolean isWeakResolve() {
        return this.myIsWeakResolve;
    }

    public boolean isResolvedComponent() {
        return this.myIsResolvedComponent;
    }

    @NotNull
    public Collection<? extends PsiElement> getElements() {
        Collection<? extends PsiElement> collection = this.myElements;
        if (collection == null) {
            ReactComponent.$$$reportNull$$$0(3);
        }
        return collection;
    }

    @NotNull
    public String getNamespace() {
        String string = this.myNamespace;
        if (string == null) {
            ReactComponent.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    public JSRecordType getProps() {
        return (JSRecordType)this.myProps.getValue();
    }

    @Nullable
    private JSRecordType resolvePropsNoCache() {
        JSType genericPropType = ReactPropTypesUtil.getGenericPropType(this.myTag, this);
        JSRecordType signatureType = ReactPropTypesUtil.asPropsResult(genericPropType);
        if (this.isAcceptableResult(signatureType)) {
            return signatureType;
        }
        boolean isTypeScript = DialectDetector.isTypeScript((PsiElement)this.myTag);
        if (isTypeScript && this.myElements.isEmpty()) {
            return null;
        }
        GlobalSearchScope scope = this.getPropsNamespaceScope();
        Collection propsNamespaceMembers = JSClassResolver.getInstance().findNamespaceMembers(this.getNamespace(), scope);
        Stream<JSPsiElementBase> resolvedNamespaceMembers = ReactPropTypesUtil.resolveNamespacePropTypes(this, scope);
        List defaultNamespaces = this.isExportDefault() ? JSClassResolver.getInstance().findNamespaceMembersIncludingLocal(DEFAULT_PROPS, GlobalSearchScope.filesScope((Project)this.myTag.getProject(), this.getCorrespondingFiles())) : Collections.emptyList();
        Stream<JSPsiElementBase> propsStream = Stream.concat(Stream.concat(propsNamespaceMembers.stream(), defaultNamespaces.stream()), resolvedNamespaceMembers);
        LinkedHashMap<String, JSRecordType.PropertySignature> result2 = new LinkedHashMap<String, JSRecordType.PropertySignature>();
        if (signatureType != null) {
            signatureType.getProperties().forEach(el -> result2.put(el.getMemberName(), (JSRecordType.PropertySignature)el));
        }
        this.mergeProperties(result2, propsStream);
        return result2.isEmpty() ? null : new JSRecordTypeImpl(JSTypeSourceFactory.createTypeSource((PsiElement)this.myTag, (boolean)true), new ArrayList(result2.values()));
    }

    private boolean isExportDefault() {
        return ContainerUtil.and(this.myElements, el -> el instanceof JSPsiElementBase && ((JSPsiElementBase)el).isExportedWithDefault());
    }

    @NotNull
    private static JSRecordType.PropertySignature makeOptional(@NotNull JSRecordType.PropertySignature el) {
        if (el == null) {
            ReactComponent.$$$reportNull$$$0(5);
        }
        return new PropertySignatureImpl(el.getMemberName(), el.getJSType(), true, el.isConst(), el.getMemberSource());
    }

    @Nullable
    private JSRecordType overrideOptional(@Nullable JSRecordType type) {
        if (type == null || !type.hasMembers()) {
            return type;
        }
        Collection<String> defaultProps = this.getDefaultProps();
        if (defaultProps.isEmpty() && !this.isWeakResolve()) {
            return type;
        }
        List newMembers = ContainerUtil.map((Collection)type.getProperties(), el -> !el.isOptional() && (this.isWeakResolve() || defaultProps.contains(el.getMemberName())) ? ReactComponent.makeOptional(el) : el);
        return new JSRecordTypeImpl(type.getSource(), newMembers);
    }

    private void mergeProperties(@NotNull Map<String, JSRecordType.PropertySignature> result2, @NotNull Stream<JSPsiElementBase> propsStream) {
        if (result2 == null) {
            ReactComponent.$$$reportNull$$$0(6);
        }
        if (propsStream == null) {
            ReactComponent.$$$reportNull$$$0(7);
        }
        propsStream.filter(el -> el.getName() != null).forEach(el -> {
            String name = el.getName();
            JSRecordType.PropertySignature oldSignature = (JSRecordType.PropertySignature)result2.get(name);
            PropertySignatureImpl newSignature = this.createSignature((JSPsiElementBase)el);
            if (oldSignature != null && (newSignature.isOptional() || JSTypeUtils.isNullOrAny((JSType)newSignature.getJSType()))) {
                return;
            }
            result2.put(name, (JSRecordType.PropertySignature)newSignature);
        });
    }

    private boolean isAcceptableResult(@Nullable JSRecordType type) {
        if (type == null || !type.hasProperties() || !type.isSourceStrict()) {
            return false;
        }
        Collection properties = type.getProperties();
        if (ReactComponent.arePropertiesNotStrict(properties) && DialectDetector.isJavaScript((PsiElement)this.myTag)) {
            return false;
        }
        int size = properties.size();
        int extendedMin = type.hasProperty("children") ? 1 : 0;
        return size > extendedMin;
    }

    private static boolean arePropertiesNotStrict(@NotNull Collection<JSRecordType.PropertySignature> properties) {
        if (properties == null) {
            ReactComponent.$$$reportNull$$$0(8);
        }
        for (JSRecordType.PropertySignature property : properties) {
            JSType jsType;
            String name = property.getMemberName();
            if ("key".equals(name) || "children".equals(name) || "ref".equals(name) || (jsType = property.getJSType()) == null || !jsType.isSourceStrict() || jsType instanceof JSAnyType) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private PropertySignatureImpl createSignature(@NotNull JSPsiElementBase el) {
        if (el == null) {
            ReactComponent.$$$reportNull$$$0(9);
        }
        return new PropertySignatureImpl(Objects.requireNonNull(el.getName()), JSXXmlExtension.getPropType((PsiElement)el), this.isWeakResolve(), false, (PsiElement)el);
    }

    @NotNull
    public GlobalSearchScope getPropsNamespaceScope() {
        if (this.useRestrictedByFilePropsNamespaceScope()) {
            return this.getRestrictedByFilePropsNamespaceScope();
        }
        GlobalSearchScope globalSearchScope = JSResolveUtil.getResolveScope((PsiElement)this.myTag);
        if (globalSearchScope == null) {
            ReactComponent.$$$reportNull$$$0(10);
        }
        return globalSearchScope;
    }

    private boolean useRestrictedByFilePropsNamespaceScope() {
        if (DialectDetector.isTypeScript((PsiElement)this.myTag)) {
            return true;
        }
        if (!this.isResolvedComponent() || this.getElements().isEmpty()) {
            return false;
        }
        for (PsiElement psiElement : this.getElements()) {
            PsiFile psiFile = psiElement.getContainingFile();
            if (!(psiFile instanceof JSFile)) {
                return false;
            }
            JSFile jsFile = (JSFile)psiFile;
            if (!jsFile.isCommonJSModule()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private Collection<String> getDefaultProps() {
        Collection<? extends PsiElement> elements = this.getElements();
        if (elements.isEmpty()) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                ReactComponent.$$$reportNull$$$0(11);
            }
            return set;
        }
        HashSet<String> objects = new HashSet<String>();
        for (PsiElement psiElement : this.getElements()) {
            JSType type;
            JSField props;
            if (!(psiElement instanceof JSClass) || (props = ((JSClass)psiElement).findFieldByName("defaultProps")) == null || (type = JSTypeUtils.getTypeOfElement((PsiElement)props)) == null || type instanceof JSEvaluableOnlyType && type.isJavaScript()) continue;
            objects.addAll(type.asRecordType().getPropertyNames());
        }
        if (objects.isEmpty()) {
            objects.addAll(this.getDefaultPropsFromIndex(this.myTag.getName()));
        }
        HashSet<String> hashSet = objects;
        if (hashSet == null) {
            ReactComponent.$$$reportNull$$$0(12);
        }
        return hashSet;
    }

    @NotNull
    private Collection<String> getDefaultPropsFromIndex(@NotNull String tagName) {
        if (tagName == null) {
            ReactComponent.$$$reportNull$$$0(13);
        }
        HashSet<String> props = new HashSet<String>();
        Processor literalProperties = base -> {
            JSExpression root = null;
            if (base instanceof JSInitializerOwner) {
                root = ((JSInitializerOwner)base).getInitializerOrStub();
            }
            if (root instanceof JSObjectLiteralExpression) {
                JSProperty[] properties;
                for (JSProperty property : properties = ((JSObjectLiteralExpression)root).getProperties()) {
                    props.add(property.getName());
                }
            }
            return true;
        };
        GlobalSearchScope scope = this.getPropsNamespaceScope();
        JSClassResolver.getInstance().processElementsByQNameIncludingImplicit(tagName + ".defaultProps", scope, literalProperties);
        ArrayList types = new ArrayList();
        Processor functionProperties = base -> {
            if (base instanceof JSFunctionItem) {
                JSType type = ((JSFunctionItem)base).getReturnType();
                ContainerUtil.addIfNotNull((Collection)types, (Object)type);
            }
            return true;
        };
        JSClassResolver.getInstance().processElementsByQNameIncludingImplicit(tagName + ".getDefaultProps", scope, functionProperties);
        for (JSType type : types) {
            props.addAll(type.asRecordType().getPropertyNames());
        }
        HashSet<String> hashSet = props;
        if (hashSet == null) {
            ReactComponent.$$$reportNull$$$0(14);
        }
        return hashSet;
    }

    @NotNull
    private GlobalSearchScope getRestrictedByFilePropsNamespaceScope() {
        GlobalSearchScope defaultScope = JSResolveUtil.getResolveScope((PsiElement)this.myTag);
        final List<VirtualFile> files = this.getCorrespondingFiles();
        if (files.isEmpty()) {
            GlobalSearchScope globalSearchScope = defaultScope;
            if (globalSearchScope == null) {
                ReactComponent.$$$reportNull$$$0(15);
            }
            return globalSearchScope;
        }
        final PsiManager manager = this.myTag.getManager();
        return new DelegatingGlobalSearchScope(defaultScope){

            public boolean contains(@NotNull VirtualFile candidate) {
                if (candidate == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!super.contains(candidate)) {
                    return false;
                }
                PsiFile psiFile = manager.findFile(candidate);
                if (!(psiFile instanceof JSFile)) {
                    return false;
                }
                JSFile jsCandidateFile = (JSFile)psiFile;
                return !jsCandidateFile.isCommonJSModule() || files.contains(candidate);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidate", "com/intellij/react/ReactComponent$1", "contains"));
            }
        };
    }

    @NotNull
    private List<VirtualFile> getCorrespondingFiles() {
        List<VirtualFile> list = this.getElements().stream().map(el -> PsiUtilCore.getVirtualFile((PsiElement)el)).filter(el -> el != null).collect(Collectors.toList());
        if (list == null) {
            ReactComponent.$$$reportNull$$$0(16);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 10, 11, 12, 14, 15, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 3: 
            case 4: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/react/ReactComponent";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "el";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propsStream";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/react/ReactComponent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getElements";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespace";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropsNamespaceScope";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultProps";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultPropsFromIndex";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getRestrictedByFilePropsNamespaceScope";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getCorrespondingFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "makeOptional";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "mergeProperties";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "arePropertiesNotStrict";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createSignature";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultPropsFromIndex";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 10, 11, 12, 14, 15, 16 -> new IllegalStateException(string);
        };
    }
}

