/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.utils;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramNodeEditingManager;
import com.intellij.diagram.DiagramNodeEditor;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.services.GraphCanvasLocationService;
import com.intellij.openapi.graph.services.GraphSelectionService;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.ui.popup.AbstractPopup;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Objects;
import java.util.Optional;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiagramCanvasLocationService {
    @NotNull
    private static final DiagramCanvasLocationService INSTANCE = new DiagramCanvasLocationService();

    @NotNull
    public static DiagramCanvasLocationService getInstance() {
        DiagramCanvasLocationService diagramCanvasLocationService = INSTANCE;
        if (diagramCanvasLocationService == null) {
            DiagramCanvasLocationService.$$$reportNull$$$0(0);
        }
        return diagramCanvasLocationService;
    }

    @NotNull
    public Point getBestPositionForSelectedNodePopupOnCanvas(@Nullable JBPopup popup, @NotNull DiagramBuilder builder) {
        Node singleSelectedNode;
        if (builder == null) {
            DiagramCanvasLocationService.$$$reportNull$$$0(1);
        }
        if ((singleSelectedNode = GraphSelectionService.getInstance().getSingleSelectedNode(builder.getGraph())) == null) {
            Point point = GraphCanvasLocationService.getInstance().getGraphCenterOnCanvas(builder.getGraphBuilder());
            if (point == null) {
                DiagramCanvasLocationService.$$$reportNull$$$0(2);
            }
            return point;
        }
        Point point = this.getBestPositionForNodePopupOnCanvas(Objects.requireNonNull(builder.getNodeObject(singleSelectedNode)), popup, builder);
        if (point == null) {
            DiagramCanvasLocationService.$$$reportNull$$$0(3);
        }
        return point;
    }

    @NotNull
    public Point getBestPositionForNodePopupOnCanvas(@NotNull DiagramNode<?> node, @Nullable JBPopup popup, @NotNull DiagramBuilder builder) {
        Rectangle selectionBounds;
        if (node == null) {
            DiagramCanvasLocationService.$$$reportNull$$$0(4);
        }
        if (builder == null) {
            DiagramCanvasLocationService.$$$reportNull$$$0(5);
        }
        Dimension popupSize = Optional.ofNullable(popup).map(it -> it instanceof AbstractPopup ? ((AbstractPopup)it).getSizeForPositioning() : it.getSize()).orElse(new Dimension(0, 0));
        DiagramNodeEditor nodeEditor = DiagramNodeEditingManager.getInstance().getLastActiveNodeEditor();
        Rectangle nodeBounds = GraphCanvasLocationService.getInstance().getNodeBoundsOnCanvas(Objects.requireNonNull(builder.getNode(node)), builder.getGraphBuilder());
        boolean doShowPopupOnTheRightOfTheNode = popup == null || nodeBounds.getMinX() + nodeBounds.getWidth() / 2.0 < builder.getView().getCanvasSize().getWidth() / 2.0;
        Rectangle rectangle = selectionBounds = nodeEditor != null ? nodeEditor.getSelectionBoundsOnCanvas() : null;
        if (selectionBounds != null) {
            return new Point(doShowPopupOnTheRightOfTheNode ? (int)selectionBounds.getMaxX() : (int)selectionBounds.getMinX() - popupSize.width, (int)selectionBounds.getMaxY());
        }
        return new Point(doShowPopupOnTheRightOfTheNode ? (int)nodeBounds.getMaxX() : (int)nodeBounds.getMinX() - popupSize.width, (int)nodeBounds.getMinY());
    }

    @NotNull
    public Point getBestPositionForSelectedNodePopupOnScreen(@Nullable JBPopup popup, @NotNull DiagramBuilder builder) {
        if (builder == null) {
            DiagramCanvasLocationService.$$$reportNull$$$0(6);
        }
        Point point = this.getBestPositionForSelectedNodePopupOnCanvas(popup, builder);
        SwingUtilities.convertPointToScreen(point, builder.getView().getCanvasComponent());
        Point point2 = point;
        if (point2 == null) {
            DiagramCanvasLocationService.$$$reportNull$$$0(7);
        }
        return point2;
    }

    @NotNull
    public Point getBestPositionForNodePopupOnScreen(@NotNull DiagramNode<?> node, @Nullable JBPopup popup, @NotNull DiagramBuilder builder) {
        if (node == null) {
            DiagramCanvasLocationService.$$$reportNull$$$0(8);
        }
        if (builder == null) {
            DiagramCanvasLocationService.$$$reportNull$$$0(9);
        }
        Point point = this.getBestPositionForNodePopupOnCanvas(node, popup, builder);
        SwingUtilities.convertPointToScreen(point, builder.getView().getCanvasComponent());
        Point point2 = point;
        if (point2 == null) {
            DiagramCanvasLocationService.$$$reportNull$$$0(10);
        }
        return point2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 4, 5, 6, 8, 9 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uml/utils/DiagramCanvasLocationService";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uml/utils/DiagramCanvasLocationService";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBestPositionForSelectedNodePopupOnCanvas";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getBestPositionForSelectedNodePopupOnScreen";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getBestPositionForNodePopupOnScreen";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getBestPositionForSelectedNodePopupOnCanvas";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getBestPositionForNodePopupOnCanvas";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getBestPositionForSelectedNodePopupOnScreen";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getBestPositionForNodePopupOnScreen";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 4, 5, 6, 8, 9 -> new IllegalArgumentException(string);
        };
    }
}

