/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.core.actions.analysis;

import com.intellij.diagram.util.DiagramAlgorithmsService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.ButtonsGroup;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.MutablePropertyKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.SliderKt;
import com.intellij.ui.dsl.builder.TextFieldKt;
import com.intellij.uml.core.actions.analysis.DiagramAutoClusteringDialog;
import com.intellij.uml.utils.DiagramBundle;
import java.util.concurrent.CompletableFuture;
import javax.swing.Action;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.ranges.IntRange;
import kotlin.reflect.KMutableProperty0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0012B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\n\u001a\u00020\u000bH\u0014J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0014J\b\u0010\u000f\u001a\u00020\u0010H\u0014J\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/uml/core/actions/analysis/DiagramAutoClusteringDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "myShowFuture", "Ljava/util/concurrent/CompletableFuture;", "Lcom/intellij/diagram/util/DiagramAlgorithmsService$ClusteringType;", "myViewModel", "Lcom/intellij/uml/core/actions/analysis/DiagramAutoClusteringDialog$MyViewModel;", "createCenterPanel", "Ljavax/swing/JComponent;", "doCancelAction", "", "doOKAction", "getOKAction", "Ljavax/swing/Action;", "showAsync", "MyViewModel", "intellij.diagram.impl"})
public final class DiagramAutoClusteringDialog
extends DialogWrapper {
    @NotNull
    private final CompletableFuture<DiagramAlgorithmsService.ClusteringType> myShowFuture;
    @NotNull
    private final MyViewModel myViewModel;

    public DiagramAutoClusteringDialog(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        this.myShowFuture = new CompletableFuture();
        this.myViewModel = new MyViewModel(null, 0, 0, 7, null);
        this.init();
        this.setTitle(DiagramBundle.message("dialog.diagram.auto.clustering", new Object[0]));
    }

    @NotNull
    public final CompletableFuture<DiagramAlgorithmsService.ClusteringType> showAsync() {
        ApplicationManager.getApplication().invokeLater(() -> DiagramAutoClusteringDialog.showAsync$lambda$0(this));
        return this.myShowFuture;
    }

    protected void doOKAction() {
        super.doOKAction();
        this.myShowFuture.complete(this.myViewModel.getClustering());
    }

    public void doCancelAction() {
        super.doCancelAction();
        this.myShowFuture.cancel(true);
    }

    @NotNull
    protected Action getOKAction() {
        Action action;
        Action action2 = super.getOKAction();
        Intrinsics.checkNotNullExpressionValue((Object)action2, (String)"getOKAction(...)");
        Action $this$getOKAction_u24lambda_u241 = action = action2;
        boolean bl = false;
        $this$getOKAction_u24lambda_u241.putValue("Name", DiagramBundle.message("dialog.diagram.auto.clustering.button.title", new Object[0]));
        return action;
    }

    @NotNull
    protected JComponent createCenterPanel() {
        DialogPanel contentPanel2 = BuilderKt.panel((Function1)((Function1)new Function1<Panel, Unit>(this){
            final /* synthetic */ DiagramAutoClusteringDialog this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull Panel $this$panel) {
                void getter$iv;
                void $this$bind$iv;
                Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                ButtonsGroup buttonsGroup = Panel.buttonsGroup$default((Panel)$this$panel, (String)DiagramBundle.message("dialog.diagram.auto.clustering", new Object[0]), (boolean)false, (Function1)((Function1)new Function1<Panel, Unit>(this.this$0){
                    final /* synthetic */ DiagramAutoClusteringDialog this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Panel $this$buttonsGroup) {
                        Intrinsics.checkNotNullParameter((Object)$this$buttonsGroup, (String)"$this$buttonsGroup");
                        Panel.row$default((Panel)$this$buttonsGroup, null, (Function1)createCenterPanel.contentPanel.1.INSTANCE, (int)1, null);
                        Panel.row$default((Panel)$this$buttonsGroup, null, (Function1)createCenterPanel.contentPanel.2.INSTANCE, (int)1, null);
                        $this$buttonsGroup.indent((Function1)new Function1<Panel, Unit>(this.this$0){
                            final /* synthetic */ DiagramAutoClusteringDialog this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(@NotNull Panel $this$indent) {
                                Intrinsics.checkNotNullParameter((Object)$this$indent, (String)"$this$indent");
                                String string = DiagramBundle.message("dialog.diagram.auto.clustering.quality.time.ratio", new Object[0]);
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                                $this$indent.row(string, (Function1)new Function1<Row, Unit>(this.this$0){
                                    final /* synthetic */ DiagramAutoClusteringDialog this$0;
                                    {
                                        this.this$0 = $receiver;
                                        super(1);
                                    }

                                    public final void invoke(@NotNull Row $this$row) {
                                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                                        SliderKt.bindValue((Cell)$this$row.slider(1, 10, 1, 1), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl(DiagramAutoClusteringDialog.access$getMyViewModel$p(this.this$0)){

                                            @Nullable
                                            public Object get() {
                                                return ((MyViewModel)this.receiver).getEdgeBetweennessQualityTimeRatio();
                                            }

                                            public void set(@Nullable Object value) {
                                                ((MyViewModel)this.receiver).setEdgeBetweennessQualityTimeRatio(((Number)value).intValue());
                                            }
                                        }));
                                    }
                                });
                            }
                        });
                        Panel.row$default((Panel)$this$buttonsGroup, null, (Function1)((Function1)new Function1<Row, Unit>(this.this$0){
                            final /* synthetic */ DiagramAutoClusteringDialog this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(@NotNull Row $this$row) {
                                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                                String string = DiagramBundle.message("dialog.diagram.auto.clustering.kmeans", new Object[0]);
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                                Cell button = Cell.comment$default((Cell)$this$row.radioButton(string, DiagramAlgorithmsService.ClusteringType.KMeans.class), (String)DiagramBundle.message("dialog.diagram.auto.clustering.kmeans.description", new Object[0]), (int)0, null, (int)6, null);
                                TextFieldKt.bindIntText((Cell)$this$row.intTextField(new IntRange(1, 100), Integer.valueOf(1)).enabledIf(ButtonKt.getSelected((Cell)button)), (Function0)((Function0)new Function0<Integer>(this.this$0){
                                    final /* synthetic */ DiagramAutoClusteringDialog this$0;
                                    {
                                        this.this$0 = $receiver;
                                        super(0);
                                    }

                                    @NotNull
                                    public final Integer invoke() {
                                        return DiagramAutoClusteringDialog.access$getMyViewModel$p(this.this$0).getKMeansBound();
                                    }
                                }), (Function1)((Function1)new Function1<Integer, Unit>(this.this$0){
                                    final /* synthetic */ DiagramAutoClusteringDialog this$0;
                                    {
                                        this.this$0 = $receiver;
                                        super(1);
                                    }

                                    public final void invoke(int it) {
                                        DiagramAutoClusteringDialog.access$getMyViewModel$p(this.this$0).setKMeansBound(it);
                                    }
                                }));
                            }
                        }), (int)1, null);
                    }
                }), (int)2, null);
                Function0 function0 = (Function0)new Function0<Class<?>>(this.this$0){
                    final /* synthetic */ DiagramAutoClusteringDialog this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    @NotNull
                    public final Class<?> invoke() {
                        return DiagramAutoClusteringDialog.access$getMyViewModel$p(this.this$0).getClusteringType();
                    }
                };
                Function1 setter$iv = (Function1)new Function1<Class<?>, Unit>(this.this$0){
                    final /* synthetic */ DiagramAutoClusteringDialog this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Class<?> it) {
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        DiagramAutoClusteringDialog.access$getMyViewModel$p(this.this$0).setClusteringType(it);
                    }
                };
                boolean $i$f$bind = false;
                $this$bind$iv.bind(MutablePropertyKt.MutableProperty((Function0)getter$iv, (Function1)setter$iv), Class.class);
            }
        }));
        return (JComponent)contentPanel2;
    }

    private static final void showAsync$lambda$0(DiagramAutoClusteringDialog this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.show();
    }

    public static final /* synthetic */ MyViewModel access$getMyViewModel$p(DiagramAutoClusteringDialog $this) {
        return $this.myViewModel;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B'\u0012\f\b\u0002\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\r\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J+\u0010\u0015\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0006\u0010\u0019\u001a\u00020\u001aJ\t\u0010\u001b\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001R\u001e\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0006\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\r\"\u0004\b\u0011\u0010\u000f\u00a8\u0006\u001e"}, d2={"Lcom/intellij/uml/core/actions/analysis/DiagramAutoClusteringDialog$MyViewModel;", "", "clusteringType", "Ljava/lang/Class;", "edgeBetweennessQualityTimeRatio", "", "kMeansBound", "(Ljava/lang/Class;II)V", "getClusteringType", "()Ljava/lang/Class;", "setClusteringType", "(Ljava/lang/Class;)V", "getEdgeBetweennessQualityTimeRatio", "()I", "setEdgeBetweennessQualityTimeRatio", "(I)V", "getKMeansBound", "setKMeansBound", "component1", "component2", "component3", "copy", "equals", "", "other", "getClustering", "Lcom/intellij/diagram/util/DiagramAlgorithmsService$ClusteringType;", "hashCode", "toString", "", "intellij.diagram.impl"})
    private static final class MyViewModel {
        @NotNull
        private Class<?> clusteringType;
        private int edgeBetweennessQualityTimeRatio;
        private int kMeansBound;

        public MyViewModel(@NotNull Class<?> clusteringType, int edgeBetweennessQualityTimeRatio, int kMeansBound) {
            Intrinsics.checkNotNullParameter(clusteringType, (String)"clusteringType");
            this.clusteringType = clusteringType;
            this.edgeBetweennessQualityTimeRatio = edgeBetweennessQualityTimeRatio;
            this.kMeansBound = kMeansBound;
        }

        public /* synthetic */ MyViewModel(Class clazz, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 1) != 0) {
                clazz = DiagramAlgorithmsService.ClusteringType.EdgeBetweenness.class;
            }
            if ((n3 & 2) != 0) {
                n = 10;
            }
            if ((n3 & 4) != 0) {
                n2 = 5;
            }
            this(clazz, n, n2);
        }

        @NotNull
        public final Class<?> getClusteringType() {
            return this.clusteringType;
        }

        public final void setClusteringType(@NotNull Class<?> clazz) {
            Intrinsics.checkNotNullParameter(clazz, (String)"<set-?>");
            this.clusteringType = clazz;
        }

        public final int getEdgeBetweennessQualityTimeRatio() {
            return this.edgeBetweennessQualityTimeRatio;
        }

        public final void setEdgeBetweennessQualityTimeRatio(int n) {
            this.edgeBetweennessQualityTimeRatio = n;
        }

        public final int getKMeansBound() {
            return this.kMeansBound;
        }

        public final void setKMeansBound(int n) {
            this.kMeansBound = n;
        }

        @NotNull
        public final DiagramAlgorithmsService.ClusteringType getClustering() {
            DiagramAlgorithmsService.ClusteringType clusteringType;
            Class<?> clazz = this.clusteringType;
            if (Intrinsics.areEqual(clazz, DiagramAlgorithmsService.ClusteringType.Biconnected.class)) {
                clusteringType = new DiagramAlgorithmsService.ClusteringType.Biconnected();
            } else if (Intrinsics.areEqual(clazz, DiagramAlgorithmsService.ClusteringType.EdgeBetweenness.class)) {
                clusteringType = new DiagramAlgorithmsService.ClusteringType.EdgeBetweenness((double)this.edgeBetweennessQualityTimeRatio / 10.0);
            } else if (Intrinsics.areEqual(clazz, DiagramAlgorithmsService.ClusteringType.KMeans.class)) {
                clusteringType = new DiagramAlgorithmsService.ClusteringType.KMeans(this.kMeansBound);
            } else {
                throw new IllegalStateException(("Unknown clustering type: " + this.clusteringType).toString());
            }
            return clusteringType;
        }

        @NotNull
        public final Class<?> component1() {
            return this.clusteringType;
        }

        public final int component2() {
            return this.edgeBetweennessQualityTimeRatio;
        }

        public final int component3() {
            return this.kMeansBound;
        }

        @NotNull
        public final MyViewModel copy(@NotNull Class<?> clusteringType, int edgeBetweennessQualityTimeRatio, int kMeansBound) {
            Intrinsics.checkNotNullParameter(clusteringType, (String)"clusteringType");
            return new MyViewModel(clusteringType, edgeBetweennessQualityTimeRatio, kMeansBound);
        }

        public static /* synthetic */ MyViewModel copy$default(MyViewModel myViewModel, Class clazz, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                clazz = myViewModel.clusteringType;
            }
            if ((n3 & 2) != 0) {
                n = myViewModel.edgeBetweennessQualityTimeRatio;
            }
            if ((n3 & 4) != 0) {
                n2 = myViewModel.kMeansBound;
            }
            return myViewModel.copy(clazz, n, n2);
        }

        @NotNull
        public String toString() {
            return "MyViewModel(clusteringType=" + this.clusteringType + ", edgeBetweennessQualityTimeRatio=" + this.edgeBetweennessQualityTimeRatio + ", kMeansBound=" + this.kMeansBound + ")";
        }

        public int hashCode() {
            int result = this.clusteringType.hashCode();
            result = result * 31 + Integer.hashCode(this.edgeBetweennessQualityTimeRatio);
            result = result * 31 + Integer.hashCode(this.kMeansBound);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MyViewModel)) {
                return false;
            }
            MyViewModel myViewModel = (MyViewModel)other;
            if (!Intrinsics.areEqual(this.clusteringType, myViewModel.clusteringType)) {
                return false;
            }
            if (this.edgeBetweennessQualityTimeRatio != myViewModel.edgeBetweennessQualityTimeRatio) {
                return false;
            }
            return this.kMeansBound == myViewModel.kMeansBound;
        }

        public MyViewModel() {
            this(null, 0, 0, 7, null);
        }
    }
}

