/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.core.actions.analysis;

import com.intellij.codeWithMe.ClientId;
import com.intellij.diagram.DiagramAction;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.util.DiagramAlgorithmsService;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.graph.builder.NodeGroupDescriptor;
import com.intellij.openapi.graph.builder.NodesGroup;
import com.intellij.openapi.graph.builder.components.BasicNodesGroup;
import com.intellij.openapi.graph.impl.GraphGroupingUtil;
import com.intellij.openapi.graph.layout.Layouter;
import com.intellij.openapi.graph.services.GraphLayoutService;
import com.intellij.openapi.graph.util.Futures;
import com.intellij.openapi.graph.view.hierarchy.GroupNodeRealizer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.uml.core.actions.analysis.DiagramAutoClusteringDialog;
import com.intellij.uml.core.actions.analysis.DiagramAutoClusteringUndoableAction;
import com.intellij.uml.utils.DiagramBundle;
import java.awt.Color;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiagramAutoClusteringAction
extends DiagramAction {
    @Override
    public void perform(@NotNull AnActionEvent e) {
        DiagramBuilder builder;
        if (e == null) {
            DiagramAutoClusteringAction.$$$reportNull$$$0(0);
        }
        if ((builder = DiagramAutoClusteringAction.getBuilder(e)) == null) {
            return;
        }
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)new DiagramAutoClusteringDialog(builder.getProject()).showAsync().thenComposeAsync(clusteringParams -> DiagramAlgorithmsService.getInstance().runAutoClusteringAsync(builder, (DiagramAlgorithmsService.ClusteringType)clusteringParams), Futures.inEdt())).thenAcceptAsync(clusters -> WriteCommandAction.writeCommandAction((Project)builder.getProject()).withName(DiagramBundle.message("dialog.diagram.auto.clustering", new Object[0])).run(() -> {
            Map<DiagramNode<?>, NodeGroupDescriptor> modelNode2GroupDescriptor = DiagramAutoClusteringAction.mapClusterIdToGroupDescriptor(builder, clusters);
            DiagramAutoClusteringUndoableAction undoableAction = new DiagramAutoClusteringUndoableAction(builder, modelNode2GroupDescriptor, true);
            undoableAction.applyClustering();
            UndoManager.getInstance((Project)builder.getProject()).undoableActionPerformed((UndoableAction)undoableAction);
        }), Futures.inEdt())).thenComposeAsync(ClientId.decorateFunction(__ -> GraphLayoutService.getInstance().queryLayout(builder.getGraphBuilder()).withLayouter((Layouter)GraphLayoutService.getInstance().getGroupLayouter()).withFitContent(GraphLayoutService.GraphLayoutQueryParams.FitContentOption.NEVER).runAsync()))).whenComplete(Futures.logIfFailed(DiagramAutoClusteringAction.class));
    }

    @NotNull
    private static Map<DiagramNode<?>, NodeGroupDescriptor> mapClusterIdToGroupDescriptor(@NotNull DiagramBuilder builder, @NotNull Map<DiagramNode<?>, Integer> clusters) {
        if (builder == null) {
            DiagramAutoClusteringAction.$$$reportNull$$$0(1);
        }
        if (clusters == null) {
            DiagramAutoClusteringAction.$$$reportNull$$$0(2);
        }
        List<Integer> allClusterIds = clusters.values().stream().distinct().toList();
        Map<Integer, MyGroupDescriptor> clusterId2GroupDescriptor = allClusterIds.stream().collect(Collectors.toMap(it -> it, it -> new MyGroupDescriptor(builder, null, DiagramBundle.message("diagram.auto.clustering.cluster", new Object[0]) + " " + (it + 1), Color.getHSBColor((float)it.intValue() / (float)allClusterIds.size(), 0.8f, 1.0f))));
        Map<DiagramNode<?>, NodeGroupDescriptor> map = clusters.entrySet().stream().collect(Collectors.toMap(it -> (DiagramNode)it.getKey(), it -> (NodeGroupDescriptor)clusterId2GroupDescriptor.get(it.getValue())));
        if (map == null) {
            DiagramAutoClusteringAction.$$$reportNull$$$0(3);
        }
        return map;
    }

    @Override
    @Nls
    @NotNull
    public String getActionName() {
        String string = DiagramBundle.message("action.Diagram.AnalyzeGraph.AutoClustering.text", new Object[0]);
        if (string == null) {
            DiagramAutoClusteringAction.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    public boolean isUndoable(@NotNull AnActionEvent e) {
        if (e == null) {
            DiagramAutoClusteringAction.$$$reportNull$$$0(5);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clusters";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uml/core/actions/analysis/DiagramAutoClusteringAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uml/core/actions/analysis/DiagramAutoClusteringAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "mapClusterIdToGroupDescriptor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "perform";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "mapClusterIdToGroupDescriptor";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isUndoable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }

    private static final class MyGroupDescriptor
    extends BasicNodesGroup {
        @NotNull
        private final DiagramBuilder myBuilder;
        @NotNull
        private final Color myBorderColor;

        private MyGroupDescriptor(@NotNull DiagramBuilder builder, @Nullable NodesGroup parent, @NotNull @NlsContexts.Label String groupName, @NotNull Color borderColor) {
            if (builder == null) {
                MyGroupDescriptor.$$$reportNull$$$0(0);
            }
            if (groupName == null) {
                MyGroupDescriptor.$$$reportNull$$$0(1);
            }
            if (borderColor == null) {
                MyGroupDescriptor.$$$reportNull$$$0(2);
            }
            super(groupName, parent);
            this.myBuilder = builder;
            this.myBorderColor = borderColor;
            this.setClosed(false);
        }

        @NotNull
        public GroupNodeRealizer createGroupNodeRealizer() {
            GroupNodeRealizer groupNodeRealizer = GraphGroupingUtil.createDefaultGroupNodeRealizer((String)this.getGroupName(), (Color)this.myBorderColor, null, (boolean)false);
            if (groupNodeRealizer == null) {
                MyGroupDescriptor.$$$reportNull$$$0(3);
            }
            return groupNodeRealizer;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "groupName";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "borderColor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/uml/core/actions/analysis/DiagramAutoClusteringAction$MyGroupDescriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/uml/core/actions/analysis/DiagramAutoClusteringAction$MyGroupDescriptor";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createGroupNodeRealizer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }
}

