/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.core.actions;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramNodeEditingManager;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.presentation.DiagramState;
import com.intellij.diagram.util.DiagramSelectionService;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.PopupAction;
import com.intellij.openapi.graph.GraphDataKeys;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.services.GraphAnimationService;
import com.intellij.openapi.graph.services.GraphCanvasLocationService;
import com.intellij.openapi.graph.services.GraphLayoutService;
import com.intellij.openapi.graph.util.Futures;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ActiveIcon;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.ui.popup.PopupPositionManager;
import com.intellij.ui.popup.PopupUpdateProcessor;
import com.intellij.uml.UmlFileEditorImpl;
import com.intellij.uml.UmlVirtualFileSystem;
import com.intellij.uml.components.UmlGraphZoomableViewport;
import com.intellij.uml.core.actions.ShowDiagramBase;
import com.intellij.uml.utils.DiagramBundle;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowDiagramPopup
extends ShowDiagramBase
implements PopupAction {
    private static final @NonNls String @NotNull [] ACTIONS = new String[]{"Uml.ShowSubtypes", "Uml.ShowSupers", "Uml.ShowUsed", "EditSource"};

    public ShowDiagramPopup() {
    }

    public ShowDiagramPopup(boolean isAlwaysAvailable) {
        super(isAlwaysAvailable);
    }

    @Override
    protected boolean isPopup() {
        return true;
    }

    @Override
    @NotNull
    @NonNls
    public String getFeatureId() {
        return "diagram.show.popup";
    }

    @NotNull
    @Nls
    protected String getTitle(@NotNull Project project, @Nullable Object element, @NotNull DiagramProvider<Object> provider, @NotNull DiagramState presentation, @NotNull Collection<Object> additionalElements) {
        if (project == null) {
            ShowDiagramPopup.$$$reportNull$$$0(0);
        }
        if (provider == null) {
            ShowDiagramPopup.$$$reportNull$$$0(1);
        }
        if (presentation == null) {
            ShowDiagramPopup.$$$reportNull$$$0(2);
        }
        if (additionalElements == null) {
            ShowDiagramPopup.$$$reportNull$$$0(3);
        }
        String string = DiagramBundle.message("show.diagram.popup.title", provider.getActionName(this.isPopup()), provider.getElementManager().getEditorTitle(element, additionalElements));
        if (string == null) {
            ShowDiagramPopup.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    private JBPopup createPopup(@Nullable Object element, @NotNull Collection<Object> elements, @NotNull DiagramBuilder builder) {
        if (elements == null) {
            ShowDiagramPopup.$$$reportNull$$$0(5);
        }
        if (builder == null) {
            ShowDiagramPopup.$$$reportNull$$$0(6);
        }
        Ref popupRef = Ref.create();
        Project project = builder.getProject();
        Graph2DView view = builder.getView();
        JComponent focusTarget = view.getJComponent();
        PopupUpdateProcessor updateProcessor = this.createUpdateProcessor(builder, project, (Ref<JBPopup>)popupRef);
        UmlGraphZoomableViewport viewport = new UmlGraphZoomableViewport(builder);
        DiagramProvider<Object> provider = builder.getProvider();
        String title = this.getTitle(project, element, provider, DiagramState.empty(provider), elements);
        JBPopup popup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)((Object)viewport), focusTarget).setResizable(true).setFocusable(true).setMovable(true).setMayBeParent(true).addListener((JBPopupListener)updateProcessor).addUserData((Object)updateProcessor).setTitle(title).setTitleIcon(new ActiveIcon(AllIcons.FileTypes.Diagram, AllIcons.FileTypes.Diagram)).setCancelOnOtherWindowOpen(false).setCancelOnWindowDeactivation(false).setRequestFocus(!this.isCalledFromJList()).setCancelCallback(() -> {
            DiagramNodeEditingManager.getInstance().dropLastActiveNodeEditor();
            return true;
        }).createPopup();
        popupRef.set((Object)popup);
        JBPopup jBPopup = popup;
        if (jBPopup == null) {
            ShowDiagramPopup.$$$reportNull$$$0(7);
        }
        return jBPopup;
    }

    @Override
    @NotNull
    public CompletionStage<Void> showReadyDiagram(@Nullable Object element, @NotNull Collection<Object> additionalElements, @NotNull DiagramBuilder builder, @NotNull UmlVirtualFileSystem.UmlVirtualFile file, @NotNull RelativePoint popupLocation) {
        if (additionalElements == null) {
            ShowDiagramPopup.$$$reportNull$$$0(8);
        }
        if (builder == null) {
            ShowDiagramPopup.$$$reportNull$$$0(9);
        }
        if (file == null) {
            ShowDiagramPopup.$$$reportNull$$$0(10);
        }
        if (popupLocation == null) {
            ShowDiagramPopup.$$$reportNull$$$0(11);
        }
        CompletableFuture completableFuture = Futures.runWriteActionAsync(() -> {
            builder.queryUpdate().withDataReload().withPresentationUpdate().run();
            JBPopup popup = this.createPopup(element, additionalElements, builder);
            Disposer.register((Disposable)popup, (Disposable)builder);
            builder.setPopup(popup);
        });
        if (completableFuture == null) {
            ShowDiagramPopup.$$$reportNull$$$0(12);
        }
        return completableFuture;
    }

    @Override
    @NotNull
    public CompletionStage<Void> afterDiagramIsShown(@Nullable Object element, @NotNull Collection<Object> additionalElements, @NotNull DiagramBuilder builder, @NotNull UmlVirtualFileSystem.UmlVirtualFile file, @NotNull RelativePoint popupLocation) {
        if (additionalElements == null) {
            ShowDiagramPopup.$$$reportNull$$$0(13);
        }
        if (builder == null) {
            ShowDiagramPopup.$$$reportNull$$$0(14);
        }
        if (file == null) {
            ShowDiagramPopup.$$$reportNull$$$0(15);
        }
        if (popupLocation == null) {
            ShowDiagramPopup.$$$reportNull$$$0(16);
        }
        CompletionStage completionStage = GraphLayoutService.getInstance().queryLayout(builder.getGraphBuilder()).runAsync().thenRunAsync(() -> {
            JBPopup popup = Objects.requireNonNull(builder.getPopup());
            GraphCanvasLocationService.getInstance().setBestPopupSizeForGraph(popup, builder.getGraphBuilder());
            popup.show(popupLocation);
            if (this.isCalledFromJList()) {
                PopupPositionManager.positionPopupInBestPosition((JBPopup)popup, null, null);
            }
            ShowDiagramPopup.customFitContent(builder.getGraphBuilder());
            builder.getDataModel().getNodes().stream().filter(it -> it.getIdentifyingElement().equals(element)).findFirst().ifPresent(it -> DiagramSelectionService.getInstance().setSelected(builder, (DiagramNode<?>)it, true));
            Graph2DView view = builder.getView();
            this.registerUmlActionsOnComponent(view.getJComponent());
            GraphDataKeys.addDataProvider((Graph2DView)view, dataId -> UmlFileEditorImpl.getData(dataId, builder));
        }, Futures.inWriteAction());
        if (completionStage == null) {
            ShowDiagramPopup.$$$reportNull$$$0(17);
        }
        return completionStage;
    }

    @NotNull
    private PopupUpdateProcessor createUpdateProcessor(final @NotNull DiagramBuilder builder, final @NotNull Project project, final @NotNull Ref<JBPopup> popupRef) {
        if (builder == null) {
            ShowDiagramPopup.$$$reportNull$$$0(18);
        }
        if (project == null) {
            ShowDiagramPopup.$$$reportNull$$$0(19);
        }
        if (popupRef == null) {
            ShowDiagramPopup.$$$reportNull$$$0(20);
        }
        return new PopupUpdateProcessor(project){

            public void updatePopup(@Nullable Object o) {
                PsiElement element = o instanceof PsiElement ? (PsiElement)o : null;
                Module module = o instanceof Module ? (Module)o : null;
                DataContext context = dataId -> {
                    if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
                        return element;
                    }
                    if (PlatformCoreDataKeys.MODULE.is(dataId) || LangDataKeys.MODULE_CONTEXT.is(dataId)) {
                        return module;
                    }
                    return null;
                };
                Object newObj = builder.getProvider().getElementManager().findInDataContext(context);
                JBPopup popup = (JBPopup)popupRef.get();
                if (newObj != null) {
                    builder.getDataModel().rebuild(newObj);
                    builder.queryUpdate().withDataReload().withPresentationUpdate().withRelayout().run();
                    builder.relayout();
                    builder.getGraphBuilder().fitContent(false);
                    if (popup instanceof AbstractPopup) {
                        DiagramProvider<Object> provider = builder.getProvider();
                        popup.setCaption(ShowDiagramPopup.this.getTitle(project, newObj, provider, DiagramState.empty(provider), Collections.emptyList()));
                    }
                    Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                    GraphCanvasLocationService.getInstance().setBestPopupSizeForGraph(popup, builder.getGraphBuilder());
                    if (focusOwner instanceof JComponent) {
                        PopupPositionManager.positionPopupInBestPosition((JBPopup)popup, null, null);
                    }
                }
            }
        };
    }

    protected void registerUmlActionsOnComponent(@Nullable JComponent component) {
        ActionManager manager = ActionManager.getInstance();
        for (String actionId : ACTIONS) {
            AnAction action = manager.getAction(actionId);
            if (action == null) continue;
            action.registerCustomShortcutSet(action.getShortcutSet(), component);
        }
    }

    private static void customFitContent(@NotNull GraphBuilder<?, ?> builder) {
        if (builder == null) {
            ShowDiagramPopup.$$$reportNull$$$0(21);
        }
        Graph2D graph = builder.getGraph();
        Rectangle r = GraphCanvasLocationService.getInstance().getBoundingBoxOfNodes(graph);
        GraphAnimationService.getInstance().zoomToArea(builder.getView(), r.getMinY(), r.getMinX(), r.getMaxY(), r.getMaxX(), false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 7, 12, 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 3: 
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalElements";
                break;
            }
            case 4: 
            case 7: 
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uml/core/actions/ShowDiagramPopup";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 6: 
            case 9: 
            case 14: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popupLocation";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popupRef";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uml/core/actions/ShowDiagramPopup";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createPopup";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "showReadyDiagram";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "afterDiagramIsShown";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getTitle";
                break;
            }
            case 4: 
            case 7: 
            case 12: 
            case 17: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createPopup";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "showReadyDiagram";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "afterDiagramIsShown";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createUpdateProcessor";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "customFitContent";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 7, 12, 17 -> new IllegalStateException(string);
        };
    }

    public static final class Default
    extends ShowDiagramPopup {
        public Default() {
            super(true);
        }
    }
}

