/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.core.actions;

import com.intellij.diagram.DiagramAction;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramNodeEditingManager;
import com.intellij.diagram.DiagramNoteNode;
import com.intellij.diagram.util.DiagramSelectionService;
import com.intellij.diagram.util.DiagramUpdateService;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.graph.builder.NodeGroupDescriptor;
import com.intellij.openapi.graph.services.GraphCanvasLocationService;
import com.intellij.openapi.graph.services.GraphSelectionService;
import com.intellij.openapi.graph.util.Futures;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.uml.utils.DiagramBundle;
import com.intellij.uml.v2.oldapiadapters.GraphChartAdapterForDiagramDataModel;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiagramDeleteSelectionAction
extends DiagramAction {
    @Override
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            DiagramDeleteSelectionAction.$$$reportNull$$$0(0);
        }
        DiagramBuilder builder = DiagramDeleteSelectionAction.getBuilder(e);
        e.getPresentation().setEnabledAndVisible(builder != null && this.isEnabled(e, builder));
    }

    @Override
    public boolean isEnabled(@NotNull AnActionEvent e, @NotNull DiagramBuilder builder) {
        if (e == null) {
            DiagramDeleteSelectionAction.$$$reportNull$$$0(1);
        }
        if (builder == null) {
            DiagramDeleteSelectionAction.$$$reportNull$$$0(2);
        }
        return GraphSelectionService.getInstance().anyNodeOrEdgeSelected(builder.getGraph()) && !DiagramNodeEditingManager.getInstance().isEditing() && builder.getProvider().getExtras().isDeleteActionImplemented();
    }

    @Override
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
        if (actionUpdateThread == null) {
            DiagramDeleteSelectionAction.$$$reportNull$$$0(3);
        }
        return actionUpdateThread;
    }

    @Override
    public void perform(@NotNull AnActionEvent e) {
        DiagramBuilder builder;
        if (e == null) {
            DiagramDeleteSelectionAction.$$$reportNull$$$0(4);
        }
        if ((builder = DiagramDeleteSelectionAction.getBuilder(e)) == null) {
            return;
        }
        if (builder.getProvider().getExtras().isDeleteActionImplemented()) {
            DiagramDeleteSelectionAction.removeSelection(builder);
        }
    }

    public static void removeSelection(@Nullable DiagramBuilder builder) {
        if (builder == null) {
            return;
        }
        List<DiagramNode<?>> selectedNodes = DiagramSelectionService.getInstance().getSelectedNodes(builder);
        List<DiagramEdge<?>> selectedEdges = DiagramSelectionService.getInstance().getSelectedEdges(builder);
        List<NodeGroupDescriptor> selectedGroupNodes = DiagramSelectionService.getInstance().getSelectedGroupNodes(builder);
        DiagramDeleteSelectionAction.remove(builder, selectedNodes, selectedEdges, selectedGroupNodes);
    }

    public static void remove(@NotNull DiagramBuilder builder, @NotNull List<DiagramNode<?>> nodesToRemove, @NotNull List<DiagramEdge<?>> edgesToRemove, @NotNull List<NodeGroupDescriptor> groupNodesToRemove) {
        if (builder == null) {
            DiagramDeleteSelectionAction.$$$reportNull$$$0(5);
        }
        if (nodesToRemove == null) {
            DiagramDeleteSelectionAction.$$$reportNull$$$0(6);
        }
        if (edgesToRemove == null) {
            DiagramDeleteSelectionAction.$$$reportNull$$$0(7);
        }
        if (groupNodesToRemove == null) {
            DiagramDeleteSelectionAction.$$$reportNull$$$0(8);
        }
        DiagramDataModel<?> dataModel = builder.getDataModel();
        if (!edgesToRemove.isEmpty()) {
            dataModel.removeEdges(edgesToRemove);
        }
        if (!nodesToRemove.isEmpty()) {
            DiagramDeleteSelectionAction.removeNodes(dataModel, nodesToRemove);
        }
        if (!groupNodesToRemove.isEmpty()) {
            dataModel.removeGroupNodes(groupNodesToRemove);
        }
        if (!(nodesToRemove.isEmpty() && edgesToRemove.isEmpty() && groupNodesToRemove.isEmpty())) {
            if (dataModel instanceof GraphChartAdapterForDiagramDataModel) {
                ((GraphChartAdapterForDiagramDataModel)dataModel).reloadDataFromGraph();
            }
            DiagramUpdateService.getInstance().requestDataModelRefreshPreservingLayout(builder).runAsync().thenRunAsync(() -> {
                JBPopup popup = builder.getPopup();
                if (popup != null) {
                    GraphCanvasLocationService.getInstance().setBestPopupSizeForGraph(popup, builder.getGraphBuilder());
                }
            }, Futures.inEdt());
        }
    }

    public static void removeNodes(@NotNull DiagramDataModel<?> dataModel, @NotNull Collection<DiagramNode<?>> umlNodes) {
        if (dataModel == null) {
            DiagramDeleteSelectionAction.$$$reportNull$$$0(9);
        }
        if (umlNodes == null) {
            DiagramDeleteSelectionAction.$$$reportNull$$$0(10);
        }
        List<DiagramNode<?>> nonNotes = umlNodes.stream().filter(node -> !(node instanceof DiagramNoteNode)).toList();
        dataModel.removeNodes(nonNotes);
        List<DiagramNoteNode> notesToRemove = umlNodes.stream().filter(node -> node instanceof DiagramNoteNode).map(node -> (DiagramNoteNode)node).toList();
        for (DiagramNoteNode note : notesToRemove) {
            dataModel.removeNote(note);
        }
        Map<DiagramNode<?>, DiagramNoteNode> notes = dataModel.getNotes();
        for (DiagramNode<?> node2 : umlNodes) {
            if (!notes.containsKey(node2)) continue;
            dataModel.removeNote(notes.get(node2));
        }
    }

    public static void removeNode(@NotNull DiagramDataModel<?> dataModel, @NotNull DiagramNode umlNode) {
        if (dataModel == null) {
            DiagramDeleteSelectionAction.$$$reportNull$$$0(11);
        }
        if (umlNode == null) {
            DiagramDeleteSelectionAction.$$$reportNull$$$0(12);
        }
        if (umlNode instanceof DiagramNoteNode) {
            dataModel.removeNote((DiagramNoteNode)umlNode);
        } else {
            dataModel.removeNode(umlNode);
            Map<DiagramNode<?>, DiagramNoteNode> notes = dataModel.getNotes();
            if (notes.containsKey(umlNode)) {
                dataModel.removeNote(notes.get(umlNode));
            }
        }
    }

    @Override
    @Nls
    @NotNull
    public String getActionName() {
        String string = DiagramBundle.message("action.Diagram.DeleteSelection.text", new Object[0]);
        if (string == null) {
            DiagramDeleteSelectionAction.$$$reportNull$$$0(13);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 3: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uml/core/actions/DiagramDeleteSelectionAction";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodesToRemove";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edgesToRemove";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupNodesToRemove";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataModel";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "umlNodes";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "umlNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uml/core/actions/DiagramDeleteSelectionAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
            case 3: 
            case 13: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "perform";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "removeNodes";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "removeNode";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 13 -> new IllegalStateException(string);
        };
    }
}

