/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml;

import com.intellij.codeWithMe.ClientId;
import com.intellij.diagnostic.Checks;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramColorManager;
import com.intellij.diagram.DiagramDataKeys;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramDataModelWrapper;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramFileEditor;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramPresentationModel;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.presentation.DiagramState;
import com.intellij.diagram.state.DiagramEdgeIdentity;
import com.intellij.diagram.state.DiagramFullSnapshot;
import com.intellij.diagram.state.DiagramLayoutSnapshot;
import com.intellij.diagram.state.DiagramNodeIdentity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.graph.GraphDataKeys;
import com.intellij.openapi.graph.base.Edge;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.GraphDataModel;
import com.intellij.openapi.graph.builder.GraphIdentifiable;
import com.intellij.openapi.graph.builder.GraphPresentationModel;
import com.intellij.openapi.graph.builder.event.GraphBuilderEvent;
import com.intellij.openapi.graph.builder.event.GraphBuilderListener;
import com.intellij.openapi.graph.builder.util.NodeFactory;
import com.intellij.openapi.graph.impl.builder.GraphBuilderImpl;
import com.intellij.openapi.graph.layout.Layouter;
import com.intellij.openapi.graph.layout.NodeLayout;
import com.intellij.openapi.graph.services.GraphCanvasLocationService;
import com.intellij.openapi.graph.services.GraphExportService;
import com.intellij.openapi.graph.services.GraphLayoutService;
import com.intellij.openapi.graph.util.Futures;
import com.intellij.openapi.graph.view.EdgeRealizer;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.uml.UmlFileEditorImpl;
import com.intellij.uml.undo.UmlRefactoringElementListenerProvider;
import com.intellij.util.ArrayUtil;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UmlGraphBuilder
extends GraphBuilderImpl<DiagramNode<?>, DiagramEdge<?>>
implements GraphBuilderListener,
DiagramBuilder,
DocumentListener {
    @Deprecated(forRemoval=true)
    @NotNull
    public static final Key<VirtualFile> EDITOR_FILE = Key.create((String)"diagram.editor.file");
    private volatile boolean myPopupMode;

    protected UmlGraphBuilder(@NotNull Project project, @NotNull Graph2D graph, @NotNull Graph2DView view, @NotNull DiagramDataModel<?> dataModel, @NotNull DiagramPresentationModel presentationModel) {
        if (project == null) {
            UmlGraphBuilder.$$$reportNull$$$0(0);
        }
        if (graph == null) {
            UmlGraphBuilder.$$$reportNull$$$0(1);
        }
        if (view == null) {
            UmlGraphBuilder.$$$reportNull$$$0(2);
        }
        if (dataModel == null) {
            UmlGraphBuilder.$$$reportNull$$$0(3);
        }
        if (presentationModel == null) {
            UmlGraphBuilder.$$$reportNull$$$0(4);
        }
        super(project, graph, view, (GraphDataModel)new DiagramDataModelWrapper(dataModel), (GraphPresentationModel)presentationModel, null);
        presentationModel.setGraphBuilder((GraphBuilder)this);
        this.addGraphBuilderListener(this, this);
        if (dataModel.isPsiListener()) {
            UmlRefactoringElementListenerProvider.getInstance(project).addBuilder(this);
            DocumentListener documentListener = new DocumentListener(){

                public void documentChanged(@NotNull DocumentEvent e) {
                    VirtualFile editorFile;
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if ((editorFile = UmlGraphBuilder.this.getEditorFile()) != null) {
                        Document document = e.getDocument();
                        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
                        Project documentProject = virtualFile == null ? null : ProjectUtil.guessProjectForFile((VirtualFile)virtualFile);
                        Project myProject = UmlGraphBuilder.this.getProject();
                        if (myProject.equals(documentProject)) {
                            PsiFile psiFile = PsiDocumentManager.getInstance((Project)myProject).getPsiFile(document);
                            if (!CommandProcessor.getInstance().isUndoTransparentActionInProgress() && CommandProcessor.getInstance().getCurrentCommand() != null && psiFile != null && psiFile.isValid() && UmlGraphBuilder.this.getDataModel().hasFile(psiFile) && UmlGraphBuilder.this.isDiagramEditorActive()) {
                                CommandProcessor.getInstance().addAffectedFiles(myProject, new VirtualFile[]{editorFile});
                            }
                        }
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/uml/UmlGraphBuilder$1", "documentChanged"));
                }
            };
            EditorFactory.getInstance().getEventMulticaster().addDocumentListener(documentListener, (Disposable)this);
        }
    }

    private boolean isDiagramEditorActive() {
        return ArrayUtil.contains((Object)this.getEditor(), (Object[])FileEditorManager.getInstance((Project)this.getProject()).getSelectedEditors());
    }

    @NotNull
    public DiagramPresentationModel getGraphPresentationModel() {
        DiagramPresentationModel diagramPresentationModel = (DiagramPresentationModel)super.getGraphPresentationModel();
        if (diagramPresentationModel == null) {
            UmlGraphBuilder.$$$reportNull$$$0(5);
        }
        return diagramPresentationModel;
    }

    @Override
    @NotNull
    public DiagramPresentationModel getPresentationModel() {
        DiagramPresentationModel diagramPresentationModel = this.getGraphPresentationModel();
        if (diagramPresentationModel == null) {
            UmlGraphBuilder.$$$reportNull$$$0(6);
        }
        return diagramPresentationModel;
    }

    @Override
    @NotNull
    public GraphBuilder<DiagramNode<?>, DiagramEdge<?>> getGraphBuilder() {
        UmlGraphBuilder umlGraphBuilder = this;
        if (umlGraphBuilder == null) {
            UmlGraphBuilder.$$$reportNull$$$0(7);
        }
        return umlGraphBuilder;
    }

    @Override
    @NotNull
    public EditorColorsScheme getColorScheme() {
        if (GraphExportService.getInstance().isPrintMode()) {
            EditorColorsScheme editorColorsScheme = EditorColorsManager.getInstance().getScheme("Default");
            if (editorColorsScheme == null) {
                UmlGraphBuilder.$$$reportNull$$$0(8);
            }
            return editorColorsScheme;
        }
        EditorColorsScheme editorColorsScheme = EditorColorsManager.getInstance().getGlobalScheme();
        if (editorColorsScheme == null) {
            UmlGraphBuilder.$$$reportNull$$$0(9);
        }
        return editorColorsScheme;
    }

    @Override
    public boolean doAllowEdgeCreation() {
        return this.getEditMode().doAllowEdgeCreation();
    }

    @Override
    public void setAllowEdgeCreation(boolean allow) {
        this.getEditMode().allowEdgeCreation(allow);
    }

    @Override
    @NotNull
    public DiagramDataModel<?> getDataModel() {
        DiagramDataModel diagramDataModel = ((DiagramDataModelWrapper)this.getGraphDataModel()).getModel();
        if (diagramDataModel == null) {
            UmlGraphBuilder.$$$reportNull$$$0(10);
        }
        return diagramDataModel;
    }

    @Override
    @NotNull
    public DiagramProvider<?> getProvider() {
        DiagramProvider provider = (DiagramProvider)this.getUserData(DiagramDataKeys.UML_PROVIDER);
        assert (provider != null) : "Forget to add uml provider to the user data";
        DiagramProvider diagramProvider = provider;
        if (diagramProvider == null) {
            UmlGraphBuilder.$$$reportNull$$$0(11);
        }
        return diagramProvider;
    }

    @Override
    @Nullable
    public DiagramFileEditor getEditor() {
        return (DiagramFileEditor)this.getUserData(DiagramDataKeys.UML_FILE_EDITOR);
    }

    @Override
    public void setEditor(@NotNull DiagramFileEditor editor) {
        if (editor == null) {
            UmlGraphBuilder.$$$reportNull$$$0(12);
        }
        this.putUserData(GraphDataKeys.GRAPH_FILE_EDITOR, editor);
        this.putUserData(DiagramDataKeys.UML_FILE_EDITOR, editor);
        editor.putUserData(DiagramDataKeys.GRAPH_BUILDER, this);
    }

    @Override
    @Nullable
    public DocumentReference getDocumentReference() {
        VirtualFile file;
        DiagramFileEditor editor = this.getEditor();
        if (editor != null && (file = editor.getOriginalVirtualFile()).isValid()) {
            return DocumentReferenceManager.getInstance().create(file);
        }
        return null;
    }

    public void beforeActionPerformed(@NotNull GraphBuilder builder, @NotNull GraphBuilderEvent event) {
        if (builder == null) {
            UmlGraphBuilder.$$$reportNull$$$0(13);
        }
        if (event == null) {
            UmlGraphBuilder.$$$reportNull$$$0(14);
        }
    }

    public void actionPerformed(@NotNull GraphBuilder builder, @NotNull GraphBuilderEvent event) {
        if (builder == null) {
            UmlGraphBuilder.$$$reportNull$$$0(15);
        }
        if (event == null) {
            UmlGraphBuilder.$$$reportNull$$$0(16);
        }
        if (event != GraphBuilderEvent.ZOOM_CHANGED && this == builder) {
            this.notifyOtherBuilders();
        }
    }

    @Override
    public void notifyOtherBuilders() {
        VirtualFile file = this.getEditorFile();
        if (file == null) {
            return;
        }
        FileEditor[] editors = FileEditorManager.getInstance((Project)this.getProject()).getAllEditors(file);
        if (editors.length < 2) {
            return;
        }
        DiagramFullSnapshot snapshot = DiagramFullSnapshot.Factory.getInstance().makeSnapshot(this);
        ApplicationManager.getApplication().invokeLater(() -> {
            for (FileEditor editor : editors) {
                DiagramBuilder anotherBuilder;
                if (!(editor instanceof UmlFileEditorImpl) || (anotherBuilder = ((UmlFileEditorImpl)editor).getModelBuilder()) == this) continue;
                snapshot.restoreAsync(anotherBuilder).thenRunAsync(ClientId.decorateRunnable(() -> anotherBuilder.queryUpdate().withPresentationUpdate().run()));
            }
        });
    }

    @Override
    @NotNull
    public DiagramBuilder.DiagramUpdateQueryParams queryUpdate() {
        return new DiagramUpdateQueryParamsImpl();
    }

    protected void runUpdate(@NotNull DiagramUpdateQueryParamsImpl params) {
        if (params == null) {
            UmlGraphBuilder.$$$reportNull$$$0(17);
        }
        if (params.doReloadData()) {
            this.update(params.doPresentationUpdate(), params.getLayouter(), params.getNodesForSizeUpdate());
        } else {
            if (params.doPresentationUpdate()) {
                this.getGraphPresentationModel().update();
            }
            this.updateView(params.getLayouter(), params.getNodesForSizeUpdate());
        }
    }

    @NotNull
    protected CompletableFuture<Void> runUpdateAsync(@NotNull DiagramUpdateQueryParamsImpl params) {
        if (params == null) {
            UmlGraphBuilder.$$$reportNull$$$0(18);
        }
        if (params.doReloadData()) {
            CompletableFuture<Void> completableFuture = this.updateAsync(params.doPresentationUpdate(), params.getLayouter(), params.getNodesForSizeUpdate());
            if (completableFuture == null) {
                UmlGraphBuilder.$$$reportNull$$$0(19);
            }
            return completableFuture;
        }
        CompletionStage completionStage = Futures.runInEdtAsync(() -> {
            if (params.doPresentationUpdate()) {
                this.getGraphPresentationModel().update();
            }
        }).thenComposeAsync(__ -> this.updateViewAsync(params.getLayouter(), params.getNodesForSizeUpdate()));
        if (completionStage == null) {
            UmlGraphBuilder.$$$reportNull$$$0(20);
        }
        return completionStage;
    }

    public void updateRealizers(boolean updateAllNodes) {
        super.updateRealizers(updateAllNodes);
        DiagramColorManager colorManager = this.getProvider().getColorManager();
        NodeRealizer.Statics.setHotSpotColor((Color)colorManager.getHotSpotColor(this));
        EdgeRealizer.Statics.setSelectionColor((Color)colorManager.getEdgeSelectionColor(this));
        EdgeRealizer.Statics.setHighlightedBendColor((Color)colorManager.getBendSelectionColor(this));
    }

    @Override
    public void update() {
        this.update(true, false);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @RequiresEdt
    public void update(boolean bl, boolean bl2) {
        void updateLayout;
        void increaseModTrackerCounter;
        ThreadingAssertions.assertEventDispatchThread();
        this.update((boolean)increaseModTrackerCounter, updateLayout != false ? this.getPresentationModel().getSettings().getCurrentLayouter() : null, Collections.emptyList());
    }

    @RequiresEdt
    protected void update(boolean increaseModTrackerCounter, @Nullable Layouter layouter, @NotNull Collection<DiagramNode<?>> nodesForSizeUpdate) {
        if (nodesForSizeUpdate == null) {
            UmlGraphBuilder.$$$reportNull$$$0(21);
        }
        ThreadingAssertions.assertEventDispatchThread();
        if (increaseModTrackerCounter) {
            this.getGraphPresentationModel().update();
        }
        DiagramLayoutSnapshot currentLayout = DiagramLayoutSnapshot.Factory.getInstance().makeSnapshot(this);
        this.updateGraph(false, nodesForSizeUpdate);
        currentLayout.restore(this);
        if (layouter != null) {
            JBPopup popup;
            this.relayout(layouter);
            if (this.isPopupMode() && (popup = (JBPopup)this.getUserData(DiagramDataKeys.UML_POPUP)) != null && !popup.isDisposed()) {
                GraphCanvasLocationService.getInstance().setBestPopupSizeForGraph(popup, (GraphBuilder)this);
            }
            this.getGraph().updateViews();
        }
    }

    @NotNull
    protected CompletableFuture<Void> updateAsync(boolean increaseModTrackerCounter, @Nullable Layouter layouter, @NotNull Collection<DiagramNode<?>> nodesForSizeUpdate) {
        if (nodesForSizeUpdate == null) {
            UmlGraphBuilder.$$$reportNull$$$0(22);
        }
        CompletionStage completionStage = ((CompletableFuture)((CompletableFuture)Futures.runInEdtAsync(() -> {
            if (increaseModTrackerCounter) {
                this.getGraphPresentationModel().update();
            }
            DiagramLayoutSnapshot currentLayout = DiagramLayoutSnapshot.Factory.getInstance().makeSnapshot(this);
            this.updateGraph(false, nodesForSizeUpdate);
            return currentLayout;
        }).thenComposeAsync(ClientId.decorateFunction(currentLayout -> currentLayout.restoreAsync(this)))).thenComposeAsync(ClientId.decorateFunction(__ -> layouter != null ? this.relayoutAsync(layouter) : CompletableFuture.completedFuture(null)))).thenRunAsync(() -> {
            JBPopup popup;
            if (this.isPopupMode() && (popup = (JBPopup)this.getUserData(DiagramDataKeys.UML_POPUP)) != null && !popup.isDisposed()) {
                GraphCanvasLocationService.getInstance().setBestPopupSizeForGraph(popup, (GraphBuilder)this);
            }
            this.getGraph().updateViews();
        }, Futures.inEdt());
        if (completionStage == null) {
            UmlGraphBuilder.$$$reportNull$$$0(23);
        }
        return completionStage;
    }

    @Override
    public boolean isPopupMode() {
        return this.myPopupMode;
    }

    @Override
    @Nullable
    public JBPopup getPopup() {
        return (JBPopup)this.getUserData(DiagramDataKeys.UML_POPUP);
    }

    @Override
    public void setPopup(@NotNull JBPopup popup) {
        if (popup == null) {
            UmlGraphBuilder.$$$reportNull$$$0(24);
        }
        this.putUserData(DiagramDataKeys.UML_POPUP, popup);
        this.setPopupMode(true);
    }

    public void setPopupMode(boolean popupMode) {
        this.myPopupMode = popupMode;
    }

    @Override
    @RequiresEdt
    public void relayout() {
        ThreadingAssertions.assertEventDispatchThread();
        GraphLayoutService.getInstance().queryLayout((GraphBuilder)this).run();
    }

    protected void relayout(@NotNull Layouter layouter) {
        if (layouter == null) {
            UmlGraphBuilder.$$$reportNull$$$0(25);
        }
        GraphLayoutService.getInstance().queryLayout((GraphBuilder)this).withLayouter(layouter).run();
    }

    @NotNull
    protected CompletableFuture<Void> relayoutAsync(@NotNull Layouter layouter) {
        if (layouter == null) {
            UmlGraphBuilder.$$$reportNull$$$0(26);
        }
        CompletableFuture completableFuture = GraphLayoutService.getInstance().queryLayout((GraphBuilder)this).withLayouter(layouter).runAsync();
        if (completableFuture == null) {
            UmlGraphBuilder.$$$reportNull$$$0(27);
        }
        return completableFuture;
    }

    @RequiresEdt
    public void createDraggedNode(@NotNull DiagramNode node, @Nullable String nodeName, @NotNull Point point) {
        NodeLayout nodeLayout;
        if (node == null) {
            UmlGraphBuilder.$$$reportNull$$$0(28);
        }
        if (point == null) {
            UmlGraphBuilder.$$$reportNull$$$0(29);
        }
        ThreadingAssertions.assertEventDispatchThread();
        Node nodeObj = NodeFactory.getInstance().createDraggedNode((GraphBuilder)this, (Object)node, node.getTooltip(), point);
        this.getDataModel().refreshDataModel();
        if (nodeObj != null && (nodeLayout = this.getGraph().getNodeLayout((Object)nodeObj)) != null) {
            nodeLayout.setLocation((double)point.x, (double)point.y);
        }
    }

    @Nullable
    public VirtualFile getEditorFile() {
        return (VirtualFile)this.getUserData(DiagramDataKeys.EDITOR_FILE);
    }

    public void dispose() {
        DocumentReference ref = this.getDocumentReference();
        if (ref != null) {
            ((UndoManagerImpl)UndoManager.getInstance((Project)this.getProject())).invalidateActionsFor(ref);
        }
        DiagramState.invalidateSnapshotsFor(this);
        super.dispose();
    }

    @Override
    public void requestFocus() {
        IdeFocusManager.getInstance((Project)this.getProject()).requestFocus((Component)this.getView().getCanvasComponent(), true);
    }

    @NotNull
    public GraphIdentifiable.Node.Identity getNodeIdentity(@NotNull Node node) {
        DiagramNode modelNode;
        if (node == null) {
            UmlGraphBuilder.$$$reportNull$$$0(30);
        }
        return (modelNode = (DiagramNode)this.getNodeObject(node)) != null ? DiagramNodeIdentity.of(modelNode) : new GraphIdentifiable.Node.OfGraphNode(node);
    }

    @NotNull
    public GraphIdentifiable.Edge.Identity getEdgeIdentity(@NotNull Edge edge) {
        DiagramEdge modelEdge;
        if (edge == null) {
            UmlGraphBuilder.$$$reportNull$$$0(31);
        }
        return (modelEdge = (DiagramEdge)this.getEdgeObject(edge)) != null ? DiagramEdgeIdentity.of(modelEdge) : new GraphIdentifiable.Edge.OfGraphEdge(edge);
    }

    public String toString() {
        return "UmlGraphBuilder@" + this.hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 7, 8, 9, 10, 11, 19, 20, 23, 27 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataModel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentationModel";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 19: 
            case 20: 
            case 23: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uml/UmlGraphBuilder";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodesForSizeUpdate";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popup";
                break;
            }
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layouter";
                break;
            }
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edge";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uml/UmlGraphBuilder";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getGraphPresentationModel";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentationModel";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getGraphBuilder";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getColorScheme";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataModel";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getProvider";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "runUpdateAsync";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "updateAsync";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "relayoutAsync";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 19: 
            case 20: 
            case 23: 
            case 27: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setEditor";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "beforeActionPerformed";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "runUpdate";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "runUpdateAsync";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "updateAsync";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "setPopup";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "relayout";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "relayoutAsync";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "createDraggedNode";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getNodeIdentity";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getEdgeIdentity";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 7, 8, 9, 10, 11, 19, 20, 23, 27 -> new IllegalStateException(string);
        };
    }

    private class DiagramUpdateQueryParamsImpl
    implements DiagramBuilder.DiagramUpdateQueryParams {
        private boolean myDoReloadData;
        private boolean myDoPresentationUpdate;
        private boolean myDoNodePresentationsUpdate;
        @Nullable
        private Layouter myLayouter;
        @NotNull
        private final List<DiagramNode<?>> myNodesForSizeUpdate = new ArrayList();
        private boolean mySealed;

        private DiagramUpdateQueryParamsImpl() {
        }

        @Override
        @NotNull
        public DiagramUpdateQueryParamsImpl withDataReload() {
            Checks.check((!this.mySealed ? 1 : 0) != 0);
            this.myDoReloadData = true;
            DiagramUpdateQueryParamsImpl diagramUpdateQueryParamsImpl = this;
            if (diagramUpdateQueryParamsImpl == null) {
                DiagramUpdateQueryParamsImpl.$$$reportNull$$$0(0);
            }
            return diagramUpdateQueryParamsImpl;
        }

        @Override
        @NotNull
        public DiagramUpdateQueryParamsImpl withRelayout() {
            Checks.check((!this.mySealed ? 1 : 0) != 0);
            this.myLayouter = UmlGraphBuilder.this.getGraphPresentationModel().getSettings().getCurrentLayouter();
            DiagramUpdateQueryParamsImpl diagramUpdateQueryParamsImpl = this;
            if (diagramUpdateQueryParamsImpl == null) {
                DiagramUpdateQueryParamsImpl.$$$reportNull$$$0(1);
            }
            return diagramUpdateQueryParamsImpl;
        }

        @Override
        @NotNull
        public DiagramUpdateQueryParamsImpl withRelayout(@NotNull Layouter layouter) {
            if (layouter == null) {
                DiagramUpdateQueryParamsImpl.$$$reportNull$$$0(2);
            }
            Checks.check((!this.mySealed ? 1 : 0) != 0);
            this.myLayouter = layouter;
            DiagramUpdateQueryParamsImpl diagramUpdateQueryParamsImpl = this;
            if (diagramUpdateQueryParamsImpl == null) {
                DiagramUpdateQueryParamsImpl.$$$reportNull$$$0(3);
            }
            return diagramUpdateQueryParamsImpl;
        }

        @Override
        @NotNull
        public DiagramUpdateQueryParamsImpl withPresentationUpdate() {
            Checks.check((!this.mySealed ? 1 : 0) != 0);
            this.myDoPresentationUpdate = true;
            DiagramUpdateQueryParamsImpl diagramUpdateQueryParamsImpl = this;
            if (diagramUpdateQueryParamsImpl == null) {
                DiagramUpdateQueryParamsImpl.$$$reportNull$$$0(4);
            }
            return diagramUpdateQueryParamsImpl;
        }

        @Override
        @NotNull
        public DiagramBuilder.DiagramUpdateQueryParams withNodePresentationsUpdate(boolean updateNodePresentations) {
            Checks.check((!this.mySealed ? 1 : 0) != 0);
            this.myDoNodePresentationsUpdate = true;
            DiagramUpdateQueryParamsImpl diagramUpdateQueryParamsImpl = this;
            if (diagramUpdateQueryParamsImpl == null) {
                DiagramUpdateQueryParamsImpl.$$$reportNull$$$0(5);
            }
            return diagramUpdateQueryParamsImpl;
        }

        @Override
        @NotNull
        public DiagramUpdateQueryParamsImpl withAllNodeSizeUpdate() {
            Checks.check((!this.mySealed ? 1 : 0) != 0);
            ContainerUtil.addAll(this.myNodesForSizeUpdate, (Iterable)((Iterable)ReadAction.compute(() -> UmlGraphBuilder.this.getNodeObjects())));
            DiagramUpdateQueryParamsImpl diagramUpdateQueryParamsImpl = this;
            if (diagramUpdateQueryParamsImpl == null) {
                DiagramUpdateQueryParamsImpl.$$$reportNull$$$0(6);
            }
            return diagramUpdateQueryParamsImpl;
        }

        @Override
        @NotNull
        public DiagramBuilder.DiagramUpdateQueryParams withNodeSizeUpdate(DiagramNode<?> ... nodesForSizeUpdate) {
            if (nodesForSizeUpdate == null) {
                DiagramUpdateQueryParamsImpl.$$$reportNull$$$0(7);
            }
            Checks.check((!this.mySealed ? 1 : 0) != 0);
            ContainerUtil.addAll(this.myNodesForSizeUpdate, (Object[])nodesForSizeUpdate);
            DiagramUpdateQueryParamsImpl diagramUpdateQueryParamsImpl = this;
            if (diagramUpdateQueryParamsImpl == null) {
                DiagramUpdateQueryParamsImpl.$$$reportNull$$$0(8);
            }
            return diagramUpdateQueryParamsImpl;
        }

        @Override
        public boolean doReloadData() {
            return this.myDoReloadData;
        }

        @Override
        public boolean doPresentationUpdate() {
            return this.myDoPresentationUpdate;
        }

        @Override
        public boolean doUpdateNodePresentations() {
            return this.myDoNodePresentationsUpdate;
        }

        @NotNull
        public List<DiagramNode<?>> getNodesForSizeUpdate() {
            List<DiagramNode<?>> list = this.myNodesForSizeUpdate;
            if (list == null) {
                DiagramUpdateQueryParamsImpl.$$$reportNull$$$0(9);
            }
            return list;
        }

        @Override
        @Nullable
        public Layouter getLayouter() {
            return this.myLayouter;
        }

        @Override
        public void run() {
            this.endQuery();
            UmlGraphBuilder.this.runUpdate(this);
        }

        @Override
        @NotNull
        public CompletableFuture<Void> runAsync() {
            this.endQuery();
            CompletionStage completionStage = UmlGraphBuilder.this.runUpdateAsync(this).whenComplete(Futures.logIfFailed(UmlGraphBuilder.class));
            if (completionStage == null) {
                DiagramUpdateQueryParamsImpl.$$$reportNull$$$0(10);
            }
            return completionStage;
        }

        @Override
        @NotNull
        public DiagramBuilder.DiagramUpdateQueryParams endQuery() {
            this.mySealed = true;
            DiagramUpdateQueryParamsImpl diagramUpdateQueryParamsImpl = this;
            if (diagramUpdateQueryParamsImpl == null) {
                DiagramUpdateQueryParamsImpl.$$$reportNull$$$0(11);
            }
            return diagramUpdateQueryParamsImpl;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 7 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/uml/UmlGraphBuilder$DiagramUpdateQueryParamsImpl";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "layouter";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nodesForSizeUpdate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withDataReload";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withRelayout";
                    break;
                }
                case 2: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/uml/UmlGraphBuilder$DiagramUpdateQueryParamsImpl";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withPresentationUpdate";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withNodePresentationsUpdate";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withAllNodeSizeUpdate";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withNodeSizeUpdate";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNodesForSizeUpdate";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "runAsync";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "endQuery";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "withRelayout";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "withNodeSizeUpdate";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 7 -> new IllegalArgumentException(string);
            };
        }
    }
}

