/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram.state;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramNoteEdge;
import com.intellij.diagram.DiagramNoteNode;
import com.intellij.diagram.state.DiagramEdgeIdentity;
import com.intellij.diagram.state.DiagramNodeIdentity;
import com.intellij.diagram.state.DiagramSnapshot;
import com.intellij.diagram.state.DiagramSnapshotFactory;
import com.intellij.openapi.graph.base.Edge;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.services.GraphSelectionService;
import com.intellij.openapi.graph.util.Futures;
import com.intellij.openapi.graph.view.Graph2D;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.jcip.annotations.Immutable;
import org.jetbrains.annotations.NotNull;

@Immutable
public final class DiagramSelectionSnapshot
implements DiagramSnapshot {
    @NotNull
    private final Set<DiagramNodeIdentity<Object>> mySelectedNodes;
    @NotNull
    private final Set<DiagramEdgeIdentity<Object>> mySelectedEdges;

    private DiagramSelectionSnapshot(@NotNull Set<DiagramNodeIdentity<Object>> selectedNodes, @NotNull Set<DiagramEdgeIdentity<Object>> selectedEdges) {
        if (selectedNodes == null) {
            DiagramSelectionSnapshot.$$$reportNull$$$0(0);
        }
        if (selectedEdges == null) {
            DiagramSelectionSnapshot.$$$reportNull$$$0(1);
        }
        this.mySelectedNodes = selectedNodes;
        this.mySelectedEdges = selectedEdges;
    }

    @Override
    @NotNull
    public CompletableFuture<Void> restoreAsync(@NotNull DiagramBuilder builder) {
        if (builder == null) {
            DiagramSelectionSnapshot.$$$reportNull$$$0(2);
        }
        CompletableFuture completableFuture = Futures.runInEdtAsync(() -> {
            Graph2D graph = builder.getGraph();
            graph.unselectAll();
            for (DiagramNode<?> diagramNode : builder.getDataModel().getNodes()) {
                if (!this.mySelectedNodes.contains(DiagramNodeIdentity.of(diagramNode))) continue;
                graph.setSelected(builder.getNode(diagramNode), true);
            }
            for (DiagramNoteNode diagramNoteNode : builder.getDataModel().getNotes().values()) {
                if (!this.mySelectedNodes.contains(DiagramNodeIdentity.of(diagramNoteNode))) continue;
                graph.setSelected(builder.getNode(diagramNoteNode), true);
            }
            for (DiagramEdge diagramEdge : builder.getDataModel().getEdges()) {
                if (!this.mySelectedEdges.contains(DiagramEdgeIdentity.of(diagramEdge))) continue;
                graph.setSelected(builder.getEdge(diagramEdge), true);
            }
            for (DiagramNoteEdge diagramNoteEdge : builder.getDataModel().getNoteEdges()) {
                if (!this.mySelectedEdges.contains(DiagramEdgeIdentity.of(diagramNoteEdge))) continue;
                graph.setSelected(builder.getEdge(diagramNoteEdge), true);
            }
        });
        if (completableFuture == null) {
            DiagramSelectionSnapshot.$$$reportNull$$$0(3);
        }
        return completableFuture;
    }

    public boolean containsRecordFor(@NotNull DiagramNode<?> node) {
        if (node == null) {
            DiagramSelectionSnapshot.$$$reportNull$$$0(4);
        }
        return this.mySelectedNodes.contains(DiagramNodeIdentity.of(node));
    }

    public boolean containsRecordFor(@NotNull DiagramEdge<?> edge) {
        if (edge == null) {
            DiagramSelectionSnapshot.$$$reportNull$$$0(5);
        }
        return this.mySelectedEdges.contains(DiagramEdgeIdentity.of(edge));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedNodes";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedEdges";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diagram/state/DiagramSelectionSnapshot";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edge";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diagram/state/DiagramSelectionSnapshot";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "restoreAsync";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "restoreAsync";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "containsRecordFor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    public static final class Factory
    implements DiagramSnapshotFactory<DiagramSelectionSnapshot> {
        @NotNull
        private static final Factory INSTANCE = new Factory();

        @NotNull
        public static Factory getInstance() {
            Factory factory = INSTANCE;
            if (factory == null) {
                Factory.$$$reportNull$$$0(0);
            }
            return factory;
        }

        @Override
        @NotNull
        public DiagramSelectionSnapshot makeSnapshot(@NotNull DiagramBuilder builder) {
            if (builder == null) {
                Factory.$$$reportNull$$$0(1);
            }
            HashSet<DiagramNodeIdentity<Object>> selectedNodes = new HashSet<DiagramNodeIdentity<Object>>();
            HashSet<DiagramEdgeIdentity<Object>> selectedEdges = new HashSet<DiagramEdgeIdentity<Object>>();
            GraphSelectionService.getInstance().forEachSelectedNode(builder.getGraph(), graphNode -> {
                DiagramNode<?> node = builder.getNodeObject((Node)graphNode);
                if (node != null) {
                    selectedNodes.add(DiagramNodeIdentity.of(node));
                }
            });
            GraphSelectionService.getInstance().forEachSelectedEdge(builder.getGraph(), graphEdge -> {
                DiagramEdge<?> edge = builder.getEdgeObject((Edge)graphEdge);
                if (edge != null) {
                    selectedEdges.add(DiagramEdgeIdentity.of(edge));
                }
            });
            return new DiagramSelectionSnapshot(selectedNodes, selectedEdges);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diagram/state/DiagramSelectionSnapshot$Factory";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInstance";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diagram/state/DiagramSelectionSnapshot$Factory";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "makeSnapshot";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1 -> new IllegalArgumentException(string);
            };
        }
    }
}

