/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram;

import com.intellij.diagram.presentation.DiagramLineType;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.graph.services.GraphExportService;
import com.intellij.openapi.graph.view.Arrow;
import com.intellij.openapi.graph.view.Drawable;
import com.intellij.openapi.graph.view.LineType;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface DiagramRelationshipInfo {
    public static final Shape ANGLE = new Area();
    public static final Shape DELTA = new Area();
    public static final Shape DIAMOND = new Area();
    public static final Shape NONE = new Area();
    public static final Shape STANDARD = new Area();
    public static final Shape INNER_CLASS_ARROW = new Area();
    public static final Shape DELTA_SMALL = new Area();
    public static final Shape WHITE_DELTA = new Area();
    public static final Shape SHORT = new Area();
    public static final Shape WHITE_DIAMOND = new Area();
    public static final Shape PLAIN = new Area();
    public static final Shape CONCAVE = new Area();
    public static final Shape CONVEX = new Area();
    public static final Shape CIRCLE = new Area();
    public static final Shape TRANSPARENT_CIRCLE = new Area();
    public static final Shape DASH = new Area();
    public static final Shape SKEWED_DASH = new Area();
    public static final Shape T_SHAPE = new Area();
    public static final Shape CROWS_FOOT_ONE_MANDATORY = new Area();
    public static final Shape CROWS_FOOT_MANY_MANDATORY = new Area();
    public static final Shape CROWS_FOOT_ONE_OPTIONAL = new Area();
    public static final Shape CROWS_FOOT_MANY_OPTIONAL = new Area();
    public static final Shape CROWS_FOOT_ONE = new Area();
    public static final Shape CROWS_FOOT_MANY = new Area();
    public static final Shape CROWS_FOOT_OPTIONAL = new Area();
    public static final DiagramRelationshipInfo NO_RELATIONSHIP = new DiagramRelationshipInfo(){

        @Override
        public DiagramLineType getLineType() {
            return null;
        }

        @Override
        @Nullable
        public Shape getSourceArrow() {
            return null;
        }

        @Override
        @Nullable
        public Shape getTargetArrow() {
            return null;
        }

        @Override
        public int getWidth() {
            return 1;
        }
    };

    @Nullable
    public DiagramLineType getLineType();

    public int getWidth();

    @Nullable
    default public Shape getSourceArrow() {
        return this.getStartArrow();
    }

    @Nullable
    default public Shape getTargetArrow() {
        return this.getEndArrow();
    }

    @Nullable
    default public Label getUpperCenterLabel() {
        return null;
    }

    @Nullable
    default public Label getBottomCenterLabel() {
        return null;
    }

    @Nullable
    default public Label getUpperSourceLabel() {
        return null;
    }

    @Nullable
    default public Label getBottomSourceLabel() {
        return null;
    }

    @Nullable
    default public Label getUpperTargetLabel() {
        return null;
    }

    @Nullable
    default public Label getBottomTargetLabel() {
        return null;
    }

    @Deprecated
    @Nullable
    default public Shape getStartArrow() {
        return this.getSourceArrow();
    }

    @Deprecated
    @Nullable
    default public Shape getEndArrow() {
        return this.getTargetArrow();
    }

    @Deprecated
    @Nullable
    default public String getLabel() {
        return Optional.ofNullable(this.getUpperCenterLabel()).map(it -> it.getText()).orElse(null);
    }

    @Deprecated(forRemoval=true)
    @Nullable
    default public String getToLabel() {
        return Optional.ofNullable(this.getUpperTargetLabel()).map(it -> it.getText()).orElse(null);
    }

    @Deprecated
    @Nullable
    default public Color getLabelColor() {
        return Optional.ofNullable(this.getUpperCenterLabel()).map(it -> it.getColor()).orElse(null);
    }

    public static interface Label {
        @NotNull
        public String getText();

        @Nullable
        public Color getColor();
    }

    public static final class Arrows {
        @NotNull
        private static final Color ARROW_BG = Gray.TRANSPARENT;
        @NotNull
        private static final Map<Shape, Arrow> KNOWN_SHAPES = new HashMap<Shape, Arrow>();

        private Arrows() {
        }

        @NotNull
        private static EditorColorsScheme getCurrentScheme() {
            EditorColorsScheme editorColorsScheme = GraphExportService.getInstance().isPrintMode() ? EditorColorsManager.getInstance().getScheme("Default") : EditorColorsManager.getInstance().getGlobalScheme();
            if (editorColorsScheme == null) {
                Arrows.$$$reportNull$$$0(0);
            }
            return editorColorsScheme;
        }

        @NotNull
        private static Arrow getInnerArrow() {
            String innerClassArrow = "InnerClassArrow";
            if (Arrow.Statics.getCustomArrow((String)"InnerClassArrow") == null) {
                int r = 5;
                Drawable arrow = new Drawable(){

                    public void paint(Graphics2D g) {
                        Paint paint = g.getPaint();
                        g.setPaint(Arrows.getCurrentScheme().getDefaultBackground());
                        g.fillOval(-10, -5, 10, 10);
                        g.setPaint(paint);
                        g.drawOval(-10, -5, 10, 10);
                        g.drawLine(-5, -3, -5, 3);
                        g.drawLine(-8, 0, -2, 0);
                    }

                    public Rectangle getBounds() {
                        return new Rectangle(-5, -5, 5, 5);
                    }
                };
                Arrow.Statics.addCustomArrow((String)"InnerClassArrow", (Drawable)arrow);
            }
            Arrow arrow = Arrow.Statics.getCustomArrow((String)"InnerClassArrow");
            if (arrow == null) {
                Arrows.$$$reportNull$$$0(1);
            }
            return arrow;
        }

        @NotNull
        private static Arrow getDeltaSmallArrow() {
            String deltaSmallArrow = "DeltaSmallArrow";
            if (Arrow.Statics.getCustomArrow((String)"DeltaSmallArrow") == null) {
                Drawable arrow = new Drawable(){
                    static final int r = 3;
                    final int[] x = new int[]{-5, 1, -5};
                    final int[] y = new int[]{-3, 0, 3};

                    public void paint(Graphics2D g) {
                        g.fillPolygon(this.x, this.y, 3);
                    }

                    public Rectangle getBounds() {
                        return new Rectangle(0, 0, 6, 6);
                    }
                };
                Arrow.Statics.addCustomArrow((String)"DeltaSmallArrow", (Drawable)arrow);
            }
            Arrow arrow = Arrow.Statics.getCustomArrow((String)"DeltaSmallArrow");
            if (arrow == null) {
                Arrows.$$$reportNull$$$0(2);
            }
            return arrow;
        }

        @NotNull
        private static Arrow getAngleArrow() {
            String name = "AngleArrow";
            if (Arrow.Statics.getCustomArrow((String)"AngleArrow") == null) {
                GeneralPath shape = new GeneralPath();
                shape.moveTo(-8.0f, -5.0f);
                shape.lineTo(0.0f, 0.0f);
                shape.lineTo(-8.0f, 5.0f);
                Arrow.Statics.addCustomArrow((String)"AngleArrow", (Shape)shape, (Color)ARROW_BG);
            }
            Arrow arrow = Arrow.Statics.getCustomArrow((String)"AngleArrow");
            if (arrow == null) {
                Arrows.$$$reportNull$$$0(3);
            }
            return arrow;
        }

        @NotNull
        private static Arrow getWhiteDeltaArrow() {
            String name = "MyWhiteArrow";
            if (Arrow.Statics.getCustomArrow((String)"MyWhiteArrow") == null) {
                GeneralPath whiteArrow = new GeneralPath(1, 6);
                whiteArrow.moveTo(0.0f, 0.0f);
                whiteArrow.lineTo(-16.0f, -6.0f);
                whiteArrow.lineTo(-16.0f, 6.0f);
                whiteArrow.closePath();
                Arrow.Statics.addCustomArrow((String)"MyWhiteArrow", (Shape)whiteArrow, (Color)new JBColor(new Color(0, true), new Color(0, true)), (Stroke)LineType.LINE_1.getBasicStroke(), null, (double)15.0, (double)0.0);
            }
            Arrow arrow = Arrow.Statics.getCustomArrow((String)"MyWhiteArrow");
            if (arrow == null) {
                Arrows.$$$reportNull$$$0(4);
            }
            return arrow;
        }

        @NotNull
        public static Arrow getArrow(@Nullable Shape shape) {
            if (shape == null) {
                Arrow arrow = Arrow.NONE;
                if (arrow == null) {
                    Arrows.$$$reportNull$$$0(5);
                }
                return arrow;
            }
            Arrow arrow = KNOWN_SHAPES.get(shape);
            if (arrow != null) {
                Arrow arrow2 = arrow;
                if (arrow2 == null) {
                    Arrows.$$$reportNull$$$0(6);
                }
                return arrow2;
            }
            String id = "UML_" + shape.hashCode();
            arrow = Arrow.Statics.getCustomArrow((String)id);
            Arrow arrow3 = arrow == null ? Arrow.Statics.addCustomArrow((String)id, (Shape)shape, (Color)ARROW_BG) : arrow;
            if (arrow3 == null) {
                Arrows.$$$reportNull$$$0(7);
            }
            return arrow3;
        }

        static {
            KNOWN_SHAPES.put(NONE, Arrow.NONE);
            KNOWN_SHAPES.put(DIAMOND, Arrow.DIAMOND);
            KNOWN_SHAPES.put(DELTA, Arrow.DELTA);
            KNOWN_SHAPES.put(STANDARD, Arrow.STANDARD);
            KNOWN_SHAPES.put(INNER_CLASS_ARROW, Arrows.getInnerArrow());
            KNOWN_SHAPES.put(DELTA_SMALL, Arrows.getDeltaSmallArrow());
            KNOWN_SHAPES.put(WHITE_DELTA, Arrows.getWhiteDeltaArrow());
            KNOWN_SHAPES.put(ANGLE, Arrows.getAngleArrow());
            KNOWN_SHAPES.put(SHORT, Arrow.SHORT);
            KNOWN_SHAPES.put(WHITE_DIAMOND, Arrow.WHITE_DIAMOND);
            KNOWN_SHAPES.put(PLAIN, Arrow.PLAIN);
            KNOWN_SHAPES.put(CONCAVE, Arrow.CONCAVE);
            KNOWN_SHAPES.put(CONVEX, Arrow.CONVEX);
            KNOWN_SHAPES.put(CIRCLE, Arrow.CIRCLE);
            KNOWN_SHAPES.put(TRANSPARENT_CIRCLE, Arrow.TRANSPARENT_CIRCLE);
            KNOWN_SHAPES.put(DASH, Arrow.DASH);
            KNOWN_SHAPES.put(SKEWED_DASH, Arrow.SKEWED_DASH);
            KNOWN_SHAPES.put(T_SHAPE, Arrow.T_SHAPE);
            KNOWN_SHAPES.put(CROWS_FOOT_ONE_MANDATORY, Arrow.CROWS_FOOT_ONE_MANDATORY);
            KNOWN_SHAPES.put(CROWS_FOOT_MANY_MANDATORY, Arrow.CROWS_FOOT_MANY_MANDATORY);
            KNOWN_SHAPES.put(CROWS_FOOT_ONE_OPTIONAL, Arrow.CROWS_FOOT_ONE_OPTIONAL);
            KNOWN_SHAPES.put(CROWS_FOOT_MANY_OPTIONAL, Arrow.CROWS_FOOT_MANY_OPTIONAL);
            KNOWN_SHAPES.put(CROWS_FOOT_ONE, Arrow.CROWS_FOOT_ONE);
            KNOWN_SHAPES.put(CROWS_FOOT_MANY, Arrow.CROWS_FOOT_MANY);
            KNOWN_SHAPES.put(CROWS_FOOT_OPTIONAL, Arrow.CROWS_FOOT_OPTIONAL);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/diagram/DiagramRelationshipInfo$Arrows";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCurrentScheme";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInnerArrow";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDeltaSmallArrow";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAngleArrow";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getWhiteDeltaArrow";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getArrow";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

