/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram;

import com.intellij.diagram.DiagramCategory;
import com.intellij.diagram.DiagramColorManager;
import com.intellij.diagram.DiagramColorManagerBase;
import com.intellij.diagram.DiagramDataKeys;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramEdgeCreationPolicy;
import com.intellij.diagram.DiagramElementManager;
import com.intellij.diagram.DiagramItemOrderingManager;
import com.intellij.diagram.DiagramNodeContentManager;
import com.intellij.diagram.DiagramPresentationModel;
import com.intellij.diagram.DiagramRelationshipManager;
import com.intellij.diagram.DiagramScopeManager;
import com.intellij.diagram.DiagramVfsResolver;
import com.intellij.diagram.DiagramVisibilityManager;
import com.intellij.diagram.actions.DiagramCreateNewElementAction;
import com.intellij.diagram.actions.DiagramCreateNewNodeElementAction;
import com.intellij.diagram.actions.DiagramNodeIntentionAction;
import com.intellij.diagram.extras.DiagramExtras;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.project.PossiblyDumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.uml.utils.DiagramBundle;
import java.util.Collection;
import javax.swing.Icon;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DiagramProvider<T>
implements PossiblyDumbAware {
    @NotNull
    public static final ExtensionPointName<DiagramProvider<?>> DIAGRAM_PROVIDER = new ExtensionPointName("com.intellij.diagram.Provider");
    @Deprecated(forRemoval=true)
    @NotNull
    public static final Key<Object> ORIGINAL_ELEMENT = DiagramDataKeys.ORIGINAL_ELEMENT;

    @Pattern(value="[a-zA-Z0-9_-]*")
    @NotNull
    public abstract String getID();

    @Nullable
    public static <T> DiagramProvider<T> findByID(@Nullable String id) {
        return (DiagramProvider)DIAGRAM_PROVIDER.findFirstSafe(it -> it.getID().equals(id));
    }

    @NotNull
    @NlsContexts.Label
    public abstract String getPresentableName();

    @NotNull
    @NlsContexts.Label
    public String getRefinedPresentableName(@Nullable T element, @NotNull Collection<T> additionalElements) {
        if (additionalElements == null) {
            DiagramProvider.$$$reportNull$$$0(0);
        }
        String string = this.getPresentableName();
        if (string == null) {
            DiagramProvider.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    @Nls
    public String getActionName(boolean isPopup) {
        String string = DiagramBundle.message("uml.action.name", new Object[0]);
        if (string == null) {
            DiagramProvider.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public Icon getActionIcon(boolean isPopup) {
        Icon icon = AllIcons.FileTypes.Diagram;
        if (icon == null) {
            DiagramProvider.$$$reportNull$$$0(3);
        }
        return icon;
    }

    @NotNull
    public abstract DiagramDataModel<T> createDataModel(@NotNull Project var1, @Nullable T var2, @Nullable VirtualFile var3, @NotNull DiagramPresentationModel var4);

    @NotNull
    public abstract DiagramVisibilityManager createVisibilityManager();

    @NotNull
    public DiagramItemOrderingManager createItemOrderingManager() {
        DiagramItemOrderingManager diagramItemOrderingManager = DiagramItemOrderingManager.NO_ORDERING_AVAILABLE;
        if (diagramItemOrderingManager == null) {
            DiagramProvider.$$$reportNull$$$0(4);
        }
        return diagramItemOrderingManager;
    }

    @Nullable
    public DiagramScopeManager<T> createScopeManager(@NotNull Project project) {
        if (project == null) {
            DiagramProvider.$$$reportNull$$$0(5);
        }
        return null;
    }

    @NotNull
    public DiagramNodeContentManager createNodeContentManager() {
        Logger.getInstance(DiagramProvider.class).warn("createNodeContentManager should be overriden to return new instance each time");
        DiagramNodeContentManager diagramNodeContentManager = this.getNodeContentManager();
        if (diagramNodeContentManager == null) {
            DiagramProvider.$$$reportNull$$$0(6);
        }
        return diagramNodeContentManager;
    }

    @Nullable
    public DiagramPresentationModel createPresentationModel(@NotNull Project project, @NotNull Graph2D graph) {
        if (project == null) {
            DiagramProvider.$$$reportNull$$$0(7);
        }
        if (graph == null) {
            DiagramProvider.$$$reportNull$$$0(8);
        }
        return null;
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public DiagramNodeContentManager getNodeContentManager() {
        DiagramNodeContentManager diagramNodeContentManager = this.createNodeContentManager();
        if (diagramNodeContentManager == null) {
            DiagramProvider.$$$reportNull$$$0(9);
        }
        return diagramNodeContentManager;
    }

    public DiagramCategory @NotNull [] getAllContentCategories() {
        DiagramNodeContentManager deprecatedGlobalContentManager = this.getNodeContentManager();
        DiagramCategory[] diagramCategoryArray = deprecatedGlobalContentManager.getContentCategories();
        if (diagramCategoryArray == null) {
            DiagramProvider.$$$reportNull$$$0(10);
        }
        return diagramCategoryArray;
    }

    @NotNull
    public abstract DiagramElementManager<T> getElementManager();

    @NotNull
    public abstract DiagramVfsResolver<T> getVfsResolver();

    @NotNull
    public DiagramColorManager getColorManager() {
        DiagramColorManager diagramColorManager = DiagramColorManagerBase.DEFAULT_COLOR_MANAGER;
        if (diagramColorManager == null) {
            DiagramProvider.$$$reportNull$$$0(11);
        }
        return diagramColorManager;
    }

    @NotNull
    public DiagramExtras<T> getExtras() {
        return new DiagramExtras();
    }

    @NotNull
    public abstract DiagramRelationshipManager<T> getRelationshipManager();

    @Nullable
    public DiagramEdgeCreationPolicy<T> getEdgeCreationPolicy() {
        return null;
    }

    public AnAction @NotNull [] getCreateNewActions() {
        if (DiagramCreateNewElementAction.EMPTY == null) {
            DiagramProvider.$$$reportNull$$$0(12);
        }
        return DiagramCreateNewElementAction.EMPTY;
    }

    public AnAction @NotNull [] getCreateNewNodeElementActions() {
        if (DiagramCreateNewNodeElementAction.EMPTY == null) {
            DiagramProvider.$$$reportNull$$$0(13);
        }
        return DiagramCreateNewNodeElementAction.EMPTY;
    }

    public DiagramNodeIntentionAction<T> @NotNull [] getNodeIntentionActions() {
        if (DiagramNodeIntentionAction.EMPTY == null) {
            DiagramProvider.$$$reportNull$$$0(14);
        }
        return DiagramNodeIntentionAction.EMPTY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 6, 9, 10, 11, 12, 13, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalElements";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diagram/DiagramProvider";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diagram/DiagramProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRefinedPresentableName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionIcon";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createItemOrderingManager";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createNodeContentManager";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeContentManager";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllContentCategories";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getColorManager";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getCreateNewActions";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getCreateNewNodeElementActions";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeIntentionActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getRefinedPresentableName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createScopeManager";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createPresentationModel";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 6, 9, 10, 11, 12, 13, 14 -> new IllegalStateException(string);
        };
    }
}

