/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram;

import com.intellij.diagram.AbstractDiagramNodeContentManager;
import com.intellij.diagram.DiagramAction;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramCategory;
import com.intellij.diagram.DiagramDataKeys;
import com.intellij.diagram.DiagramDataView;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramItemOrderingManager;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramNodeContentManager;
import com.intellij.diagram.DiagramNoteEdge;
import com.intellij.diagram.DiagramNoteNode;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.DiagramScopeManager;
import com.intellij.diagram.DiagramVisibilityManager;
import com.intellij.diagram.settings.DiagramConfiguration;
import com.intellij.diagram.util.DiagramUpdateService;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.graph.builder.NodeGroupDescriptor;
import com.intellij.openapi.graph.util.Futures;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.search.scope.packageSet.CustomScopesProviderEx;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopeManager;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.uml.utils.DiagramBundle;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Cursor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@ThreadSafe
public abstract class DiagramDataModel<T>
extends UserDataHolderBase
implements ModificationTracker,
Disposable,
DiagramDataView<T> {
    @NotNull
    private final Project myProject;
    @NotNull
    private final DiagramProvider<T> myProvider;
    @NotNull
    private final DiagramVisibilityManager myVisibilityManager;
    @NotNull
    private final DiagramItemOrderingManager myItemOrderingManager;
    @Nullable
    private final DiagramScopeManager<T> myScopeManager;
    @Nullable
    private DiagramNodeContentManager myNodeContentManager;
    @Nullable
    private volatile T myOriginalElement;
    @GuardedBy(value="myNotesLock")
    @NotNull
    private final Map<DiagramNode<?>, DiagramNoteNode> myNotes;
    @GuardedBy(value="myNotesLock")
    @NotNull
    private final Map<DiagramNoteNode, DiagramNoteEdge> myNoteEdges;
    @NotNull
    private final Object myNotesLock;
    private volatile boolean isShowDependencies;
    private volatile boolean isInitState;
    @NotNull
    protected final SimpleModificationTracker myModificationTracker;

    public DiagramDataModel(@NotNull Project project, @NotNull DiagramProvider<T> provider) {
        if (project == null) {
            DiagramDataModel.$$$reportNull$$$0(0);
        }
        if (provider == null) {
            DiagramDataModel.$$$reportNull$$$0(1);
        }
        this(project, provider, null);
    }

    public DiagramDataModel(@NotNull Project project, @NotNull DiagramProvider<T> provider, @Nullable DiagramNodeContentManager nodeContentManager) {
        if (project == null) {
            DiagramDataModel.$$$reportNull$$$0(2);
        }
        if (provider == null) {
            DiagramDataModel.$$$reportNull$$$0(3);
        }
        this(project, provider, provider.createVisibilityManager(), provider.createItemOrderingManager(), provider.createScopeManager(project), nodeContentManager);
    }

    protected DiagramDataModel(@NotNull Project project, @NotNull DiagramProvider<T> provider, @NotNull DiagramVisibilityManager visibilityManager, @NotNull DiagramItemOrderingManager itemOrderingManager, @Nullable DiagramScopeManager<T> scopeManager, @Nullable DiagramNodeContentManager nodeContentManager) {
        if (project == null) {
            DiagramDataModel.$$$reportNull$$$0(4);
        }
        if (provider == null) {
            DiagramDataModel.$$$reportNull$$$0(5);
        }
        if (visibilityManager == null) {
            DiagramDataModel.$$$reportNull$$$0(6);
        }
        if (itemOrderingManager == null) {
            DiagramDataModel.$$$reportNull$$$0(7);
        }
        this.myNotes = new HashMap();
        this.myNoteEdges = new HashMap<DiagramNoteNode, DiagramNoteEdge>();
        this.myNotesLock = new Object();
        this.isShowDependencies = false;
        this.isInitState = true;
        this.myProject = project;
        this.myProvider = provider;
        this.myVisibilityManager = visibilityManager;
        this.myItemOrderingManager = itemOrderingManager;
        this.myScopeManager = scopeManager;
        this.myModificationTracker = this.createModificationTracker();
        this.myNodeContentManager = nodeContentManager;
    }

    @NotNull
    protected <T> DiagramNodeContentManager initNodeContentManager(@NotNull DiagramProvider<T> provider) {
        if (provider == null) {
            DiagramDataModel.$$$reportNull$$$0(8);
        }
        DiagramNodeContentManager nodeContentManager = this.getOrCreateContentManager(provider);
        DiagramConfiguration configuration = DiagramConfiguration.getInstance();
        for (DiagramCategory category : nodeContentManager.getContentCategories()) {
            if (!configuration.isEnabledByDefault(provider, category.getName())) continue;
            nodeContentManager.setCategoryEnabled(category, true);
        }
        if (nodeContentManager instanceof AbstractDiagramNodeContentManager) {
            ((AbstractDiagramNodeContentManager)nodeContentManager).setDataModel(this);
        }
        DiagramNodeContentManager diagramNodeContentManager = nodeContentManager;
        if (diagramNodeContentManager == null) {
            DiagramDataModel.$$$reportNull$$$0(9);
        }
        return diagramNodeContentManager;
    }

    @NotNull
    protected <T> DiagramNodeContentManager getOrCreateContentManager(@NotNull DiagramProvider<T> provider) {
        if (provider == null) {
            DiagramDataModel.$$$reportNull$$$0(10);
        }
        DiagramNodeContentManager diagramNodeContentManager = provider.createNodeContentManager();
        if (diagramNodeContentManager == null) {
            DiagramDataModel.$$$reportNull$$$0(11);
        }
        return diagramNodeContentManager;
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            DiagramDataModel.$$$reportNull$$$0(12);
        }
        return project;
    }

    @NotNull
    public DiagramProvider<T> getProvider() {
        DiagramProvider<T> diagramProvider = this.myProvider;
        if (diagramProvider == null) {
            DiagramDataModel.$$$reportNull$$$0(13);
        }
        return diagramProvider;
    }

    @NotNull
    public DiagramVisibilityManager getVisibilityManager() {
        DiagramVisibilityManager diagramVisibilityManager = this.myVisibilityManager;
        if (diagramVisibilityManager == null) {
            DiagramDataModel.$$$reportNull$$$0(14);
        }
        return diagramVisibilityManager;
    }

    @NotNull
    public DiagramItemOrderingManager getItemOrderingManager() {
        DiagramItemOrderingManager diagramItemOrderingManager = this.myItemOrderingManager;
        if (diagramItemOrderingManager == null) {
            DiagramDataModel.$$$reportNull$$$0(15);
        }
        return diagramItemOrderingManager;
    }

    @Nullable
    public DiagramScopeManager<T> getScopeManager() {
        return this.myScopeManager;
    }

    @NotNull
    public DiagramNodeContentManager getNodeContentManager() {
        if (this.myNodeContentManager == null) {
            this.myNodeContentManager = this.initNodeContentManager(this.myProvider);
        }
        DiagramNodeContentManager diagramNodeContentManager = this.myNodeContentManager;
        if (diagramNodeContentManager == null) {
            DiagramDataModel.$$$reportNull$$$0(16);
        }
        return diagramNodeContentManager;
    }

    @Nullable
    public T getOriginalElement() {
        return this.myOriginalElement;
    }

    public void setOriginalElement(@Nullable T originalElement) {
        this.myOriginalElement = originalElement;
    }

    public final boolean isModelInitializationFinished() {
        return !this.isInitState;
    }

    public final void setModelInitializationFinished() {
        this.isInitState = false;
    }

    public final void setShowDependencies(boolean show) {
        this.isShowDependencies = show;
    }

    public final boolean isShowDependencies() {
        return this.isShowDependencies;
    }

    public boolean isDependencyDiagramSupported() {
        return false;
    }

    public boolean isPsiListener() {
        return false;
    }

    @NotNull
    public DiagramBuilder getBuilder() {
        DiagramBuilder builder = (DiagramBuilder)this.getUserData(DiagramDataKeys.GRAPH_BUILDER);
        Logger.getInstance(DiagramDataModel.class).assertTrue(builder != null, (Object)"Forget to set GraphBuilder");
        DiagramBuilder diagramBuilder = builder;
        if (diagramBuilder == null) {
            DiagramDataModel.$$$reportNull$$$0(17);
        }
        return diagramBuilder;
    }

    @NotNull
    public abstract ModificationTracker getModificationTracker();

    @NotNull
    protected SimpleModificationTracker createModificationTracker() {
        return new SimpleModificationTracker();
    }

    public long getModificationCount() {
        return this.myModificationTracker.getModificationCount();
    }

    protected void incModificationCount() {
        this.myModificationTracker.incModificationCount();
    }

    @Override
    @NotNull
    public abstract Collection<? extends DiagramNode<T>> getNodes();

    @NotNull
    public abstract String getNodeName(@NotNull DiagramNode<T> var1);

    @NotNull
    public String getEdgeName(@NotNull DiagramEdge<T> e) {
        if (e == null) {
            DiagramDataModel.$$$reportNull$$$0(18);
        }
        String string = e.getName();
        if (string == null) {
            DiagramDataModel.$$$reportNull$$$0(19);
        }
        return string;
    }

    @Nullable
    public abstract DiagramNode<T> addElement(@Nullable T var1);

    @NotNull
    public List<DiagramNode<T>> addMultiNodeElement(@Nullable T element) {
        DiagramNode<T> node = this.addElement(element);
        List<Object> list = node == null ? List.of() : List.of(node);
        if (list == null) {
            DiagramDataModel.$$$reportNull$$$0(20);
        }
        return list;
    }

    @NotNull
    public List<List<DiagramNode<T>>> addMultiNodeElements(@NotNull List<T> elements) {
        if (elements == null) {
            DiagramDataModel.$$$reportNull$$$0(21);
        }
        List list = ContainerUtil.map(elements, this::addMultiNodeElement);
        if (list == null) {
            DiagramDataModel.$$$reportNull$$$0(22);
        }
        return list;
    }

    public void removeNode(@NotNull DiagramNode<T> node) {
        if (node == null) {
            DiagramDataModel.$$$reportNull$$$0(23);
        }
    }

    public void removeNodes(@NotNull Collection<DiagramNode<?>> nodes) {
        if (nodes == null) {
            DiagramDataModel.$$$reportNull$$$0(24);
        }
        for (DiagramNode<?> node : nodes) {
            this.removeNode(node);
        }
    }

    public boolean hasElement(@Nullable T element) {
        return false;
    }

    public void collapseNode(@NotNull DiagramNode<T> node) {
        if (node == null) {
            DiagramDataModel.$$$reportNull$$$0(25);
        }
    }

    public void expandNode(@NotNull DiagramNode<T> node) {
        if (node == null) {
            DiagramDataModel.$$$reportNull$$$0(26);
        }
    }

    @Nullable
    public NodeGroupDescriptor getGroup(@NotNull DiagramNode<T> n) {
        if (n == null) {
            DiagramDataModel.$$$reportNull$$$0(27);
        }
        return null;
    }

    @Nullable
    public NodeGroupDescriptor getGroup(@NotNull NodeGroupDescriptor n) {
        if (n == null) {
            DiagramDataModel.$$$reportNull$$$0(28);
        }
        return null;
    }

    public void removeGroupNode(@NotNull NodeGroupDescriptor groupNode) {
        if (groupNode == null) {
            DiagramDataModel.$$$reportNull$$$0(29);
        }
    }

    public void removeGroupNodes(@NotNull Collection<NodeGroupDescriptor> groupNodes) {
        if (groupNodes == null) {
            DiagramDataModel.$$$reportNull$$$0(30);
        }
        for (NodeGroupDescriptor groupNode : groupNodes) {
            this.removeGroupNode(groupNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public final Map<DiagramNode<?>, DiagramNoteNode> getNotes() {
        Object object = this.myNotesLock;
        // MONITORENTER : object
        HashMap hashMap = new HashMap(this.myNotes);
        // MONITOREXIT : object
        if (hashMap != null) return hashMap;
        DiagramDataModel.$$$reportNull$$$0(31);
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public final Collection<DiagramNoteEdge> getNoteEdges() {
        Object object = this.myNotesLock;
        // MONITORENTER : object
        ArrayList<DiagramNoteEdge> arrayList = new ArrayList<DiagramNoteEdge>(this.myNoteEdges.values());
        // MONITOREXIT : object
        if (arrayList != null) return arrayList;
        DiagramDataModel.$$$reportNull$$$0(32);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final DiagramNoteNode addNote(@NotNull DiagramNode<T> node, @Nullable @Nls String note) {
        if (node == null) {
            DiagramDataModel.$$$reportNull$$$0(33);
        }
        if (note != null && !note.isEmpty()) {
            Object object = this.myNotesLock;
            synchronized (object) {
                if (!this.myNotes.containsKey(node)) {
                    DiagramNoteNode noteNode = new DiagramNoteNode(node, note);
                    this.myNotes.put(node, noteNode);
                    this.myNoteEdges.put(noteNode, new DiagramNoteEdge(node, noteNode));
                    return noteNode;
                }
                DiagramNoteNode noteNode = this.myNotes.get(node);
                noteNode.setNoteText(note);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeNote(@NotNull DiagramNoteNode note) {
        if (note == null) {
            DiagramDataModel.$$$reportNull$$$0(34);
        }
        Object object = this.myNotesLock;
        synchronized (object) {
            if (this.myNotes.containsValue(note)) {
                this.myNotes.remove(note.getIdentifyingElement());
                this.myNoteEdges.remove(note);
            }
        }
    }

    @Override
    @NotNull
    public abstract Collection<? extends DiagramEdge<T>> getEdges();

    @Nullable
    public DiagramEdge<T> createEdge(@NotNull DiagramNode<T> from, @NotNull DiagramNode<T> to) {
        if (from == null) {
            DiagramDataModel.$$$reportNull$$$0(35);
        }
        if (to == null) {
            DiagramDataModel.$$$reportNull$$$0(36);
        }
        return null;
    }

    public void removeEdge(@NotNull DiagramEdge<T> edge) {
        if (edge == null) {
            DiagramDataModel.$$$reportNull$$$0(37);
        }
    }

    public void removeEdges(@NotNull Collection<DiagramEdge<?>> edges) {
        if (edges == null) {
            DiagramDataModel.$$$reportNull$$$0(38);
        }
        for (DiagramEdge<?> edge : edges) {
            this.removeEdge(edge);
        }
    }

    @NotNull
    public Collection<? extends NodeGroupDescriptor> getGroupNodes() {
        Set set = Collections.emptySet();
        if (set == null) {
            DiagramDataModel.$$$reportNull$$$0(39);
        }
        return set;
    }

    @NotNull
    public DiagramNode<T> getSourceNode(@NotNull DiagramEdge<T> e) {
        if (e == null) {
            DiagramDataModel.$$$reportNull$$$0(40);
        }
        DiagramNode<T> diagramNode = e.getSource();
        if (diagramNode == null) {
            DiagramDataModel.$$$reportNull$$$0(41);
        }
        return diagramNode;
    }

    @NotNull
    public DiagramNode<T> getTargetNode(@NotNull DiagramEdge<T> e) {
        if (e == null) {
            DiagramDataModel.$$$reportNull$$$0(42);
        }
        DiagramNode<T> diagramNode = e.getTarget();
        if (diagramNode == null) {
            DiagramDataModel.$$$reportNull$$$0(43);
        }
        return diagramNode;
    }

    public void refreshDataModel() {
    }

    @RequiresBackgroundThread
    @NotNull
    public CompletableFuture<Void> refreshDataModelAsync(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            DiagramDataModel.$$$reportNull$$$0(44);
        }
        ThreadingAssertions.assertBackgroundThread();
        CompletableFuture completableFuture = Futures.runInEdtAsync(this::refreshDataModel);
        if (completableFuture == null) {
            DiagramDataModel.$$$reportNull$$$0(45);
        }
        return completableFuture;
    }

    @NotNull
    public CompletableFuture<Void> updateNodePresentations(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            DiagramDataModel.$$$reportNull$$$0(46);
        }
        CompletableFuture completableFuture = Futures.runInEdtAsync(() -> this.updatePresentations());
        if (completableFuture == null) {
            DiagramDataModel.$$$reportNull$$$0(47);
        }
        return completableFuture;
    }

    private void updatePresentations() {
        this.getNodes().forEach(node -> node.precachePresentation());
    }

    public void rebuild(T element) {
        this.removeAll();
    }

    public final void removeAll() {
        for (DiagramNoteNode diagramNoteNode : new ArrayList<DiagramNoteNode>(this.getNotes().values())) {
            this.removeNote(diagramNoteNode);
        }
        for (DiagramNode<DiagramNode<Object>> diagramNode : new ArrayList<DiagramNode<T>>(this.getNodes())) {
            this.removeNode(diagramNode);
        }
    }

    public boolean hasFile(@Nullable PsiFile file) {
        if (file == null) {
            return false;
        }
        return this.getNodes().stream().map(it -> it.getIdentifyingElement()).anyMatch(it -> it instanceof PsiElement && ((PsiElement)it).isValid() && DiagramDataModel.containsRegardlessInjection(this.getProject(), file, (PsiElement)it));
    }

    private static boolean containsRegardlessInjection(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement element) {
        if (project == null) {
            DiagramDataModel.$$$reportNull$$$0(48);
        }
        if (file == null) {
            DiagramDataModel.$$$reportNull$$$0(49);
        }
        if (element == null) {
            DiagramDataModel.$$$reportNull$$$0(50);
        }
        if (element.getContainingFile() == file) {
            return true;
        }
        PsiLanguageInjectionHost host1 = InjectedLanguageManager.getInstance((Project)project).getInjectionHost(element);
        PsiLanguageInjectionHost host2 = InjectedLanguageManager.getInstance((Project)project).getInjectionHost((PsiElement)file);
        if (host1 == null && host2 == null) {
            return false;
        }
        if (host1 != null && host2 != null) {
            return host1.getContainingFile() == host2.getContainingFile();
        }
        return host1 == null ? element.getContainingFile() == host2.getContainingFile() : host1.getContainingFile() == file;
    }

    public final void setupScopeManager(@Nullable Object element, boolean showNotification) {
        DiagramScopeManager<T> scopeManager = this.getScopeManager();
        if (scopeManager != null && element instanceof PsiElement) {
            PackageSet value;
            PsiFile psiFile = ((PsiElement)element).getContainingFile();
            NamedScope currentScope = scopeManager.getCurrentScope();
            if (!(currentScope == null || (value = currentScope.getValue()) == null || psiFile != null && value.contains(psiFile, (NamedScopesHolder)NamedScopeManager.getInstance((Project)this.getProject())))) {
                scopeManager.setCurrentScope(CustomScopesProviderEx.getAllScope());
                if (showNotification) {
                    SwingUtilities.invokeLater(() -> DiagramAction.showNotification(DiagramBundle.message("notification.message.scope.has.been.changed.to.b.all.b", new Object[0]), this.getBuilder()));
                }
            }
        }
    }

    public static void refreshDataModelInSmartMode(@Nullable DiagramBuilder builder) {
        if (builder == null || Disposer.isDisposed((Disposable)builder)) {
            return;
        }
        DiagramDataModel<?> model = builder.getDataModel();
        JComponent viewComponent = builder.getView().getJComponent();
        Cursor oldCursor = viewComponent.getCursor();
        viewComponent.setCursor(Cursor.getPredefinedCursor(3));
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            try {
                DumbService.getInstance((Project)builder.getProject()).runReadActionInSmartMode(() -> {
                    if (Disposer.isDisposed((Disposable)builder)) {
                        return;
                    }
                    DiagramUpdateService.getInstance().requestDataModelRefreshPreservingLayout(builder).runAsync();
                });
            }
            finally {
                UIUtil.invokeLaterIfNeeded(() -> viewComponent.setCursor(oldCursor));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9, 11, 12, 13, 14, 15, 16, 17, 19, 20, 22, 31, 32, 39, 41, 43, 45, 47 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visibilityManager";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "itemOrderingManager";
                break;
            }
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 31: 
            case 32: 
            case 39: 
            case 41: 
            case 43: 
            case 45: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diagram/DiagramDataModel";
                break;
            }
            case 18: 
            case 40: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 23: 
            case 25: 
            case 26: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodes";
                break;
            }
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "n";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupNode";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupNodes";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "note";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edge";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edges";
                break;
            }
            case 44: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diagram/DiagramDataModel";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "initNodeContentManager";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateContentManager";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getProvider";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisibilityManager";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getItemOrderingManager";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeContentManager";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuilder";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdgeName";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "addMultiNodeElement";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "addMultiNodeElements";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotes";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getNoteEdges";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupNodes";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceNode";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetNode";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "refreshDataModelAsync";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "updateNodePresentations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "initNodeContentManager";
                break;
            }
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 31: 
            case 32: 
            case 39: 
            case 41: 
            case 43: 
            case 45: 
            case 47: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateContentManager";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getEdgeName";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addMultiNodeElements";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "removeNode";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "removeNodes";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "collapseNode";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "expandNode";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getGroup";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "removeGroupNode";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "removeGroupNodes";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "addNote";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "removeNote";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "createEdge";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "removeEdge";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "removeEdges";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getSourceNode";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getTargetNode";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "refreshDataModelAsync";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "updateNodePresentations";
                break;
            }
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "containsRegardlessInjection";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9, 11, 12, 13, 14, 15, 16, 17, 19, 20, 22, 31, 32, 39, 41, 43, 45, 47 -> new IllegalStateException(string);
        };
    }

    @Deprecated(forRemoval=true)
    public static interface AsyncDataLoader {
        @Deprecated
        @NotNull
        default public Promise<?> refreshDataModelAsync() {
            Promise promise = Promises.resolvedPromise();
            if (promise == null) {
                AsyncDataLoader.$$$reportNull$$$0(0);
            }
            return promise;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diagram/DiagramDataModel$AsyncDataLoader", "refreshDataModelAsync"));
        }
    }
}

