/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram;

import com.intellij.diagram.DefaultDiagramUpdateQueryParams;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramFileEditor;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramPresentationModel;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.presentation.DiagramState;
import com.intellij.diagram.util.DiagramSelectionService;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.graph.base.Edge;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.NodeGroupDescriptor;
import com.intellij.openapi.graph.builder.edges.CollapsedEdge;
import com.intellij.openapi.graph.layout.Layouter;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.UserDataHolder;
import java.awt.Point;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface DiagramBuilder
extends Disposable,
UserDataHolder {
    @NotNull
    public Project getProject();

    @NotNull
    public Collection<DiagramNode<?>> getNodeObjects();

    @NotNull
    public Collection<DiagramEdge<?>> getEdgeObjects();

    @NotNull
    public Collection<NodeGroupDescriptor> getGroupNodeObjects();

    @NotNull
    public Collection<CollapsedEdge> getCollapsedEdgeObjects();

    @NotNull
    public DiagramPresentationModel getPresentationModel();

    @NotNull
    public DiagramDataModel<?> getDataModel();

    @NotNull
    public DiagramProvider<?> getProvider();

    public double getZoom();

    public void setZoom(double var1);

    @NotNull
    public EditorColorsScheme getColorScheme();

    @Contract(pure=true)
    @NotNull
    default public DiagramUpdateQueryParams queryUpdate() {
        return new DefaultDiagramUpdateQueryParams(this);
    }

    @Contract(pure=true)
    @NotNull
    default public DiagramUpdateQueryParams queryUpdate(@NotNull DiagramUpdateQueryParams queryParams) {
        if (queryParams == null) {
            DiagramBuilder.$$$reportNull$$$0(0);
        }
        DiagramUpdateQueryParams queryBuilder = this.queryUpdate();
        if (queryParams.doReloadData()) {
            queryBuilder = queryBuilder.withDataReload();
        }
        if (queryParams.doPresentationUpdate()) {
            queryBuilder = queryBuilder.withPresentationUpdate();
        }
        if (queryParams.getLayouter() != null) {
            queryBuilder = queryBuilder.withRelayout(queryParams.getLayouter());
        }
        if (!queryParams.getNodesForSizeUpdate().isEmpty()) {
            queryBuilder = queryBuilder.withNodeSizeUpdate((DiagramNode[])queryBuilder.getNodesForSizeUpdate().toArray());
        }
        DiagramUpdateQueryParams diagramUpdateQueryParams = queryBuilder;
        if (diagramUpdateQueryParams == null) {
            DiagramBuilder.$$$reportNull$$$0(1);
        }
        return diagramUpdateQueryParams;
    }

    public boolean isPopupMode();

    @Nullable
    public JBPopup getPopup();

    @NotNull
    public Graph2D getGraph();

    @NotNull
    public Graph2DView getView();

    @Nullable
    public Node getNode(DiagramNode<?> var1);

    @Nullable
    public DiagramNode<?> getNodeObject(Node var1);

    @Nullable
    public Edge getEdge(DiagramEdge<?> var1);

    @Nullable
    public DiagramEdge<?> getEdgeObject(Edge var1);

    @Nullable
    public Node getGroupNode(NodeGroupDescriptor var1);

    @Nullable
    public Edge getCollapsedEdge(CollapsedEdge var1);

    @Nullable
    public NodeGroupDescriptor getGroupNodeObject(Node var1);

    @Nullable
    public CollapsedEdge getCollapsedEdgeObject(Edge var1);

    @ApiStatus.Internal
    @Nullable
    public DiagramFileEditor getEditor();

    @ApiStatus.Internal
    public void setEditor(@NotNull DiagramFileEditor var1);

    @ApiStatus.Internal
    public void setPopup(@NotNull JBPopup var1);

    @ApiStatus.Internal
    @Nullable
    public DocumentReference getDocumentReference();

    @ApiStatus.Internal
    public void initialize();

    @ApiStatus.Internal
    public void notifyOtherBuilders();

    @NotNull
    public GraphBuilder<DiagramNode<?>, DiagramEdge<?>> getGraphBuilder();

    @Deprecated(forRemoval=true)
    default public void setSelected(@NotNull DiagramNode<?> node, boolean selected) {
        if (node == null) {
            DiagramBuilder.$$$reportNull$$$0(2);
        }
        DiagramSelectionService.getInstance().setSelected(this, node, selected);
    }

    @Deprecated(forRemoval=true)
    default public void setSelected(@NotNull DiagramEdge<?> edge, boolean selected) {
        if (edge == null) {
            DiagramBuilder.$$$reportNull$$$0(3);
        }
        DiagramSelectionService.getInstance().setSelected(this, edge, selected);
    }

    @Deprecated(forRemoval=true)
    public void update();

    @Deprecated
    public void update(boolean var1, boolean var2);

    @Deprecated
    public void updateView();

    @Deprecated(forRemoval=true)
    public void updateGraph();

    @Deprecated
    public void relayout();

    @Deprecated
    public void requestFocus();

    @Deprecated
    default public boolean doAllowEdgeCreation() {
        return true;
    }

    @Deprecated
    public void setAllowEdgeCreation(boolean var1);

    @Deprecated(forRemoval=true)
    @NotNull
    default public DiagramState getPresentation() {
        DiagramState diagramState = DiagramState.empty(this.getProvider());
        if (diagramState == null) {
            DiagramBuilder.$$$reportNull$$$0(4);
        }
        return diagramState;
    }

    @Deprecated
    public void createDraggedNode(@NotNull DiagramNode<?> var1, @Nullable String var2, @NotNull Point var3);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryParams";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diagram/DiagramBuilder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edge";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diagram/DiagramBuilder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "queryUpdate";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "queryUpdate";
                break;
            }
            case 1: 
            case 4: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setSelected";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4 -> new IllegalStateException(string);
        };
    }

    public static interface DiagramUpdateQueryParams {
        @Contract(pure=true)
        @NotNull
        public DiagramUpdateQueryParams withDataReload();

        @Contract(pure=true)
        @NotNull
        public DiagramUpdateQueryParams withPresentationUpdate();

        @Contract(pure=true)
        @NotNull
        default public DiagramUpdateQueryParams withNodePresentationsUpdate(boolean updateNodePresentations) {
            DiagramUpdateQueryParams diagramUpdateQueryParams = this;
            if (diagramUpdateQueryParams == null) {
                DiagramUpdateQueryParams.$$$reportNull$$$0(0);
            }
            return diagramUpdateQueryParams;
        }

        @Contract(pure=true)
        @NotNull
        public DiagramUpdateQueryParams withAllNodeSizeUpdate();

        @Contract(pure=true)
        @NotNull
        public DiagramUpdateQueryParams withNodeSizeUpdate(DiagramNode<?> ... var1);

        @Contract(pure=true)
        @NotNull
        public DiagramUpdateQueryParams withRelayout();

        @Contract(pure=true)
        @NotNull
        default public DiagramUpdateQueryParams withRelayoutIf(boolean statement) {
            DiagramUpdateQueryParams diagramUpdateQueryParams = statement ? this.withRelayout() : this;
            if (diagramUpdateQueryParams == null) {
                DiagramUpdateQueryParams.$$$reportNull$$$0(1);
            }
            return diagramUpdateQueryParams;
        }

        @Contract(pure=true)
        @NotNull
        public DiagramUpdateQueryParams withRelayout(@NotNull Layouter var1);

        @Contract(pure=true)
        @NotNull
        default public DiagramUpdateQueryParams withRelayoutIf(boolean statement, @NotNull Layouter layouter) {
            if (layouter == null) {
                DiagramUpdateQueryParams.$$$reportNull$$$0(2);
            }
            DiagramUpdateQueryParams diagramUpdateQueryParams = statement ? this.withRelayout(layouter) : this;
            if (diagramUpdateQueryParams == null) {
                DiagramUpdateQueryParams.$$$reportNull$$$0(3);
            }
            return diagramUpdateQueryParams;
        }

        public void run();

        @NotNull
        public CompletableFuture<Void> runAsync();

        @NotNull
        public DiagramUpdateQueryParams endQuery();

        public boolean doReloadData();

        public boolean doPresentationUpdate();

        default public boolean doUpdateNodePresentations() {
            return false;
        }

        @NotNull
        public Collection<DiagramNode<?>> getNodesForSizeUpdate();

        @Nullable
        public Layouter getLayouter();

        default public boolean isCollapseEdgesForClosedGroups() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diagram/DiagramBuilder$DiagramUpdateQueryParams";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "layouter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withNodePresentationsUpdate";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withRelayoutIf";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diagram/DiagramBuilder$DiagramUpdateQueryParams";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "withRelayoutIf";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2 -> new IllegalArgumentException(string);
            };
        }
    }
}

