/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.sarif.model.taint;

import com.jetbrains.qodana.sarif.model.Location;
import com.jetbrains.qodana.sarif.model.PhysicalLocation;
import com.jetbrains.qodana.sarif.model.Region;
import com.jetbrains.qodana.sarif.model.Result;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.qodana.sarif.SarifConverterKt;
import org.jetbrains.qodana.sarif.model.taint.TaintFragment;
import org.jetbrains.qodana.sarif.model.taint.TaintMarker;
import org.jetbrains.qodana.sarif.model.taint.TaintProblem;
import org.jetbrains.qodana.sarif.model.taint.TaintSink;
import org.jetbrains.qodana.sarif.model.taint.TaintSource;
import org.jetbrains.teamcity.qodana.model.Severity;
import org.jetbrains.teamcity.qodana.model.version3.Problem;
import org.jetbrains.teamcity.qodana.model.version3.Source;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lorg/jetbrains/qodana/sarif/model/taint/TaintCode;", "", "()V", "Companion", "sarif-converter"})
public final class TaintCode {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final transient String category = "General";
    @NotNull
    public static final String type = "Taint analysis";
    @NotNull
    public static final String language = "php";
    @NotNull
    private static final Severity severity = Severity.WARNING;
    @NotNull
    private static final String comment = "Potentially vulnerable path";
    @NotNull
    public static final String inspectionName = "PhpVulnerablePathsInspection";
    @NotNull
    private static final List<String> possibleVulnerabilities;

    static {
        Object[] objectArray = new String[]{"Code", "XSS", "SQL", "XPATH", "LDAP", "HEADER", "RCE", "SESSION", "DIRECT_REF", "INCLUSION", "DISCLOSURE"};
        possibleVulnerabilities = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u001aB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b\u0011J\b\u0010\u0012\u001a\u00020\u000eH\u0002J\f\u0010\u0005\u001a\u00020\u0004*\u00020\u0010H\u0002J\u0012\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u0014*\u00020\u0010H\u0002J\f\u0010\u0015\u001a\u00020\u0004*\u00020\u0010H\u0002J\f\u0010\u0016\u001a\u00020\u000e*\u00020\u0010H\u0002J\u000e\u0010\u0017\u001a\u0004\u0018\u00010\u0018*\u00020\u0019H\u0002J\f\u0010\f\u001a\u00020\u0004*\u00020\u0010H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/qodana/sarif/model/taint/TaintCode$Companion;", "", "()V", "category", "", "comment", "inspectionName", "language", "possibleVulnerabilities", "", "severity", "Lorg/jetbrains/teamcity/qodana/model/Severity;", "type", "convert", "Lorg/jetbrains/teamcity/qodana/model/version3/Problem;", "taintProblem", "Lorg/jetbrains/qodana/sarif/model/taint/TaintProblem;", "convert$sarif_converter", "emptyProblem", "tags", "", "taintSources", "toSimpleProblem", "toSource", "Lorg/jetbrains/teamcity/qodana/model/version3/Source;", "Lorg/jetbrains/qodana/sarif/model/taint/TaintFragment;", "ShortMarkerDescription", "sarif-converter"})
    @SourceDebugExtension(value={"SMAP\nTaintCode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TaintCode.kt\norg/jetbrains/qodana/sarif/model/taint/TaintCode$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,102:1\n1603#2,9:103\n1855#2:112\n1856#2:114\n1612#2:115\n1549#2:117\n1620#2,3:118\n1603#2,9:121\n1855#2:130\n1856#2:132\n1612#2:133\n1360#2:134\n1446#2,2:135\n1549#2:137\n1620#2,3:138\n1448#2,3:141\n1#3:113\n1#3:116\n1#3:131\n*S KotlinDebug\n*F\n+ 1 TaintCode.kt\norg/jetbrains/qodana/sarif/model/taint/TaintCode$Companion\n*L\n55#1:103,9\n55#1:112\n55#1:114\n55#1:115\n67#1:117\n67#1:118,3\n82#1:121,9\n82#1:130\n82#1:132\n82#1:133\n87#1:134\n87#1:135,2\n87#1:137\n87#1:138,3\n87#1:141,3\n55#1:113\n82#1:131\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final Problem emptyProblem() {
            return new Problem("Code Inspection", TaintCode.category, null, TaintCode.type, null, severity, TaintCode.comment, "", new ArrayList(), null, MapsKt.emptyMap(), "", null);
        }

        @NotNull
        public final Problem convert$sarif_converter(@NotNull TaintProblem taintProblem) {
            Intrinsics.checkNotNullParameter((Object)taintProblem, (String)"taintProblem");
            return this.toSimpleProblem(taintProblem);
        }

        /*
         * WARNING - void declaration
         */
        private final Problem toSimpleProblem(TaintProblem $this$toSimpleProblem) {
            Result.BaselineState baselineState;
            void $this$toSimpleProblem_u24lambda_u244_u24lambda_u243;
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            Problem problem;
            Problem $this$toSimpleProblem_u24lambda_u244 = problem = this.emptyProblem();
            boolean bl = false;
            $this$toSimpleProblem_u24lambda_u244.setType(Companion.type($this$toSimpleProblem));
            $this$toSimpleProblem_u24lambda_u244.setComment(Companion.comment($this$toSimpleProblem));
            $this$toSimpleProblem_u24lambda_u244.setTags(Companion.tags($this$toSimpleProblem));
            List<TaintFragment> list2 = $this$toSimpleProblem.getFragments();
            Intrinsics.checkNotNull(list2);
            Object object = list2;
            Problem problem2 = $this$toSimpleProblem_u24lambda_u244;
            boolean $i$f$mapNotNull22 = false;
            void var8_9 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Source it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl2 = false;
                TaintFragment it = (TaintFragment)element$iv$iv;
                boolean bl3 = false;
                if (Companion.toSource(it) == null) continue;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            problem2.setSources(CollectionsKt.toMutableList((Collection)((List)destination$iv$iv)));
            Object $i$f$mapNotNull22 = object = (Map)new LinkedHashMap();
            problem2 = $this$toSimpleProblem_u24lambda_u244;
            boolean bl5 = false;
            $this$toSimpleProblem_u24lambda_u244_u24lambda_u243.put("source_markers", Companion.taintSources($this$toSimpleProblem));
            $this$toSimpleProblem_u24lambda_u244_u24lambda_u243.put("inspectionName", TaintCode.inspectionName);
            Result.BaselineState baselineState2 = baselineState = $this$toSimpleProblem.getResult().getBaselineState();
            if (baselineState2 != null) {
                Intrinsics.checkNotNullExpressionValue((Object)((Object)baselineState2), (String)"baselineState");
                Result.BaselineState it = baselineState;
                boolean bl6 = false;
                if (SarifConverterKt.isTechDebt(it)) {
                    $this$toSimpleProblem_u24lambda_u244_u24lambda_u243.put("isTechDebt", "true");
                }
            }
            Result.BaselineState baselineState3 = baselineState = $this$toSimpleProblem.getResult().getBaselineState();
            if (baselineState3 != null) {
                Intrinsics.checkNotNullExpressionValue((Object)((Object)baselineState3), (String)"baselineState");
                Result.BaselineState it = baselineState;
                boolean bl7 = false;
                String string = it.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.toString()");
                $this$toSimpleProblem_u24lambda_u244_u24lambda_u243.put("baselineState", string);
            }
            problem2.setAttributes((Map<String, String>)object);
            return problem;
        }

        /*
         * WARNING - void declaration
         */
        private final Source toSource(TaintFragment $this$toSource) {
            Object object;
            Object object2 = $this$toSource.getLocation();
            if (object2 != null && (object2 = SarifConverterKt.source$default((Location)object2, TaintCode.type, null, 2, null)) != null) {
                List list2;
                List list3;
                void $this$toSource_u24lambda_u247_u24lambda_u246;
                Map map2;
                Object object3;
                Object $this$toSource_u24lambda_u247 = object3 = object2;
                boolean bl = false;
                ((Source)$this$toSource_u24lambda_u247).setOffset(1);
                Map map3 = map2 = (Map)new LinkedHashMap();
                Object object4 = $this$toSource_u24lambda_u247;
                boolean bl2 = false;
                void v1 = $this$toSource_u24lambda_u247_u24lambda_u246;
                String string = "markers";
                List<TaintMarker> list4 = $this$toSource.getMarkers();
                if (list4 != null) {
                    Collection<ShortMarkerDescription> collection;
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Iterable iterable = list4;
                    String string2 = string;
                    void var11_11 = v1;
                    boolean $i$f$map = false;
                    void var13_13 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        int n;
                        Integer n2;
                        List list5;
                        Region region;
                        void marker;
                        TaintMarker taintMarker = (TaintMarker)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl3 = false;
                        Object object5 = $this$toSource.getLocation();
                        Region contextRegion = object5 != null && (object5 = ((Location)object5).getPhysicalLocation()) != null ? ((PhysicalLocation)object5).getRegion() : null;
                        Object object6 = marker.getLocation();
                        Intrinsics.checkNotNull((Object)(object6 != null && (object6 = ((Location)object6).getPhysicalLocation()) != null ? ((PhysicalLocation)object6).getRegion() : null));
                        region = region;
                        String string3 = marker.getOrder();
                        Intrinsics.checkNotNull((Object)string3);
                        String string4 = string3.toString();
                        List list6 = marker.getSuccessors();
                        if (list6 == null) {
                            list6 = CollectionsKt.emptyList();
                        }
                        if ((list5 = marker.getPredecessors()) == null) {
                            list5 = CollectionsKt.emptyList();
                        }
                        Integer n3 = region.getStartLine();
                        Intrinsics.checkNotNullExpressionValue((Object)n3, (String)"region.startLine");
                        int n4 = ((Number)n3).intValue();
                        int n5 = region.getCharOffset();
                        Region region2 = contextRegion;
                        Integer n6 = n2 = region2 != null ? region2.getCharOffset() : null;
                        if (n6 == null) {
                            n = 0;
                        } else {
                            Intrinsics.checkNotNullExpressionValue((Object)n6, (String)"contextRegion?.charOffset ?: 0");
                            n = n2;
                        }
                        int n7 = n5 - n;
                        Integer n8 = region.getCharLength();
                        Intrinsics.checkNotNullExpressionValue((Object)n8, (String)"region.charLength");
                        collection.add(new ShortMarkerDescription(string4, list6, list5, n4, n7, ((Number)n8).intValue()));
                    }
                    collection = (List)destination$iv$iv;
                    v1 = var11_11;
                    string = string2;
                    list3 = collection;
                } else {
                    list3 = list2 = null;
                }
                if (list3 == null) {
                    list2 = CollectionsKt.emptyList();
                }
                v1.put(string, list2);
                ((Source)object4).setAttributes(map2);
                object = object3;
            } else {
                object = null;
            }
            return object;
        }

        /*
         * WARNING - void declaration
         */
        private final String taintSources(TaintProblem $this$taintSources) {
            List list2;
            List list3;
            List<TaintSource> list4 = $this$taintSources.getSources();
            if (list4 != null) {
                void $this$mapNotNullTo$iv$iv;
                Iterable $this$mapNotNull$iv = list4;
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    String it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl = false;
                    TaintSource it = (TaintSource)element$iv$iv;
                    boolean bl2 = false;
                    if (it.getOrder() == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                list3 = (List)destination$iv$iv;
            } else {
                list3 = list2 = null;
            }
            if (list3 == null) {
                list2 = CollectionsKt.emptyList();
            }
            return CollectionsKt.joinToString$default((Iterable)list2, (CharSequence)"|", null, null, (int)0, null, null, (int)62, null);
        }

        private final String type(TaintProblem $this$type) {
            TaintSink taintSink = $this$type.getSink();
            Intrinsics.checkNotNull((Object)taintSink);
            return taintSink.type();
        }

        /*
         * WARNING - void declaration
         */
        private final List<String> tags(TaintProblem $this$tags) {
            void $this$flatMapTo$iv$iv;
            List<TaintFragment> list2 = $this$tags.getFragments();
            Intrinsics.checkNotNull(list2);
            Iterable $this$flatMap$iv = list2;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                void $this$mapTo$iv$iv;
                TaintFragment it = (TaintFragment)element$iv$iv;
                boolean bl = false;
                List<TaintMarker> list3 = it.getMarkers();
                Intrinsics.checkNotNull(list3);
                Iterable $this$map$iv = list3;
                boolean $i$f$map = false;
                Iterable iterable2 = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void marker;
                    TaintMarker taintMarker = (TaintMarker)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl2 = false;
                    List<String> list4 = marker.getSanitizedVulnerabilities();
                    Intrinsics.checkNotNull(list4);
                    collection.add(list4);
                }
                Iterable list$iv$iv = CollectionsKt.flatten((Iterable)((List)destination$iv$iv2));
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            Set sanitizedVulnerabilities = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            return CollectionsKt.toMutableList((Collection)SetsKt.minus((Set)CollectionsKt.toSet((Iterable)possibleVulnerabilities), (Iterable)sanitizedVulnerabilities));
        }

        private final String comment(TaintProblem $this$comment) {
            TaintSink taintSink = $this$comment.getSink();
            Intrinsics.checkNotNull((Object)taintSink);
            List<TaintSource> list2 = $this$comment.getSources();
            Intrinsics.checkNotNull(list2);
            return taintSink.comment(list2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\r\b\u0000\u0018\u00002\u00020\u0001BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u00a2\u0006\u0002\u0010\u000bR\u0011\u0010\n\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\rR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/qodana/sarif/model/taint/TaintCode$Companion$ShortMarkerDescription;", "", "name", "", "target", "", "source", "line", "", "offset", "length", "(Ljava/lang/String;Ljava/util/List;Ljava/util/List;III)V", "getLength", "()I", "getLine", "getName", "()Ljava/lang/String;", "getOffset", "getSource", "()Ljava/util/List;", "getTarget", "sarif-converter"})
        public static final class ShortMarkerDescription {
            @NotNull
            private final String name;
            @NotNull
            private final List<String> target;
            @NotNull
            private final List<String> source;
            private final int line;
            private final int offset;
            private final int length;

            public ShortMarkerDescription(@NotNull String name, @NotNull List<String> target, @NotNull List<String> source, int line, int offset, int length) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter(target, (String)"target");
                Intrinsics.checkNotNullParameter(source, (String)"source");
                this.name = name;
                this.target = target;
                this.source = source;
                this.line = line;
                this.offset = offset;
                this.length = length;
            }

            @NotNull
            public final String getName() {
                return this.name;
            }

            @NotNull
            public final List<String> getTarget() {
                return this.target;
            }

            @NotNull
            public final List<String> getSource() {
                return this.source;
            }

            public final int getLine() {
                return this.line;
            }

            public final int getOffset() {
                return this.offset;
            }

            public final int getLength() {
                return this.length;
            }
        }
    }
}

