/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.highlight;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.codeInsight.daemon.impl.analysis.DaemonTooltipsUtil;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.history.FileRevisionTimestampComparator;
import com.intellij.history.LocalHistory;
import com.intellij.lang.annotation.ProblemGroup;
import com.intellij.navigation.JBProtocolRevisionResolver;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.ide.progress.TasksKt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.QodanaBundle;
import org.jetbrains.qodana.actions.QodanaRootIgnoreIntention;
import org.jetbrains.qodana.actions.QodanaSuppressableProblemGroup;
import org.jetbrains.qodana.actions.StopShowingReportAction;
import org.jetbrains.qodana.coroutines.QodanaDispatchersKt;
import org.jetbrains.qodana.extensions.QodanaHighlightInfoTypeProvider;
import org.jetbrains.qodana.extensions.QodanaHighlightingSupportInfoProvider;
import org.jetbrains.qodana.extensions.RepositoryRevisionProvider;
import org.jetbrains.qodana.highlight.HighlightedReportData;
import org.jetbrains.qodana.highlight.HighlightedReportState;
import org.jetbrains.qodana.highlight.HighlightedReportStateKt;
import org.jetbrains.qodana.highlight.ProblemWithRange;
import org.jetbrains.qodana.highlight.QodanaHighlightedReportService;
import org.jetbrains.qodana.highlight.QodanaHighlightingInfoType;
import org.jetbrains.qodana.highlight.QodanaHighlightingPassState;
import org.jetbrains.qodana.highlight.QodanaLocalDocumentData;
import org.jetbrains.qodana.highlight.QodanaRangeCalculator;
import org.jetbrains.qodana.highlight.QodanaReportHighlightingPass;
import org.jetbrains.qodana.highlight.QodanaReportHighlightingPassKt;
import org.jetbrains.qodana.highlight.QodanaRevisionData;
import org.jetbrains.qodana.highlight.QodanaRevisionDataKt;
import org.jetbrains.qodana.highlight.SarifInspectionDescriptionLinkHandler;
import org.jetbrains.qodana.highlight.SarifProblemPropertiesUpdater;
import org.jetbrains.qodana.problem.SarifProblem;
import org.jetbrains.qodana.problem.SarifProblemKt;
import org.jetbrains.qodana.problem.SarifProblemProperties;
import org.jetbrains.qodana.settings.ConfigExcludeItem;
import org.jetbrains.qodana.staticAnalysis.inspections.coverage.UtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ&\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u001c\u0010\u001c\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0003\u001a\u00020\u00042\b\u0010\u001d\u001a\u0004\u0018\u00010\u0016H\u0002J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0003\u001a\u00020\u0004H\u0002J1\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\"2\b\u0010#\u001a\u0004\u0018\u00010$2\u000e\u0010%\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00160&H\u0002\u00a2\u0006\u0002\u0010'J\u0010\u0010(\u001a\u00020\u00182\u0006\u0010#\u001a\u00020$H\u0002J\u0018\u0010)\u001a\u00020\u00182\u000e\u0010%\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00160&H\u0002J\u001e\u0010*\u001a\u00020\u00182\u0006\u0010+\u001a\u00020,2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020.0\u000eH\u0002J\b\u0010/\u001a\u00020 H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lorg/jetbrains/qodana/highlight/QodanaReportHighlightingPass;", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPass;", "Lcom/intellij/openapi/project/DumbAware;", "myFile", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "reportService", "Lorg/jetbrains/qodana/highlight/QodanaHighlightedReportService;", "passState", "Lorg/jetbrains/qodana/highlight/QodanaHighlightingPassState;", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/openapi/editor/Editor;Lorg/jetbrains/qodana/highlight/QodanaHighlightedReportService;Lorg/jetbrains/qodana/highlight/QodanaHighlightingPassState;)V", "myHighlightInfos", "Ljava/util/concurrent/atomic/AtomicReference;", "", "Lcom/intellij/codeInsight/daemon/impl/HighlightInfo;", "buildHighlightInfo", "problem", "Lorg/jetbrains/qodana/problem/SarifProblem;", "textRange", "Lcom/intellij/openapi/util/TextRange;", "suppressToolId", "", "doApplyInformationToEditor", "", "doCollectInformation", "progress", "Lcom/intellij/openapi/progress/ProgressIndicator;", "getPsiFileByRevision", "revisionId", "getPsiFileForLastRevision", "isDataCorrect", "", "data", "Lorg/jetbrains/qodana/highlight/QodanaRevisionData;", "localIdeRunTimestamp", "", "revisionIds", "", "(Lorg/jetbrains/qodana/highlight/QodanaRevisionData;Ljava/lang/Long;Ljava/util/Set;)Z", "putLocalRunData", "putRevisionData", "updateProblemsRanges", "highlightedReportData", "Lorg/jetbrains/qodana/highlight/HighlightedReportData;", "problemsWithRanges", "Lorg/jetbrains/qodana/highlight/ProblemWithRange;", "updateWasAnalyzedOnceStatus", "intellij.qodana"})
@SourceDebugExtension(value={"SMAP\nQodanaReportHighlightingPass.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QodanaReportHighlightingPass.kt\norg/jetbrains/qodana/highlight/QodanaReportHighlightingPass\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,261:1\n1#2:262\n1#2:286\n1#2:321\n1#2:334\n766#3:263\n857#3,2:264\n766#3:266\n857#3:267\n1747#3,3:268\n858#3:271\n1549#3:272\n1620#3,3:273\n1603#3,9:276\n1855#3:285\n1856#3:287\n1612#3:288\n1726#3,3:289\n1271#3,2:292\n1285#3,4:294\n1549#3:298\n1620#3,3:299\n1726#3,3:302\n1603#3,9:311\n1855#3:320\n1856#3:322\n1612#3:323\n1603#3,9:324\n1855#3:333\n1856#3:335\n1612#3:336\n766#3:337\n857#3,2:338\n9972#4:305\n10394#4,5:306\n*S KotlinDebug\n*F\n+ 1 QodanaReportHighlightingPass.kt\norg/jetbrains/qodana/highlight/QodanaReportHighlightingPass\n*L\n96#1:286\n225#1:321\n229#1:334\n63#1:263\n63#1:264,2\n64#1:266\n64#1:267\n65#1:268,3\n64#1:271\n72#1:272\n72#1:273,3\n96#1:276,9\n96#1:285\n96#1:287\n96#1:288\n114#1:289,3\n132#1:292,2\n132#1:294,4\n140#1:298\n140#1:299,3\n206#1:302,3\n225#1:311,9\n225#1:320\n225#1:322\n225#1:323\n229#1:324,9\n229#1:333\n229#1:335\n229#1:336\n237#1:337\n237#1:338,2\n216#1:305\n216#1:306,5\n*E\n"})
public final class QodanaReportHighlightingPass
extends TextEditorHighlightingPass
implements DumbAware {
    @NotNull
    private final PsiFile myFile;
    @NotNull
    private final Editor editor;
    @NotNull
    private final QodanaHighlightedReportService reportService;
    @NotNull
    private final QodanaHighlightingPassState passState;
    @NotNull
    private final AtomicReference<List<HighlightInfo>> myHighlightInfos;

    public QodanaReportHighlightingPass(@NotNull PsiFile myFile, @NotNull Editor editor, @NotNull QodanaHighlightedReportService reportService, @NotNull QodanaHighlightingPassState passState) {
        Intrinsics.checkNotNullParameter((Object)myFile, (String)"myFile");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)reportService, (String)"reportService");
        Intrinsics.checkNotNullParameter((Object)passState, (String)"passState");
        super(myFile.getProject(), editor.getDocument());
        this.myFile = myFile;
        this.editor = editor;
        this.reportService = reportService;
        this.passState = passState;
        this.myHighlightInfos = new AtomicReference<List>(CollectionsKt.emptyList());
    }

    /*
     * WARNING - void declaration
     */
    public void doCollectInformation(@NotNull ProgressIndicator progress) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Collection collection;
        Object item$iv$iv2;
        void $this$mapTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Object it;
        Object object;
        VirtualFile virtualFile2;
        block20: {
            block19: {
                Intrinsics.checkNotNullParameter((Object)progress, (String)"progress");
                VirtualFile virtualFile3 = this.myFile.getVirtualFile();
                if (virtualFile3 == null) {
                    return;
                }
                virtualFile2 = virtualFile3;
                Project project = this.myProject;
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
                object = ProjectUtil.guessProjectDir((Project)project);
                if (object == null) break block19;
                it = object;
                boolean bl = false;
                String string = it.getCanonicalPath();
                if (string == null) {
                    string = it.getPath();
                }
                String string2 = string;
                Intrinsics.checkNotNull((Object)string2);
                Path path = Paths.get(string2, new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
                object = path;
                if (path != null) break block20;
            }
            return;
        }
        Object projectDir = object;
        this.myHighlightInfos.set(CollectionsKt.emptyList());
        List highlights = new ArrayList();
        HighlightedReportData highlightedReportData2 = HighlightedReportStateKt.getHighlightedReportDataIfSelected((HighlightedReportState)this.reportService.getHighlightedReportState().getValue());
        if (highlightedReportData2 == null) {
            return;
        }
        HighlightedReportData highlightedReportData3 = highlightedReportData2;
        String string = virtualFile2.getCanonicalPath();
        if (string == null) {
            string = virtualFile2.getPath();
        }
        it = string;
        Intrinsics.checkNotNull((Object)it);
        Object virtualFilePath = it;
        Path path = Paths.get((String)virtualFilePath, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        Iterable bl = HighlightedReportData.getRelevantProblemsByFilePath$default(highlightedReportData3, (Path)projectDir, path, false, 4, null);
        boolean $i$f$filter = false;
        void var10_13 = $this$filter$iv;
        Iterable<Object> destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            SarifProblem it2 = (SarifProblem)element$iv$iv;
            boolean bl2 = false;
            if (!it2.getHasRange()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl3;
            block18: {
                SarifProblem problem = (SarifProblem)element$iv$iv;
                boolean bl4 = false;
                Iterable $this$any$iv = (Iterable)highlightedReportData3.getExcludedDataFlow().getValue();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl3 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ConfigExcludeItem data2 = (ConfigExcludeItem)element$iv;
                        boolean bl5 = false;
                        if (!data2.isRelatedToProblem(problem)) continue;
                        bl3 = true;
                        break block18;
                    }
                    bl3 = false;
                }
            }
            boolean bl6 = !bl3;
            if (!bl6) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List relevantProblems = (List)destination$iv$iv;
        if (relevantProblems.isEmpty()) {
            return;
        }
        Iterable $this$map$iv = relevantProblems;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
            void it3;
            SarifProblem bl4 = (SarifProblem)item$iv$iv2;
            collection = destination$iv$iv2;
            boolean bl7 = false;
            collection.add(it3.getRevisionId());
        }
        Set revisionIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
        HighlightedReportData.IdeRunData ideRunData = highlightedReportData3.getIdeRunData();
        Long localIdeRunTimestamp = ideRunData != null ? ideRunData.getIdeRunTimestamp() : null;
        QodanaRevisionData data3 = (QodanaRevisionData)this.editor.getDocument().getUserData(QodanaRevisionDataKt.getQODANA_REVISION_DATA());
        if (!this.isDataCorrect(data3, localIdeRunTimestamp, revisionIds)) {
            BuildersKt.launch$default((CoroutineScope)this.passState.getScope(), (CoroutineContext)QodanaDispatchersKt.getQodanaDispatchers().getDefault(), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, localIdeRunTimestamp, (Set<String>)revisionIds, null){
                int label;
                final /* synthetic */ QodanaReportHighlightingPass this$0;
                final /* synthetic */ Long $localIdeRunTimestamp;
                final /* synthetic */ Set<String> $revisionIds;
                {
                    this.this$0 = $receiver;
                    this.$localIdeRunTimestamp = $localIdeRunTimestamp;
                    this.$revisionIds = $revisionIds;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            Project project = QodanaReportHighlightingPass.access$getMyProject$p$s1464811777(this.this$0);
                            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"access$getMyProject$p$s1464811777(...)");
                            Object[] objectArray = new Object[]{QodanaReportHighlightingPass.access$getMyFile$p(this.this$0).getName()};
                            String string = QodanaBundle.message("progress.title.qodana.highlight.calc", objectArray);
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                            this.label = 1;
                            Object object3 = TasksKt.withBackgroundProgress((Project)project, (String)string, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$localIdeRunTimestamp, this.this$0, this.$revisionIds, null){
                                int label;
                                final /* synthetic */ Long $localIdeRunTimestamp;
                                final /* synthetic */ QodanaReportHighlightingPass this$0;
                                final /* synthetic */ Set<String> $revisionIds;
                                {
                                    this.$localIdeRunTimestamp = $localIdeRunTimestamp;
                                    this.this$0 = $receiver;
                                    this.$revisionIds = $revisionIds;
                                    super(2, $completion);
                                }

                                @Nullable
                                public final Object invokeSuspend(@NotNull Object object) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)object);
                                            if (this.$localIdeRunTimestamp != null) {
                                                QodanaReportHighlightingPass.access$putLocalRunData(this.this$0, this.$localIdeRunTimestamp);
                                            } else {
                                                QodanaReportHighlightingPass.access$putRevisionData(this.this$0, this.$revisionIds);
                                            }
                                            DaemonCodeAnalyzer.getInstance((Project)QodanaReportHighlightingPass.access$getMyProject$p$s1464811777(this.this$0)).restart(QodanaReportHighlightingPass.access$getMyFile$p(this.this$0));
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                @Nullable
                                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (Continuation)((Continuation)this));
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
            return;
        }
        Project project = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
        Document document2 = this.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"getDocument(...)");
        QodanaRangeCalculator rangesCalculator = new QodanaRangeCalculator(project, this.myFile, document2, highlightedReportData3);
        QodanaRevisionData qodanaRevisionData = data3;
        Intrinsics.checkNotNull((Object)qodanaRevisionData);
        List<ProblemWithRange> relevantProblemsWithRanges = rangesCalculator.calculateTextRanges$intellij_qodana(relevantProblems, qodanaRevisionData);
        Iterable $i$f$mapTo22 = relevantProblemsWithRanges;
        collection = highlights;
        boolean $i$f$mapNotNull = false;
        item$iv$iv2 = $this$mapNotNull$iv;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            HighlightInfo it$iv$iv;
            String toolId;
            TextRange range;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl8 = false;
            ProblemWithRange problemWithRange = (ProblemWithRange)element$iv$iv;
            boolean bl9 = false;
            SarifProblem problem = problemWithRange.component1();
            if (this.buildHighlightInfo(problem, range = problemWithRange.component2(), toolId = highlightedReportData3.getInspectionsInfoProvider().getSuppressIdByInspection(problem.getInspectionId())) == null) continue;
            boolean bl10 = false;
            destination$iv$iv3.add(it$iv$iv);
        }
        collection.addAll((List)destination$iv$iv3);
        if (virtualFile2.isInLocalFileSystem()) {
            this.updateProblemsRanges(highlightedReportData3, relevantProblemsWithRanges);
        }
        this.myHighlightInfos.set(highlights);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isDataCorrect(QodanaRevisionData data2, Long localIdeRunTimestamp, Set<String> revisionIds) {
        QodanaRevisionData qodanaRevisionData = data2;
        if (qodanaRevisionData == null) {
            return false;
        }
        if (qodanaRevisionData instanceof QodanaRevisionData.VCSInfo) {
            PsiFile it;
            if (localIdeRunTimestamp != null) return false;
            if (!Intrinsics.areEqual((Object)CollectionsKt.toSet((Iterable)((QodanaRevisionData.VCSInfo)data2).getRevisionPsiFiles().keySet()), revisionIds)) return false;
            Iterable $this$all$iv = CollectionsKt.filterNotNull((Iterable)CollectionsKt.toSet((Iterable)((QodanaRevisionData.VCSInfo)data2).getRevisionPsiFiles().values()));
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                return true;
            }
            Iterator iterator2 = $this$all$iv.iterator();
            do {
                if (!iterator2.hasNext()) return true;
                Object element$iv = iterator2.next();
                it = (PsiFile)element$iv;
                boolean bl = false;
            } while (it.isValid());
            return false;
        }
        if (!(qodanaRevisionData instanceof QodanaRevisionData.LocalInfo)) throw new NoWhenBranchMatchedException();
        Long l = localIdeRunTimestamp;
        if (l == null) return false;
        if (((QodanaRevisionData.LocalInfo)data2).getLocalDocumentData().getTimestamp() != l.longValue()) return false;
        return true;
    }

    private final void putLocalRunData(long localIdeRunTimestamp) {
        LocalHistory localHistory = LocalHistory.Companion.getInstance();
        VirtualFile virtualFile2 = this.myFile.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getVirtualFile(...)");
        byte[] byArray = localHistory.getByteContent(virtualFile2, new FileRevisionTimestampComparator(localIdeRunTimestamp){
            final /* synthetic */ long $localIdeRunTimestamp;
            {
                this.$localIdeRunTimestamp = $localIdeRunTimestamp;
            }

            public final boolean isSuitable(long t2) {
                return t2 <= this.$localIdeRunTimestamp;
            }
        });
        if (byArray == null) {
            byArray = new byte[]{};
        }
        byte[] revisionFileContent2 = byArray;
        String text2 = ((Object)LoadTextUtil.getTextByBinaryPresentation((byte[])revisionFileContent2, (VirtualFile)this.myFile.getVirtualFile(), (boolean)false, (boolean)false)).toString();
        Document document2 = EditorFactory.getInstance().createDocument((CharSequence)text2);
        Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"createDocument(...)");
        Document createdDocument = document2;
        this.editor.getDocument().putUserData(QodanaRevisionDataKt.getQODANA_REVISION_DATA(), (Object)new QodanaRevisionData.LocalInfo(new QodanaLocalDocumentData(localIdeRunTimestamp, createdDocument)));
    }

    /*
     * WARNING - void declaration
     */
    private final void putRevisionData(Set<String> revisionIds) {
        Iterable $this$associateWith$iv = revisionIds;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it;
            String string = (String)element$iv$iv;
            Object t2 = element$iv$iv;
            Map map2 = result$iv;
            boolean bl = false;
            PsiFile psiFile2 = this.getPsiFileByRevision(this.myFile, (String)it);
            if (psiFile2 == null) {
                psiFile2 = this.getPsiFileForLastRevision(this.myFile);
            }
            PsiFile psiFile3 = psiFile2;
            map2.put(t2, psiFile3);
        }
        Map psiFiles = result$iv;
        this.editor.getDocument().putUserData(QodanaRevisionDataKt.getQODANA_REVISION_DATA(), (Object)new QodanaRevisionData.VCSInfo(psiFiles));
    }

    /*
     * WARNING - void declaration
     */
    private final void updateProblemsRanges(HighlightedReportData highlightedReportData2, List<ProblemWithRange> problemsWithRanges) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = problemsWithRanges;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            SarifProblemPropertiesUpdater sarifProblemPropertiesUpdater;
            ProblemWithRange problemWithRange = (ProblemWithRange)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            SarifProblem problem = problemWithRange.component1();
            TextRange textRange = problemWithRange.component2();
            if (textRange == null) {
                sarifProblemPropertiesUpdater = new SarifProblemPropertiesUpdater(problem, (Function1<? super SarifProblemProperties, SarifProblemProperties>)((Function1)updateProblemsRanges.propertiesUpdaters.1.1.INSTANCE));
            } else {
                int line = this.getDocument().getLineNumber(textRange.getStartOffset());
                int lineStartOffset = this.getDocument().getLineStartOffset(line);
                int column = textRange.getStartOffset() - lineStartOffset;
                sarifProblemPropertiesUpdater = new SarifProblemPropertiesUpdater(problem, (Function1<? super SarifProblemProperties, SarifProblemProperties>)((Function1)new Function1<SarifProblemProperties, SarifProblemProperties>(line, column){
                    final /* synthetic */ int $line;
                    final /* synthetic */ int $column;
                    {
                        this.$line = $line;
                        this.$column = $column;
                        super(1);
                    }

                    @NotNull
                    public final SarifProblemProperties invoke(@NotNull SarifProblemProperties it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return SarifProblemProperties.copy$default(it, false, false, false, this.$line, this.$column, 5, null);
                    }
                }));
            }
            collection.add(sarifProblemPropertiesUpdater);
        }
        List propertiesUpdaters2 = (List)destination$iv$iv;
        highlightedReportData2.updateProblemsProperties(propertiesUpdaters2);
    }

    private final PsiFile getPsiFileByRevision(PsiFile myFile, String revisionId) {
        PsiFile psiFile2;
        if (revisionId == null) {
            return null;
        }
        String string = myFile.getVirtualFile().getCanonicalPath();
        if (string == null) {
            return null;
        }
        String path = string;
        VirtualFile virtualFile2 = JBProtocolRevisionResolver.processResolvers((Project)this.myProject, (String)path, (String)revisionId);
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile revisionFile = virtualFile2;
        PsiFile psiFile3 = psiFile2 = (PsiFile)ActionsKt.runReadAction((Function0)((Function0)new Function0<PsiFile>(this, revisionFile){
            final /* synthetic */ QodanaReportHighlightingPass this$0;
            final /* synthetic */ VirtualFile $revisionFile;
            {
                this.this$0 = $receiver;
                this.$revisionFile = $revisionFile;
                super(0);
            }

            @Nullable
            public final PsiFile invoke() {
                return PsiManager.getInstance((Project)QodanaReportHighlightingPass.access$getMyProject$p$s1464811777(this.this$0)).findFile(this.$revisionFile);
            }
        }));
        return (psiFile3 != null ? !psiFile3.isValid() : false) ? null : psiFile2;
    }

    private final PsiFile getPsiFileForLastRevision(PsiFile myFile) {
        Project project = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
        String currentRevision = RepositoryRevisionProvider.Companion.getRepositoryRevision(project, myFile.getVirtualFile());
        return this.getPsiFileByRevision(myFile, currentRevision);
    }

    private final HighlightInfo buildHighlightInfo(SarifProblem problem, TextRange textRange, String suppressToolId) {
        HighlightInfo highlight;
        if (textRange == null) {
            return null;
        }
        String description2 = SarifProblemKt.buildDescription(problem, true, true);
        String string = DaemonTooltipsUtil.getWrappedTooltipWithCustomReference((String)description2, (String)SarifInspectionDescriptionLinkHandler.Companion.getLinkReferenceToInspection(problem.getInspectionId()), (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getWrappedTooltipWithCustomReference(...)");
        String tooltip = string;
        PsiElement element2 = this.myFile.findElementAt(textRange.getStartOffset());
        HighlightInfoType infoType = QodanaHighlightInfoTypeProvider.Companion.getHighlightTypeInfo();
        HighlightInfo.Builder builder = HighlightInfo.newHighlightInfo((HighlightInfoType)new QodanaHighlightingInfoType(problem, infoType));
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"newHighlightInfo(...)");
        HighlightInfo.Builder builder2 = builder;
        List ignoreActions = new ArrayList();
        if (suppressToolId != null) {
            QodanaSuppressableProblemGroup problemGroup = new QodanaSuppressableProblemGroup(suppressToolId, this.myFile.getVirtualFile());
            builder2.problemGroup((ProblemGroup)problemGroup);
            Object[] suppressActions = problemGroup.getSuppressActions(element2);
            CollectionsKt.addAll((Collection)ignoreActions, (Object[])suppressActions);
        }
        ignoreActions.add(new StopShowingReportAction());
        builder2.registerFix((IntentionAction)new QodanaRootIgnoreIntention(), ignoreActions, null, null, null);
        HighlightInfo highlightInfo = highlight = builder2.range(textRange).needsUpdateOnTyping(true).description(description2).escapedToolTip(tooltip).create();
        if (!((highlightInfo != null ? highlightInfo.getInspectionToolId() : null) == null)) {
            boolean bl = false;
            String string2 = "Inspection id must not be passed via HighlightInfo, otherwise inspections pass may clean it up";
            throw new IllegalArgumentException(string2.toString());
        }
        return highlight;
    }

    private final boolean updateWasAnalyzedOnceStatus() {
        boolean bl;
        block3: {
            DaemonCodeAnalyzer daemonCodeAnalyzer = DaemonCodeAnalyzerEx.getInstance((Project)this.myProject);
            DaemonCodeAnalyzerImpl codeAnalyzer = daemonCodeAnalyzer instanceof DaemonCodeAnalyzerImpl ? (DaemonCodeAnalyzerImpl)daemonCodeAnalyzer : null;
            Iterable $this$all$iv = QodanaHighlightingSupportInfoProvider.Companion.getPrecedingPassesIds();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    int it = ((Number)element$iv).intValue();
                    boolean bl2 = false;
                    DaemonCodeAnalyzerImpl daemonCodeAnalyzerImpl = codeAnalyzer;
                    if ((daemonCodeAnalyzerImpl != null && (daemonCodeAnalyzerImpl = daemonCodeAnalyzerImpl.getFileStatusMap()) != null ? daemonCodeAnalyzerImpl.getFileDirtyScope(this.getDocument(), this.myFile, it) : null) == null) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        boolean firstAnalysisPassed = bl;
        return this.passState.updateWasAnalysedOnce(firstAnalysisPassed);
    }

    /*
     * WARNING - void declaration
     */
    public void doApplyInformationToEditor() {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        HighlightedReportData highlightedReportData2;
        QodanaHighlightingInfoType type;
        HighlightInfoType highlightInfoType;
        HighlightInfo qodanaHighlight;
        boolean bl;
        Object element$iv$iv;
        Object element$iv$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Iterable element$iv$iv22;
        void $this$flatMapTo$iv$iv;
        MarkupModel markupModel = DocumentMarkupModel.forDocument((Document)this.getDocument(), (Project)this.myProject, (boolean)false);
        List<HighlightInfo> qodanaHighlights = this.myHighlightInfos.get();
        RangeHighlighter[] rangeHighlighterArray = markupModel.getAllHighlighters();
        Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighterArray, (String)"getAllHighlighters(...)");
        Object[] $this$flatMap$iv = rangeHighlighterArray;
        boolean $i$f$flatMap = false;
        Object[] objectArray = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Iterable element$iv$iv22 : $this$flatMapTo$iv$iv) {
            RangeHighlighter it = (RangeHighlighter)element$iv$iv22;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)it);
            Intrinsics.checkNotNull(qodanaHighlights);
            Iterable list$iv$iv = QodanaReportHighlightingPassKt.getQodanaHighlightsDuplicatingIde(it, qodanaHighlights);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Set qodanaHighlightersDuplicatingIde = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Intrinsics.checkNotNull(qodanaHighlights);
        List onlyQodanaHighlights = CollectionsKt.minus((Iterable)qodanaHighlights, (Iterable)qodanaHighlightersDuplicatingIde);
        boolean analyzedOnce = this.updateWasAnalyzedOnceStatus();
        Project project = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
        Set<String> enabledInspections = QodanaHighlightingSupportInfoProvider.Companion.getEnabledInspections(project);
        Set<String> notFixableInspection = UtilsKt.getCOVERAGE_INSPECTIONS_NAMES();
        Iterable $this$mapNotNull$iv = onlyQodanaHighlights;
        boolean $i$f$mapNotNull = false;
        element$iv$iv22 = $this$mapNotNull$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Iterable $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            SarifProblemPropertiesUpdater sarifProblemPropertiesUpdater;
            element$iv$iv = element$iv$iv$iv = iterator2.next();
            bl = false;
            qodanaHighlight = (HighlightInfo)element$iv$iv;
            boolean bl3 = false;
            highlightInfoType = qodanaHighlight.type;
            if ((highlightInfoType instanceof QodanaHighlightingInfoType ? (QodanaHighlightingInfoType)highlightInfoType : null) == null) {
                sarifProblemPropertiesUpdater = null;
            } else {
                type = type;
                boolean isFixed = analyzedOnce && enabledInspections.contains(type.getSarifProblem().getInspectionId()) && !notFixableInspection.contains(type.getSarifProblem().getInspectionId());
                sarifProblemPropertiesUpdater = new SarifProblemPropertiesUpdater(type.getSarifProblem(), (Function1<? super SarifProblemProperties, SarifProblemProperties>)((Function1)new Function1<SarifProblemProperties, SarifProblemProperties>(isFixed){
                    final /* synthetic */ boolean $isFixed;
                    {
                        this.$isFixed = $isFixed;
                        super(1);
                    }

                    @NotNull
                    public final SarifProblemProperties invoke(@NotNull SarifProblemProperties it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return SarifProblemProperties.copy$default(it, false, false, this.$isFixed, 0, 0, 27, null);
                    }
                }));
            }
            if (sarifProblemPropertiesUpdater == null) continue;
            SarifProblemPropertiesUpdater it$iv$iv = sarifProblemPropertiesUpdater;
            boolean bl4 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        $this$mapNotNull$iv = qodanaHighlightersDuplicatingIde;
        Collection collection = (List)destination$iv$iv2;
        $i$f$mapNotNull = false;
        $this$mapNotNullTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv2 = new ArrayList();
        $i$f$mapNotNullTo = false;
        $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        $i$f$forEach = false;
        iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            SarifProblemPropertiesUpdater sarifProblemPropertiesUpdater;
            element$iv$iv = element$iv$iv$iv = iterator2.next();
            bl = false;
            qodanaHighlight = (HighlightInfo)element$iv$iv;
            boolean bl5 = false;
            highlightInfoType = qodanaHighlight.type;
            if ((highlightInfoType instanceof QodanaHighlightingInfoType ? (QodanaHighlightingInfoType)highlightInfoType : null) == null) {
                sarifProblemPropertiesUpdater = null;
            } else {
                type = type;
                sarifProblemPropertiesUpdater = new SarifProblemPropertiesUpdater(type.getSarifProblem(), (Function1<? super SarifProblemProperties, SarifProblemProperties>)((Function1)doApplyInformationToEditor.toUpdate.2.1.INSTANCE));
            }
            if (sarifProblemPropertiesUpdater == null) continue;
            SarifProblemPropertiesUpdater it$iv$iv = sarifProblemPropertiesUpdater;
            boolean bl6 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        List toUpdate2 = CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv2));
        HighlightedReportData highlightedReportData3 = highlightedReportData2 = HighlightedReportStateKt.getHighlightedReportDataIfSelected((HighlightedReportState)this.reportService.getHighlightedReportState().getValue());
        if (highlightedReportData3 != null) {
            highlightedReportData3.updateProblemsProperties(toUpdate2);
        }
        $this$mapNotNullTo$iv$iv = onlyQodanaHighlights;
        boolean $i$f$filter = false;
        void $i$f$mapNotNullTo2 = $this$filter$iv;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv3 : $this$filterTo$iv$iv) {
            HighlightInfo it = (HighlightInfo)element$iv$iv3;
            boolean bl7 = false;
            HighlightInfoType highlightInfoType2 = it.type;
            Object object = highlightInfoType2 instanceof QodanaHighlightingInfoType ? (QodanaHighlightingInfoType)highlightInfoType2 : null;
            String inspectionId = object != null && (object = ((QodanaHighlightingInfoType)object).getSarifProblem()) != null ? ((SarifProblem)object).getInspectionId() : null;
            if (!(!CollectionsKt.contains((Iterable)enabledInspections, (Object)inspectionId) || CollectionsKt.contains((Iterable)notFixableInspection, (Object)inspectionId))) continue;
            destination$iv$iv3.add(element$iv$iv3);
        }
        List onlyQodanaNotFixedHighlights = (List)destination$iv$iv3;
        UpdateHighlightersUtil.setHighlightersToEditor((Project)this.myProject, (Document)this.editor.getDocument(), (int)0, (int)this.myFile.getTextLength(), (Collection)onlyQodanaNotFixedHighlights, (EditorColorsScheme)this.getColorsScheme(), (int)this.getId());
        this.passState.setInfosFromPass(onlyQodanaHighlights);
    }

    public static final /* synthetic */ Project access$getMyProject$p$s1464811777(QodanaReportHighlightingPass $this) {
        return $this.myProject;
    }

    public static final /* synthetic */ PsiFile access$getMyFile$p(QodanaReportHighlightingPass $this) {
        return $this.myFile;
    }

    public static final /* synthetic */ void access$putLocalRunData(QodanaReportHighlightingPass $this, long localIdeRunTimestamp) {
        $this.putLocalRunData(localIdeRunTimestamp);
    }

    public static final /* synthetic */ void access$putRevisionData(QodanaReportHighlightingPass $this, Set revisionIds) {
        $this.putRevisionData(revisionIds);
    }
}

