/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.extensions;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLElementGenerator;
import org.jetbrains.yaml.YAMLTokenTypes;
import org.jetbrains.yaml.YAMLUtil;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLSequence;
import org.jetbrains.yaml.psi.YAMLSequenceItem;
import org.jetbrains.yaml.psi.YAMLValue;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a:\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0000\u001a\"\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u000bH\u0000\u001a\u0016\u0010\u0011\u001a\u0004\u0018\u00010\u0001*\u00020\u00072\u0006\u0010\f\u001a\u00020\u000bH\u0000\u001a\u001e\u0010\u0012\u001a\u0004\u0018\u00010\u0001*\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0000\u001a\u0018\u0010\u0013\u001a\u0004\u0018\u00010\u0014*\u00020\u00072\b\u0010\u0015\u001a\u0004\u0018\u00010\u000bH\u0000\u001a\u0016\u0010\u0016\u001a\u0004\u0018\u00010\u0014*\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u000bH\u0000\u001a\u0014\u0010\u0017\u001a\u00020\u0018*\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0014H\u0000\u00a8\u0006\u001b"}, d2={"findMappingOrAdd", "Lorg/jetbrains/yaml/psi/YAMLKeyValue;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "elementGenerator", "Lorg/jetbrains/yaml/YAMLElementGenerator;", "mappingToSearch", "Lorg/jetbrains/yaml/psi/YAMLMapping;", "mappingName", "", "content", "getOrAddSequenceForMapping", "Lorg/jetbrains/yaml/psi/YAMLValue;", "mapping", "name", "createKeyValue", "createMappingWithContent", "createSequenceItem", "Lorg/jetbrains/yaml/psi/YAMLSequenceItem;", "data", "createSequenceItemRaw", "putSequenceItem", "", "Lorg/jetbrains/yaml/psi/YAMLSequence;", "itemToAdd", "intellij.qodana"})
public final class YamlKt {
    @Nullable
    public static final YAMLValue getOrAddSequenceForMapping(@NotNull YAMLElementGenerator elementGenerator, @NotNull YAMLMapping mapping, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)elementGenerator, (String)"elementGenerator");
        Intrinsics.checkNotNullParameter((Object)mapping, (String)"mapping");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (mapping.getKeyValueByKey(name) == null) {
            YAMLKeyValue yAMLKeyValue = elementGenerator.createYamlKeyValue(name, "_");
            Intrinsics.checkNotNullExpressionValue((Object)yAMLKeyValue, (String)"createYamlKeyValue(...)");
            YAMLKeyValue newNode = yAMLKeyValue;
            mapping.putKeyValue(newNode);
        }
        YAMLKeyValue yAMLKeyValue = mapping.getKeyValueByKey(name);
        if (yAMLKeyValue == null) {
            return null;
        }
        YAMLKeyValue node = yAMLKeyValue;
        if (node.getValue() == null || !(node.getValue() instanceof YAMLSequence)) {
            YAMLSequence yAMLSequence = elementGenerator.createEmptySequence();
            Intrinsics.checkNotNullExpressionValue((Object)yAMLSequence, (String)"createEmptySequence(...)");
            YAMLSequence emptySequence = yAMLSequence;
            node.setValue((YAMLValue)emptySequence);
        }
        return node.getValue();
    }

    public static final void putSequenceItem(@NotNull YAMLSequence $this$putSequenceItem, @NotNull YAMLSequenceItem itemToAdd) {
        Intrinsics.checkNotNullParameter((Object)$this$putSequenceItem, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)itemToAdd, (String)"itemToAdd");
        PsiElement lastChild = $this$putSequenceItem.getLastChild();
        if (lastChild != null && !Intrinsics.areEqual((Object)lastChild.getNode().getElementType(), (Object)YAMLTokenTypes.EOL)) {
            $this$putSequenceItem.getNode().addChild(YAMLElementGenerator.getInstance((Project)$this$putSequenceItem.getProject()).createEol().getNode());
        }
        PsiElement psiElement = lastChild;
        int indent = psiElement != null ? YAMLUtil.getIndentToThisElement((PsiElement)psiElement) : YAMLUtil.getIndentToThisElement((PsiElement)((PsiElement)$this$putSequenceItem)) + 2;
        $this$putSequenceItem.getNode().addChild(YAMLElementGenerator.getInstance((Project)$this$putSequenceItem.getProject()).createIndent(indent).getNode());
        $this$putSequenceItem.getNode().addChild(itemToAdd.getNode());
    }

    @Nullable
    public static final YAMLKeyValue findMappingOrAdd(@NotNull Project project, @NotNull PsiFile file, @NotNull YAMLElementGenerator elementGenerator, @NotNull YAMLMapping mappingToSearch, @NotNull String mappingName, @NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)elementGenerator, (String)"elementGenerator");
        Intrinsics.checkNotNullParameter((Object)mappingToSearch, (String)"mappingToSearch");
        Intrinsics.checkNotNullParameter((Object)mappingName, (String)"mappingName");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        YAMLKeyValue mapping = mappingToSearch.getKeyValueByKey(mappingName);
        if (mapping == null) {
            YAMLKeyValue yAMLKeyValue = YamlKt.createKeyValue(elementGenerator, content);
            if (yAMLKeyValue == null) {
                return null;
            }
            YAMLKeyValue toAdd2 = yAMLKeyValue;
            mappingToSearch.putKeyValue(toAdd2);
            CodeStyleManager.getInstance((Project)project).adjustLineIndent(file, mappingToSearch.getTextRange());
            return null;
        }
        return mappingToSearch.getKeyValueByKey(mappingName);
    }

    @Nullable
    public static final YAMLKeyValue createMappingWithContent(@NotNull YAMLElementGenerator $this$createMappingWithContent, @NotNull String name, @NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)$this$createMappingWithContent, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        String mappingText = name + ":\n" + StringsKt.replaceIndent((String)content, (String)"  ");
        return (YAMLKeyValue)PsiTreeUtil.findChildOfType((PsiElement)((PsiElement)$this$createMappingWithContent.createDummyYamlWithText(StringsKt.trimIndent((String)mappingText))), YAMLKeyValue.class);
    }

    @Nullable
    public static final YAMLKeyValue createKeyValue(@NotNull YAMLElementGenerator $this$createKeyValue, @NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)$this$createKeyValue, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        return (YAMLKeyValue)PsiTreeUtil.findChildOfType((PsiElement)((PsiElement)$this$createKeyValue.createDummyYamlWithText(content)), YAMLKeyValue.class);
    }

    @Nullable
    public static final YAMLSequenceItem createSequenceItem(@NotNull YAMLElementGenerator $this$createSequenceItem, @Nullable String data2) {
        Intrinsics.checkNotNullParameter((Object)$this$createSequenceItem, (String)"<this>");
        return (YAMLSequenceItem)PsiTreeUtil.findChildOfType((PsiElement)((PsiElement)$this$createSequenceItem.createDummyYamlWithText("- " + data2)), YAMLSequenceItem.class);
    }

    @Nullable
    public static final YAMLSequenceItem createSequenceItemRaw(@NotNull YAMLElementGenerator $this$createSequenceItemRaw, @NotNull String data2) {
        Intrinsics.checkNotNullParameter((Object)$this$createSequenceItemRaw, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        return (YAMLSequenceItem)PsiTreeUtil.findChildOfType((PsiElement)((PsiElement)$this$createSequenceItemRaw.createDummyYamlWithText(data2)), YAMLSequenceItem.class);
    }
}

