/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.ttf;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fontbox.ttf.KerningSubtable;
import org.apache.fontbox.ttf.TTFDataStream;
import org.apache.fontbox.ttf.TTFTable;
import org.apache.fontbox.ttf.TrueTypeFont;

public class KerningTable
extends TTFTable {
    private static final Log LOG = LogFactory.getLog(KerningTable.class);
    public static final String TAG = "kern";
    private KerningSubtable[] subtables;

    KerningTable(TrueTypeFont font) {
        super(font);
    }

    @Override
    void read(TrueTypeFont ttf, TTFDataStream data2) throws IOException {
        int version = data2.readUnsignedShort();
        if (version != 0) {
            version = version << 16 | data2.readUnsignedShort();
        }
        int numSubtables = 0;
        if (version == 0) {
            numSubtables = data2.readUnsignedShort();
        } else if (version == 1) {
            numSubtables = (int)data2.readUnsignedInt();
        } else {
            LOG.debug((Object)("Skipped kerning table due to an unsupported kerning table version: " + version));
        }
        if (numSubtables > 0) {
            this.subtables = new KerningSubtable[numSubtables];
            for (int i = 0; i < numSubtables; ++i) {
                KerningSubtable subtable = new KerningSubtable();
                subtable.read(data2, version);
                this.subtables[i] = subtable;
            }
        }
        this.initialized = true;
    }

    public KerningSubtable getHorizontalKerningSubtable() {
        return this.getHorizontalKerningSubtable(false);
    }

    public KerningSubtable getHorizontalKerningSubtable(boolean cross) {
        if (this.subtables != null) {
            for (KerningSubtable s : this.subtables) {
                if (!s.isHorizontalKerning(cross)) continue;
                return s;
            }
        }
        return null;
    }
}

