/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.formatter.internal;

import com.vladsch.flexmark.formatter.MergeContext;
import com.vladsch.flexmark.formatter.MergeContextConsumer;
import com.vladsch.flexmark.formatter.TranslationContext;
import com.vladsch.flexmark.formatter.TranslationHandler;
import com.vladsch.flexmark.util.ast.Document;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MergeContextImpl
implements MergeContext {
    private Document[] myDocuments;
    private TranslationHandler[] myTranslationHandlers;
    private final HashMap<TranslationContext, Document> myTranslationHandlerDocumentMap;

    public MergeContextImpl(Document[] documents, TranslationHandler[] translationHandlers) {
        assert (documents.length == translationHandlers.length);
        this.myDocuments = documents;
        this.myTranslationHandlers = translationHandlers;
        this.myTranslationHandlerDocumentMap = new HashMap();
        this.updateDocumentMap();
        for (TranslationHandler handler : this.myTranslationHandlers) {
            handler.setMergeContext(this);
        }
    }

    private void updateDocumentMap() {
        int iMax = this.myDocuments.length;
        for (int i = 0; i < iMax; ++i) {
            this.myTranslationHandlerDocumentMap.put(this.myTranslationHandlers[i], this.myDocuments[i]);
        }
    }

    public Document[] getDocuments() {
        return this.myDocuments;
    }

    public void setDocuments(Document[] documents) {
        assert (documents.length == this.myTranslationHandlers.length);
        this.myDocuments = documents;
        this.updateDocumentMap();
    }

    public TranslationHandler[] getTranslationHandlers() {
        return this.myTranslationHandlers;
    }

    @Override
    @NotNull
    public Document getDocument(@NotNull TranslationContext context) {
        return this.myTranslationHandlerDocumentMap.get(context);
    }

    @Override
    public void forEachPrecedingDocument(@Nullable Document document2, @NotNull MergeContextConsumer consumer) {
        int iMax = this.myDocuments.length;
        for (int i = 0; i < iMax && this.myDocuments[i] != document2; ++i) {
            consumer.accept(this.myTranslationHandlers[i], this.myDocuments[i], i);
        }
    }
}

