/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.enumerated.reference.internal;

import com.vladsch.flexmark.ast.Heading;
import com.vladsch.flexmark.ext.attributes.AttributeNode;
import com.vladsch.flexmark.ext.attributes.AttributesNode;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedReferenceExtension;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedReferenceRepository;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedReferenceText;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedReferences;
import com.vladsch.flexmark.html.renderer.HeaderIdGenerator;
import com.vladsch.flexmark.html.renderer.HtmlIdGenerator;
import com.vladsch.flexmark.parser.block.NodePostProcessor;
import com.vladsch.flexmark.parser.block.NodePostProcessorFactory;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.ast.NodeTracker;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import org.jetbrains.annotations.NotNull;

public class EnumeratedReferenceNodePostProcessor
extends NodePostProcessor {
    private final EnumeratedReferences enumeratedReferences;
    private final HtmlIdGenerator headerIdGenerator;

    public EnumeratedReferenceNodePostProcessor(Document document2) {
        this.enumeratedReferences = EnumeratedReferenceExtension.ENUMERATED_REFERENCE_ORDINALS.get(document2);
        this.headerIdGenerator = new HeaderIdGenerator.Factory().create();
        this.headerIdGenerator.generateIds(document2);
    }

    @Override
    public void process(@NotNull NodeTracker state, @NotNull Node node) {
        block2: {
            block3: {
                if (!(node instanceof AttributesNode)) break block3;
                AttributesNode attributesNode = (AttributesNode)node;
                for (Node attributeNode : attributesNode.getChildren()) {
                    if (!(attributeNode instanceof AttributeNode) || !((AttributeNode)attributeNode).isId()) continue;
                    String text2 = ((AttributeNode)attributeNode).getValue().toString();
                    this.enumeratedReferences.add(text2);
                    break block2;
                }
                break block2;
            }
            if (!(node instanceof Heading)) break block2;
            for (Node child : node.getChildren()) {
                BasedSequence text3;
                String type;
                if (!(child instanceof EnumeratedReferenceText) || !(type = EnumeratedReferenceRepository.getType((text3 = ((EnumeratedReferenceText)child).getText()).toString())).isEmpty() && !text3.equals(type + ":")) continue;
                String id = (Comparable)((Object)(type.isEmpty() ? text3 : type)) + ":" + this.headerIdGenerator.getId(node);
                this.enumeratedReferences.add(id);
            }
        }
    }

    public static class Factory
    extends NodePostProcessorFactory {
        public Factory() {
            super(false);
            this.addNodes(AttributesNode.class, Heading.class);
        }

        @Override
        @NotNull
        public NodePostProcessor apply(@NotNull Document document2) {
            return new EnumeratedReferenceNodePostProcessor(document2);
        }
    }
}

