/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.pdfboxout;

import com.openhtmltopdf.extend.NamespaceHandler;
import com.openhtmltopdf.extend.ReplacedElement;
import com.openhtmltopdf.layout.SharedContext;
import com.openhtmltopdf.pdfboxout.PdfBoxFastLinkManager;
import com.openhtmltopdf.pdfboxout.PdfBoxOutputDevice;
import com.openhtmltopdf.pdfboxout.PdfContentStreamAdapter;
import com.openhtmltopdf.render.BlockBox;
import com.openhtmltopdf.render.Box;
import com.openhtmltopdf.render.PageBox;
import com.openhtmltopdf.render.RenderingContext;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.interactive.action.PDAction;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionGoTo;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionJavaScript;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionURI;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationLink;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDBorderStyleDictionary;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDPageXYZDestination;
import org.w3c.dom.Element;

@Deprecated
public class PdfBoxLinkManager {
    private final Map<PDPage, Set<String>> _linkTargetAreas;
    private final SharedContext _sharedContext;
    private final float _dotsPerPoint;
    private final Box _root;
    private final PdfBoxOutputDevice _od;
    private final List<LinkDetails> _links;

    public PdfBoxLinkManager(SharedContext ctx2, float dotsPerPoint, Box root2, PdfBoxOutputDevice od) {
        this._sharedContext = ctx2;
        this._dotsPerPoint = dotsPerPoint;
        this._root = root2;
        this._od = od;
        this._linkTargetAreas = new HashMap<PDPage, Set<String>>();
        this._links = new ArrayList<LinkDetails>();
    }

    private Rectangle2D calcTotalLinkArea(RenderingContext c, Box box, float pageHeight, AffineTransform transform2) {
        Box prev;
        Box current = box;
        while ((prev = current.getPreviousSibling()) != null && prev.getElement() == box.getElement()) {
            current = prev;
        }
        Rectangle2D result2 = PdfBoxLinkManager.createTargetArea(c, current, pageHeight, transform2, this._root, this._od);
        for (current = current.getNextSibling(); current != null && current.getElement() == box.getElement(); current = current.getNextSibling()) {
            result2 = this.add(result2, PdfBoxLinkManager.createTargetArea(c, current, pageHeight, transform2, this._root, this._od));
        }
        return result2;
    }

    private Rectangle2D add(Rectangle2D r1, Rectangle2D r2) {
        return r1.createUnion(r2);
    }

    private String createRectKey(Rectangle2D rect, Shape linkShape, AffineTransform transform2) {
        StringBuilder key = new StringBuilder(rect.getMinX() + ":" + rect.getMaxY() + ":" + rect.getMaxX() + ":" + rect.getMinY());
        if (linkShape != null) {
            PathIterator pathIterator = linkShape.getPathIterator(transform2);
            double[] vals = new double[6];
            while (!pathIterator.isDone()) {
                int type = pathIterator.currentSegment(vals);
                switch (type) {
                    case 3: {
                        key.append("C");
                        key.append(vals[0]).append(":").append(vals[1]).append(":").append(vals[2]).append(":").append(vals[3]).append(":").append(vals[4]).append(":").append(vals[5]);
                        break;
                    }
                    case 1: {
                        key.append("L");
                        key.append(vals[0]).append(":").append(vals[1]).append(":");
                        break;
                    }
                    case 0: {
                        key.append("M");
                        key.append(vals[0]).append(":").append(vals[1]).append(":");
                        break;
                    }
                    case 2: {
                        key.append("Q");
                        key.append(vals[0]).append(":").append(vals[1]).append(":").append(vals[2]).append(":").append(vals[3]);
                        break;
                    }
                    case 4: {
                        key.append("cp");
                        break;
                    }
                }
                pathIterator.next();
            }
        }
        return key.toString();
    }

    private Rectangle2D checkLinkArea(PDPage page, RenderingContext c, Box box, float pageHeight, AffineTransform transform2, Shape linkShape) {
        Rectangle2D targetArea = this.calcTotalLinkArea(c, box, pageHeight, transform2);
        String key = this.createRectKey(targetArea, linkShape, transform2);
        Set<String> keys = this._linkTargetAreas.get(page);
        if (keys == null) {
            keys = new HashSet<String>();
            this._linkTargetAreas.put(page, keys);
        }
        if (keys.contains(key)) {
            return null;
        }
        keys.add(key);
        return targetArea;
    }

    private void processLink(RenderingContext c, Box box, PDPage page, float pageHeight, AffineTransform transform2) {
        Map<Shape, String> linkMap;
        ReplacedElement element2;
        NamespaceHandler handler;
        String uri;
        Element elem = box.getElement();
        if (elem != null && (uri = (handler = this._sharedContext.getNamespaceHandler()).getLinkUri(elem)) != null) {
            this.addUriAsLink(c, box, page, pageHeight, transform2, elem, handler, uri, null);
        }
        if (box instanceof BlockBox && (element2 = ((BlockBox)box).getReplacedElement()) instanceof IPdfBoxElementWithShapedLinks && (linkMap = ((IPdfBoxElementWithShapedLinks)((Object)element2)).getLinkMap()) != null) {
            for (Map.Entry<Shape, String> shapeStringEntry : linkMap.entrySet()) {
                Shape shape = shapeStringEntry.getKey();
                String shapeUri = shapeStringEntry.getValue();
                NamespaceHandler handler2 = this._sharedContext.getNamespaceHandler();
                this.addUriAsLink(c, box, page, pageHeight, transform2, elem, handler2, shapeUri, shape);
            }
        }
    }

    private static boolean isPointEqual(Point2D.Float p1, Point2D.Float p2) {
        double epsilon = 1.0E-6;
        return (double)Math.abs(p1.x - p2.x) < 1.0E-6 && (double)Math.abs(p1.y - p2.y) < 1.0E-6;
    }

    private static void removeDoublicatePoints(List<Point2D.Float> points) {
        boolean rerun;
        do {
            Point2D.Float p2;
            Point2D.Float p1;
            int i;
            rerun = false;
            for (i = 0; i < points.size() - 1; ++i) {
                p1 = points.get(i);
                if (!PdfBoxLinkManager.isPointEqual(p1, p2 = points.get(i + 1))) continue;
                points.remove(i);
                rerun = true;
            }
            for (i = 0; i < points.size() - 2; ++i) {
                p1 = points.get(i);
                if (!PdfBoxLinkManager.isPointEqual(p1, p2 = points.get(i + 2))) continue;
                points.remove(i);
                rerun = true;
            }
        } while (rerun);
    }

    private void addUriAsLink(RenderingContext c, Box box, PDPage page, float pageHeight, AffineTransform transform2, Element elem, NamespaceHandler handler, String uri, Shape linkShape) {
        if (uri.length() > 1 && uri.charAt(0) == '#') {
            String anchor = uri.substring(1);
            Box target = this._sharedContext.getBoxById(anchor);
            if (target != null) {
                PDAction action;
                PDPageXYZDestination dest = this.createDestination(c, target);
                if (handler.getAttributeValue(elem, "onclick") != null && !"".equals(handler.getAttributeValue(elem, "onclick"))) {
                    action = new PDActionJavaScript(handler.getAttributeValue(elem, "onclick"));
                } else {
                    PDActionGoTo go = new PDActionGoTo();
                    go.setDestination(dest);
                    action = go;
                }
                Rectangle2D targetArea = this.checkLinkArea(page, c, box, pageHeight, transform2, linkShape);
                if (targetArea == null) {
                    return;
                }
                PDAnnotationLink annot = new PDAnnotationLink();
                annot.setAction(action);
                if (!this.placeAnnotation(transform2, linkShape, targetArea, annot)) {
                    return;
                }
                this.addLinkToPage(page, annot);
            }
        } else if (uri.contains("://")) {
            PDActionURI uriAct = new PDActionURI();
            uriAct.setURI(uri);
            Rectangle2D targetArea = this.checkLinkArea(page, c, box, pageHeight, transform2, linkShape);
            if (targetArea == null) {
                return;
            }
            PDAnnotationLink annot = new PDAnnotationLink();
            annot.setAction(uriAct);
            if (!this.placeAnnotation(transform2, linkShape, targetArea, annot)) {
                return;
            }
            this.addLinkToPage(page, annot);
        }
    }

    private boolean placeAnnotation(AffineTransform transform2, Shape linkShape, Rectangle2D targetArea, PDAnnotationLink annot) {
        annot.setRectangle(new PDRectangle((float)targetArea.getMinX(), (float)targetArea.getMinY(), (float)targetArea.getWidth(), (float)targetArea.getHeight()));
        if (linkShape != null) {
            PdfBoxFastLinkManager.QuadPointShape quadPointsResult = PdfBoxFastLinkManager.mapShapeToQuadPoints(transform2, linkShape, targetArea);
            if (quadPointsResult.quadPoints.length == 0) {
                return false;
            }
            annot.setQuadPoints(quadPointsResult.quadPoints);
            Rectangle2D reducedTarget = quadPointsResult.boundingBox;
            annot.setRectangle(new PDRectangle((float)reducedTarget.getMinX(), (float)reducedTarget.getMinY(), (float)reducedTarget.getWidth(), (float)reducedTarget.getHeight()));
        }
        return true;
    }

    private void addLinkToPage(PDPage page, PDAnnotationLink annot) {
        PDBorderStyleDictionary styleDict = new PDBorderStyleDictionary();
        styleDict.setWidth(0.0f);
        styleDict.setStyle("S");
        annot.setBorderStyle(styleDict);
        try {
            List<PDAnnotation> annots = page.getAnnotations();
            if (annots == null) {
                annots = new ArrayList<PDAnnotation>();
                page.setAnnotations(annots);
            }
            annots.add(annot);
        }
        catch (IOException e) {
            throw new PdfContentStreamAdapter.PdfException("processLink", e);
        }
    }

    private PDPageXYZDestination createDestination(RenderingContext c, Box box) {
        PDPageXYZDestination result2 = new PDPageXYZDestination();
        PageBox page = this._root.getLayer().getPage(c, this._od.getPageRefY(box));
        int distanceFromTop = page.getMarginBorderPadding(c, 3);
        distanceFromTop = (int)((float)distanceFromTop + ((float)box.getAbsY() + box.getMargin(c).top() - (float)page.getTop()));
        result2.setTop((int)((float)page.getHeight(c) / this._dotsPerPoint - (float)distanceFromTop / this._dotsPerPoint));
        result2.setPage(this._od.getWriter().getPage(this._od.getStartPageNo() + page.getPageNo()));
        return result2;
    }

    public static Rectangle2D createTargetArea(RenderingContext c, Box box, float pageHeight, AffineTransform transform2, Box _root, PdfBoxOutputDevice _od) {
        Rectangle bounds = box.getContentAreaEdge(box.getAbsX(), box.getAbsY(), c);
        Point2D.Float pt = new Point2D.Float(bounds.x, (float)bounds.getMaxY());
        Point2D ptTransformed = transform2.transform(pt, null);
        return new Rectangle2D.Float((float)ptTransformed.getX(), _od.normalizeY((float)ptTransformed.getY(), pageHeight), _od.getDeviceLength(bounds.width), _od.getDeviceLength(bounds.height));
    }

    public void processLinkLater(RenderingContext c, Box box, PDPage page, float pageHeight, AffineTransform transform2) {
        if (box instanceof BlockBox && ((BlockBox)box).getReplacedElement() != null || box.getElement() != null && box.getElement().getNodeName().equals("a")) {
            LinkDetails link2 = new LinkDetails();
            link2.c = c;
            link2.box = box;
            link2.page = page;
            link2.pageHeight = pageHeight;
            link2.transform = (AffineTransform)transform2.clone();
            this._links.add(link2);
        }
    }

    public void processLinks() {
        for (LinkDetails link2 : this._links) {
            this.processLink(link2.c, link2.box, link2.page, link2.pageHeight, link2.transform);
        }
    }

    public static class LinkDetails {
        RenderingContext c;
        Box box;
        PDPage page;
        float pageHeight;
        AffineTransform transform;
    }

    public static interface IPdfBoxElementWithShapedLinks {
        public Map<Shape, String> getLinkMap();
    }
}

