/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.css.parser.property;

import com.openhtmltopdf.css.constants.CSSName;
import com.openhtmltopdf.css.constants.IdentValue;
import com.openhtmltopdf.css.parser.CSSParseException;
import com.openhtmltopdf.css.parser.PropertyValue;
import com.openhtmltopdf.css.parser.property.AbstractPropertyBuilder;
import com.openhtmltopdf.css.sheet.PropertyDeclaration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class QuotesPropertyBuilder
extends AbstractPropertyBuilder {
    @Override
    public List<PropertyDeclaration> buildDeclarations(CSSName cssName, List<PropertyValue> values, int origin, boolean important, boolean inheritAllowed) {
        if (values.size() == 1) {
            IdentValue ident;
            PropertyValue value2 = values.get(0);
            if (value2.getCssValueType() == 0) {
                return Collections.emptyList();
            }
            if (value2.getPrimitiveType() == 21 && (ident = this.checkIdent(CSSName.QUOTES, value2)) == IdentValue.NONE) {
                return Collections.singletonList(new PropertyDeclaration(CSSName.QUOTES, value2, important, origin));
            }
        }
        if (values.size() % 2 == 1) {
            throw new CSSParseException("Mismatched quotes " + values, -1);
        }
        ArrayList<PropertyValue> resultValues = new ArrayList<PropertyValue>();
        for (PropertyValue value3 : values) {
            if (value3.getOperator() != null) {
                throw new CSSParseException("Found unexpected operator, " + value3.getOperator().getExternalName(), -1);
            }
            short type = value3.getPrimitiveType();
            if (type == 19) {
                resultValues.add(value3);
                continue;
            }
            if (type == 20) {
                throw new CSSParseException("URI is not allowed here", -1);
            }
            if (value3.getPropertyValueType() == 7) {
                throw new CSSParseException("Function " + value3.getFunction().getName() + " is not allowed here", -1);
            }
            if (type == 21) {
                throw new CSSParseException("Identifier is not a valid value for the quotes property", -1);
            }
            throw new CSSParseException(value3.getCssText() + " is not a value value for the quotes property", -1);
        }
        if (resultValues.size() > 0) {
            return Collections.singletonList(new PropertyDeclaration(CSSName.QUOTES, new PropertyValue(resultValues), important, origin));
        }
        return Collections.emptyList();
    }
}

