/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.css.parser.property;

import com.openhtmltopdf.css.constants.CSSName;
import com.openhtmltopdf.css.constants.IdentValue;
import com.openhtmltopdf.css.parser.CSSParseException;
import com.openhtmltopdf.css.parser.CSSPrimitiveValue;
import com.openhtmltopdf.css.parser.FSFunction;
import com.openhtmltopdf.css.parser.FSRGBColor;
import com.openhtmltopdf.css.parser.PropertyValue;
import com.openhtmltopdf.css.parser.Token;
import com.openhtmltopdf.css.parser.property.AbstractPropertyBuilder;
import com.openhtmltopdf.css.parser.property.Conversions;
import com.openhtmltopdf.css.parser.property.PropertyBuilder;
import com.openhtmltopdf.css.sheet.PropertyDeclaration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class PrimitivePropertyBuilders {
    public static final BitSet BORDER_STYLES = PrimitivePropertyBuilders.setFor(IdentValue.NONE, IdentValue.HIDDEN, IdentValue.DOTTED, IdentValue.DASHED, IdentValue.SOLID, IdentValue.DOUBLE, IdentValue.GROOVE, IdentValue.RIDGE, IdentValue.INSET, IdentValue.OUTSET);
    public static final BitSet BORDER_WIDTHS = PrimitivePropertyBuilders.setFor(IdentValue.THIN, IdentValue.MEDIUM, IdentValue.THICK);
    public static final BitSet DIRECTIONS = PrimitivePropertyBuilders.setFor(IdentValue.LTR, IdentValue.RTL, IdentValue.AUTO);
    public static final BitSet FONT_VARIANTS = PrimitivePropertyBuilders.setFor(IdentValue.NORMAL, IdentValue.SMALL_CAPS);
    public static final BitSet FONT_SUBSETS = PrimitivePropertyBuilders.setFor(IdentValue.SUBSET, IdentValue.COMPLETE_FONT);
    public static final BitSet CHECKBOX_STYLES = PrimitivePropertyBuilders.setFor(IdentValue.SQUARE, IdentValue.CIRCLE, IdentValue.DIAMOND, IdentValue.CHECK, IdentValue.CROSS, IdentValue.STAR);
    public static final BitSet FONT_STYLES = PrimitivePropertyBuilders.setFor(IdentValue.NORMAL, IdentValue.ITALIC, IdentValue.OBLIQUE);
    public static final BitSet FONT_WEIGHTS = PrimitivePropertyBuilders.setFor(IdentValue.NORMAL, IdentValue.BOLD, IdentValue.BOLDER, IdentValue.LIGHTER);
    public static final BitSet PAGE_ORIENTATIONS = PrimitivePropertyBuilders.setFor(IdentValue.AUTO, IdentValue.PORTRAIT, IdentValue.LANDSCAPE);
    public static final BitSet LIST_STYLE_POSITIONS = PrimitivePropertyBuilders.setFor(IdentValue.INSIDE, IdentValue.OUTSIDE);
    public static final BitSet LIST_STYLE_TYPES = PrimitivePropertyBuilders.setFor(IdentValue.DISC, IdentValue.CIRCLE, IdentValue.SQUARE, IdentValue.DECIMAL, IdentValue.DECIMAL_LEADING_ZERO, IdentValue.LOWER_ROMAN, IdentValue.UPPER_ROMAN, IdentValue.LOWER_GREEK, IdentValue.LOWER_LATIN, IdentValue.UPPER_LATIN, IdentValue.ARMENIAN, IdentValue.GEORGIAN, IdentValue.LOWER_ALPHA, IdentValue.UPPER_ALPHA, IdentValue.NONE);
    public static final BitSet BACKGROUND_REPEATS = PrimitivePropertyBuilders.setFor(IdentValue.REPEAT, IdentValue.REPEAT_X, IdentValue.REPEAT_Y, IdentValue.NO_REPEAT);
    public static final BitSet BACKGROUND_ATTACHMENTS = PrimitivePropertyBuilders.setFor(IdentValue.SCROLL);
    public static final BitSet BACKGROUND_POSITIONS = PrimitivePropertyBuilders.setFor(IdentValue.LEFT, IdentValue.RIGHT, IdentValue.TOP, IdentValue.BOTTOM, IdentValue.CENTER);
    public static final BitSet ABSOLUTE_FONT_SIZES = PrimitivePropertyBuilders.setFor(IdentValue.XX_SMALL, IdentValue.X_SMALL, IdentValue.SMALL, IdentValue.MEDIUM, IdentValue.LARGE, IdentValue.X_LARGE, IdentValue.XX_LARGE);
    public static final BitSet RELATIVE_FONT_SIZES = PrimitivePropertyBuilders.setFor(IdentValue.SMALLER, IdentValue.LARGER);
    public static final PropertyBuilder COLOR = new GenericColor();
    public static final PropertyBuilder BORDER_STYLE = new GenericBorderStyle();
    public static final PropertyBuilder BORDER_WIDTH = new GenericBorderWidth();
    public static final PropertyBuilder BORDER_RADIUS = new NonNegativeLengthLike();
    public static final PropertyBuilder MARGIN = new LengthLikeWithAuto();
    public static final PropertyBuilder PADDING = new NonNegativeLengthLike();

    static BitSet setFor(IdentValue ... values) {
        BitSet result2 = new BitSet(IdentValue.getIdentCount());
        for (int i = 0; i < values.length; ++i) {
            IdentValue ident = values[i];
            result2.set(ident.FS_ID);
        }
        return result2;
    }

    static List<PropertyDeclaration> createTwoValueResponse(CSSName cssName, PropertyValue value1, PropertyValue value2, int origin, boolean important) {
        ArrayList<PropertyValue> values = new ArrayList<PropertyValue>(2);
        values.add(value1);
        values.add(value2);
        PropertyDeclaration result2 = new PropertyDeclaration(cssName, new PropertyValue(values), important, origin);
        return Collections.singletonList(result2);
    }

    public static class FSOverflowPagesDirection
    extends SingleIdent {
        private static final BitSet ALLOWED = PrimitivePropertyBuilders.setFor(IdentValue.LTR, IdentValue.RTL);

        @Override
        protected BitSet getAllowed() {
            return ALLOWED;
        }
    }

    public static class FSMaxOverflowPages
    extends PlainInteger {
        @Override
        protected boolean isNegativeValuesAllowed() {
            return false;
        }
    }

    public static class BoxSizing
    extends SingleIdent {
        private static final BitSet ALLOWED = PrimitivePropertyBuilders.setFor(IdentValue.BORDER_BOX, IdentValue.CONTENT_BOX);

        @Override
        protected BitSet getAllowed() {
            return ALLOWED;
        }
    }

    public static class ImageRenderingBuilder
    extends SingleIdent {
        private static final BitSet ALLOWED = PrimitivePropertyBuilders.setFor(IdentValue.AUTO, IdentValue.PIXELATED, IdentValue.CRISP_EDGES);

        @Override
        protected BitSet getAllowed() {
            return ALLOWED;
        }
    }

    public static class TransformOriginPropertyBuilder
    extends AbstractPropertyBuilder {
        @Override
        public List<PropertyDeclaration> buildDeclarations(CSSName cssName, List<PropertyValue> values, int origin, boolean important, boolean inheritAllowed) {
            this.checkValueCount(cssName, 2, 3, values.size());
            PropertyValue x = values.get(0);
            PropertyValue y = values.get(1);
            return Arrays.asList(new TransformOriginX().buildDeclarations(CSSName.FS_TRANSFORM_ORIGIN_X, Collections.singletonList(x), origin, important).get(0), new TransformOriginY().buildDeclarations(CSSName.FS_TRANSFORM_ORIGIN_Y, Collections.singletonList(y), origin, important).get(0));
        }
    }

    public static class TransformOriginY
    extends AbstractPropertyBuilder {
        private static final BitSet ALLOWED = PrimitivePropertyBuilders.setFor(IdentValue.TOP, IdentValue.CENTER, IdentValue.BOTTOM);

        @Override
        public List<PropertyDeclaration> buildDeclarations(CSSName cssName, List<PropertyValue> values, int origin, boolean important, boolean inheritAllowed) {
            this.checkValueCount(cssName, 1, values.size());
            CSSPrimitiveValue value2 = values.get(0);
            this.checkInheritAllowed(value2, inheritAllowed);
            if (value2.getCssValueType() == 0) {
                return Collections.singletonList(new PropertyDeclaration(cssName, value2, important, origin));
            }
            if (value2.getPrimitiveType() == 21) {
                IdentValue ident = this.checkIdent(cssName, value2);
                this.checkValidity(cssName, ALLOWED, ident);
                if (ident == IdentValue.TOP) {
                    return Collections.singletonList(new PropertyDeclaration(cssName, new PropertyValue(2, 0.0f, "0%"), important, origin));
                }
                if (ident == IdentValue.CENTER) {
                    return Collections.singletonList(new PropertyDeclaration(cssName, new PropertyValue(2, 50.0f, "50%"), important, origin));
                }
                return Collections.singletonList(new PropertyDeclaration(cssName, new PropertyValue(2, 100.0f, "100%"), important, origin));
            }
            this.checkLengthOrPercentType(cssName, value2);
            return Collections.singletonList(new PropertyDeclaration(cssName, value2, important, origin));
        }
    }

    public static class TransformOriginX
    extends AbstractPropertyBuilder {
        private static final BitSet ALLOWED = PrimitivePropertyBuilders.setFor(IdentValue.LEFT, IdentValue.CENTER, IdentValue.RIGHT);

        @Override
        public List<PropertyDeclaration> buildDeclarations(CSSName cssName, List<PropertyValue> values, int origin, boolean important, boolean inheritAllowed) {
            this.checkValueCount(cssName, 1, values.size());
            CSSPrimitiveValue value2 = values.get(0);
            this.checkInheritAllowed(value2, inheritAllowed);
            if (value2.getCssValueType() == 0) {
                return Collections.singletonList(new PropertyDeclaration(cssName, value2, important, origin));
            }
            if (value2.getPrimitiveType() == 21) {
                IdentValue ident = this.checkIdent(cssName, value2);
                this.checkValidity(cssName, ALLOWED, ident);
                if (ident == IdentValue.LEFT) {
                    return Collections.singletonList(new PropertyDeclaration(cssName, new PropertyValue(2, 0.0f, "0%"), important, origin));
                }
                if (ident == IdentValue.CENTER) {
                    return Collections.singletonList(new PropertyDeclaration(cssName, new PropertyValue(2, 50.0f, "50%"), important, origin));
                }
                return Collections.singletonList(new PropertyDeclaration(cssName, new PropertyValue(2, 100.0f, "100%"), important, origin));
            }
            this.checkLengthOrPercentType(cssName, value2);
            return Collections.singletonList(new PropertyDeclaration(cssName, value2, important, origin));
        }
    }

    public static class TransformPropertyBuilder
    extends AbstractPropertyBuilder {
        private static final BitSet ALLOWED = PrimitivePropertyBuilders.setFor(IdentValue.NONE);

        @Override
        public List<PropertyDeclaration> buildDeclarations(CSSName cssName, List<PropertyValue> values, int origin, boolean important, boolean inheritAllowed) {
            CSSPrimitiveValue value2;
            this.checkValueCount(cssName, 1, Integer.MAX_VALUE, values.size());
            this.checkInheritAllowed(values.get(0), inheritAllowed);
            if (values.get(0).getCssValueType() == 0) {
                return Collections.singletonList(new PropertyDeclaration(cssName, values.get(0), important, origin));
            }
            if (values.size() == 1 && (value2 = (CSSPrimitiveValue)values.get(0)).getPrimitiveType() == 21) {
                IdentValue ident = this.checkIdent(cssName, value2);
                this.checkValidity(cssName, ALLOWED, ident);
                return Collections.singletonList(new PropertyDeclaration(CSSName.TRANSFORM, value2, important, origin));
            }
            for (PropertyValue v : values) {
                PropertyValue value3 = v;
                if (value3.getPropertyValueType() != 7) {
                    throw new CSSParseException("One or more functions must be provided for transform property", -1);
                }
                String fName = value3.getFunction().getName();
                int expected = 0;
                if (fName.equalsIgnoreCase("matrix")) {
                    expected = 6;
                    for (PropertyValue p : value3.getFunction().getParameters()) {
                        this.checkNumberType(cssName, p);
                    }
                } else if (fName.equalsIgnoreCase("translate")) {
                    expected = 2;
                    for (PropertyValue p : value3.getFunction().getParameters()) {
                        this.checkLengthOrPercentType(cssName, p);
                    }
                } else if (fName.equalsIgnoreCase("translateX")) {
                    expected = 1;
                    for (PropertyValue p : value3.getFunction().getParameters()) {
                        this.checkLengthOrPercentType(cssName, p);
                    }
                } else if (fName.equalsIgnoreCase("translateY")) {
                    expected = 1;
                    for (PropertyValue p : value3.getFunction().getParameters()) {
                        this.checkLengthOrPercentType(cssName, p);
                    }
                } else if (fName.equalsIgnoreCase("scale")) {
                    expected = 2;
                    for (PropertyValue p : value3.getFunction().getParameters()) {
                        this.checkNumberType(cssName, p);
                    }
                    if (value3.getFunction().getParameters().size() == 1) {
                        expected = 1;
                    }
                } else if (fName.equalsIgnoreCase("scaleX")) {
                    expected = 1;
                    for (PropertyValue p : value3.getFunction().getParameters()) {
                        this.checkNumberType(cssName, p);
                    }
                } else if (fName.equalsIgnoreCase("scaleY")) {
                    expected = 1;
                    for (PropertyValue p : value3.getFunction().getParameters()) {
                        this.checkNumberType(cssName, p);
                    }
                } else if (fName.equalsIgnoreCase("skew")) {
                    expected = 2;
                    for (PropertyValue p : value3.getFunction().getParameters()) {
                        this.checkAngleType(cssName, p);
                    }
                    if (value3.getFunction().getParameters().size() == 1) {
                        expected = 1;
                    }
                } else if (fName.equalsIgnoreCase("skewX")) {
                    expected = 1;
                    for (PropertyValue p : value3.getFunction().getParameters()) {
                        this.checkAngleType(cssName, p);
                    }
                } else if (fName.equalsIgnoreCase("skewY")) {
                    expected = 1;
                    for (PropertyValue p : value3.getFunction().getParameters()) {
                        this.checkAngleType(cssName, p);
                    }
                } else if (fName.equalsIgnoreCase("rotate")) {
                    expected = 1;
                    for (PropertyValue p : value3.getFunction().getParameters()) {
                        this.checkAngleType(cssName, p);
                    }
                } else {
                    throw new CSSParseException("Unsupported function provided in transform property: " + fName, -1);
                }
                this.checkValueCount(cssName, expected, value3.getFunction().getParameters().size());
            }
            return Collections.singletonList(new PropertyDeclaration(CSSName.TRANSFORM, new PropertyValue(values), important, origin));
        }
    }

    public static class ColumnGap
    extends LengthLikeWithIdent {
        private static final BitSet ALLOWED = PrimitivePropertyBuilders.setFor(IdentValue.NORMAL);

        @Override
        protected BitSet getAllowed() {
            return ALLOWED;
        }
    }

    public static class ColumnCount
    extends AbstractPropertyBuilder {
        private static final BitSet ALLOWED = PrimitivePropertyBuilders.setFor(IdentValue.AUTO);

        @Override
        public List<PropertyDeclaration> buildDeclarations(CSSName cssName, List<PropertyValue> values, int origin, boolean important, boolean inheritAllowed) {
            this.checkValueCount(cssName, 1, values.size());
            CSSPrimitiveValue value2 = values.get(0);
            this.checkInheritAllowed(value2, inheritAllowed);
            if (value2.getCssValueType() != 0) {
                this.checkIdentOrIntegerType(cssName, value2);
                if (value2.getPrimitiveType() == 21) {
                    IdentValue ident = this.checkIdent(cssName, value2);
                    this.checkValidity(cssName, ALLOWED, ident);
                } else if (value2.getFloatValue((short)1) < 1.0f) {
                    throw new CSSParseException("column-count must be one or greater", -1);
                }
            }
            return Collections.singletonList(new PropertyDeclaration(cssName, value2, important, origin));
        }
    }

    public static class ZIndex
    extends AbstractPropertyBuilder {
        private static final BitSet ALLOWED = PrimitivePropertyBuilders.setFor(IdentValue.AUTO);

        @Override
        public List<PropertyDeclaration> buildDeclarations(CSSName cssName, List<PropertyValue> values, int origin, boolean important, boolean inheritAllowed) {
            this.checkValueCount(cssName, 1, values.size());
            CSSPrimitiveValue value2 = values.get(0);
            this.checkInheritAllowed(value2, inheritAllowed);
            if (value2.getCssValueType() != 0) {
                this.checkIdentOrIntegerType(cssName, value2);
                if (value2.getPrimitiveType() == 21) {
                    IdentValue ident = this.checkIdent(cssName, value2);
                    this.checkValidity(cssName, ALLOWED, ident);
                }
            }
            return Collections.singletonList(new PropertyDeclaration(cssName, value2, important, origin));
        }
    }

    public static class WordSpacing
    extends LengthWithNormal {
    }

    public static class Width
    extends LengthLikeWithAuto {
        @Override
        protected boolean isNegativeValuesAllowed() {
            return false;
        }
    }

    public static class Widows
    extends PlainInteger {
        @Override
        protected boolean isNegativeValuesAllowed() {
            return false;
        }
    }

    public static class WordWrap
    extends SingleIdent {
        private static final BitSet ALLOWED = PrimitivePropertyBuilders.setFor(IdentValue.NORMAL, IdentValue.BREAK_WORD);

        @Override
        protected BitSet getAllowed() {
            return ALLOWED;
        }
    }

    public static class WhiteSpace
    extends SingleIdent {
        private static final BitSet ALLOWED = PrimitivePropertyBuilders.setFor(IdentValue.NORMAL, IdentValue.PRE, IdentValue.NOWRAP, IdentValue.PRE_WRAP, IdentValue.PRE_LINE);

        @Override
        protected BitSet getAllowed() {
            return ALLOWED;
        }
    }

    public static class Visibility
    extends SingleIdent {
        private static final BitSet ALLOWED = PrimitivePropertyBuilders.setFor(IdentValue.VISIBLE, IdentValue.HIDDEN, IdentValue.COLLAPSE, IdentValue.FS_TABLE_PAGINATE_REPEATED_VISIBLE);

        @Override
        protected BitSet getAllowed() {
            return ALLOWED;
        }
    }

    public static class VerticalAlign
    extends LengthLikeWithIdent {
        private static final BitSet ALLOWED = PrimitivePropertyBuilders.setFor(IdentValue.BASELINE, IdentValue.SUB, IdentValue.SUPER, IdentValue.TOP, IdentValue.TEXT_TOP, IdentValue.MIDDLE, IdentValue.BOTTOM, IdentValue.TEXT_BOTTOM);

        @Override
        protected BitSet getAllowed() {
            return ALLOWED;
        }
    }

    public static class TextTransform
    extends SingleIdent {
        private static final BitSet ALLOWED = PrimitivePropertyBuilders.setFor(IdentValue.CAPITALIZE, IdentValue.UPPERCASE, IdentValue.LOWERCASE, IdentValue.NONE);

        @Override
        protected BitSet getAllowed() {
            return ALLOWED;
        }
    }

    public static class TextIndent
    extends LengthLike {
    }

    public static class TextDecoration
    extends AbstractPropertyBuilder {
        private static final BitSet ALLOWED = PrimitivePropertyBuilders.setFor(IdentValue.UNDERLINE, IdentValue.OVERLINE, IdentValue.LINE_THROUGH);

        private BitSet getAllowed() {
            return ALLOWED;
        }

        @Override
        public List<PropertyDeclaration> buildDeclarations(CSSName cssName, List<PropertyValue> values, int origin, boolean important, boolean inheritAllowed) {
            IdentValue ident;
            if (values.size() == 1) {
                CSSPrimitiveValue value2 = values.get(0);
                boolean goWithSingle = false;
                if (value2.getCssValueType() == 0) {
                    goWithSingle = true;
                } else {
                    this.checkIdentType(CSSName.TEXT_DECORATION, value2);
                    ident = this.checkIdent(cssName, value2);
                    if (ident == IdentValue.NONE) {
                        goWithSingle = true;
                    }
                }
                if (goWithSingle) {
                    return Collections.singletonList(new PropertyDeclaration(cssName, value2, important, origin));
                }
            }
            for (PropertyValue value3 : values) {
                this.checkInheritAllowed(value3, false);
                this.checkIdentType(cssName, value3);
                ident = this.checkIdent(cssName, value3);
                if (ident == IdentValue.NONE) {
                    throw new CSSParseException("Value none may not be used in this position", -1);
                }
                this.checkValidity(cssName, this.getAllowed(), ident);
            }
            return Collections.singletonList(new PropertyDeclaration(cssName, new PropertyValue(values), important, origin));
        }
    }

    public static class TextAlign
    extends SingleIdent {
        private static final BitSet ALLOWED = PrimitivePropertyBuilders.setFor(IdentValue.LEFT, IdentValue.RIGHT, IdentValue.CENTER, IdentValue.JUSTIFY, IdentValue.START);

        @Override
        protected BitSet getAllowed() {
            return ALLOWED;
        }
    }

    public static class TableLayout
    extends SingleIdent {
        private static final BitSet ALLOWED = PrimitivePropertyBuilders.setFor(IdentValue.AUTO, IdentValue.FIXED);

        @Override
        protected BitSet getAllowed() {
            return ALLOWED;
        }
    }

    public static class Top
    extends LengthLikeWithAuto {
    }

    public static class TabSize
    extends PlainInteger {
        @Override
        protected boolean isNegativeValuesAllowed() {
            return false;
        }
    }

    public static class Src
    extends GenericURIWithNone {
        @Override
        public List<PropertyDeclaration> buildDeclarations(CSSName cssName, List<PropertyValue> values, int origin, boolean important, boolean inheritAllowed) {
            if (values.size() == 1) {
                return super.buildDeclarations(cssName, values, origin, important, inheritAllowed);
            }
            for (int i = 0; i < values.size(); ++i) {
                PropertyValue next;
                PropertyValue value2 = values.get(i);
                PropertyValue propertyValue = next = i + 1 < values.size() ? values.get(i + 1) : null;
                if (value2.getPrimitiveType() != 20 || next == null || next.getPropertyValueType() != 7 || !"format".equals(next.getFunction().getName()) || next.getFunction().getParameters().size() < 1 || !"truetype".equals(next.getFunction().getParameters().get(0).getStringValue())) continue;
                return super.buildDeclarations(cssName, Collections.singletonList(value2), origin, important, inheritAllowed);
            }
            throw new CSSParseException("Could not find font src with format(truetype) in list (" + values.toString() + ") of fonts", -1);
        }
    }

    public static class Right
    extends LengthLikeWithAuto {
    }

    public static class Position
    extends AbstractPropertyBuilder {
        private static final BitSet ALLOWED = PrimitivePropertyBuilders.setFor(IdentValue.STATIC, IdentValue.RELATIVE, IdentValue.ABSOLUTE, IdentValue.FIXED);

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public List<PropertyDeclaration> buildDeclarations(CSSName cssName, List<PropertyValue> values, int origin, boolean important, boolean inheritAllowed) {
            this.checkValueCount(cssName, 1, values.size());
            PropertyValue value2 = values.get(0);
            this.checkInheritAllowed(value2, inheritAllowed);
            if (value2.getCssValueType() == 0) return Collections.singletonList(new PropertyDeclaration(cssName, value2, important, origin));
            if (value2.getPrimitiveType() == 21) {
                this.checkIdentType(cssName, value2);
                IdentValue ident = this.checkIdent(cssName, value2);
                this.checkValidity(cssName, this.getAllowed(), ident);
                return Collections.singletonList(new PropertyDeclaration(cssName, value2, important, origin));
            } else {
                if (value2.getPropertyValueType() != 7) throw new CSSParseException("Value for " + cssName + " must be an identifier or function", -1);
                FSFunction function = value2.getFunction();
                if (!function.getName().equals("running")) throw new CSSParseException("Only the running function is supported here", -1);
                List<PropertyValue> params = function.getParameters();
                if (params.size() != 1) throw new CSSParseException("The running function takes one parameter", -1);
                PropertyValue param = params.get(0);
                if (param.getPrimitiveType() == 21) return Collections.singletonList(new PropertyDeclaration(cssName, value2, important, origin));
                throw new CSSParseException("The running function takes an identifier as a parameter", -1);
            }
        }

        private BitSet getAllowed() {
            return ALLOWED;
        }
    }

    public static class PageBreakInside
    extends SingleIdent {
        private static final BitSet ALLOWED = PrimitivePropertyBuilders.setFor(IdentValue.AVOID, IdentValue.AUTO);

        @Override
        protected BitSet getAllowed() {
            return ALLOWED;
        }
    }

    public static class PageBreakAfter
    extends SingleIdent {
        private static final BitSet ALLOWED = PrimitivePropertyBuilders.setFor(IdentValue.AUTO, IdentValue.ALWAYS, IdentValue.AVOID, IdentValue.LEFT, IdentValue.RIGHT);

        @Override
        protected BitSet getAllowed() {
            return ALLOWED;
        }
    }

    public static class Page
    extends AbstractPropertyBuilder {
        @Override
        public List<PropertyDeclaration> buildDeclarations(CSSName cssName, List<PropertyValue> values, int origin, boolean important, boolean inheritAllowed) {
            this.checkValueCount(cssName, 1, values.size());
            CSSPrimitiveValue value2 = values.get(0);
            this.checkInheritAllowed(value2, inheritAllowed);
            if (value2.getCssValueType() != 0) {
                this.checkIdentType(cssName, value2);
                if (!value2.getStringValue().equals("auto")) {
                    value2 = new PropertyValue(19, value2.getStringValue(), value2.getCssText());
                }
            }
            return Collections.singletonList(new PropertyDeclaration(cssName, value2, important, origin));
        }
    }

    public static class BreakAfter
    extends SingleIdent {
        private static final BitSet ALLOWED = PrimitivePropertyBuilders.setFor(IdentValue.AUTO, IdentValue.COLUMN);

        @Override
        protected BitSet getAllowed() {
            return ALLOWED;
        }
    }

    public static class BreakBefore
    extends SingleIdent {
        private static final BitSet ALLOWED = PrimitivePropertyBuilders.setFor(IdentValue.AUTO, IdentValue.COLUMN);

        @Override
        protected BitSet getAllowed() {
            return ALLOWED;
        }
    }

    public static class PageBreakBefore
    extends SingleIdent {
        private static final BitSet ALLOWED = PrimitivePropertyBuilders.setFor(IdentValue.AUTO, IdentValue.ALWAYS, IdentValue.AVOID, IdentValue.LEFT, IdentValue.RIGHT);

        @Override
        protected BitSet getAllowed() {
            return ALLOWED;
        }
    }

    public static class PaddingLeft
    extends NonNegativeLengthLike {
    }

    public static class PaddingBottom
    extends NonNegativeLengthLike {
    }

    public static class PaddingRight
    extends NonNegativeLengthLike {
    }

    public static class PaddingTop
    extends NonNegativeLengthLike {
    }

    public static class Overflow
    extends SingleIdent {
        private static final BitSet ALLOWED = PrimitivePropertyBuilders.setFor(IdentValue.VISIBLE, IdentValue.HIDDEN);

        @Override
        protected BitSet getAllowed() {
            return ALLOWED;
        }
    }

    public static class Orphans
    extends PlainInteger {
        @Override
        protected boolean isNegativeValuesAllowed() {
            return false;
        }
    }

    public static class FSMaxJustificationInterChar
    extends NonNegativeLengthLike {
    }

    public static class FSMaxJustificationInterWord
    extends NonNegativeLengthLike {
    }

    public static class FSPageBreakMinHeight
    extends NonNegativeLengthLike {
    }

    public static class MinWidth
    extends NonNegativeLengthLike {
    }

    public static class MinHeight
    extends NonNegativeLengthLike {
    }

    public static class MaxWidth
    extends LengthLikeWithNone {
        @Override
        protected boolean isNegativeValuesAllowed() {
            return false;
        }
    }

    public static class MaxHeight
    extends LengthLikeWithNone {
        @Override
        protected boolean isNegativeValuesAllowed() {
            return false;
        }
    }

    public static class MarginLeft
    extends LengthLikeWithAuto {
    }

    public static class MarginBottom
    extends LengthLikeWithAuto {
    }

    public static class MarginRight
    extends LengthLikeWithAuto {
    }

    public static class MarginTop
    extends LengthLikeWithAuto {
    }

    public static class ListStyleType
    extends SingleIdent {
        @Override
        protected BitSet getAllowed() {
            return LIST_STYLE_TYPES;
        }
    }

    public static class ListStylePosition
    extends SingleIdent {
        @Override
        protected BitSet getAllowed() {
            return LIST_STYLE_POSITIONS;
        }
    }

    public static class ListStyleImage
    extends GenericURIWithNone {
    }

    public static class LineHeight
    extends AbstractPropertyBuilder {
        private static final BitSet ALLOWED = PrimitivePropertyBuilders.setFor(IdentValue.NORMAL);

        @Override
        public List<PropertyDeclaration> buildDeclarations(CSSName cssName, List<PropertyValue> values, int origin, boolean important, boolean inheritAllowed) {
            this.checkValueCount(cssName, 1, values.size());
            PropertyValue value2 = values.get(0);
            this.checkInheritAllowed(value2, inheritAllowed);
            if (value2.getCssValueType() != 0) {
                this.checkIdentLengthNumberOrPercentType(cssName, value2);
                if (value2.getPrimitiveType() == 21) {
                    IdentValue ident = this.checkIdent(cssName, value2);
                    this.checkValidity(cssName, ALLOWED, ident);
                } else if ((double)value2.getFloatValue() < 0.0) {
                    throw new CSSParseException("line-height may not be negative", -1);
                }
            }
            return Collections.singletonList(new PropertyDeclaration(cssName, value2, important, origin));
        }
    }

    public static class LetterSpacing
    extends LengthWithNormal {
    }

    public static class Left
    extends LengthLikeWithAuto {
    }

    public static class FSNamedDestination
    extends SingleIdent {
        private static final BitSet ALLOWED = PrimitivePropertyBuilders.setFor(IdentValue.NONE, IdentValue.CREATE);

        @Override
        protected BitSet getAllowed() {
            return ALLOWED;
        }
    }

    public static class FSKeepWithInline
    extends SingleIdent {
        private static final BitSet ALLOWED = PrimitivePropertyBuilders.setFor(IdentValue.AUTO, IdentValue.KEEP);

        @Override
        protected BitSet getAllowed() {
            return ALLOWED;
        }
    }

    public static class FSDynamicAutoWidth
    extends SingleIdent {
        private static final BitSet ALLOWED = PrimitivePropertyBuilders.setFor(IdentValue.DYNAMIC, IdentValue.STATIC);

        @Override
        protected BitSet getAllowed() {
            return ALLOWED;
        }
    }

    public static class Height
    extends LengthLikeWithAuto {
        @Override
        protected boolean isNegativeValuesAllowed() {
            return false;
        }
    }

    public static class FSFitImagesToWidth
    extends LengthLikeWithAuto {
        @Override
        protected boolean isNegativeValuesAllowed() {
            return false;
        }
    }

    public static class FSTextDecorationExtent
    extends SingleIdent {
        private static final BitSet ALLOWED = PrimitivePropertyBuilders.setFor(IdentValue.LINE, IdentValue.BLOCK);

        @Override
        protected BitSet getAllowed() {
            return ALLOWED;
        }
    }

    public static class FSTablePaginate
    extends SingleIdent {
        private static final BitSet ALLOWED = PrimitivePropertyBuilders.setFor(IdentValue.PAGINATE, IdentValue.AUTO);

        @Override
        protected BitSet getAllowed() {
            return ALLOWED;
        }
    }

    public static class FSTableCellRowspan
    extends ColOrRowSpan {
    }

    public static class FSTableCellColspan
    extends ColOrRowSpan {
    }

    public static class FSPDFFontEncoding
    extends AbstractPropertyBuilder {
        @Override
        public List<PropertyDeclaration> buildDeclarations(CSSName cssName, List<PropertyValue> values, int origin, boolean important, boolean inheritAllowed) {
            this.checkValueCount(cssName, 1, values.size());
            CSSPrimitiveValue value2 = values.get(0);
            this.checkInheritAllowed(value2, inheritAllowed);
            if (value2.getCssValueType() != 0) {
                this.checkIdentOrString(cssName, value2);
                if (value2.getPrimitiveType() == 21) {
                    return Collections.singletonList(new PropertyDeclaration(cssName, new PropertyValue(19, value2.getStringValue(), value2.getCssText()), important, origin));
                }
            }
            return Collections.singletonList(new PropertyDeclaration(cssName, value2, important, origin));
        }
    }

    public static class FSPDFFontEmbed
    extends SingleIdent {
        private static final BitSet ALLOWED = PrimitivePropertyBuilders.setFor(IdentValue.AUTO, IdentValue.EMBED);

        @Override
        protected BitSet getAllowed() {
            return ALLOWED;
        }
    }

    public static class FSPageOrientation
    extends SingleIdent {
        @Override
        protected BitSet getAllowed() {
            return PAGE_ORIENTATIONS;
        }
    }

    public static class FSPageSequence
    extends SingleIdent {
        private static final BitSet ALLOWED = PrimitivePropertyBuilders.setFor(IdentValue.START, IdentValue.AUTO);

        @Override
        protected BitSet getAllowed() {
            return ALLOWED;
        }
    }

    public static class FSPageWidth
    extends LengthLikeWithAuto {
        @Override
        protected boolean isNegativeValuesAllowed() {
            return false;
        }
    }

    public static class FSPageHeight
    extends LengthLikeWithAuto {
        @Override
        protected boolean isNegativeValuesAllowed() {
            return false;
        }
    }

    public static class FSCheckboxStyle
    extends SingleIdent {
        @Override
        protected BitSet getAllowed() {
            return CHECKBOX_STYLES;
        }
    }

    public static class FSFontSubset
    extends SingleIdent {
        @Override
        protected BitSet getAllowed() {
            return FONT_SUBSETS;
        }
    }

    public static class FSBorderSpacingVertical
    extends Length {
    }

    public static class FSBorderSpacingHorizontal
    extends Length {
    }

    public static class FontWeight
    extends AbstractPropertyBuilder {
        @Override
        public List<PropertyDeclaration> buildDeclarations(CSSName cssName, List<PropertyValue> values, int origin, boolean important, boolean inheritAllowed) {
            this.checkValueCount(cssName, 1, values.size());
            PropertyValue value2 = values.get(0);
            this.checkInheritAllowed(value2, inheritAllowed);
            if (value2.getCssValueType() != 0) {
                this.checkIdentOrNumberType(cssName, value2);
                short type = value2.getPrimitiveType();
                if (type == 21) {
                    this.checkIdentType(cssName, value2);
                    IdentValue ident = this.checkIdent(cssName, value2);
                    this.checkValidity(cssName, this.getAllowed(), ident);
                } else if (type == 1) {
                    IdentValue weight = Conversions.getNumericFontWeight(value2.getFloatValue());
                    if (weight == null) {
                        throw new CSSParseException(value2 + " is not a valid font weight", -1);
                    }
                    PropertyValue replacement = new PropertyValue(21, weight.toString(), weight.toString());
                    replacement.setIdentValue(weight);
                    return Collections.singletonList(new PropertyDeclaration(cssName, replacement, important, origin));
                }
            }
            return Collections.singletonList(new PropertyDeclaration(cssName, value2, important, origin));
        }

        private BitSet getAllowed() {
            return FONT_WEIGHTS;
        }
    }

    public static class FontVariant
    extends SingleIdent {
        @Override
        protected BitSet getAllowed() {
            return FONT_VARIANTS;
        }
    }

    public static class FontStyle
    extends SingleIdent {
        @Override
        protected BitSet getAllowed() {
            return FONT_STYLES;
        }
    }

    public static class FontSize
    extends AbstractPropertyBuilder {
        private static final BitSet ALLOWED = new BitSet(IdentValue.getIdentCount());

        @Override
        public List<PropertyDeclaration> buildDeclarations(CSSName cssName, List<PropertyValue> values, int origin, boolean important, boolean inheritAllowed) {
            this.checkValueCount(cssName, 1, values.size());
            PropertyValue value2 = values.get(0);
            this.checkInheritAllowed(value2, inheritAllowed);
            if (value2.getCssValueType() != 0) {
                this.checkIdentLengthOrPercentType(cssName, value2);
                if (value2.getPrimitiveType() == 21) {
                    IdentValue ident = this.checkIdent(cssName, value2);
                    this.checkValidity(cssName, ALLOWED, ident);
                } else if (value2.getFloatValue() < 0.0f) {
                    throw new CSSParseException("font-size may not be negative", -1);
                }
            }
            return Collections.singletonList(new PropertyDeclaration(cssName, value2, important, origin));
        }

        static {
            ALLOWED.or(ABSOLUTE_FONT_SIZES);
            ALLOWED.or(RELATIVE_FONT_SIZES);
        }
    }

    public static class FontFamily
    extends AbstractPropertyBuilder {
        @Override
        public List<PropertyDeclaration> buildDeclarations(CSSName cssName, List<PropertyValue> values, int origin, boolean important, boolean inheritAllowed) {
            if (values.size() == 1) {
                CSSPrimitiveValue value2 = values.get(0);
                this.checkInheritAllowed(value2, inheritAllowed);
                if (value2.getCssValueType() == 0) {
                    return Collections.singletonList(new PropertyDeclaration(cssName, value2, important, origin));
                }
            }
            ArrayList<String> consecutiveIdents = new ArrayList<String>();
            ArrayList<String> normalized = new ArrayList<String>(values.size());
            for (PropertyValue value3 : values) {
                Token operator = value3.getOperator();
                if (operator != null && operator != Token.TK_COMMA) {
                    throw new CSSParseException("Invalid font-family definition", -1);
                }
                if (operator != null && consecutiveIdents.size() > 0) {
                    normalized.add(this.concat(consecutiveIdents, ' '));
                    consecutiveIdents.clear();
                }
                this.checkInheritAllowed(value3, false);
                short type = value3.getPrimitiveType();
                if (type == 19) {
                    if (consecutiveIdents.size() > 0) {
                        normalized.add(this.concat(consecutiveIdents, ' '));
                        consecutiveIdents.clear();
                    }
                    normalized.add(value3.getStringValue());
                    continue;
                }
                if (type == 21) {
                    consecutiveIdents.add(value3.getStringValue());
                    continue;
                }
                throw new CSSParseException("Invalid font-family definition", -1);
            }
            if (consecutiveIdents.size() > 0) {
                normalized.add(this.concat(consecutiveIdents, ' '));
            }
            String text2 = this.concat(normalized, ',');
            PropertyValue result2 = new PropertyValue(19, text2, text2);
            result2.setStringArrayValue(normalized.toArray(new String[normalized.size()]));
            return Collections.singletonList(new PropertyDeclaration(cssName, result2, important, origin));
        }

        private String concat(List<String> strings, char separator) {
            StringBuilder buf = new StringBuilder(64);
            Iterator<String> i = strings.iterator();
            while (i.hasNext()) {
                String s = i.next();
                buf.append(s);
                if (!i.hasNext()) continue;
                buf.append(separator);
            }
            return buf.toString();
        }
    }

    public static class Float
    extends SingleIdent {
        private static final BitSet ALLOWED = PrimitivePropertyBuilders.setFor(IdentValue.LEFT, IdentValue.RIGHT, IdentValue.NONE, IdentValue.BOTTOM, IdentValue.FOOTNOTE);

        @Override
        protected BitSet getAllowed() {
            return ALLOWED;
        }
    }

    public static class EmptyCells
    extends SingleIdent {
        private static final BitSet ALLOWED = PrimitivePropertyBuilders.setFor(IdentValue.SHOW, IdentValue.HIDE);

        @Override
        protected BitSet getAllowed() {
            return ALLOWED;
        }
    }

    public static class Display
    extends SingleIdent {
        private static final BitSet ALLOWED = PrimitivePropertyBuilders.setFor(IdentValue.INLINE, IdentValue.BLOCK, IdentValue.LIST_ITEM, IdentValue.INLINE_BLOCK, IdentValue.TABLE, IdentValue.INLINE_TABLE, IdentValue.TABLE_ROW_GROUP, IdentValue.TABLE_HEADER_GROUP, IdentValue.TABLE_FOOTER_GROUP, IdentValue.TABLE_ROW, IdentValue.TABLE_COLUMN_GROUP, IdentValue.TABLE_COLUMN, IdentValue.TABLE_CELL, IdentValue.TABLE_CAPTION, IdentValue.NONE);

        @Override
        protected BitSet getAllowed() {
            return ALLOWED;
        }
    }

    public static class Cursor
    extends SingleIdent {
        private static final BitSet ALLOWED = PrimitivePropertyBuilders.setFor(IdentValue.AUTO, IdentValue.CROSSHAIR, IdentValue.DEFAULT, IdentValue.POINTER, IdentValue.MOVE, IdentValue.E_RESIZE, IdentValue.NE_RESIZE, IdentValue.NW_RESIZE, IdentValue.N_RESIZE, IdentValue.SE_RESIZE, IdentValue.SW_RESIZE, IdentValue.S_RESIZE, IdentValue.W_RESIZE, IdentValue.TEXT, IdentValue.WAIT, IdentValue.HELP, IdentValue.PROGRESS);

        @Override
        protected BitSet getAllowed() {
            return ALLOWED;
        }
    }

    public static class Color
    extends GenericColor {
    }

    public static class Clear
    extends SingleIdent {
        private static final BitSet ALLOWED = PrimitivePropertyBuilders.setFor(IdentValue.NONE, IdentValue.LEFT, IdentValue.RIGHT, IdentValue.BOTH);

        @Override
        protected BitSet getAllowed() {
            return ALLOWED;
        }
    }

    public static class CaptionSide
    extends SingleIdent {
        private static final BitSet ALLOWED = PrimitivePropertyBuilders.setFor(IdentValue.TOP, IdentValue.BOTTOM);

        @Override
        protected BitSet getAllowed() {
            return ALLOWED;
        }
    }

    public static class Bottom
    extends LengthLikeWithAuto {
    }

    public static class BorderBottomLeftRadius
    extends GenericBorderCornerRadius {
    }

    public static class BorderBottomRightRadius
    extends GenericBorderCornerRadius {
    }

    public static class BorderTopRightRadius
    extends GenericBorderCornerRadius {
    }

    public static class BorderTopLeftRadius
    extends GenericBorderCornerRadius {
    }

    public static class BorderLeftWidth
    extends GenericBorderWidth {
    }

    public static class BorderBottomWidth
    extends GenericBorderWidth {
    }

    public static class BorderRightWidth
    extends GenericBorderWidth {
    }

    public static class BorderTopWidth
    extends GenericBorderWidth {
    }

    public static class BorderLeftStyle
    extends GenericBorderStyle {
    }

    public static class BorderBottomStyle
    extends GenericBorderStyle {
    }

    public static class BorderRightStyle
    extends GenericBorderStyle {
    }

    public static class BorderTopStyle
    extends GenericBorderStyle {
    }

    public static class BorderLeftColor
    extends GenericColor {
    }

    public static class BorderBottomColor
    extends GenericColor {
    }

    public static class BorderRightColor
    extends GenericColor {
    }

    public static class BorderTopColor
    extends GenericColor {
    }

    public static class FSBorderRendering
    extends SingleIdent {
        final BitSet ALLOWED = PrimitivePropertyBuilders.setFor(IdentValue.AUTO, IdentValue.NO_BEVEL);

        @Override
        protected BitSet getAllowed() {
            return this.ALLOWED;
        }
    }

    public static class BorderCollapse
    extends SingleIdent {
        private static final BitSet ALLOWED = PrimitivePropertyBuilders.setFor(IdentValue.COLLAPSE, IdentValue.SEPARATE);

        @Override
        protected BitSet getAllowed() {
            return ALLOWED;
        }
    }

    static class GenericURIWithNone
    extends AbstractPropertyBuilder {
        private static final BitSet ALLOWED = PrimitivePropertyBuilders.setFor(IdentValue.NONE);

        GenericURIWithNone() {
        }

        @Override
        public List<PropertyDeclaration> buildDeclarations(CSSName cssName, List<PropertyValue> values, int origin, boolean important, boolean inheritAllowed) {
            this.checkValueCount(cssName, 1, values.size());
            CSSPrimitiveValue value2 = values.get(0);
            this.checkInheritAllowed(value2, inheritAllowed);
            if (value2.getCssValueType() != 0) {
                this.checkIdentOrURIType(cssName, value2);
                if (value2.getPrimitiveType() == 21) {
                    IdentValue ident = this.checkIdent(cssName, value2);
                    this.checkValidity(cssName, ALLOWED, ident);
                }
            }
            return Collections.singletonList(new PropertyDeclaration(cssName, value2, important, origin));
        }
    }

    private static class LengthLikeWithNone
    extends LengthLikeWithIdent {
        private static final BitSet ALLOWED = PrimitivePropertyBuilders.setFor(IdentValue.NONE);

        private LengthLikeWithNone() {
        }

        @Override
        protected BitSet getAllowed() {
            return ALLOWED;
        }
    }

    private static class LengthWithNormal
    extends LengthWithIdent {
        private static final BitSet ALLOWED = PrimitivePropertyBuilders.setFor(IdentValue.NORMAL);

        private LengthWithNormal() {
        }

        @Override
        protected BitSet getAllowed() {
            return ALLOWED;
        }
    }

    private static class LengthLikeWithAuto
    extends LengthLikeWithIdent {
        private static final BitSet ALLOWED = PrimitivePropertyBuilders.setFor(IdentValue.AUTO);

        private LengthLikeWithAuto() {
        }

        @Override
        protected BitSet getAllowed() {
            return ALLOWED;
        }
    }

    private static class Length
    extends AbstractPropertyBuilder {
        private Length() {
        }

        @Override
        public List<PropertyDeclaration> buildDeclarations(CSSName cssName, List<PropertyValue> values, int origin, boolean important, boolean inheritAllowed) {
            this.checkValueCount(cssName, 1, values.size());
            PropertyValue value2 = values.get(0);
            this.checkInheritAllowed(value2, inheritAllowed);
            if (value2.getCssValueType() != 0) {
                this.checkLengthType(cssName, value2);
                if (!this.isNegativeValuesAllowed() && value2.getFloatValue() < 0.0f) {
                    throw new CSSParseException(cssName + " may not be negative", -1);
                }
            }
            return Collections.singletonList(new PropertyDeclaration(cssName, value2, important, origin));
        }

        protected boolean isNegativeValuesAllowed() {
            return true;
        }
    }

    private static class PlainInteger
    extends AbstractPropertyBuilder {
        private PlainInteger() {
        }

        @Override
        public List<PropertyDeclaration> buildDeclarations(CSSName cssName, List<PropertyValue> values, int origin, boolean important, boolean inheritAllowed) {
            this.checkValueCount(cssName, 1, values.size());
            PropertyValue value2 = values.get(0);
            this.checkInheritAllowed(value2, inheritAllowed);
            if (value2.getCssValueType() != 0) {
                this.checkInteger(cssName, value2);
                if (!this.isNegativeValuesAllowed() && value2.getFloatValue() < 0.0f) {
                    throw new CSSParseException(cssName + " may not be negative", -1);
                }
            }
            return Collections.singletonList(new PropertyDeclaration(cssName, value2, important, origin));
        }

        protected boolean isNegativeValuesAllowed() {
            return true;
        }
    }

    private static class ColOrRowSpan
    extends AbstractPropertyBuilder {
        private ColOrRowSpan() {
        }

        @Override
        public List<PropertyDeclaration> buildDeclarations(CSSName cssName, List<PropertyValue> values, int origin, boolean important, boolean inheritAllowed) {
            this.checkValueCount(cssName, 1, values.size());
            PropertyValue value2 = values.get(0);
            this.checkInheritAllowed(value2, inheritAllowed);
            if (value2.getCssValueType() != 0) {
                this.checkNumberType(cssName, value2);
                if (value2.getFloatValue() < 1.0f) {
                    throw new CSSParseException("colspan/rowspan must be greater than zero", -1);
                }
            }
            return Collections.singletonList(new PropertyDeclaration(cssName, value2, important, origin));
        }
    }

    private static class NonNegativeLengthLike
    extends LengthLike {
        private NonNegativeLengthLike() {
        }

        @Override
        protected boolean isNegativeValuesAllowed() {
            return false;
        }
    }

    private static class LengthLike
    extends AbstractPropertyBuilder {
        private LengthLike() {
        }

        @Override
        public List<PropertyDeclaration> buildDeclarations(CSSName cssName, List<PropertyValue> values, int origin, boolean important, boolean inheritAllowed) {
            this.checkValueCount(cssName, 1, values.size());
            PropertyValue value2 = values.get(0);
            this.checkInheritAllowed(value2, inheritAllowed);
            if (value2.getCssValueType() != 0) {
                this.checkLengthOrPercentType(cssName, value2);
                if (!this.isNegativeValuesAllowed() && value2.getFloatValue() < 0.0f) {
                    throw new CSSParseException(cssName + " may not be negative", -1);
                }
            }
            return Collections.singletonList(new PropertyDeclaration(cssName, value2, important, origin));
        }

        protected boolean isNegativeValuesAllowed() {
            return true;
        }
    }

    private static abstract class LengthLikeWithIdent
    extends AbstractPropertyBuilder {
        private LengthLikeWithIdent() {
        }

        protected abstract BitSet getAllowed();

        @Override
        public List<PropertyDeclaration> buildDeclarations(CSSName cssName, List<PropertyValue> values, int origin, boolean important, boolean inheritAllowed) {
            this.checkValueCount(cssName, 1, values.size());
            PropertyValue value2 = values.get(0);
            this.checkInheritAllowed(value2, inheritAllowed);
            if (value2.getCssValueType() != 0) {
                this.checkIdentLengthOrPercentType(cssName, value2);
                if (value2.getPrimitiveType() == 21) {
                    IdentValue ident = this.checkIdent(cssName, value2);
                    this.checkValidity(cssName, this.getAllowed(), ident);
                } else if (!this.isNegativeValuesAllowed() && value2.getFloatValue() < 0.0f) {
                    throw new CSSParseException(cssName + " may not be negative", -1);
                }
            }
            return Collections.singletonList(new PropertyDeclaration(cssName, value2, important, origin));
        }

        protected boolean isNegativeValuesAllowed() {
            return true;
        }
    }

    private static abstract class LengthWithIdent
    extends AbstractPropertyBuilder {
        private LengthWithIdent() {
        }

        protected abstract BitSet getAllowed();

        @Override
        public List<PropertyDeclaration> buildDeclarations(CSSName cssName, List<PropertyValue> values, int origin, boolean important, boolean inheritAllowed) {
            this.checkValueCount(cssName, 1, values.size());
            PropertyValue value2 = values.get(0);
            this.checkInheritAllowed(value2, inheritAllowed);
            if (value2.getCssValueType() != 0) {
                this.checkIdentOrLengthType(cssName, value2);
                if (value2.getPrimitiveType() == 21) {
                    IdentValue ident = this.checkIdent(cssName, value2);
                    this.checkValidity(cssName, this.getAllowed(), ident);
                } else if (!this.isNegativeValuesAllowed() && value2.getFloatValue() < 0.0f) {
                    throw new CSSParseException(cssName + " may not be negative", -1);
                }
            }
            return Collections.singletonList(new PropertyDeclaration(cssName, value2, important, origin));
        }

        protected boolean isNegativeValuesAllowed() {
            return true;
        }
    }

    private static class GenericBorderCornerRadius
    extends AbstractPropertyBuilder {
        private GenericBorderCornerRadius() {
        }

        @Override
        public List<PropertyDeclaration> buildDeclarations(CSSName cssName, List<PropertyValue> values, int origin, boolean important, boolean inheritAllowed) {
            this.checkValueCount(cssName, 1, 2, values.size());
            PropertyValue first = values.get(0);
            PropertyValue second = null;
            if (values.size() == 2) {
                second = values.get(1);
            }
            this.checkInheritAllowed(first, inheritAllowed);
            if (second != null) {
                this.checkInheritAllowed(second, false);
            }
            this.checkLengthOrPercentType(cssName, first);
            if (second == null) {
                return PrimitivePropertyBuilders.createTwoValueResponse(cssName, first, first, origin, important);
            }
            this.checkLengthOrPercentType(cssName, second);
            return PrimitivePropertyBuilders.createTwoValueResponse(cssName, first, second, origin, important);
        }
    }

    private static class GenericBorderWidth
    extends AbstractPropertyBuilder {
        private GenericBorderWidth() {
        }

        @Override
        public List<PropertyDeclaration> buildDeclarations(CSSName cssName, List<PropertyValue> values, int origin, boolean important, boolean inheritAllowed) {
            this.checkValueCount(cssName, 1, values.size());
            PropertyValue value2 = values.get(0);
            this.checkInheritAllowed(value2, inheritAllowed);
            if (value2.getCssValueType() != 0) {
                this.checkIdentOrLengthType(cssName, value2);
                if (value2.getPrimitiveType() == 21) {
                    IdentValue ident = this.checkIdent(cssName, value2);
                    this.checkValidity(cssName, BORDER_WIDTHS, ident);
                    return Collections.singletonList(new PropertyDeclaration(cssName, Conversions.getBorderWidth(ident.toString()), important, origin));
                }
                if (value2.getFloatValue() < 0.0f) {
                    throw new CSSParseException(cssName + " may not be negative", -1);
                }
            }
            return Collections.singletonList(new PropertyDeclaration(cssName, value2, important, origin));
        }
    }

    public static class Direction
    extends SingleIdent {
        @Override
        protected BitSet getAllowed() {
            return DIRECTIONS;
        }
    }

    private static class GenericBorderStyle
    extends SingleIdent {
        private GenericBorderStyle() {
        }

        @Override
        protected BitSet getAllowed() {
            return BORDER_STYLES;
        }
    }

    static class GenericColor
    extends AbstractPropertyBuilder {
        private static final BitSet ALLOWED = PrimitivePropertyBuilders.setFor(IdentValue.TRANSPARENT);

        GenericColor() {
        }

        @Override
        public List<PropertyDeclaration> buildDeclarations(CSSName cssName, List<PropertyValue> values, int origin, boolean important, boolean inheritAllowed) {
            this.checkValueCount(cssName, 1, values.size());
            CSSPrimitiveValue value2 = values.get(0);
            this.checkInheritAllowed(value2, inheritAllowed);
            if (value2.getCssValueType() != 0) {
                this.checkIdentOrColorType(cssName, value2);
                if (value2.getPrimitiveType() == 21) {
                    FSRGBColor color = Conversions.getColor(value2.getStringValue());
                    if (color != null) {
                        return Collections.singletonList(new PropertyDeclaration(cssName, new PropertyValue(color), important, origin));
                    }
                    IdentValue ident = this.checkIdent(cssName, value2);
                    this.checkValidity(cssName, ALLOWED, ident);
                }
            }
            return Collections.singletonList(new PropertyDeclaration(cssName, value2, important, origin));
        }
    }

    static abstract class SingleIdent
    extends AbstractPropertyBuilder {
        SingleIdent() {
        }

        protected abstract BitSet getAllowed();

        @Override
        public List<PropertyDeclaration> buildDeclarations(CSSName cssName, List<PropertyValue> values, int origin, boolean important, boolean inheritAllowed) {
            this.checkValueCount(cssName, 1, values.size());
            CSSPrimitiveValue value2 = values.get(0);
            this.checkInheritAllowed(value2, inheritAllowed);
            if (value2.getCssValueType() != 0) {
                this.checkIdentType(cssName, value2);
                IdentValue ident = this.checkIdent(cssName, value2);
                this.checkValidity(cssName, this.getAllowed(), ident);
            }
            return Collections.singletonList(new PropertyDeclaration(cssName, value2, important, origin));
        }
    }
}

