/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.css.parser.property;

import com.openhtmltopdf.css.constants.CSSName;
import com.openhtmltopdf.css.constants.IdentValue;
import com.openhtmltopdf.css.parser.CSSParseException;
import com.openhtmltopdf.css.parser.PropertyValue;
import com.openhtmltopdf.css.parser.property.AbstractPropertyBuilder;
import com.openhtmltopdf.css.parser.property.PrimitivePropertyBuilders;
import com.openhtmltopdf.css.sheet.PropertyDeclaration;
import java.util.ArrayList;
import java.util.List;

public class ListStylePropertyBuilder
extends AbstractPropertyBuilder {
    private static final CSSName[] ALL = new CSSName[]{CSSName.LIST_STYLE_TYPE, CSSName.LIST_STYLE_POSITION, CSSName.LIST_STYLE_IMAGE};

    @Override
    public List<PropertyDeclaration> buildDeclarations(CSSName cssName, List<PropertyValue> values, int origin, boolean important, boolean inheritAllowed) {
        List<PropertyDeclaration> result2 = this.checkInheritAll(ALL, values, origin, important, inheritAllowed);
        if (result2 != null) {
            return result2;
        }
        PropertyDeclaration listStyleType = null;
        PropertyDeclaration listStylePosition = null;
        PropertyDeclaration listStyleImage = null;
        for (PropertyValue value2 : values) {
            this.checkInheritAllowed(value2, false);
            short type = value2.getPrimitiveType();
            if (type == 21) {
                IdentValue ident = this.checkIdent(CSSName.LIST_STYLE_SHORTHAND, value2);
                if (ident == IdentValue.NONE) {
                    if (listStyleType == null) {
                        listStyleType = new PropertyDeclaration(CSSName.LIST_STYLE_TYPE, value2, important, origin);
                    }
                    if (listStyleImage != null) continue;
                    listStyleImage = new PropertyDeclaration(CSSName.LIST_STYLE_IMAGE, value2, important, origin);
                    continue;
                }
                if (PrimitivePropertyBuilders.LIST_STYLE_POSITIONS.get(ident.FS_ID)) {
                    if (listStylePosition != null) {
                        throw new CSSParseException("A list-style-position value cannot be set twice", -1);
                    }
                    listStylePosition = new PropertyDeclaration(CSSName.LIST_STYLE_POSITION, value2, important, origin);
                    continue;
                }
                if (!PrimitivePropertyBuilders.LIST_STYLE_TYPES.get(ident.FS_ID)) continue;
                if (listStyleType != null) {
                    throw new CSSParseException("A list-style-type value cannot be set twice", -1);
                }
                listStyleType = new PropertyDeclaration(CSSName.LIST_STYLE_TYPE, value2, important, origin);
                continue;
            }
            if (type != 20) continue;
            if (listStyleImage != null) {
                throw new CSSParseException("A list-style-image value cannot be set twice", -1);
            }
            listStyleImage = new PropertyDeclaration(CSSName.LIST_STYLE_IMAGE, value2, important, origin);
        }
        result2 = new ArrayList<PropertyDeclaration>(3);
        if (listStyleType != null) {
            result2.add(listStyleType);
        }
        if (listStylePosition != null) {
            result2.add(listStylePosition);
        }
        if (listStyleImage != null) {
            result2.add(listStyleImage);
        }
        return result2;
    }
}

