/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.css.parser.property;

import com.openhtmltopdf.css.constants.CSSName;
import com.openhtmltopdf.css.constants.IdentValue;
import com.openhtmltopdf.css.parser.CSSParseException;
import com.openhtmltopdf.css.parser.FSRGBColor;
import com.openhtmltopdf.css.parser.PropertyValue;
import com.openhtmltopdf.css.parser.property.AbstractPropertyBuilder;
import com.openhtmltopdf.css.parser.property.Conversions;
import com.openhtmltopdf.css.parser.property.PrimitivePropertyBuilders;
import com.openhtmltopdf.css.parser.property.PropertyBuilder;
import com.openhtmltopdf.css.sheet.PropertyDeclaration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class BackgroundPropertyBuilder
extends AbstractPropertyBuilder {
    private static final CSSName[] ALL = new CSSName[]{CSSName.BACKGROUND_COLOR, CSSName.BACKGROUND_IMAGE, CSSName.BACKGROUND_REPEAT, CSSName.BACKGROUND_ATTACHMENT, CSSName.BACKGROUND_POSITION};

    private boolean isAppliesToBackgroundPosition(PropertyValue value2) {
        short type = value2.getPrimitiveType();
        if (this.isLength(value2) || type == 2) {
            return true;
        }
        if (type != 21) {
            return false;
        }
        IdentValue ident = IdentValue.valueOf(value2.getStringValue());
        return ident != null && PrimitivePropertyBuilders.BACKGROUND_POSITIONS.get(ident.FS_ID);
    }

    @Override
    public List<PropertyDeclaration> buildDeclarations(CSSName cssName, List<PropertyValue> values, int origin, boolean important, boolean inheritAllowed) {
        List<PropertyDeclaration> result2 = this.checkInheritAll(ALL, values, origin, important, inheritAllowed);
        if (result2 != null) {
            return result2;
        }
        PropertyDeclaration backgroundColor = null;
        PropertyDeclaration backgroundImage = null;
        PropertyDeclaration backgroundRepeat = null;
        PropertyDeclaration backgroundAttachment = null;
        PropertyDeclaration backgroundPosition = null;
        for (int i = 0; i < values.size(); ++i) {
            PropertyValue next;
            PropertyValue value2 = values.get(i);
            this.checkInheritAllowed(value2, false);
            boolean processingBackgroundPosition = false;
            short type = value2.getPrimitiveType();
            if (type == 21) {
                FSRGBColor color = Conversions.getColor(value2.getStringValue());
                if (color != null) {
                    if (backgroundColor != null) {
                        throw new CSSParseException("A background-color value cannot be set twice", -1);
                    }
                    backgroundColor = new PropertyDeclaration(CSSName.BACKGROUND_COLOR, new PropertyValue(color), important, origin);
                    continue;
                }
                IdentValue ident = this.checkIdent(CSSName.BACKGROUND_SHORTHAND, value2);
                if (PrimitivePropertyBuilders.BACKGROUND_REPEATS.get(ident.FS_ID)) {
                    if (backgroundRepeat != null) {
                        throw new CSSParseException("A background-repeat value cannot be set twice", -1);
                    }
                    backgroundRepeat = new PropertyDeclaration(CSSName.BACKGROUND_REPEAT, new PropertyValue(Collections.singletonList(value2)), important, origin);
                }
                if (PrimitivePropertyBuilders.BACKGROUND_ATTACHMENTS.get(ident.FS_ID)) {
                    if (backgroundAttachment != null) {
                        throw new CSSParseException("A background-attachment value cannot be set twice", -1);
                    }
                    backgroundAttachment = new PropertyDeclaration(CSSName.BACKGROUND_ATTACHMENT, new PropertyValue(Collections.singletonList(value2)), important, origin);
                }
                if (ident == IdentValue.TRANSPARENT) {
                    if (backgroundColor != null) {
                        throw new CSSParseException("A background-color value cannot be set twice", -1);
                    }
                    backgroundColor = new PropertyDeclaration(CSSName.BACKGROUND_COLOR, value2, important, origin);
                }
                if (ident == IdentValue.NONE) {
                    if (backgroundImage != null) {
                        throw new CSSParseException("A background-image value cannot be set twice", -1);
                    }
                    List<PropertyValue> bgImages = Collections.singletonList(value2);
                    backgroundImage = new PropertyDeclaration(CSSName.BACKGROUND_IMAGE, new PropertyValue(bgImages), important, origin);
                }
                if (PrimitivePropertyBuilders.BACKGROUND_POSITIONS.get(ident.FS_ID)) {
                    processingBackgroundPosition = true;
                }
            } else if (type == 25) {
                if (backgroundColor != null) {
                    throw new CSSParseException("A background-color value cannot be set twice", -1);
                }
                backgroundColor = new PropertyDeclaration(CSSName.BACKGROUND_COLOR, value2, important, origin);
            } else if (type == 20) {
                if (backgroundImage != null) {
                    throw new CSSParseException("A background-image value cannot be set twice", -1);
                }
                List<PropertyValue> bgImages = Collections.singletonList(value2);
                backgroundImage = new PropertyDeclaration(CSSName.BACKGROUND_IMAGE, new PropertyValue(bgImages), important, origin);
            }
            if (!processingBackgroundPosition && !this.isLength(value2) && type != 2) continue;
            if (backgroundPosition != null) {
                throw new CSSParseException("A background-position value cannot be set twice", -1);
            }
            ArrayList<PropertyValue> v = new ArrayList<PropertyValue>(2);
            v.add(value2);
            if (i < values.size() - 1 && this.isAppliesToBackgroundPosition(next = values.get(i + 1))) {
                v.add(next);
                ++i;
            }
            PropertyBuilder builder = CSSName.getPropertyBuilder(CSSName.BACKGROUND_POSITION);
            backgroundPosition = builder.buildDeclarations(CSSName.BACKGROUND_POSITION, v, origin, important).get(0);
        }
        if (backgroundColor == null) {
            backgroundColor = new PropertyDeclaration(CSSName.BACKGROUND_COLOR, new PropertyValue(IdentValue.TRANSPARENT), important, origin);
        }
        if (backgroundImage == null) {
            List<PropertyValue> bgImages = Collections.singletonList(new PropertyValue(IdentValue.NONE));
            backgroundImage = new PropertyDeclaration(CSSName.BACKGROUND_IMAGE, new PropertyValue(bgImages), important, origin);
        }
        if (backgroundRepeat == null) {
            backgroundRepeat = new PropertyDeclaration(CSSName.BACKGROUND_REPEAT, new PropertyValue(Collections.singletonList(new PropertyValue(IdentValue.REPEAT))), important, origin);
        }
        if (backgroundAttachment == null) {
            backgroundAttachment = new PropertyDeclaration(CSSName.BACKGROUND_ATTACHMENT, new PropertyValue(Collections.singletonList(new PropertyValue(IdentValue.SCROLL))), important, origin);
        }
        if (backgroundPosition == null) {
            ArrayList<PropertyValue> v = new ArrayList<PropertyValue>(2);
            v.add(new PropertyValue(2, 0.0f, "0%"));
            v.add(new PropertyValue(2, 0.0f, "0%"));
            backgroundPosition = new PropertyDeclaration(CSSName.BACKGROUND_POSITION, new PropertyValue(v), important, origin);
        }
        return Arrays.asList(backgroundColor, backgroundImage, backgroundRepeat, backgroundAttachment, backgroundPosition);
    }
}

