/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.qodana.sarif;

import com.jetbrains.qodana.sarif.model.ReportingDescriptor;
import com.jetbrains.qodana.sarif.model.Run;
import com.jetbrains.qodana.sarif.model.SarifReport;
import com.jetbrains.qodana.sarif.model.ToolComponent;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RuleUtil {
    private RuleUtil() {
        throw new IllegalStateException("No instances.");
    }

    @Nullable
    public static ReportingDescriptor findRuleDescriptor(@NotNull SarifReport report2, @Nullable String ruleId) {
        if (ruleId == null || ruleId.isEmpty()) {
            return null;
        }
        return RuleUtil.allRules(report2).filter(r -> Objects.equals(r.getId(), ruleId)).findFirst().orElse(null);
    }

    @NotNull
    public static Stream<ReportingDescriptor> allRules(@NotNull SarifReport report2) {
        return RuleUtil.stream(report2.getRuns()).map(Run::getTool).filter(Objects::nonNull).flatMap(tool -> {
            ToolComponent driver = tool.getDriver();
            Stream driverRules = driver == null ? Stream.empty() : RuleUtil.stream(driver.getRules());
            Stream extRules = RuleUtil.stream(tool.getExtensions()).flatMap(e -> RuleUtil.stream(e.getRules()));
            return Stream.concat(driverRules, extRules);
        });
    }

    @NotNull
    private static <T> Stream<T> stream(@Nullable Collection<T> c) {
        if (c == null) {
            return Stream.empty();
        }
        return c.stream().filter(Objects::nonNull);
    }
}

