/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.image.BufferedImage;

public interface FontMetricsAccessor {
    public FontMetrics getMetrics(Font var1, FontRenderContext var2);

    public float codePointWidth(FontMetrics var1, int var2);

    public void setOverride(FontMetrics var1, Overrider var2);

    public boolean hasOverride(FontMetrics var1);

    public void removeAllOverrides();

    public static class __Fallback
    implements FontMetricsAccessor {
        private final Graphics2D g = new BufferedImage(1, 1, 1).createGraphics();

        __Fallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public FontMetrics getMetrics(Font font, FontRenderContext context) {
            Graphics2D graphics2D = this.g;
            synchronized (graphics2D) {
                this.g.setTransform(context.getTransform());
                this.g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, context.getAntiAliasingHint());
                this.g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, context.getFractionalMetricsHint());
                return this.g.getFontMetrics(font);
            }
        }

        @Override
        public float codePointWidth(FontMetrics metrics, int codePoint) {
            String s = new String(new int[]{codePoint}, 0, 1);
            return (float)metrics.getFont().getStringBounds(s, metrics.getFontRenderContext()).getWidth();
        }

        @Override
        public void setOverride(FontMetrics metrics, Overrider overrider) {
        }

        @Override
        public boolean hasOverride(FontMetrics metrics) {
            return false;
        }

        @Override
        public void removeAllOverrides() {
        }
    }

    public static interface Overrider {
        public float charWidth(int var1);
    }
}

