/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.exp.completion;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.terminal.completion.ShellEnvironment;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import kotlinx.serialization.json.Json;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.exp.BlockTerminalSession;
import org.jetbrains.plugins.terminal.exp.completion.DataProviderCommand;
import org.jetbrains.plugins.terminal.exp.completion.DataProviderCommandsKt;
import org.jetbrains.plugins.terminal.exp.completion.GetEnvironmentCommand$ShellEnvCommandResult$;
import org.jetbrains.plugins.terminal.exp.completion.TerminalShellSupport;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\b\b\b\u0000\u0018\u0000 \u001a2\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001:\u0002\u001a\u001bB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0003\u001a\u00020\u0004H\u0016J\u001c\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u00142\u0006\u0010\u0015\u001a\u00020\nH\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0017\u001a\u00020\nH\u0016J\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\n0\u000e*\u00020\n2\u0006\u0010\u0019\u001a\u00020\nH\u0002R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/plugins/terminal/exp/completion/GetEnvironmentCommand;", "Lorg/jetbrains/plugins/terminal/exp/completion/DataProviderCommand;", "Lcom/intellij/terminal/completion/ShellEnvironment;", "session", "Lorg/jetbrains/plugins/terminal/exp/BlockTerminalSession;", "(Lorg/jetbrains/plugins/terminal/exp/BlockTerminalSession;)V", "defaultResult", "getDefaultResult", "()Lcom/intellij/terminal/completion/ShellEnvironment;", "functionName", "", "getFunctionName", "()Ljava/lang/String;", "parameters", "", "getParameters", "()Ljava/util/List;", "isAvailable", "", "parseAliases", "", "text", "parseResult", "result", "splitIfNotEmpty", "delimiter", "Companion", "ShellEnvCommandResult", "intellij.terminal"})
@SourceDebugExtension(value={"SMAP\nDataProviderCommands.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataProviderCommands.kt\norg/jetbrains/plugins/terminal/exp/completion/GetEnvironmentCommand\n+ 2 Json.kt\nkotlinx/serialization/json/Json\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,88:1\n96#2:89\n11#3:90\n*S KotlinDebug\n*F\n+ 1 DataProviderCommands.kt\norg/jetbrains/plugins/terminal/exp/completion/GetEnvironmentCommand\n*L\n37#1:89\n80#1:90\n*E\n"})
public final class GetEnvironmentCommand
implements DataProviderCommand<ShellEnvironment> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BlockTerminalSession session;
    @NotNull
    private final String functionName;
    @NotNull
    private final List<String> parameters;
    @Nullable
    private final ShellEnvironment defaultResult;
    @NotNull
    private static final Logger LOG;

    public GetEnvironmentCommand(@NotNull BlockTerminalSession session2) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        this.session = session2;
        this.functionName = "__jetbrains_intellij_get_environment";
        this.parameters = CollectionsKt.emptyList();
    }

    @Override
    @NotNull
    public String getFunctionName() {
        return this.functionName;
    }

    @Override
    @NotNull
    public List<String> getParameters() {
        return this.parameters;
    }

    @Override
    @Nullable
    public ShellEnvironment getDefaultResult() {
        return this.defaultResult;
    }

    @Override
    public boolean isAvailable(@NotNull BlockTerminalSession session2) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        return DataProviderCommandsKt.isBashZshPwsh(session2);
    }

    @Override
    @Nullable
    public ShellEnvironment parseResult(@NotNull String result2) {
        ShellEnvCommandResult shellEnvCommandResult;
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        try {
            Json this_$iv = (Json)Json.Default;
            boolean $i$f$decodeFromString = false;
            this_$iv.getSerializersModule();
            shellEnvCommandResult = (ShellEnvCommandResult)this_$iv.decodeFromString((DeserializationStrategy)ShellEnvCommandResult.Companion.serializer(), result2);
        }
        catch (Throwable t) {
            LOG.error("Failed to parse shell env:\n" + result2, t);
            return null;
        }
        ShellEnvCommandResult rawEnv = shellEnvCommandResult;
        return new ShellEnvironment(this.splitIfNotEmpty(rawEnv.getEnvs(), "\n"), this.splitIfNotEmpty(rawEnv.getKeywords(), "\n"), this.splitIfNotEmpty(rawEnv.getBuiltins(), "\n"), this.splitIfNotEmpty(rawEnv.getFunctions(), "\n"), this.splitIfNotEmpty(rawEnv.getCommands(), "\n"), this.parseAliases(rawEnv.getAliases()));
    }

    private final Map<String, String> parseAliases(String text) {
        Map map2;
        TerminalShellSupport terminalShellSupport = TerminalShellSupport.Companion.findByShellType(this.session.getShellIntegration().getShellType());
        if (terminalShellSupport == null) {
            return MapsKt.emptyMap();
        }
        TerminalShellSupport shellSupport = terminalShellSupport;
        try {
            map2 = shellSupport.parseAliases(text);
        }
        catch (Throwable t) {
            LOG.error("Failed to parse aliases: " + text);
            map2 = MapsKt.emptyMap();
        }
        return map2;
    }

    private final List<String> splitIfNotEmpty(String $this$splitIfNotEmpty, String delimiter) {
        List list;
        if (((CharSequence)$this$splitIfNotEmpty).length() == 0) {
            list = CollectionsKt.emptyList();
        } else {
            String[] stringArray = new String[]{delimiter};
            list = StringsKt.split$default((CharSequence)$this$splitIfNotEmpty, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        }
        return list;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GetEnvironmentCommand.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/plugins/terminal/exp/completion/GetEnvironmentCommand$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.terminal"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Serializable
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0083\b\u0018\u0000 +2\u00020\u0001:\u0002*+BU\b\u0011\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\rB5\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u000eJ\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0005H\u00c6\u0003JE\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\u00052\b\b\u0002\u0010\t\u001a\u00020\u00052\b\b\u0002\u0010\n\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010 \u001a\u00020\u0003H\u00d6\u0001J\t\u0010!\u001a\u00020\u0005H\u00d6\u0001J&\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00002\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u00c1\u0001\u00a2\u0006\u0002\b)R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0011\u0010\t\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0010\u00a8\u0006,"}, d2={"Lorg/jetbrains/plugins/terminal/exp/completion/GetEnvironmentCommand$ShellEnvCommandResult;", "", "seen1", "", "envs", "", "keywords", "builtins", "functions", "commands", "aliases", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getAliases", "()Ljava/lang/String;", "getBuiltins", "getCommands", "getEnvs", "getFunctions", "getKeywords", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "toString", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$intellij_terminal", "$serializer", "Companion", "intellij.terminal"})
    private static final class ShellEnvCommandResult {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String envs;
        @NotNull
        private final String keywords;
        @NotNull
        private final String builtins;
        @NotNull
        private final String functions;
        @NotNull
        private final String commands;
        @NotNull
        private final String aliases;

        public ShellEnvCommandResult(@NotNull String envs, @NotNull String keywords, @NotNull String builtins, @NotNull String functions, @NotNull String commands2, @NotNull String aliases2) {
            Intrinsics.checkNotNullParameter((Object)envs, (String)"envs");
            Intrinsics.checkNotNullParameter((Object)keywords, (String)"keywords");
            Intrinsics.checkNotNullParameter((Object)builtins, (String)"builtins");
            Intrinsics.checkNotNullParameter((Object)functions, (String)"functions");
            Intrinsics.checkNotNullParameter((Object)commands2, (String)"commands");
            Intrinsics.checkNotNullParameter((Object)aliases2, (String)"aliases");
            this.envs = envs;
            this.keywords = keywords;
            this.builtins = builtins;
            this.functions = functions;
            this.commands = commands2;
            this.aliases = aliases2;
        }

        @NotNull
        public final String getEnvs() {
            return this.envs;
        }

        @NotNull
        public final String getKeywords() {
            return this.keywords;
        }

        @NotNull
        public final String getBuiltins() {
            return this.builtins;
        }

        @NotNull
        public final String getFunctions() {
            return this.functions;
        }

        @NotNull
        public final String getCommands() {
            return this.commands;
        }

        @NotNull
        public final String getAliases() {
            return this.aliases;
        }

        @NotNull
        public final String component1() {
            return this.envs;
        }

        @NotNull
        public final String component2() {
            return this.keywords;
        }

        @NotNull
        public final String component3() {
            return this.builtins;
        }

        @NotNull
        public final String component4() {
            return this.functions;
        }

        @NotNull
        public final String component5() {
            return this.commands;
        }

        @NotNull
        public final String component6() {
            return this.aliases;
        }

        @NotNull
        public final ShellEnvCommandResult copy(@NotNull String envs, @NotNull String keywords, @NotNull String builtins, @NotNull String functions, @NotNull String commands2, @NotNull String aliases2) {
            Intrinsics.checkNotNullParameter((Object)envs, (String)"envs");
            Intrinsics.checkNotNullParameter((Object)keywords, (String)"keywords");
            Intrinsics.checkNotNullParameter((Object)builtins, (String)"builtins");
            Intrinsics.checkNotNullParameter((Object)functions, (String)"functions");
            Intrinsics.checkNotNullParameter((Object)commands2, (String)"commands");
            Intrinsics.checkNotNullParameter((Object)aliases2, (String)"aliases");
            return new ShellEnvCommandResult(envs, keywords, builtins, functions, commands2, aliases2);
        }

        public static /* synthetic */ ShellEnvCommandResult copy$default(ShellEnvCommandResult shellEnvCommandResult, String string, String string2, String string3, String string4, String string5, String string6, int n, Object object) {
            if ((n & 1) != 0) {
                string = shellEnvCommandResult.envs;
            }
            if ((n & 2) != 0) {
                string2 = shellEnvCommandResult.keywords;
            }
            if ((n & 4) != 0) {
                string3 = shellEnvCommandResult.builtins;
            }
            if ((n & 8) != 0) {
                string4 = shellEnvCommandResult.functions;
            }
            if ((n & 0x10) != 0) {
                string5 = shellEnvCommandResult.commands;
            }
            if ((n & 0x20) != 0) {
                string6 = shellEnvCommandResult.aliases;
            }
            return shellEnvCommandResult.copy(string, string2, string3, string4, string5, string6);
        }

        @NotNull
        public String toString() {
            return "ShellEnvCommandResult(envs=" + this.envs + ", keywords=" + this.keywords + ", builtins=" + this.builtins + ", functions=" + this.functions + ", commands=" + this.commands + ", aliases=" + this.aliases + ")";
        }

        public int hashCode() {
            int result2 = this.envs.hashCode();
            result2 = result2 * 31 + this.keywords.hashCode();
            result2 = result2 * 31 + this.builtins.hashCode();
            result2 = result2 * 31 + this.functions.hashCode();
            result2 = result2 * 31 + this.commands.hashCode();
            result2 = result2 * 31 + this.aliases.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ShellEnvCommandResult)) {
                return false;
            }
            ShellEnvCommandResult shellEnvCommandResult = (ShellEnvCommandResult)other;
            if (!Intrinsics.areEqual((Object)this.envs, (Object)shellEnvCommandResult.envs)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.keywords, (Object)shellEnvCommandResult.keywords)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.builtins, (Object)shellEnvCommandResult.builtins)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.functions, (Object)shellEnvCommandResult.functions)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.commands, (Object)shellEnvCommandResult.commands)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.aliases, (Object)shellEnvCommandResult.aliases);
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$intellij_terminal(ShellEnvCommandResult self, CompositeEncoder output, SerialDescriptor serialDesc) {
            output.encodeStringElement(serialDesc, 0, self.envs);
            output.encodeStringElement(serialDesc, 1, self.keywords);
            output.encodeStringElement(serialDesc, 2, self.builtins);
            output.encodeStringElement(serialDesc, 3, self.functions);
            output.encodeStringElement(serialDesc, 4, self.commands);
            output.encodeStringElement(serialDesc, 5, self.aliases);
        }

        @Deprecated(message="This synthesized declaration should not be used directly", replaceWith=@ReplaceWith(expression="", imports={}), level=DeprecationLevel.HIDDEN)
        public /* synthetic */ ShellEnvCommandResult(int seen1, String envs, String keywords, String builtins, String functions, String commands2, String aliases2, SerializationConstructorMarker serializationConstructorMarker) {
            if (63 != (0x3F & seen1)) {
                PluginExceptionsKt.throwMissingFieldException((int)seen1, (int)63, (SerialDescriptor)ShellEnvCommandResult$$serializer.INSTANCE.getDescriptor());
            }
            this.envs = envs;
            this.keywords = keywords;
            this.builtins = builtins;
            this.functions = functions;
            this.commands = commands2;
            this.aliases = aliases2;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u00c6\u0001\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/plugins/terminal/exp/completion/GetEnvironmentCommand$ShellEnvCommandResult$Companion;", "", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lorg/jetbrains/plugins/terminal/exp/completion/GetEnvironmentCommand$ShellEnvCommandResult;", "intellij.terminal"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<ShellEnvCommandResult> serializer() {
                return (KSerializer)ShellEnvCommandResult$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

