/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.exp;

import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.find.FindUtil;
import com.intellij.find.SearchSession;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.jediterm.core.util.TermSize;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.exp.BlockTerminalSearchSession;
import org.jetbrains.plugins.terminal.exp.BlockTerminalSession;
import org.jetbrains.plugins.terminal.exp.CommandBlock;
import org.jetbrains.plugins.terminal.exp.CommandFinishedEvent;
import org.jetbrains.plugins.terminal.exp.ShellCommandListener;
import org.jetbrains.plugins.terminal.exp.TerminalFocusModel;
import org.jetbrains.plugins.terminal.exp.TerminalModel;
import org.jetbrains.plugins.terminal.exp.TerminalOutputController;
import org.jetbrains.plugins.terminal.exp.TerminalOutputModel;
import org.jetbrains.plugins.terminal.exp.TerminalPromptController;
import org.jetbrains.plugins.terminal.exp.TerminalSelectionController;
import org.jetbrains.plugins.terminal.exp.TerminalUiUtilsKt;
import org.jetbrains.plugins.terminal.exp.TerminalUsageLocalStorage;
import org.jetbrains.plugins.terminal.fus.TerminalShellInfoStatistics;
import org.jetbrains.plugins.terminal.fus.TerminalUsageTriggerCollector;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u0000 42\u00020\u0001:\u000234B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u0017\u001a\u00020\u0018H\u0007J\u001a\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u00112\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u001cJ\u0010\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u00182\u0006\u0010!\u001a\u00020\"H\u0002J\b\u0010#\u001a\u00020\u0018H\u0007J\u000e\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%H\u0002J\b\u0010'\u001a\u00020\u0018H\u0016J\b\u0010(\u001a\u00020\u0018H\u0002J\u000e\u0010)\u001a\u00020\u00182\u0006\u0010*\u001a\u00020+J\u0010\u0010,\u001a\u00020\u00182\u0006\u0010-\u001a\u00020.H\u0016J\u0010\u0010/\u001a\u00020\u00182\u0006\u00100\u001a\u00020.H\u0003J\u0010\u00101\u001a\u00020\u00182\u0006\u00100\u001a\u00020.H\u0007J\b\u00102\u001a\u00020\u0018H\u0007R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0014\u001a\u0004\u0018\u00010\u00132\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lorg/jetbrains/plugins/terminal/exp/BlockTerminalController;", "Lorg/jetbrains/plugins/terminal/exp/ShellCommandListener;", "project", "Lcom/intellij/openapi/project/Project;", "session", "Lorg/jetbrains/plugins/terminal/exp/BlockTerminalSession;", "outputController", "Lorg/jetbrains/plugins/terminal/exp/TerminalOutputController;", "promptController", "Lorg/jetbrains/plugins/terminal/exp/TerminalPromptController;", "selectionController", "Lorg/jetbrains/plugins/terminal/exp/TerminalSelectionController;", "focusModel", "Lorg/jetbrains/plugins/terminal/exp/TerminalFocusModel;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/terminal/exp/BlockTerminalSession;Lorg/jetbrains/plugins/terminal/exp/TerminalOutputController;Lorg/jetbrains/plugins/terminal/exp/TerminalPromptController;Lorg/jetbrains/plugins/terminal/exp/TerminalSelectionController;Lorg/jetbrains/plugins/terminal/exp/TerminalFocusModel;)V", "listeners", "", "Lorg/jetbrains/plugins/terminal/exp/BlockTerminalController$BlockTerminalControllerListener;", "<set-?>", "Lorg/jetbrains/plugins/terminal/exp/BlockTerminalSearchSession;", "searchSession", "getSearchSession", "()Lorg/jetbrains/plugins/terminal/exp/BlockTerminalSearchSession;", "activateSearchSession", "", "addListener", "listener", "disposable", "Lcom/intellij/openapi/Disposable;", "commandFinished", "event", "Lorg/jetbrains/plugins/terminal/exp/CommandFinishedEvent;", "finishCommandBlock", "exitCode", "", "finishSearchSession", "getDisposed", "Lkotlin/Function0;", "", "initialized", "onSearchClosed", "resize", "newSize", "Lcom/jediterm/core/util/TermSize;", "shellInfoReceived", "rawShellInfo", "", "startCommandBlock", "command", "startCommandExecution", "startSearchSession", "BlockTerminalControllerListener", "Companion", "intellij.terminal"})
@SourceDebugExtension(value={"SMAP\nBlockTerminalController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BlockTerminalController.kt\norg/jetbrains/plugins/terminal/exp/BlockTerminalController\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,172:1\n9#2:173\n1855#3,2:174\n1855#3,2:177\n1#4:176\n*S KotlinDebug\n*F\n+ 1 BlockTerminalController.kt\norg/jetbrains/plugins/terminal/exp/BlockTerminalController\n*L\n86#1:173\n127#1:174,2\n147#1:177,2\n*E\n"})
public final class BlockTerminalController
implements ShellCommandListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final BlockTerminalSession session;
    @NotNull
    private final TerminalOutputController outputController;
    @NotNull
    private final TerminalPromptController promptController;
    @NotNull
    private final TerminalSelectionController selectionController;
    @NotNull
    private final TerminalFocusModel focusModel;
    @NotNull
    private final List<BlockTerminalControllerListener> listeners;
    @Nullable
    private BlockTerminalSearchSession searchSession;
    @NotNull
    private static final DataKey<BlockTerminalController> KEY;

    public BlockTerminalController(@NotNull Project project, @NotNull BlockTerminalSession session2, @NotNull TerminalOutputController outputController, @NotNull TerminalPromptController promptController, @NotNull TerminalSelectionController selectionController, @NotNull TerminalFocusModel focusModel) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)outputController, (String)"outputController");
        Intrinsics.checkNotNullParameter((Object)promptController, (String)"promptController");
        Intrinsics.checkNotNullParameter((Object)selectionController, (String)"selectionController");
        Intrinsics.checkNotNullParameter((Object)focusModel, (String)"focusModel");
        this.project = project;
        this.session = session2;
        this.outputController = outputController;
        this.promptController = promptController;
        this.selectionController = selectionController;
        this.focusModel = focusModel;
        this.listeners = new CopyOnWriteArrayList();
        BlockTerminalSession.addCommandListener$default(this.session, this, null, 2, null);
        this.outputController.startCommandBlock(null, null);
        this.promptController.setPromptIsVisible(false);
        this.session.getModel().setCommandRunning(true);
    }

    @Nullable
    public final BlockTerminalSearchSession getSearchSession() {
        return this.searchSession;
    }

    public final void resize(@NotNull TermSize newSize) {
        Intrinsics.checkNotNullParameter((Object)newSize, (String)"newSize");
        this.session.postResize(newSize);
    }

    @RequiresEdt
    public final void startCommandExecution(@NotNull String command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        if (StringsKt.isBlank((CharSequence)command)) {
            this.promptController.reset();
            this.outputController.insertEmptyLine();
        } else {
            this.session.getCommandManager$intellij_terminal().sendCommandToExecute(command);
            this.outputController.doWhenNextBlockCanBeStarted((Function0<Unit>)((Function0)new Function0<Unit>(this, command){
                final /* synthetic */ BlockTerminalController this$0;
                final /* synthetic */ String $command;
                {
                    this.this$0 = $receiver;
                    this.$command = $command;
                    super(0);
                }

                public final void invoke() {
                    BlockTerminalController.access$startCommandBlock(this.this$0, this.$command);
                }
            }));
        }
        TerminalUsageTriggerCollector.triggerCommandStarted(this.project, command, true);
    }

    @RequiresEdt(generateAssertion=false)
    private final void startCommandBlock(String command) {
        this.outputController.startCommandBlock(command, this.promptController.getPromptRenderingInfo());
        Disposable disposable = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        Disposable disposable2 = disposable;
        this.outputController.getOutputModel().addListener(new TerminalOutputModel.TerminalOutputListener(this, disposable2){
            final /* synthetic */ BlockTerminalController this$0;
            final /* synthetic */ Disposable $disposable;
            {
                this.this$0 = $receiver;
                this.$disposable = $disposable;
            }

            public void blockCreated(@NotNull CommandBlock block2) {
                Intrinsics.checkNotNullParameter((Object)block2, (String)"block");
                BlockTerminalController.access$getPromptController$p(this.this$0).setPromptIsVisible(false);
                Disposer.dispose((Disposable)this.$disposable);
            }
        }, disposable2);
        this.session.getModel().setCommandRunning(true);
        TerminalUsageLocalStorage.Companion.getInstance().recordCommandExecuted(this.session.getShellIntegration().getShellType().toString());
    }

    @Override
    public void shellInfoReceived(@NotNull String rawShellInfo) {
        Intrinsics.checkNotNullParameter((Object)rawShellInfo, (String)"rawShellInfo");
        BlockTerminalController $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(BlockTerminalController.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.info("Started shell info: " + rawShellInfo);
        ApplicationManager.getApplication().executeOnPooledThread(() -> BlockTerminalController.shellInfoReceived$lambda$1(rawShellInfo, this));
    }

    @Override
    public void initialized() {
        this.finishCommandBlock(0);
    }

    @Override
    public void commandFinished(@NotNull CommandFinishedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.finishCommandBlock(event.getExitCode());
        TerminalUsageTriggerCollector.INSTANCE.triggerCommandFinished-Wn2Vu4Y(this.project, event.getCommand(), event.getExitCode(), event.getDuration-UwyO8pc());
    }

    private final void finishCommandBlock(int exitCode) {
        this.outputController.finishCommandBlock(exitCode);
        TerminalModel model = this.session.getModel();
        model.setCommandRunning(false);
        Function0<Boolean> function0 = this.getDisposed();
        ModalityState modalityState = ModalityState.any();
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"any(...)");
        TerminalUiUtilsKt.invokeLater(function0, modalityState, () -> BlockTerminalController.finishCommandBlock$lambda$2(this));
    }

    @RequiresEdt
    public final void startSearchSession() {
        BlockTerminalSearchSession session2;
        FindModel findModel = new FindModel();
        findModel.copyFrom(FindManager.getInstance((Project)this.project).getFindInFileModel());
        findModel.setWholeWordsOnly(false);
        BlockTerminalSearchSession.Companion.setSearchInBlock(findModel, this.selectionController.getPrimarySelection() != null);
        EditorEx editor = this.outputController.getOutputModel().getEditor();
        FindUtil.configureFindModel((boolean)false, (Editor)((Editor)editor), (FindModel)findModel, (boolean)false);
        findModel.setGlobal(false);
        this.searchSession = session2 = new BlockTerminalSearchSession(this.project, editor, findModel, this.outputController.getOutputModel(), this.outputController.getSelectionModel(), (Function0<Unit>)((Function0)new Function0<Unit>((Object)this){

            public final void invoke() {
                BlockTerminalController.access$onSearchClosed((BlockTerminalController)this.receiver);
            }
        }));
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BlockTerminalControllerListener it = (BlockTerminalControllerListener)element$iv;
            boolean bl = false;
            it.searchSessionStarted(session2);
        }
        session2.getComponent().requestFocusInTheSearchFieldAndSelectContent(this.project);
    }

    @RequiresEdt
    public final void activateSearchSession() {
        BlockTerminalSearchSession blockTerminalSearchSession = this.searchSession;
        if (blockTerminalSearchSession == null) {
            return;
        }
        BlockTerminalSearchSession session2 = blockTerminalSearchSession;
        EditorEx editor = this.outputController.getOutputModel().getEditor();
        session2.getComponent().requestFocusInTheSearchFieldAndSelectContent(this.project);
        FindUtil.configureFindModel((boolean)false, (Editor)((Editor)editor), (FindModel)session2.getFindModel(), (boolean)false);
        BlockTerminalSearchSession.Companion.setSearchInBlock(session2.getFindModel(), this.selectionController.getPrimarySelection() != null);
        session2.getFindModel().setGlobal(false);
    }

    @RequiresEdt
    public final void finishSearchSession() {
        block0: {
            BlockTerminalSearchSession blockTerminalSearchSession = this.searchSession;
            if (blockTerminalSearchSession == null) break block0;
            blockTerminalSearchSession.close();
        }
    }

    private final void onSearchClosed() {
        BlockTerminalSearchSession blockTerminalSearchSession = this.searchSession;
        if (blockTerminalSearchSession != null) {
            BlockTerminalSearchSession session2 = blockTerminalSearchSession;
            boolean bl = false;
            Iterable $this$forEach$iv = this.listeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                BlockTerminalControllerListener it = (BlockTerminalControllerListener)element$iv;
                boolean bl2 = false;
                it.searchSessionFinished(session2);
            }
        }
        this.searchSession = null;
        if (this.selectionController.getPrimarySelection() != null || this.session.getModel().isCommandRunning()) {
            this.focusModel.focusOutput();
        } else {
            this.focusModel.focusPrompt();
        }
    }

    public final void addListener(@NotNull BlockTerminalControllerListener listener, @Nullable Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.listeners.add(listener);
        if (disposable != null) {
            Disposer.register((Disposable)disposable, () -> BlockTerminalController.addListener$lambda$6(this, listener));
        }
    }

    public static /* synthetic */ void addListener$default(BlockTerminalController blockTerminalController, BlockTerminalControllerListener blockTerminalControllerListener, Disposable disposable, int n, Object object) {
        if ((n & 2) != 0) {
            disposable = null;
        }
        blockTerminalController.addListener(blockTerminalControllerListener, disposable);
    }

    private final Function0<Boolean> getDisposed() {
        return TerminalUiUtilsKt.getDisposed((Editor)this.outputController.getOutputModel().getEditor());
    }

    private static final void shellInfoReceived$lambda$1(String $rawShellInfo, BlockTerminalController this$0) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)$rawShellInfo, (String)"$rawShellInfo");
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            TerminalShellInfoStatistics.LoggableShellInfo loggableShellInfo = TerminalShellInfoStatistics.INSTANCE.getLoggableShellInfo($rawShellInfo);
            if (loggableShellInfo == null) break block0;
            TerminalShellInfoStatistics.LoggableShellInfo it = loggableShellInfo;
            boolean bl = false;
            TerminalUsageTriggerCollector.INSTANCE.triggerLocalShellStarted$intellij_terminal(this$0.project, this$0.session.getShellIntegration().getShellType().toString(), it);
        }
    }

    private static final void finishCommandBlock$lambda$2(BlockTerminalController this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.promptController.reset();
        this$0.promptController.setPromptIsVisible(true);
    }

    private static final void addListener$lambda$6(BlockTerminalController this$0, BlockTerminalControllerListener $listener) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$listener, (String)"$listener");
        this$0.listeners.remove($listener);
    }

    public static final /* synthetic */ void access$startCommandBlock(BlockTerminalController $this, String command) {
        $this.startCommandBlock(command);
    }

    public static final /* synthetic */ TerminalPromptController access$getPromptController$p(BlockTerminalController $this) {
        return $this.promptController;
    }

    public static final /* synthetic */ void access$onSearchClosed(BlockTerminalController $this) {
        $this.onSearchClosed();
    }

    static {
        DataKey dataKey = DataKey.create((String)"BlockTerminalController");
        Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"create(...)");
        KEY = dataKey;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0007\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/plugins/terminal/exp/BlockTerminalController$BlockTerminalControllerListener;", "", "searchSessionFinished", "", "session", "Lcom/intellij/find/SearchSession;", "searchSessionStarted", "intellij.terminal"})
    public static interface BlockTerminalControllerListener {
        default public void searchSessionStarted(@NotNull SearchSession session2) {
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        }

        default public void searchSessionFinished(@NotNull SearchSession session2) {
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/plugins/terminal/exp/BlockTerminalController$Companion;", "", "()V", "KEY", "Lcom/intellij/openapi/actionSystem/DataKey;", "Lorg/jetbrains/plugins/terminal/exp/BlockTerminalController;", "getKEY", "()Lcom/intellij/openapi/actionSystem/DataKey;", "intellij.terminal"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DataKey<BlockTerminalController> getKEY() {
            return KEY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

