/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.relocated.apache.batik.svggen;

import java.awt.BasicStroke;
import org.jetbrains.relocated.apache.batik.ext.awt.g2d.GraphicContext;
import org.jetbrains.relocated.apache.batik.svggen.AbstractSVGConverter;
import org.jetbrains.relocated.apache.batik.svggen.SVGDescriptor;
import org.jetbrains.relocated.apache.batik.svggen.SVGGeneratorContext;
import org.jetbrains.relocated.apache.batik.svggen.SVGStrokeDescriptor;

public class SVGBasicStroke
extends AbstractSVGConverter {
    public SVGBasicStroke(SVGGeneratorContext generatorContext) {
        super(generatorContext);
    }

    @Override
    public SVGDescriptor toSVG(GraphicContext gc) {
        if (gc.getStroke() instanceof BasicStroke) {
            return this.toSVG((BasicStroke)gc.getStroke());
        }
        return null;
    }

    public final SVGStrokeDescriptor toSVG(BasicStroke stroke) {
        String strokeWidth = this.doubleString(stroke.getLineWidth());
        String capStyle = SVGBasicStroke.endCapToSVG(stroke.getEndCap());
        String joinStyle = SVGBasicStroke.joinToSVG(stroke.getLineJoin());
        String miterLimit = this.doubleString(stroke.getMiterLimit());
        float[] array2 = stroke.getDashArray();
        String dashArray2 = null;
        dashArray2 = array2 != null ? this.dashArrayToSVG(array2) : "none";
        String dashOffset = this.doubleString(stroke.getDashPhase());
        return new SVGStrokeDescriptor(strokeWidth, capStyle, joinStyle, miterLimit, dashArray2, dashOffset);
    }

    private final String dashArrayToSVG(float[] dashArray2) {
        StringBuffer dashArrayBuf = new StringBuffer(dashArray2.length * 8);
        if (dashArray2.length > 0) {
            dashArrayBuf.append(this.doubleString(dashArray2[0]));
        }
        for (int i = 1; i < dashArray2.length; ++i) {
            dashArrayBuf.append(",");
            dashArrayBuf.append(this.doubleString(dashArray2[i]));
        }
        return dashArrayBuf.toString();
    }

    private static String joinToSVG(int lineJoin) {
        switch (lineJoin) {
            case 2: {
                return "bevel";
            }
            case 1: {
                return "round";
            }
        }
        return "miter";
    }

    private static String endCapToSVG(int endCap) {
        switch (endCap) {
            case 0: {
                return "butt";
            }
            case 1: {
                return "round";
            }
        }
        return "square";
    }
}

