/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.datamodel.svg.dom;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.intern.observable.property.Property;
import org.jetbrains.letsPlot.commons.intern.observable.property.WritableProperty;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgAttributeSpec;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgColor;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgGraphicsElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgPlatformPeer;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgShape;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgTransform;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgTransformable;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgUtils;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 $2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001$B'\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tB\u0005\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0014H\u0016J\u0010\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00180\u0017H\u0016J\u0010\u0010\u0019\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0014H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0016J\u0010\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0016J\u0010\u0010\u001e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0014H\u0016J\u0010\u0010\u001f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00180\u0017H\u0016J\u0010\u0010 \u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0014H\u0016J\u0010\u0010!\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0014H\u0016J\u0010\u0010\"\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010#0\u0014H\u0016J\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0014J\u000e\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0014J\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0014J\u000e\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0014R\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006%"}, d2={"Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgLineElement;", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgGraphicsElement;", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgTransformable;", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgShape;", "x1", "", "y1", "x2", "y2", "(DDDD)V", "()V", "bBox", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "getBBox", "()Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "elementName", "", "getElementName", "()Ljava/lang/String;", "fill", "Lorg/jetbrains/letsPlot/commons/intern/observable/property/Property;", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgColor;", "fillColor", "Lorg/jetbrains/letsPlot/commons/intern/observable/property/WritableProperty;", "Lorg/jetbrains/letsPlot/commons/values/Color;", "fillOpacity", "pointToAbsoluteCoordinates", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "point", "pointToTransformedCoordinates", "stroke", "strokeColor", "strokeOpacity", "strokeWidth", "transform", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgTransform;", "Companion", "datamodel"})
public final class SvgLineElement
extends SvgGraphicsElement
implements SvgTransformable,
SvgShape {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String elementName;
    @NotNull
    private static final SvgAttributeSpec<Double> X1 = SvgAttributeSpec.Companion.createSpec("x1");
    @NotNull
    private static final SvgAttributeSpec<Double> Y1 = SvgAttributeSpec.Companion.createSpec("y1");
    @NotNull
    private static final SvgAttributeSpec<Double> X2 = SvgAttributeSpec.Companion.createSpec("x2");
    @NotNull
    private static final SvgAttributeSpec<Double> Y2 = SvgAttributeSpec.Companion.createSpec("y2");

    public SvgLineElement() {
        this.elementName = "line";
    }

    @Override
    @NotNull
    public String getElementName() {
        return this.elementName;
    }

    @Override
    @NotNull
    public DoubleRectangle getBBox() {
        SvgPlatformPeer svgPlatformPeer = this.container().getPeer();
        Intrinsics.checkNotNull((Object)svgPlatformPeer);
        return svgPlatformPeer.getBBox(this);
    }

    public SvgLineElement(double x1, double y1, double x2, double y2) {
        this();
        this.setAttribute(X1, x1);
        this.setAttribute(Y1, y1);
        this.setAttribute(X2, x2);
        this.setAttribute(Y2, y2);
    }

    @NotNull
    public final Property<Double> x1() {
        return this.getAttribute(X1);
    }

    @NotNull
    public final Property<Double> y1() {
        return this.getAttribute(Y1);
    }

    @NotNull
    public final Property<Double> x2() {
        return this.getAttribute(X2);
    }

    @NotNull
    public final Property<Double> y2() {
        return this.getAttribute(Y2);
    }

    @Override
    @NotNull
    public Property<SvgTransform> transform() {
        return this.getAttribute(SvgTransformable.Companion.getTRANSFORM());
    }

    @Override
    @NotNull
    public Property<SvgColor> fill() {
        return this.getAttribute(SvgShape.Companion.getFILL());
    }

    @Override
    @NotNull
    public WritableProperty<Color> fillColor() {
        return SvgUtils.INSTANCE.colorAttributeTransform$datamodel(this.fill(), this.fillOpacity());
    }

    @Override
    @NotNull
    public Property<Double> fillOpacity() {
        return this.getAttribute(SvgShape.Companion.getFILL_OPACITY());
    }

    @Override
    @NotNull
    public Property<SvgColor> stroke() {
        return this.getAttribute(SvgShape.Companion.getSTROKE());
    }

    @Override
    @NotNull
    public WritableProperty<Color> strokeColor() {
        return SvgUtils.INSTANCE.colorAttributeTransform$datamodel(this.stroke(), this.strokeOpacity());
    }

    @Override
    @NotNull
    public Property<Double> strokeOpacity() {
        return this.getAttribute(SvgShape.Companion.getSTROKE_OPACITY());
    }

    @Override
    @NotNull
    public Property<Double> strokeWidth() {
        return this.getAttribute(SvgShape.Companion.getSTROKE_WIDTH());
    }

    @Override
    @NotNull
    public DoubleVector pointToTransformedCoordinates(@NotNull DoubleVector point2) {
        Intrinsics.checkNotNullParameter((Object)point2, (String)"point");
        SvgPlatformPeer svgPlatformPeer = this.container().getPeer();
        Intrinsics.checkNotNull((Object)svgPlatformPeer);
        return svgPlatformPeer.invertTransform(this, point2);
    }

    @Override
    @NotNull
    public DoubleVector pointToAbsoluteCoordinates(@NotNull DoubleVector point2) {
        Intrinsics.checkNotNullParameter((Object)point2, (String)"point");
        SvgPlatformPeer svgPlatformPeer = this.container().getPeer();
        Intrinsics.checkNotNull((Object)svgPlatformPeer);
        return svgPlatformPeer.applyTransform(this, point2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgLineElement$Companion;", "", "()V", "X1", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgAttributeSpec;", "", "getX1", "()Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgAttributeSpec;", "X2", "getX2", "Y1", "getY1", "Y2", "getY2", "datamodel"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SvgAttributeSpec<Double> getX1() {
            return X1;
        }

        @NotNull
        public final SvgAttributeSpec<Double> getY1() {
            return Y1;
        }

        @NotNull
        public final SvgAttributeSpec<Double> getX2() {
            return X2;
        }

        @NotNull
        public final SvgAttributeSpec<Double> getY2() {
            return Y2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

