/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.spec.front.tiles;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.core.plot.base.Aes;
import org.jetbrains.letsPlot.core.plot.base.DataFrame;
import org.jetbrains.letsPlot.core.plot.base.Scale;
import org.jetbrains.letsPlot.core.plot.base.Stat;
import org.jetbrains.letsPlot.core.plot.base.data.DataFrameUtil;
import org.jetbrains.letsPlot.core.plot.base.theme.FontFamilyRegistry;
import org.jetbrains.letsPlot.core.plot.base.theme.Theme;
import org.jetbrains.letsPlot.core.plot.base.tooltip.ContextualMappingProvider;
import org.jetbrains.letsPlot.core.plot.builder.MarginalLayerUtil;
import org.jetbrains.letsPlot.core.plot.builder.VarBinding;
import org.jetbrains.letsPlot.core.plot.builder.assemble.GeomLayerBuilder;
import org.jetbrains.letsPlot.core.plot.builder.assemble.geom.GeomProvider;
import org.jetbrains.letsPlot.core.plot.builder.coord.CoordProvider;
import org.jetbrains.letsPlot.core.plot.builder.tooltip.conf.GeomInteraction;
import org.jetbrains.letsPlot.core.spec.config.LayerConfig;
import org.jetbrains.letsPlot.core.spec.front.GeomInteractionUtil;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0003\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0016\u0010\t\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\u0004\u0012\u00020\u00060\u0004J(\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011JR\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\b0\u00132\u001c\u0010\u0015\u001a\u0018\u0012\u0014\u0012\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\u0004\u0012\u00020\u00060\u00040\u00132\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0019JF\u0010\u001a\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\u0004\u0012\u00020\u00060\u00042\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00132\u0006\u0010\u001d\u001a\u00020\u00192\u0016\u0010\u001e\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\u0004\u0012\u00020\u00060\u0004H\u0002\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/letsPlot/core/spec/front/tiles/PlotGeomTilesUtil;", "", "()V", "buildLayerScaleMap", "", "Lorg/jetbrains/letsPlot/core/plot/base/Aes;", "Lorg/jetbrains/letsPlot/core/plot/base/Scale;", "layerConfig", "Lorg/jetbrains/letsPlot/core/spec/config/LayerConfig;", "commonScales", "createLayerBuilder", "Lorg/jetbrains/letsPlot/core/plot/builder/assemble/GeomLayerBuilder;", "fontFamilyRegistry", "Lorg/jetbrains/letsPlot/core/plot/base/theme/FontFamilyRegistry;", "geomInteraction", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/conf/GeomInteraction;", "theme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/Theme;", "geomInteractionByLayer", "", "layerConfigs", "scaleMapByLayer", "coordProvider", "Lorg/jetbrains/letsPlot/core/plot/builder/coord/CoordProvider;", "isLiveMap", "", "namePositionalScalesAfterStatVariables", "layerVarBindings", "Lorg/jetbrains/letsPlot/core/plot/builder/VarBinding;", "isYOrientation", "commonScaleMap", "plot-stem"})
@SourceDebugExtension(value={"SMAP\nPlotGeomTilesUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlotGeomTilesUtil.kt\norg/jetbrains/letsPlot/core/spec/front/tiles/PlotGeomTilesUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,169:1\n766#2:170\n857#2,2:171\n819#2:173\n847#2,2:174\n766#2:176\n857#2,2:177\n1179#2,2:179\n1253#2,4:181\n1559#2:185\n1590#2,3:186\n777#2:189\n788#2:190\n1864#2,2:191\n789#2,2:193\n1866#2:195\n791#2:196\n1747#2,3:197\n1593#2:200\n*S KotlinDebug\n*F\n+ 1 PlotGeomTilesUtil.kt\norg/jetbrains/letsPlot/core/spec/front/tiles/PlotGeomTilesUtil\n*L\n53#1:170\n53#1:171,2\n54#1:173\n54#1:174,2\n55#1:176\n55#1:177,2\n57#1:179,2\n57#1:181,4\n75#1:185\n75#1:186,3\n81#1:189\n81#1:190\n81#1:191,2\n81#1:193,2\n81#1:195\n81#1:196\n82#1:197,3\n75#1:200\n*E\n"})
public final class PlotGeomTilesUtil {
    @NotNull
    public static final PlotGeomTilesUtil INSTANCE = new PlotGeomTilesUtil();

    private PlotGeomTilesUtil() {
    }

    @NotNull
    public final Map<Aes<?>, Scale> buildLayerScaleMap(@NotNull LayerConfig layerConfig, @NotNull Map<Aes<?>, ? extends Scale> commonScales) {
        Map<Aes<?>, Scale> map2;
        Intrinsics.checkNotNullParameter((Object)layerConfig, (String)"layerConfig");
        Intrinsics.checkNotNullParameter(commonScales, (String)"commonScales");
        Map<Aes<?>, Scale> layerRenamedScales = this.namePositionalScalesAfterStatVariables(layerConfig.getVarBindings(), layerConfig.isYOrientation(), commonScales);
        Map<Aes<?>, Scale> layerScales = MapsKt.plus(commonScales, layerRenamedScales);
        boolean bl = layerConfig.isMarginal();
        if (bl) {
            map2 = MarginalLayerUtil.INSTANCE.toMarginalScaleMap(layerScales, layerConfig.getMarginalSide(), false);
        } else if (!bl) {
            map2 = layerScales;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return map2;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<Aes<?>, Scale> namePositionalScalesAfterStatVariables(List<VarBinding> layerVarBindings, boolean isYOrientation, Map<Aes<?>, ? extends Scale> commonScaleMap) {
        void $this$associateTo$iv$iv;
        Iterable $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv;
        VarBinding it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = layerVarBindings;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (VarBinding)element$iv$iv;
            boolean bl = false;
            if (!it.getVariable().isStat()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filterNot = false;
        $this$filterTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (VarBinding)element$iv$iv;
            boolean bl = false;
            if (Intrinsics.areEqual(it.getAes(), Aes.Companion.getX()) || Intrinsics.areEqual(it.getAes(), Aes.Companion.getY())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterNot$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterNotTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (VarBinding)element$iv$iv;
            boolean bl = false;
            if (!Aes.Companion.isPositionalXY(it.getAes())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List statPositionalBindings = (List)destination$iv$iv;
        Iterable $this$associate$iv = statPositionalBindings;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associate$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Aes<Double> aes2;
            Map map2 = destination$iv$iv2;
            VarBinding binding = (VarBinding)element$iv$iv;
            boolean bl = false;
            boolean bl2 = isYOrientation;
            if (bl2) {
                aes2 = Aes.Companion.isPositionalX(binding.getAes()) ? Aes.Companion.getY() : Aes.Companion.getX();
            } else if (!bl2) {
                aes2 = Aes.Companion.isPositionalX(binding.getAes()) ? Aes.Companion.getX() : Aes.Companion.getY();
            } else {
                throw new NoWhenBranchMatchedException();
            }
            Aes<Double> positionalAes = aes2;
            Scale scaleProto = (Scale)MapsKt.getValue(commonScaleMap, positionalAes);
            Scale aesScale = scaleProto.with().name(binding.getVariable().getLabel()).build();
            Pair pair2 = TuplesKt.to(binding.getAes(), (Object)aesScale);
            map2.put(pair2.getFirst(), pair2.getSecond());
        }
        return destination$iv$iv2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<GeomInteraction> geomInteractionByLayer(@NotNull List<LayerConfig> layerConfigs, @NotNull List<? extends Map<Aes<?>, ? extends Scale>> scaleMapByLayer, @NotNull CoordProvider coordProvider, @NotNull Theme theme2, boolean isLiveMap) {
        void $this$mapIndexedTo$iv$iv;
        Intrinsics.checkNotNullParameter(layerConfigs, (String)"layerConfigs");
        Intrinsics.checkNotNullParameter(scaleMapByLayer, (String)"scaleMapByLayer");
        Intrinsics.checkNotNullParameter((Object)coordProvider, (String)"coordProvider");
        Intrinsics.checkNotNullParameter((Object)theme2, (String)"theme");
        Iterable $this$mapIndexed$iv = layerConfigs;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            GeomInteraction geomInteraction;
            void layerConfig;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            LayerConfig layerConfig2 = (LayerConfig)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (layerConfig.isMarginal()) {
                geomInteraction = null;
            } else {
                boolean bl2;
                void layerIndex;
                block9: {
                    void $this$any$iv;
                    void $this$filterIndexedTo$iv$iv;
                    Iterable $this$filterIndexed$iv;
                    Iterable iterable2 = layerConfigs;
                    boolean $i$f$filterIndexed = false;
                    Iterator iterator2 = $this$filterIndexed$iv;
                    Collection destination$iv$iv2 = new ArrayList();
                    boolean $i$f$filterIndexedTo = false;
                    void $this$forEachIndexed$iv$iv$iv = $this$filterIndexedTo$iv$iv;
                    boolean $i$f$forEachIndexed = false;
                    int index$iv$iv$iv = 0;
                    for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
                        void element$iv$iv;
                        int n3;
                        if ((n3 = index$iv$iv$iv++) < 0) {
                            CollectionsKt.throwIndexOverflow();
                        }
                        Object t = item$iv$iv$iv;
                        int index$iv$iv2 = n3;
                        boolean bl3 = false;
                        LayerConfig cfr_ignored_0 = (LayerConfig)element$iv$iv;
                        int index = index$iv$iv2;
                        boolean bl4 = false;
                        if (!(index != layerIndex)) continue;
                        destination$iv$iv2.add(element$iv$iv);
                    }
                    $this$filterIndexed$iv = (List)destination$iv$iv2;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl2 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            Collection collection2;
                            LayerConfig layer = (LayerConfig)element$iv;
                            boolean bl5 = false;
                            boolean bl6 = !((Collection)layer.getVarBindings()).isEmpty() && !layer.getTooltips().hideTooltips() || !((collection2 = (Collection)layer.getTooltips().getTooltipLinePatterns()) == null || collection2.isEmpty());
                            if (!bl6) continue;
                            bl2 = true;
                            break block9;
                        }
                        bl2 = false;
                    }
                }
                boolean otherLayerWithTooltips = bl2;
                geomInteraction = GeomInteractionUtil.INSTANCE.configGeomTargets$plot_stem((LayerConfig)layerConfig, scaleMapByLayer.get((int)layerIndex), otherLayerWithTooltips, isLiveMap, coordProvider.isLinear(), theme2);
            }
            collection.add(geomInteraction);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final GeomLayerBuilder createLayerBuilder(@NotNull LayerConfig layerConfig, @NotNull FontFamilyRegistry fontFamilyRegistry, @Nullable GeomInteraction geomInteraction, @NotNull Theme theme2) {
        Object it;
        Intrinsics.checkNotNullParameter((Object)layerConfig, (String)"layerConfig");
        Intrinsics.checkNotNullParameter((Object)fontFamilyRegistry, (String)"fontFamilyRegistry");
        Intrinsics.checkNotNullParameter((Object)theme2, (String)"theme");
        GeomProvider geomProvider = layerConfig.getGeomProto().geomProvider(layerConfig, layerConfig.getAopConversion(), theme2.getExponentFormat().getSuperscript());
        Stat stat = layerConfig.getStat();
        GeomLayerBuilder layerBuilder = new GeomLayerBuilder(geomProvider, stat, layerConfig.getPosProvider(), fontFamilyRegistry).yOrientation(layerConfig.isYOrientation()).marginal(layerConfig.isMarginal(), layerConfig.getMarginalSide(), layerConfig.getMarginalSize());
        layerBuilder.colorByAes(layerConfig.getColorByAes()).fillByAes(layerConfig.getFillByAes());
        layerBuilder.geomTheme(theme2.geometries(layerConfig.getGeomProto().getGeomKind()));
        layerBuilder.superscriptExponent(theme2.getExponentFormat().getSuperscript());
        Map<Aes<?>, Object> constantAesMap = layerConfig.getConstantsMap();
        for (Aes<?> aes2 : constantAesMap.keySet()) {
            Intrinsics.checkNotNull(aes2, (String)"null cannot be cast to non-null type org.jetbrains.letsPlot.core.plot.base.Aes<kotlin.Any>");
            Object object = constantAesMap.get(aes2);
            Intrinsics.checkNotNull((Object)object);
            layerBuilder.addConstantAes(aes2, object);
        }
        if (layerConfig.hasExplicitGrouping()) {
            String string = layerConfig.getExplicitGroupingVarName();
            Intrinsics.checkNotNull((Object)string);
            layerBuilder.groupingVarName(string);
        }
        DataFrame.Variable variable = DataFrameUtil.INSTANCE.variables(layerConfig.getCombinedData()).get("__geo_id__");
        if (variable != null) {
            it = variable;
            boolean bl = false;
            layerBuilder.pathIdVarName("__geo_id__");
        }
        List<VarBinding> bindings = layerConfig.getVarBindings();
        for (VarBinding binding : bindings) {
            layerBuilder.addBinding(binding);
        }
        layerBuilder.disableLegend(layerConfig.isLegendDisabled());
        GeomInteraction geomInteraction2 = geomInteraction;
        if (geomInteraction2 != null) {
            it = geomInteraction2;
            boolean bl = false;
            layerBuilder.locatorLookupSpec(((GeomInteraction)it).createLookupSpec()).contextualMappingProvider((ContextualMappingProvider)it);
        }
        layerBuilder.annotationSpecification(layerConfig.getAnnotations(), theme2.annotations().textStyle(), theme2.annotations().useCustomColor());
        return layerBuilder;
    }
}

