/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.spec.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.core.plot.base.Aes;
import org.jetbrains.letsPlot.core.plot.base.DataFrame;
import org.jetbrains.letsPlot.core.plot.builder.VarBinding;
import org.jetbrains.letsPlot.core.spec.GeomProto;
import org.jetbrains.letsPlot.core.spec.Option;
import org.jetbrains.letsPlot.core.spec.config.OptionsAccessor;
import org.jetbrains.letsPlot.core.spec.conversion.AesOptionConversion;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JH\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0018\u0010\b\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\t2\u0010\u0010\f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\r2\u0006\u0010\u000e\u001a\u00020\u000fJ8\u0010\u0010\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n\u0012\u0004\u0012\u00020\u00010\t2\u0006\u0010\u0011\u001a\u00020\u00122\u0010\u0010\f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\r2\u0006\u0010\u0013\u001a\u00020\u0014J\"\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00010\t2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0018\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/letsPlot/core/spec/config/LayerConfigUtil;", "", "()V", "createBindings", "", "Lorg/jetbrains/letsPlot/core/plot/builder/VarBinding;", "data", "Lorg/jetbrains/letsPlot/core/plot/base/DataFrame;", "mapping", "", "Lorg/jetbrains/letsPlot/core/plot/base/Aes;", "Lorg/jetbrains/letsPlot/core/plot/base/DataFrame$Variable;", "consumedAesSet", "", "clientSide", "", "initConstants", "layerOptions", "Lorg/jetbrains/letsPlot/core/spec/config/OptionsAccessor;", "aopConversion", "Lorg/jetbrains/letsPlot/core/spec/conversion/AesOptionConversion;", "positionAdjustmentOptions", "", "geomProto", "Lorg/jetbrains/letsPlot/core/spec/GeomProto;", "plot-stem"})
@SourceDebugExtension(value={"SMAP\nLayerConfigUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LayerConfigUtil.kt\norg/jetbrains/letsPlot/core/spec/config/LayerConfigUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,94:1\n766#2:95\n857#2,2:96\n1271#2,2:98\n1285#2,4:100\n494#3,7:104\n215#4,2:111\n*S KotlinDebug\n*F\n+ 1 LayerConfigUtil.kt\norg/jetbrains/letsPlot/core/spec/config/LayerConfigUtil\n*L\n55#1:95\n55#1:96,2\n56#1:98,2\n56#1:100,4\n57#1:104,7\n58#1:111,2\n*E\n"})
public final class LayerConfigUtil {
    @NotNull
    public static final LayerConfigUtil INSTANCE = new LayerConfigUtil();

    private LayerConfigUtil() {
    }

    @NotNull
    public final Map<String, Object> positionAdjustmentOptions(@NotNull OptionsAccessor layerOptions, @NotNull GeomProto geomProto) {
        Intrinsics.checkNotNullParameter((Object)layerOptions, (String)"layerOptions");
        Intrinsics.checkNotNullParameter((Object)geomProto, (String)"geomProto");
        Map preferredPosOptions = geomProto.preferredPositionAdjustmentOptions(layerOptions);
        boolean hasOwnPositionOptions = geomProto.hasOwnPositionAdjustmentOptions(layerOptions);
        Object v = layerOptions.get("position");
        Map specifiedPosOptions = v == null ? preferredPosOptions : (v instanceof Map ? (Map)v : MapsKt.mapOf((Pair)TuplesKt.to((Object)"name", (Object)v.toString())));
        return Intrinsics.areEqual(specifiedPosOptions.get("name"), preferredPosOptions.get("name")) ? (hasOwnPositionOptions ? MapsKt.plus((Map)specifiedPosOptions, (Map)preferredPosOptions) : MapsKt.plus((Map)preferredPosOptions, (Map)specifiedPosOptions)) : (hasOwnPositionOptions ? preferredPosOptions : specifiedPosOptions);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<Aes<?>, Object> initConstants(@NotNull OptionsAccessor layerOptions, @NotNull Set<? extends Aes<?>> consumedAesSet, @NotNull AesOptionConversion aopConversion) {
        void $this$forEach$iv;
        Map $this$filterValues$iv;
        Map $this$associateWith$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)layerOptions, (String)"layerOptions");
        Intrinsics.checkNotNullParameter(consumedAesSet, (String)"consumedAesSet");
        Intrinsics.checkNotNullParameter((Object)aopConversion, (String)"aopConversion");
        HashMap result2 = new HashMap();
        Iterable<String> iterable = Option.Mapping.INSTANCE.getREAL_AES_OPTION_NAMES();
        boolean $i$f$filter232 = false;
        void var7_9 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean bl = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String p0 = (String)element$iv$iv;
            boolean bl2 = false;
            if (!layerOptions.has(p0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        Option.Mapping $i$f$filter232 = Option.Mapping.INSTANCE;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)((Object)$this$associateWith$iv), (int)10)), (int)16));
        void entry = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : entry) {
            void p0;
            String bl2 = (String)element$iv$iv;
            Object e = element$iv$iv;
            Map map2 = result$iv;
            boolean bl22 = false;
            Aes<?> aes2 = $i$f$filter232.toAes((String)p0);
            map2.put(e, aes2);
        }
        $this$associateWith$iv = result$iv;
        boolean $i$f$filterValues = false;
        LinkedHashMap result$iv2 = new LinkedHashMap();
        for (Map.Entry entry2 : $this$filterValues$iv.entrySet()) {
            Aes aes3 = (Aes)entry2.getValue();
            boolean bl3 = false;
            if (!consumedAesSet.contains(aes3)) continue;
            result$iv2.put(entry2.getKey(), entry2.getValue());
        }
        $this$filterValues$iv = result$iv2;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Object constantValue;
            Object optionValue;
            Map.Entry element$iv;
            Map.Entry entry3 = element$iv = iterator2.next();
            boolean bl4 = false;
            String option = (String)entry3.getKey();
            Aes aes4 = (Aes)entry3.getValue();
            if (aopConversion.apply(aes4, optionValue = layerOptions.getSafe(option)) == null) {
                throw new IllegalArgumentException("Can't convert to '" + option + "' value: " + optionValue);
            }
            ((Map)result2).put(aes4, constantValue);
        }
        return result2;
    }

    @NotNull
    public final List<VarBinding> createBindings(@NotNull DataFrame data, @Nullable Map<Aes<?>, DataFrame.Variable> mapping2, @NotNull Set<? extends Aes<?>> consumedAesSet, boolean clientSide) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter(consumedAesSet, (String)"consumedAesSet");
        ArrayList<VarBinding> result2 = new ArrayList<VarBinding>();
        if (mapping2 != null && data.rowCount() > 0) {
            HashSet aesSet = new HashSet(consumedAesSet);
            aesSet.retainAll((Collection)mapping2.keySet());
            for (Aes aes2 : aesSet) {
                VarBinding varBinding;
                Intrinsics.checkNotNull((Object)aes2);
                DataFrame.Variable variable = (DataFrame.Variable)MapsKt.getValue(mapping2, (Object)aes2);
                if (data.has(variable)) {
                    varBinding = new VarBinding(variable, aes2);
                } else if (variable.isStat() && !clientSide) {
                    varBinding = new VarBinding(variable, aes2);
                } else {
                    throw new IllegalArgumentException(data.undefinedVariableErrorMessage(variable.getName()));
                }
                VarBinding binding = varBinding;
                result2.add(binding);
            }
        }
        return result2;
    }
}

