/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.spec.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.Grouping;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.core.commons.data.SeriesUtil;
import org.jetbrains.letsPlot.core.plot.base.Aes;
import org.jetbrains.letsPlot.core.plot.base.DataFrame;
import org.jetbrains.letsPlot.core.plot.base.GeomKind;
import org.jetbrains.letsPlot.core.plot.base.GeomMeta;
import org.jetbrains.letsPlot.core.plot.base.Stat;
import org.jetbrains.letsPlot.core.plot.base.data.DataFrameUtil;
import org.jetbrains.letsPlot.core.plot.base.util.YOrientationBaseUtilKt;
import org.jetbrains.letsPlot.core.plot.builder.MarginSide;
import org.jetbrains.letsPlot.core.plot.builder.VarBinding;
import org.jetbrains.letsPlot.core.plot.builder.annotation.AnnotationSpecification;
import org.jetbrains.letsPlot.core.plot.builder.assemble.PosProvider;
import org.jetbrains.letsPlot.core.plot.builder.data.OrderOptionUtil;
import org.jetbrains.letsPlot.core.plot.builder.sampling.Sampling;
import org.jetbrains.letsPlot.core.plot.builder.tooltip.TooltipSpecification;
import org.jetbrains.letsPlot.core.spec.GeomProto;
import org.jetbrains.letsPlot.core.spec.Option;
import org.jetbrains.letsPlot.core.spec.PosProto;
import org.jetbrains.letsPlot.core.spec.StatKind;
import org.jetbrains.letsPlot.core.spec.StatProto;
import org.jetbrains.letsPlot.core.spec.config.AnnotationConfig;
import org.jetbrains.letsPlot.core.spec.config.ConfigUtil;
import org.jetbrains.letsPlot.core.spec.config.DataConfigUtil;
import org.jetbrains.letsPlot.core.spec.config.DataMetaUtil;
import org.jetbrains.letsPlot.core.spec.config.LayerConfig;
import org.jetbrains.letsPlot.core.spec.config.LayerConfigUtil;
import org.jetbrains.letsPlot.core.spec.config.OptionsAccessor;
import org.jetbrains.letsPlot.core.spec.config.SamplingConfig;
import org.jetbrains.letsPlot.core.spec.config.TooltipConfig;
import org.jetbrains.letsPlot.core.spec.conversion.AesOptionConversion;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00ac\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0018\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 o2\u00020\u0001:\u0001oBs\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\u0010\t\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0014J\u001c\u0010_\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b\u0018\u00010`J.\u0010a\u001a\b\u0012\u0004\u0012\u00020$0#2\f\u0010b\u001a\b\u0012\u0004\u0012\u00020$0#2\u0010\u0010/\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030#0\u000bH\u0002J\u0014\u0010c\u001a\u0004\u0018\u00010d2\n\u0010b\u001a\u0006\u0012\u0002\b\u00030#J\u0006\u0010e\u001a\u00020\u0012J\u000e\u0010f\u001a\u00020\u00122\u0006\u0010g\u001a\u00020\u0004J\"\u0010h\u001a\u0004\u0018\u00010\u00042\u0006\u0010i\u001a\u00020\u00072\u000e\u0010j\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003H\u0002J\u000e\u0010k\u001a\u00020\u00122\u0006\u0010g\u001a\u00020\u0004J\u0010\u0010l\u001a\u00020m2\b\u0010n\u001a\u0004\u0018\u00010\u0007R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0017\u001a\u0018\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u0018X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R \u0010(\u001a\u00020\u00072\u0006\u0010'\u001a\u00020\u00078F@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u000e\u0010+\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R!\u0010,\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030#\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0018\u0010/\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030#0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u00100\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102R\u0017\u00103\u001a\b\u0012\u0004\u0012\u00020$0#\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u0010&R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00106R\u0011\u00107\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b7\u00108R\u0011\u00109\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u00108R\u0011\u0010:\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u00108R\u0011\u0010;\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b;\u00108R\u0011\u0010<\u001a\u00020=\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010?R\u0011\u0010@\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\bA\u0010BR*\u0010C\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\f0\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bD\u0010ER\u001e\u0010F\u001a\u00020\u00072\u0006\u0010'\u001a\u00020\u0007@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bG\u0010*R\u0011\u0010H\u001a\u00020I\u00a2\u0006\b\n\u0000\u001a\u0004\bJ\u0010KR\u001b\u0010L\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030#0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\bM\u0010ER\u0017\u0010N\u001a\b\u0012\u0004\u0012\u00020\u00160\u000b8F\u00a2\u0006\u0006\u001a\u0004\bO\u0010ER\u0011\u0010P\u001a\u00020Q\u00a2\u0006\b\n\u0000\u001a\u0004\bR\u0010SR\u0011\u0010T\u001a\u00020U\u00a2\u0006\b\n\u0000\u001a\u0004\bV\u0010WR\u0011\u0010X\u001a\u00020Y\u00a2\u0006\b\n\u0000\u001a\u0004\bZ\u0010[R\u0017\u0010\\\u001a\b\u0012\u0004\u0012\u00020]0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b^\u0010E\u00a8\u0006p"}, d2={"Lorg/jetbrains/letsPlot/core/spec/config/LayerConfig;", "Lorg/jetbrains/letsPlot/core/spec/config/OptionsAccessor;", "layerOptions", "", "", "", "plotData", "Lorg/jetbrains/letsPlot/core/plot/base/DataFrame;", "plotMappings", "plotDataMeta", "plotOrderOptions", "", "Lorg/jetbrains/letsPlot/core/plot/builder/data/OrderOptionUtil$OrderOption;", "geomProto", "Lorg/jetbrains/letsPlot/core/spec/GeomProto;", "aopConversion", "Lorg/jetbrains/letsPlot/core/spec/conversion/AesOptionConversion;", "clientSide", "", "isMapPlot", "(Ljava/util/Map;Lorg/jetbrains/letsPlot/core/plot/base/DataFrame;Ljava/util/Map;Ljava/util/Map;Ljava/util/List;Lorg/jetbrains/letsPlot/core/spec/GeomProto;Lorg/jetbrains/letsPlot/core/spec/conversion/AesOptionConversion;ZZ)V", "_samplings", "Lorg/jetbrains/letsPlot/core/plot/builder/sampling/Sampling;", "aggregateOperation", "Lkotlin/Function1;", "", "getAggregateOperation$plot_stem", "()Lkotlin/jvm/functions/Function1;", "annotations", "Lorg/jetbrains/letsPlot/core/plot/builder/annotation/AnnotationSpecification;", "getAnnotations", "()Lorg/jetbrains/letsPlot/core/plot/builder/annotation/AnnotationSpecification;", "getAopConversion", "()Lorg/jetbrains/letsPlot/core/spec/conversion/AesOptionConversion;", "colorByAes", "Lorg/jetbrains/letsPlot/core/plot/base/Aes;", "Lorg/jetbrains/letsPlot/commons/values/Color;", "getColorByAes", "()Lorg/jetbrains/letsPlot/core/plot/base/Aes;", "<set-?>", "combinedData", "getCombinedData", "()Lorg/jetbrains/letsPlot/core/plot/base/DataFrame;", "combinedDataValid", "constantsMap", "getConstantsMap", "()Ljava/util/Map;", "explicitConstantAes", "explicitGroupingVarName", "getExplicitGroupingVarName", "()Ljava/lang/String;", "fillByAes", "getFillByAes", "getGeomProto", "()Lorg/jetbrains/letsPlot/core/spec/GeomProto;", "isLegendDisabled", "()Z", "isLiveMap", "isMarginal", "isYOrientation", "marginalSide", "Lorg/jetbrains/letsPlot/core/plot/builder/MarginSide;", "getMarginalSide", "()Lorg/jetbrains/letsPlot/core/plot/builder/MarginSide;", "marginalSize", "getMarginalSize", "()D", "orderOptions", "getOrderOptions", "()Ljava/util/List;", "ownData", "getOwnData$plot_stem", "posProvider", "Lorg/jetbrains/letsPlot/core/plot/builder/assemble/PosProvider;", "getPosProvider", "()Lorg/jetbrains/letsPlot/core/plot/builder/assemble/PosProvider;", "renderedAes", "getRenderedAes", "samplings", "getSamplings", "stat", "Lorg/jetbrains/letsPlot/core/plot/base/Stat;", "getStat", "()Lorg/jetbrains/letsPlot/core/plot/base/Stat;", "statKind", "Lorg/jetbrains/letsPlot/core/spec/StatKind;", "getStatKind", "()Lorg/jetbrains/letsPlot/core/spec/StatKind;", "tooltips", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/TooltipSpecification;", "getTooltips", "()Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/TooltipSpecification;", "varBindings", "Lorg/jetbrains/letsPlot/core/plot/builder/VarBinding;", "getVarBindings", "getMapJoin", "Lkotlin/Pair;", "getPaintAes", "aes", "getVariableForAes", "Lorg/jetbrains/letsPlot/core/plot/base/DataFrame$Variable;", "hasExplicitGrouping", "hasVarBinding", "varName", "initGroupingVarName", "data", "mappingOptions", "isExplicitGrouping", "replaceOwnData", "", "dataFrame", "Companion", "plot-stem"})
@SourceDebugExtension(value={"SMAP\nLayerConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LayerConfig.kt\norg/jetbrains/letsPlot/core/spec/config/LayerConfig\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,436:1\n766#2:437\n857#2,2:438\n1549#2:440\n1620#2,3:441\n1238#2,4:446\n766#2:457\n857#2,2:458\n766#2:460\n857#2,2:461\n453#3:444\n403#3:445\n478#3,7:450\n1#4:463\n*S KotlinDebug\n*F\n+ 1 LayerConfig.kt\norg/jetbrains/letsPlot/core/spec/config/LayerConfig\n*L\n68#1:437\n68#1:438,2\n69#1:440\n69#1:441,3\n151#1:446,4\n215#1:457\n215#1:458,2\n225#1:460\n225#1:461,2\n151#1:444\n151#1:445\n169#1:450,7\n*E\n"})
public final class LayerConfig
extends OptionsAccessor {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final GeomProto geomProto;
    @NotNull
    private final AesOptionConversion aopConversion;
    private final boolean clientSide;
    @NotNull
    private final StatKind statKind;
    @NotNull
    private final Stat stat;
    @NotNull
    private final PosProvider posProvider;
    private final boolean isLiveMap;
    @NotNull
    private final List<Aes<?>> explicitConstantAes;
    @NotNull
    private final Aes<Color> colorByAes;
    @NotNull
    private final Aes<Color> fillByAes;
    @NotNull
    private final List<Aes<?>> renderedAes;
    @NotNull
    private final List<Sampling> _samplings;
    private final boolean isMarginal;
    @NotNull
    private final MarginSide marginalSide;
    private final double marginalSize;
    @NotNull
    private final Function1<List<Double>, Double> aggregateOperation;
    @NotNull
    private List<OrderOptionUtil.OrderOption> orderOptions;
    @Nullable
    private final String explicitGroupingVarName;
    @NotNull
    private final List<VarBinding> varBindings;
    @NotNull
    private final Map<Aes<?>, Object> constantsMap;
    @NotNull
    private final TooltipSpecification tooltips;
    @NotNull
    private final AnnotationSpecification annotations;
    @NotNull
    private DataFrame ownData;
    private boolean combinedDataValid;
    @NotNull
    private DataFrame combinedData;

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public LayerConfig(@NotNull Map<String, ? extends Object> layerOptions, @NotNull DataFrame plotData, @NotNull Map<String, String> plotMappings, @NotNull Map<?, ?> plotDataMeta, @NotNull List<OrderOptionUtil.OrderOption> plotOrderOptions, @NotNull GeomProto geomProto, @NotNull AesOptionConversion aopConversion, boolean clientSide, boolean isMapPlot) {
        AnnotationSpecification annotationSpecification2;
        TooltipSpecification tooltipSpecification;
        Object object;
        Iterable $this$filter$iv;
        Set set2;
        Object object2;
        void $this$mapValuesTo$iv$iv;
        MarginSide marginSide;
        Object object3;
        Map<String, Object> $this$mapTo$iv$iv;
        Object destination$iv$iv;
        Object object4;
        block25: {
            block22: {
                String side;
                block23: {
                    block24: {
                        void $this$map$iv;
                        Object element$iv$iv2;
                        void $this$filterTo$iv$iv;
                        Iterable $this$filter$iv2;
                        Intrinsics.checkNotNullParameter(layerOptions, (String)"layerOptions");
                        Intrinsics.checkNotNullParameter((Object)plotData, (String)"plotData");
                        Intrinsics.checkNotNullParameter(plotMappings, (String)"plotMappings");
                        Intrinsics.checkNotNullParameter(plotDataMeta, (String)"plotDataMeta");
                        Intrinsics.checkNotNullParameter(plotOrderOptions, (String)"plotOrderOptions");
                        Intrinsics.checkNotNullParameter((Object)geomProto, (String)"geomProto");
                        Intrinsics.checkNotNullParameter((Object)aopConversion, (String)"aopConversion");
                        super(layerOptions, LayerConfig.Companion.initLayerDefaultOptions(layerOptions, geomProto));
                        this.geomProto = geomProto;
                        this.aopConversion = aopConversion;
                        this.clientSide = clientSide;
                        this.statKind = StatKind.Companion.safeValueOf(this.getStringSafe("stat"));
                        this.stat = StatProto.INSTANCE.createStat$plot_stem(this.statKind, this);
                        this.posProvider = PosProto.INSTANCE.createPosProvider(LayerConfigUtil.INSTANCE.positionAdjustmentOptions(this, this.geomProto));
                        this.isLiveMap = this.geomProto.getGeomKind() == GeomKind.LIVE_MAP;
                        Iterable<String> iterable = Option.Mapping.INSTANCE.getREAL_AES_OPTION_NAMES();
                        object4 = this;
                        boolean $i$f$filter22 = false;
                        void var12_14 = $this$filter$iv2;
                        Collection destination$iv$iv2 = new ArrayList();
                        boolean $i$f$filterTo = false;
                        for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                            String p0 = (String)element$iv$iv2;
                            boolean bl = false;
                            if (!this.hasOwn(p0)) continue;
                            destination$iv$iv2.add(element$iv$iv2);
                        }
                        $this$filter$iv2 = (List)destination$iv$iv2;
                        Option.Mapping $i$f$filter22 = Option.Mapping.INSTANCE;
                        boolean $i$f$map = false;
                        destination$iv$iv2 = $this$map$iv;
                        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        element$iv$iv2 = $this$mapTo$iv$iv.iterator();
                        while (element$iv$iv2.hasNext()) {
                            void p0;
                            Object item$iv$iv = element$iv$iv2.next();
                            String bl = (String)item$iv$iv;
                            object3 = destination$iv$iv;
                            boolean bl2 = false;
                            object3.add($i$f$filter22.toAes((String)p0));
                        }
                        ((LayerConfig)object4).explicitConstantAes = (List)destination$iv$iv;
                        this.colorByAes = this.getPaintAes(Aes.Companion.getCOLOR(), this.explicitConstantAes);
                        this.fillByAes = this.getPaintAes(Aes.Companion.getFILL(), this.explicitConstantAes);
                        this.renderedAes = GeomMeta.renders$default(GeomMeta.INSTANCE, this.geomProto.getGeomKind(), this.colorByAes, this.fillByAes, null, 8, null);
                        this._samplings = this.clientSide ? CollectionsKt.emptyList() : LayerConfig.Companion.initSampling(this, this.geomProto.preferredSampling());
                        this.isMarginal = this.getBoolean("marginal", false);
                        if (!this.isMarginal) break block22;
                        String string = this.getStringSafe("margin_side").toLowerCase(Locale.ROOT);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                        side = string;
                        switch (side.hashCode()) {
                            case 114: {
                                if (side.equals("r")) break;
                                throw new IllegalArgumentException("margin_side expected l|r|t|b but was '" + side + '\'');
                            }
                            case 98: {
                                if (!side.equals("b")) {
                                    throw new IllegalArgumentException("margin_side expected l|r|t|b but was '" + side + '\'');
                                }
                                break block23;
                            }
                            case 116: {
                                if (!side.equals("t")) {
                                    throw new IllegalArgumentException("margin_side expected l|r|t|b but was '" + side + '\'');
                                }
                                break block24;
                            }
                            case 108: {
                                if (!side.equals("l")) throw new IllegalArgumentException("margin_side expected l|r|t|b but was '" + side + '\'');
                                marginSide = MarginSide.LEFT;
                                break block25;
                            }
                        }
                        marginSide = MarginSide.RIGHT;
                        break block25;
                    }
                    marginSide = MarginSide.TOP;
                    break block25;
                }
                marginSide = MarginSide.BOTTOM;
                break block25;
                throw new IllegalArgumentException("margin_side expected l|r|t|b but was '" + side + '\'');
            }
            marginSide = MarginSide.LEFT;
        }
        this.marginalSide = marginSide;
        this.marginalSize = this.getDoubleDef("margin_size", 0.1);
        this.aggregateOperation = Intrinsics.areEqual((Object)this.getString("position"), (Object)"stack") ? (Function1)new Function1<List<? extends Double>, Double>((Object)SeriesUtil.INSTANCE){

            @NotNull
            public final Double invoke(@NotNull List<Double> p0) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                return ((SeriesUtil)this.receiver).sum(p0);
            }
        } : (Function1)aggregateOperation.2.INSTANCE;
        this.combinedDataValid = true;
        this.ownData = ConfigUtil.INSTANCE.createDataFrame$plot_stem(this.get("data"));
        Map<String, Object> $this$mapValues$iv = this.getMap("mapping");
        boolean $i$f$mapValues = false;
        $this$mapTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv22 = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo2 = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv22) {
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Object object5 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            object3 = it$iv$iv.getKey();
            object4 = object5;
            boolean bl3 = false;
            Object variable = entry2.getValue();
            Intrinsics.checkNotNull(variable, (String)"null cannot be cast to non-null type kotlin.String");
            object2 = (String)variable;
            object4.put(object3, object2);
        }
        Object layerMappings = destination$iv$iv;
        Map<String, String> combinedDiscreteMappings = DataConfigUtil.INSTANCE.combinedDiscreteMapping(plotMappings, (Map<String, String>)layerMappings, DataMetaUtil.INSTANCE.getAsDiscreteAesSet(plotDataMeta), DataMetaUtil.INSTANCE.getAsDiscreteAesSet(this.getMap("data_meta")));
        Set it = CollectionsKt.toSet((Iterable)this.renderedAes);
        boolean bl = false;
        boolean $this$associateByTo$iv$iv$iv22 = this.clientSide;
        if ($this$associateByTo$iv$iv$iv22) {
            set2 = it;
        } else {
            if ($this$associateByTo$iv$iv$iv22) throw new NoWhenBranchMatchedException();
            set2 = SetsKt.plus((Set)it, (Iterable)this.stat.consumes());
        }
        Set<Aes<?>> consumedAesSet = YOrientationBaseUtilKt.afterOrientation(set2, this.isYOrientation());
        Map $this$filterKeys$iv = MapsKt.plus(plotMappings, (Map)layerMappings);
        boolean $i$f$filterKeys = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterKeys$iv.entrySet()) {
            boolean bl4;
            String aesName = (String)entry$iv.getKey();
            boolean bl5 = false;
            if (Intrinsics.areEqual((Object)aesName, (Object)"group")) {
                bl4 = true;
            } else {
                Aes<?> aes2 = Option.Mapping.INSTANCE.toAes(aesName);
                bl4 = consumedAesSet.contains(aes2);
            }
            if (!bl4) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        Map consumedAesMappings = result$iv;
        Pair<Map<Aes<?>, DataFrame.Variable>, DataFrame> pair2 = DataConfigUtil.INSTANCE.layerMappingsAndCombinedData(layerOptions, this.geomProto.getGeomKind(), this.stat, plotData, this.ownData, combinedDiscreteMappings, consumedAesMappings, this.explicitConstantAes, this.isYOrientation(), this.clientSide, isMapPlot);
        Map aesMappings = (Map)pair2.component1();
        DataFrame rawCombinedData = (DataFrame)pair2.component2();
        this.constantsMap = LayerConfigUtil.INSTANCE.initConstants(this, SetsKt.minus(consumedAesSet, (Iterable)aesMappings.keySet()), this.aopConversion);
        this.explicitGroupingVarName = this.initGroupingVarName(rawCombinedData, consumedAesMappings);
        this.varBindings = LayerConfigUtil.INSTANCE.createBindings(rawCombinedData, aesMappings, consumedAesSet, this.clientSide);
        Object object6 = this;
        if (this.has("tooltips")) {
            void $this$filterTo$iv$iv;
            Iterable $i$f$associateByTo2 = this.varBindings;
            object2 = this.getSafe("tooltips");
            object3 = Companion;
            object4 = object6;
            boolean $i$f$filter = false;
            void aesName = $this$filter$iv;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                VarBinding it2 = (VarBinding)element$iv$iv;
                boolean bl6 = false;
                if (!this.renderedAes.contains(it2.getAes())) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            object = (List)destination$iv$iv3;
            object6 = object4;
            tooltipSpecification = ((Companion)object3).initTooltipsSpec(object2, (List)object, this.constantsMap, this.explicitGroupingVarName);
        } else {
            tooltipSpecification = TooltipSpecification.Companion.defaultTooltip();
        }
        ((LayerConfig)object6).tooltips = tooltipSpecification;
        Object object7 = this;
        if (this.has("labels")) {
            $this$filter$iv = this.varBindings;
            object = this.getMap("labels");
            object4 = object7;
            boolean $i$f$filter = false;
            Iterable $this$filterTo$iv$iv = $this$filter$iv;
            Collection destination$iv$iv4 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                VarBinding it3 = (VarBinding)element$iv$iv;
                boolean bl7 = false;
                if (!this.renderedAes.contains(it3.getAes())) continue;
                destination$iv$iv4.add(element$iv$iv);
            }
            List list2 = (List)destination$iv$iv4;
            object7 = object4;
            String string = this.explicitGroupingVarName;
            Map<Aes<?>, Object> map2 = this.constantsMap;
            List list3 = list2;
            Object object8 = object;
            annotationSpecification2 = new AnnotationConfig((Map<String, ? extends Object>)object8, list3, map2, string).createAnnotations();
        } else {
            annotationSpecification2 = AnnotationSpecification.Companion.getNONE();
        }
        ((LayerConfig)object7).annotations = annotationSpecification2;
        this.orderOptions = LayerConfig.Companion.initOrderOptions(plotOrderOptions, layerOptions, this.varBindings, consumedAesMappings, this.clientSide);
        this.combinedData = DataConfigUtil.INSTANCE.combinedDataWithDataMeta(rawCombinedData, this.varBindings, plotDataMeta, this.getMap("data_meta"), combinedDiscreteMappings.keySet(), this.orderOptions, this.aggregateOperation, this.clientSide);
    }

    @NotNull
    public final GeomProto getGeomProto() {
        return this.geomProto;
    }

    @NotNull
    public final AesOptionConversion getAopConversion() {
        return this.aopConversion;
    }

    @NotNull
    public final StatKind getStatKind() {
        return this.statKind;
    }

    @NotNull
    public final Stat getStat() {
        return this.stat;
    }

    @NotNull
    public final PosProvider getPosProvider() {
        return this.posProvider;
    }

    public final boolean isLiveMap() {
        return this.isLiveMap;
    }

    @NotNull
    public final Aes<Color> getColorByAes() {
        return this.colorByAes;
    }

    @NotNull
    public final Aes<Color> getFillByAes() {
        return this.fillByAes;
    }

    @NotNull
    public final List<Aes<?>> getRenderedAes() {
        return this.renderedAes;
    }

    public final boolean isLegendDisabled() {
        return this.hasOwn("show_legend") ? !this.getBoolean("show_legend", true) : false;
    }

    @NotNull
    public final List<Sampling> getSamplings() {
        if (!(!this.clientSide)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        return this._samplings;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isYOrientation() {
        boolean bl = this.hasOwn("orientation");
        if (bl) {
            String string = this.getString("orientation");
            String string2 = string;
            if (string == null) return false;
            String string3 = string2.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
            string2 = string3;
            if (string3 == null) return false;
            String it = string2;
            boolean bl2 = false;
            String string4 = it;
            if (Intrinsics.areEqual((Object)string4, (Object)"y")) {
                return true;
            }
            if (!Intrinsics.areEqual((Object)string4, (Object)"x")) throw new IllegalArgumentException("orientation expected x|y but was " + it);
            return false;
        }
        if (bl) throw new NoWhenBranchMatchedException();
        return false;
    }

    public final boolean isMarginal() {
        return this.isMarginal;
    }

    @NotNull
    public final MarginSide getMarginalSide() {
        return this.marginalSide;
    }

    public final double getMarginalSize() {
        return this.marginalSize;
    }

    @NotNull
    public final Function1<List<Double>, Double> getAggregateOperation$plot_stem() {
        return this.aggregateOperation;
    }

    @NotNull
    public final List<OrderOptionUtil.OrderOption> getOrderOptions() {
        return this.orderOptions;
    }

    @Nullable
    public final String getExplicitGroupingVarName() {
        return this.explicitGroupingVarName;
    }

    @NotNull
    public final List<VarBinding> getVarBindings() {
        return this.varBindings;
    }

    @NotNull
    public final Map<Aes<?>, Object> getConstantsMap() {
        return this.constantsMap;
    }

    @NotNull
    public final TooltipSpecification getTooltips() {
        return this.tooltips;
    }

    @NotNull
    public final AnnotationSpecification getAnnotations() {
        return this.annotations;
    }

    @NotNull
    public final DataFrame getOwnData$plot_stem() {
        return this.ownData;
    }

    @NotNull
    public final DataFrame getCombinedData() {
        if (!this.combinedDataValid) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        return this.combinedData;
    }

    private final String initGroupingVarName(DataFrame data, Map<?, ?> mappingOptions) {
        DataFrame.Variable groupVar;
        String fieldName;
        Object groupBy = mappingOptions.get("group");
        String string = fieldName = groupBy instanceof String ? (String)groupBy : null;
        if (fieldName == null && this.has("map") && (groupVar = DataFrameUtil.INSTANCE.variables(data).get("group")) != null) {
            fieldName = groupVar.getName();
        }
        return fieldName;
    }

    public final boolean hasVarBinding(@NotNull String varName) {
        Intrinsics.checkNotNullParameter((Object)varName, (String)"varName");
        for (VarBinding binding : this.varBindings) {
            if (!Intrinsics.areEqual((Object)binding.getVariable().getName(), (Object)varName)) continue;
            return true;
        }
        return false;
    }

    public final void replaceOwnData(@Nullable DataFrame dataFrame) {
        if (!(!this.clientSide)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        if (!(dataFrame != null)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.update("data", DataFrameUtil.INSTANCE.toMap(dataFrame));
        this.ownData = dataFrame;
        this.combinedDataValid = false;
    }

    public final boolean hasExplicitGrouping() {
        return this.explicitGroupingVarName != null;
    }

    public final boolean isExplicitGrouping(@NotNull String varName) {
        Intrinsics.checkNotNullParameter((Object)varName, (String)"varName");
        return this.explicitGroupingVarName != null && Intrinsics.areEqual((Object)this.explicitGroupingVarName, (Object)varName);
    }

    @Nullable
    public final DataFrame.Variable getVariableForAes(@NotNull Aes<?> aes2) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter(aes2, (String)"aes");
            Iterable iterable = this.varBindings;
            for (Object t : iterable) {
                VarBinding it = (VarBinding)t;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getAes(), aes2)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        VarBinding varBinding = v0;
        return varBinding != null ? varBinding.getVariable() : null;
    }

    @Nullable
    public final Pair<List<?>, List<?>> getMapJoin() {
        if (!this.hasOwn("map_join")) {
            return null;
        }
        List<?> mapJoin = this.getList("map_join");
        if (!(mapJoin.size() == 2)) {
            boolean $i$a$-require-LayerConfig$getMapJoin$42 = false;
            String $i$a$-require-LayerConfig$getMapJoin$42 = "map_join require 2 parameters";
            throw new IllegalArgumentException($i$a$-require-LayerConfig$getMapJoin$42.toString());
        }
        Object dataVar = mapJoin.get(0);
        Object mapVar = mapJoin.get(1);
        if (!(dataVar != null)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(mapVar != null)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(dataVar instanceof List)) {
            boolean $i$a$-require-LayerConfig$getMapJoin$52 = false;
            String $i$a$-require-LayerConfig$getMapJoin$52 = "Wrong map_join parameter type: should be a list of strings, but was " + Reflection.getOrCreateKotlinClass(dataVar.getClass()).getSimpleName();
            throw new IllegalArgumentException($i$a$-require-LayerConfig$getMapJoin$52.toString());
        }
        if (!(mapVar instanceof List)) {
            boolean bl = false;
            String string = "Wrong map_join parameter type: should be a list of string, but was " + Reflection.getOrCreateKotlinClass(mapVar.getClass()).getSimpleName();
            throw new IllegalArgumentException(string.toString());
        }
        return new Pair(dataVar, mapVar);
    }

    private final Aes<Color> getPaintAes(Aes<Color> aes2, List<? extends Aes<?>> explicitConstantAes) {
        Aes<Color> aes3;
        Aes<Color> aes4 = aes2;
        if (explicitConstantAes.contains(aes4)) {
            aes3 = aes2;
        } else {
            Aes<?> colorBy;
            Aes<?> aes5;
            Aes<Color> aes6 = aes2;
            String optionName = Intrinsics.areEqual(aes6, Aes.Companion.getCOLOR()) ? "color_by" : (Intrinsics.areEqual(aes6, Aes.Companion.getFILL()) ? "fill_by" : aes2.getName());
            String string = this.getString(optionName);
            if (string != null) {
                String aesName = string;
                boolean bl = false;
                Aes<?> aesByName = Option.Mapping.INSTANCE.toAes(aesName);
                if (!Aes.Companion.isColor(aesByName)) {
                    boolean bl2 = false;
                    String string2 = '\'' + optionName + "' should be an aesthetic related to color";
                    throw new IllegalArgumentException(string2.toString());
                }
                Intrinsics.checkNotNull(aesByName, (String)"null cannot be cast to non-null type org.jetbrains.letsPlot.core.plot.base.Aes<org.jetbrains.letsPlot.commons.values.Color>");
                aes5 = aesByName;
            } else {
                aes5 = null;
            }
            Aes<?> aes7 = colorBy = aes5;
            aes3 = aes7 == null ? aes2 : (explicitConstantAes.contains(aes7) ? aes2 : colorBy);
        }
        return aes3;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u00042\u000e\u0010\u0006\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0002JZ\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u00042\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\n2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\n2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0013H\u0002J@\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\n2\u0016\u0010\u001a\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001b\u0012\u0004\u0012\u00020\u00010\u00042\b\u0010\u001c\u001a\u0004\u0018\u00010\u0005H\u0002\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/letsPlot/core/spec/config/LayerConfig$Companion;", "", "()V", "initLayerDefaultOptions", "", "", "layerOptions", "geomProto", "Lorg/jetbrains/letsPlot/core/spec/GeomProto;", "initOrderOptions", "", "Lorg/jetbrains/letsPlot/core/plot/builder/data/OrderOptionUtil$OrderOption;", "plotOrderOptions", "varBindings", "Lorg/jetbrains/letsPlot/core/plot/builder/VarBinding;", "combinedMappingOptions", "clientSide", "", "initSampling", "Lorg/jetbrains/letsPlot/core/plot/builder/sampling/Sampling;", "opts", "Lorg/jetbrains/letsPlot/core/spec/config/OptionsAccessor;", "defaultSampling", "initTooltipsSpec", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/TooltipSpecification;", "tooltipOptions", "constantsMap", "Lorg/jetbrains/letsPlot/core/plot/base/Aes;", "explicitGroupingVarName", "plot-stem"})
    @SourceDebugExtension(value={"SMAP\nLayerConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LayerConfig.kt\norg/jetbrains/letsPlot/core/spec/config/LayerConfig$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Grouping.kt\nkotlin/collections/GroupingKt__GroupingKt\n*L\n1#1,436:1\n1549#2:437\n1620#2,3:438\n766#2:441\n857#2,2:442\n1536#2:444\n211#3:445\n53#3:446\n80#3,4:447\n213#3:451\n85#3:452\n214#3:453\n*S KotlinDebug\n*F\n+ 1 LayerConfig.kt\norg/jetbrains/letsPlot/core/spec/config/LayerConfig$Companion\n*L\n409#1:437\n409#1:438,3\n412#1:441\n412#1:442,2\n425#1:444\n426#1:445\n426#1:446\n426#1:447,4\n426#1:451\n426#1:452\n426#1:453\n*E\n"})
    private static final class Companion {
        private Companion() {
        }

        private final Map<String, Object> initLayerDefaultOptions(Map<?, ?> layerOptions, GeomProto geomProto) {
            if (!(layerOptions.containsKey("geom") || layerOptions.containsKey("stat"))) {
                boolean $i$a$-require-LayerConfig$Companion$initLayerDefaultOptions$22 = false;
                String $i$a$-require-LayerConfig$Companion$initLayerDefaultOptions$22 = "Either 'geom' or 'stat' must be specified.";
                throw new IllegalArgumentException($i$a$-require-LayerConfig$Companion$initLayerDefaultOptions$22.toString());
            }
            HashMap<String, Object> defaults = new HashMap<String, Object>();
            defaults.putAll(geomProto.defaultOptions());
            String statName = (String)layerOptions.get("stat");
            if (statName == null) {
                Object v = defaults.get("stat");
                Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.String");
                statName = (String)v;
            }
            return MapsKt.plus((Map)defaults, StatProto.INSTANCE.defaultOptions$plot_stem(statName, geomProto.getGeomKind()));
        }

        private final List<Sampling> initSampling(OptionsAccessor opts, Sampling defaultSampling) {
            return opts.has("sampling") ? SamplingConfig.INSTANCE.create(opts.getSafe("sampling")) : CollectionsKt.listOf((Object)defaultSampling);
        }

        private final TooltipSpecification initTooltipsSpec(Object tooltipOptions, List<VarBinding> varBindings, Map<Aes<?>, ? extends Object> constantsMap, String explicitGroupingVarName) {
            TooltipSpecification tooltipSpecification;
            Object object = tooltipOptions;
            if (object instanceof Map) {
                Intrinsics.checkNotNull((Object)tooltipOptions, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>");
                tooltipSpecification = new TooltipConfig((Map<String, ? extends Object>)((Map)tooltipOptions), constantsMap, explicitGroupingVarName, varBindings).createTooltips();
            } else if (Intrinsics.areEqual((Object)object, (Object)"none")) {
                tooltipSpecification = TooltipSpecification.Companion.withoutTooltip();
            } else {
                throw new IllegalStateException("Incorrect tooltips specification".toString());
            }
            return tooltipSpecification;
        }

        /*
         * WARNING - void declaration
         */
        private final List<OrderOptionUtil.OrderOption> initOrderOptions(List<OrderOptionUtil.OrderOption> plotOrderOptions, Map<String, ? extends Object> layerOptions, List<VarBinding> varBindings, Map<String, String> combinedMappingOptions, boolean clientSide) {
            List list2;
            List orderOptions;
            void $this$filterTo$iv$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = varBindings;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                VarBinding varBinding = (VarBinding)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getVariable().getName());
            }
            List mappedVariables = (List)destination$iv$iv;
            Iterable $this$filter$iv = plotOrderOptions;
            boolean $i$f$filter = false;
            destination$iv$iv = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                OrderOptionUtil.OrderOption orderOption = (OrderOptionUtil.OrderOption)element$iv$iv;
                boolean bl = false;
                if (!mappedVariables.contains(orderOption.getVariableName())) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List plotOrderOptions2 = (List)destination$iv$iv2;
            List<OrderOptionUtil.OrderOption> ownOrderOptions = DataMetaUtil.INSTANCE.getOrderOptions(layerOptions, combinedMappingOptions, clientSide);
            List it = orderOptions = CollectionsKt.plus((Collection)plotOrderOptions2, (Iterable)ownOrderOptions);
            boolean bl = false;
            if (clientSide) {
                void destination$iv$iv$iv;
                void $this$aggregateTo$iv$iv$iv;
                void $this$reduce$iv;
                Iterable $this$groupingBy$iv = it;
                boolean $i$f$groupingBy = false;
                $this$groupingBy$iv = (Grouping)new Grouping<OrderOptionUtil.OrderOption, String>($this$groupingBy$iv){
                    final /* synthetic */ Iterable $this_groupingBy;
                    {
                        this.$this_groupingBy = $receiver;
                    }

                    @NotNull
                    public Iterator<OrderOptionUtil.OrderOption> sourceIterator() {
                        return this.$this_groupingBy.iterator();
                    }

                    /*
                     * Ignored method signature, as it can't be verified against descriptor
                     */
                    public Object keyOf(Object element) {
                        OrderOptionUtil.OrderOption p0 = (OrderOptionUtil.OrderOption)element;
                        boolean bl = false;
                        return p0.getVariableName();
                    }
                };
                boolean $i$f$reduce = false;
                void $this$aggregate$iv$iv = $this$reduce$iv;
                boolean $i$f$aggregate = false;
                void var17_26 = $this$aggregate$iv$iv;
                Map map2 = new LinkedHashMap();
                boolean $i$f$aggregateTo = false;
                Iterator iterator2 = $this$aggregateTo$iv$iv$iv.sourceIterator();
                while (iterator2.hasNext()) {
                    OrderOptionUtil.OrderOption orderOption;
                    void e$iv;
                    void first$iv;
                    Object e$iv$iv$iv = iterator2.next();
                    Object key$iv$iv$iv = $this$aggregateTo$iv$iv$iv.keyOf(e$iv$iv$iv);
                    Object accumulator$iv$iv$iv = destination$iv$iv$iv.get(key$iv$iv$iv);
                    boolean bl2 = accumulator$iv$iv$iv == null && !destination$iv$iv$iv.containsKey(key$iv$iv$iv);
                    Object e = e$iv$iv$iv;
                    Object v = accumulator$iv$iv$iv;
                    Object object = key$iv$iv$iv;
                    Object object2 = key$iv$iv$iv;
                    void var29_38 = destination$iv$iv$iv;
                    boolean bl3 = false;
                    if (first$iv != false) {
                        orderOption = e$iv;
                    } else {
                        void element;
                        void combined;
                        void key$iv;
                        void acc$iv;
                        OrderOptionUtil.OrderOption orderOption2 = (OrderOptionUtil.OrderOption)e$iv;
                        OrderOptionUtil.OrderOption orderOption3 = (OrderOptionUtil.OrderOption)acc$iv;
                        String cfr_ignored_0 = (String)key$iv;
                        boolean bl4 = false;
                        orderOption = OrderOptionUtil.OrderOption.Companion.mergeWith((OrderOptionUtil.OrderOption)combined, (OrderOptionUtil.OrderOption)element);
                    }
                    void var34_43 = orderOption;
                    var29_38.put(object2, var34_43);
                }
                list2 = CollectionsKt.toList((Iterable)destination$iv$iv$iv.values());
            } else {
                list2 = it;
            }
            return list2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

