/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.layout.tile;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.core.plot.base.layout.Thickness;
import org.jetbrains.letsPlot.core.plot.builder.coord.CoordProvider;
import org.jetbrains.letsPlot.core.plot.builder.layout.AxisLayoutInfo;
import org.jetbrains.letsPlot.core.plot.builder.layout.AxisLayoutInfoQuad;
import org.jetbrains.letsPlot.core.plot.builder.layout.AxisLayoutQuad;
import org.jetbrains.letsPlot.core.plot.builder.layout.GeomMarginsLayout;
import org.jetbrains.letsPlot.core.plot.builder.layout.TileLayout;
import org.jetbrains.letsPlot.core.plot.builder.layout.TileLayoutInfo;
import org.jetbrains.letsPlot.core.plot.builder.layout.util.GeomAreaInsets;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0010\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0004J\u0018\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/layout/tile/TopDownTileLayout;", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/TileLayout;", "axisLayoutQuad", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/AxisLayoutQuad;", "hDomain", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "vDomain", "marginsLayout", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/GeomMarginsLayout;", "panelInset", "Lorg/jetbrains/letsPlot/core/plot/base/layout/Thickness;", "(Lorg/jetbrains/letsPlot/core/plot/builder/layout/AxisLayoutQuad;Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;Lorg/jetbrains/letsPlot/core/plot/builder/layout/GeomMarginsLayout;Lorg/jetbrains/letsPlot/core/plot/base/layout/Thickness;)V", "insideOut", "", "getInsideOut", "()Z", "computeAxisInfos", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/util/GeomAreaInsets;", "plotSize", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "coordProvider", "Lorg/jetbrains/letsPlot/core/plot/builder/coord/CoordProvider;", "computeGeomContentBounds", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "geomInsets", "computeGeomWithAxisBounds", "geomOuterBounds", "axisInfos", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/AxisLayoutInfoQuad;", "doLayout", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/TileLayoutInfo;", "preferredSize", "plot-builder"})
@SourceDebugExtension(value={"SMAP\nTopDownTileLayout.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TopDownTileLayout.kt\norg/jetbrains/letsPlot/core/plot/builder/layout/tile/TopDownTileLayout\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,122:1\n1#2:123\n*E\n"})
public class TopDownTileLayout
implements TileLayout {
    @NotNull
    private final AxisLayoutQuad axisLayoutQuad;
    @NotNull
    private final DoubleSpan hDomain;
    @NotNull
    private final DoubleSpan vDomain;
    @NotNull
    private final GeomMarginsLayout marginsLayout;
    @NotNull
    private final Thickness panelInset;
    private final boolean insideOut;

    public TopDownTileLayout(@NotNull AxisLayoutQuad axisLayoutQuad, @NotNull DoubleSpan hDomain, @NotNull DoubleSpan vDomain, @NotNull GeomMarginsLayout marginsLayout, @NotNull Thickness panelInset) {
        Intrinsics.checkNotNullParameter((Object)axisLayoutQuad, (String)"axisLayoutQuad");
        Intrinsics.checkNotNullParameter((Object)hDomain, (String)"hDomain");
        Intrinsics.checkNotNullParameter((Object)vDomain, (String)"vDomain");
        Intrinsics.checkNotNullParameter((Object)marginsLayout, (String)"marginsLayout");
        Intrinsics.checkNotNullParameter((Object)panelInset, (String)"panelInset");
        this.axisLayoutQuad = axisLayoutQuad;
        this.hDomain = hDomain;
        this.vDomain = vDomain;
        this.marginsLayout = marginsLayout;
        this.panelInset = panelInset;
    }

    @Override
    public boolean getInsideOut() {
        return this.insideOut;
    }

    @Override
    @NotNull
    public TileLayoutInfo doLayout(@NotNull DoubleVector preferredSize, @NotNull CoordProvider coordProvider) {
        Intrinsics.checkNotNullParameter((Object)preferredSize, (String)"preferredSize");
        Intrinsics.checkNotNullParameter((Object)coordProvider, (String)"coordProvider");
        GeomAreaInsets geomAreaInsets = this.computeAxisInfos(preferredSize, coordProvider);
        DoubleRectangle geomContentBounds = this.computeGeomContentBounds(geomAreaInsets, preferredSize, coordProvider);
        DoubleRectangle geomInnerBounds = this.panelInset.inflateRect(geomContentBounds);
        DoubleRectangle geomOuterBounds = this.marginsLayout.toOuterBounds(geomInnerBounds);
        AxisLayoutInfoQuad axisInfos = geomAreaInsets.getAxisInfoQuad();
        DoubleRectangle geomWithAxisBounds = this.computeGeomWithAxisBounds(geomOuterBounds, axisInfos);
        AxisLayoutInfoQuad axisInfosNew = axisInfos.withHAxisLength(geomContentBounds.getWidth()).withVAxisLength(geomContentBounds.getHeight());
        return new TileLayoutInfo(DoubleVector.Companion.getZERO(), geomWithAxisBounds, geomOuterBounds, geomInnerBounds, geomContentBounds, axisInfosNew, true, true, null, null, 0, 768, null);
    }

    @NotNull
    protected DoubleRectangle computeGeomWithAxisBounds(@NotNull DoubleRectangle geomOuterBounds, @NotNull AxisLayoutInfoQuad axisInfos) {
        Object object;
        Object object2;
        Object object3;
        Intrinsics.checkNotNullParameter((Object)geomOuterBounds, (String)"geomOuterBounds");
        Intrinsics.checkNotNullParameter((Object)axisInfos, (String)"axisInfos");
        AxisLayoutInfo l = axisInfos.component1();
        AxisLayoutInfo r = axisInfos.component2();
        AxisLayoutInfo t = axisInfos.component3();
        AxisLayoutInfo b2 = axisInfos.component4();
        Object object4 = l;
        return DoubleRectangle.Companion.LTRB(object4 != null && (object4 = ((AxisLayoutInfo)object4).axisBoundsAbsolute(geomOuterBounds)) != null ? ((DoubleRectangle)object4).getLeft() : geomOuterBounds.getLeft(), (object3 = t) != null && (object3 = ((AxisLayoutInfo)object3).axisBoundsAbsolute(geomOuterBounds)) != null ? ((DoubleRectangle)object3).getTop() : geomOuterBounds.getTop(), (object2 = r) != null && (object2 = ((AxisLayoutInfo)object2).axisBoundsAbsolute(geomOuterBounds)) != null ? ((DoubleRectangle)object2).getRight() : geomOuterBounds.getRight(), (object = b2) != null && (object = ((AxisLayoutInfo)object).axisBoundsAbsolute(geomOuterBounds)) != null ? ((DoubleRectangle)object).getBottom() : geomOuterBounds.getBottom());
    }

    @NotNull
    protected GeomAreaInsets computeAxisInfos(@NotNull DoubleVector plotSize2, @NotNull CoordProvider coordProvider) {
        GeomAreaInsets geomAreaInsets;
        Intrinsics.checkNotNullParameter((Object)plotSize2, (String)"plotSize");
        Intrinsics.checkNotNullParameter((Object)coordProvider, (String)"coordProvider");
        GeomAreaInsets insetsInitial = GeomAreaInsets.Companion.init(this.axisLayoutQuad);
        DoubleVector doubleVector = this.computeGeomContentBounds(insetsInitial, plotSize2, coordProvider).getDimension();
        GeomMarginsLayout geomMarginsLayout = this.marginsLayout;
        DoubleVector p0 = doubleVector;
        boolean bl = false;
        double axisHeightEstim = geomMarginsLayout.toInnerSize(p0).getY();
        GeomAreaInsets insetsVAxis = insetsInitial.layoutVAxis(this.vDomain, axisHeightEstim);
        DoubleRectangle plottingArea = this.computeGeomContentBounds(insetsVAxis, plotSize2, coordProvider);
        double hAxisLength = this.marginsLayout.toInnerBounds(plottingArea).getWidth();
        GeomAreaInsets insetsHVAxis = insetsVAxis.layoutHAxis(this.hDomain, hAxisLength);
        if (insetsHVAxis.getTop() + insetsHVAxis.getBottom() > insetsInitial.getTop() + insetsInitial.getBottom()) {
            DoubleVector doubleVector2 = this.computeGeomContentBounds(insetsHVAxis, plotSize2, coordProvider).getDimension();
            GeomMarginsLayout geomMarginsLayout2 = this.marginsLayout;
            DoubleVector p02 = doubleVector2;
            boolean bl2 = false;
            double geomHeight = geomMarginsLayout2.toInnerSize(p02).getY();
            geomAreaInsets = insetsHVAxis.layoutVAxis(this.vDomain, geomHeight);
        } else {
            geomAreaInsets = insetsHVAxis;
        }
        GeomAreaInsets insetsFinal = geomAreaInsets;
        return insetsFinal;
    }

    @NotNull
    protected final DoubleRectangle computeGeomContentBounds(@NotNull GeomAreaInsets geomInsets, @NotNull DoubleVector plotSize2, @NotNull CoordProvider coordProvider) {
        Intrinsics.checkNotNullParameter((Object)geomInsets, (String)"geomInsets");
        Intrinsics.checkNotNullParameter((Object)plotSize2, (String)"plotSize");
        Intrinsics.checkNotNullParameter((Object)coordProvider, (String)"coordProvider");
        DoubleRectangle plottingArea = geomInsets.subtractFrom(new DoubleRectangle(DoubleVector.Companion.getZERO(), plotSize2));
        DoubleRectangle panelBounds = this.marginsLayout.toInnerBounds(plottingArea);
        DoubleRectangle contentBounds = this.panelInset.shrinkRect(panelBounds);
        DoubleVector geomOuterSizeAdjusted = coordProvider.adjustGeomSize(this.hDomain, this.vDomain, contentBounds.getDimension());
        return new DoubleRectangle(contentBounds.getOrigin(), geomOuterSizeAdjusted);
    }
}

