/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.layout.figure.composite;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.core.plot.builder.FigureBuildInfo;
import org.jetbrains.letsPlot.core.plot.builder.layout.figure.composite.FigureGridLayoutUtil;
import org.jetbrains.letsPlot.core.plot.builder.layout.figure.composite.ScaleSharePolicy;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 #2\u00020\u0001:\u0001#Bm\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u000e\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\t\u0012\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u000e\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\t\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0012J.\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\t2\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00032\u000e\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\tH\u0002J\u0006\u0010\u001a\u001a\u00020\fJ\u001a\u0010\u001b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\t0\t2\u0006\u0010\u001c\u001a\u00020\u0003J\u001a\u0010\u001d\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\t0\t2\u0006\u0010\u001c\u001a\u00020\u0003J(\u0010\u001e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001f0\t2\u0006\u0010 \u001a\u00020!2\u000e\u0010\"\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001f0\tH\u0004R\u0016\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0004\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014R\u0016\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/layout/figure/composite/CompositeFigureGridLayoutBase;", "", "ncols", "", "nrows", "hSpace", "", "vSpace", "colWidths", "", "rowHeights", "fitCellAspectRatio", "", "elementsDefaultSizes", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "scaleShareX", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/figure/composite/ScaleSharePolicy;", "scaleShareY", "(IIDDLjava/util/List;Ljava/util/List;ZLjava/util/List;Lorg/jetbrains/letsPlot/core/plot/builder/layout/figure/composite/ScaleSharePolicy;Lorg/jetbrains/letsPlot/core/plot/builder/layout/figure/composite/ScaleSharePolicy;)V", "getNcols", "()I", "getNrows", "cellSizeList", "totalSize", "n", "sizeList", "hasSharedAxis", "indicesWithSharedXAxis", "elementCount", "indicesWithSharedYAxis", "toElelemtsWithInitialBounds", "Lorg/jetbrains/letsPlot/core/plot/builder/FigureBuildInfo;", "bounds", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "elements", "Companion", "plot-builder"})
@SourceDebugExtension(value={"SMAP\nCompositeFigureGridLayoutBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompositeFigureGridLayoutBase.kt\norg/jetbrains/letsPlot/core/plot/builder/layout/figure/composite/CompositeFigureGridLayoutBase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,140:1\n1559#2:141\n1590#2,4:142\n1549#2:147\n1620#2,3:148\n1549#2:151\n1620#2,3:152\n1549#2:155\n1620#2,3:156\n1#3:146\n*S KotlinDebug\n*F\n+ 1 CompositeFigureGridLayoutBase.kt\norg/jetbrains/letsPlot/core/plot/builder/layout/figure/composite/CompositeFigureGridLayoutBase\n*L\n54#1:141\n54#1:142,4\n86#1:147\n86#1:148,3\n88#1:151\n88#1:152,3\n89#1:155\n89#1:156,3\n*E\n"})
public abstract class CompositeFigureGridLayoutBase {
    @NotNull
    private static final Companion Companion = new Companion(null);
    private final int ncols;
    private final int nrows;
    private final double hSpace;
    private final double vSpace;
    @Nullable
    private final List<Double> colWidths;
    @Nullable
    private final List<Double> rowHeights;
    private final boolean fitCellAspectRatio;
    @NotNull
    private final List<DoubleVector> elementsDefaultSizes;
    @NotNull
    private final ScaleSharePolicy scaleShareX;
    @NotNull
    private final ScaleSharePolicy scaleShareY;

    public CompositeFigureGridLayoutBase(int ncols, int nrows, double hSpace, double vSpace, @Nullable List<Double> colWidths, @Nullable List<Double> rowHeights, boolean fitCellAspectRatio, @NotNull List<DoubleVector> elementsDefaultSizes, @NotNull ScaleSharePolicy scaleShareX, @NotNull ScaleSharePolicy scaleShareY) {
        Intrinsics.checkNotNullParameter(elementsDefaultSizes, (String)"elementsDefaultSizes");
        Intrinsics.checkNotNullParameter((Object)((Object)scaleShareX), (String)"scaleShareX");
        Intrinsics.checkNotNullParameter((Object)((Object)scaleShareY), (String)"scaleShareY");
        this.ncols = ncols;
        this.nrows = nrows;
        this.hSpace = hSpace;
        this.vSpace = vSpace;
        this.colWidths = colWidths;
        this.rowHeights = rowHeights;
        this.fitCellAspectRatio = fitCellAspectRatio;
        this.elementsDefaultSizes = elementsDefaultSizes;
        this.scaleShareX = scaleShareX;
        this.scaleShareY = scaleShareY;
    }

    protected final int getNcols() {
        return this.ncols;
    }

    protected final int getNrows() {
        return this.nrows;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final List<FigureBuildInfo> toElelemtsWithInitialBounds(@NotNull DoubleRectangle bounds, @NotNull List<? extends FigureBuildInfo> elements) {
        void $this$mapIndexedTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        if (!(this.ncols > 0)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        if (!(this.nrows > 0)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        if (!(elements.size() == this.nrows * this.ncols)) {
            boolean bl = false;
            String string = "Grid size mismatch: " + elements.size() + " elements in a " + this.ncols + " X " + this.nrows + " grid.";
            throw new IllegalStateException(string.toString());
        }
        double hSpaceSum = this.hSpace * (double)(this.ncols - 1);
        double vSpaceSum = this.vSpace * (double)(this.nrows - 1);
        List<Double> cellWidthByCol = this.cellSizeList(bounds.getWidth() - hSpaceSum, this.ncols, this.colWidths);
        List<Double> cellHeightByRow = this.cellSizeList(bounds.getHeight() - vSpaceSum, this.nrows, this.rowHeights);
        Iterable $this$mapIndexed$iv = elements;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            FigureBuildInfo figureBuildInfo;
            void buildInfo;
            void index;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            FigureBuildInfo figureBuildInfo2 = (FigureBuildInfo)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            int row = FigureGridLayoutUtil.INSTANCE.indexToRow((int)index, this.ncols);
            int col = FigureGridLayoutUtil.INSTANCE.indexToCol((int)index, this.ncols);
            DoubleRectangle cellBounds = new DoubleRectangle(FigureGridLayoutUtil.INSTANCE.toCellOrigin(col, cellWidthByCol, this.hSpace), FigureGridLayoutUtil.INSTANCE.toCellOrigin(row, cellHeightByRow, this.vSpace), ((Number)cellWidthByCol.get(col)).doubleValue(), ((Number)cellHeightByRow.get(row)).doubleValue());
            if (buildInfo != null) {
                void it;
                DoubleRectangle doubleRectangle;
                boolean bl2 = false;
                if (this.fitCellAspectRatio) {
                    doubleRectangle = cellBounds;
                } else {
                    DoubleVector figureDefaultSize;
                    Intrinsics.checkNotNull((Object)this.elementsDefaultSizes.get((int)index));
                    doubleRectangle = cellBounds.srinkToAspectRatio(figureDefaultSize);
                }
                DoubleRectangle figureBounds = doubleRectangle;
                figureBuildInfo = it.withBounds(figureBounds.add(bounds.getOrigin()));
            } else {
                figureBuildInfo = null;
            }
            collection.add(figureBuildInfo);
        }
        return (List)destination$iv$iv;
    }

    private final List<Double> cellSizeList(double totalSize, int n, List<Double> sizeList) {
        double it;
        Iterable $this$mapTo$iv$iv;
        List list2;
        Collection<Double> collection;
        int n2;
        int n3;
        ArrayList<Double> arrayList = (ArrayList<Double>)sizeList;
        if (arrayList == null || arrayList.isEmpty()) {
            arrayList = new ArrayList<Double>(n);
            n3 = 0;
            while (n3 < n) {
                int n4 = n2 = n3++;
                collection = arrayList;
                boolean bl = false;
                ((ArrayList)collection).add(1.0);
            }
            list2 = arrayList;
        } else {
            collection = (ArrayList<Double>)sizeList;
            arrayList = new ArrayList(n);
            n3 = 0;
            while (n3 < n) {
                int it2 = n2 = n3++;
                ArrayList<Double> arrayList2 = arrayList;
                boolean bl = false;
                arrayList2.add(((Number)CollectionsKt.last(sizeList)).doubleValue());
            }
            list2 = CollectionsKt.take((Iterable)CollectionsKt.plus(collection, (Iterable)arrayList), (int)n);
        }
        List sizeList2 = list2;
        double sizeSum = CollectionsKt.sumOfDouble((Iterable)sizeList2);
        Iterable $this$map$iv = sizeList2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            double d = ((Number)item$iv$iv).doubleValue();
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add((double)(it / sizeSum));
        }
        List sizeListNorm = (List)destination$iv$iv;
        $this$map$iv = sizeListNorm;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = ((Number)item$iv$iv).doubleValue();
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it * totalSize);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = ((Number)item$iv$iv).doubleValue();
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Math.max(it, 1.0));
        }
        return (List)destination$iv$iv;
    }

    public final boolean hasSharedAxis() {
        return this.scaleShareX != ScaleSharePolicy.NONE || this.scaleShareY != ScaleSharePolicy.NONE;
    }

    @NotNull
    public final List<List<Integer>> indicesWithSharedXAxis(int elementCount) {
        return CompositeFigureGridLayoutBase.Companion.indicesWithSharedAxis(this.scaleShareX, elementCount, this.ncols);
    }

    @NotNull
    public final List<List<Integer>> indicesWithSharedYAxis(int elementCount) {
        return CompositeFigureGridLayoutBase.Companion.indicesWithSharedAxis(this.scaleShareY, elementCount, this.ncols);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u00042\u0018\u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00070\u0004H\u0002J,\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005H\u0002\u00a8\u0006\r"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/layout/figure/composite/CompositeFigureGridLayoutBase$Companion;", "", "()V", "groupByFirst", "", "", "pairs", "Lkotlin/Pair;", "indicesWithSharedAxis", "sharePolicy", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/figure/composite/ScaleSharePolicy;", "elementCount", "ncols", "plot-builder"})
    @SourceDebugExtension(value={"SMAP\nCompositeFigureGridLayoutBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompositeFigureGridLayoutBase.kt\norg/jetbrains/letsPlot/core/plot/builder/layout/figure/composite/CompositeFigureGridLayoutBase$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,140:1\n1#2:141\n1549#3:142\n1620#3,3:143\n1549#3:146\n1620#3,3:147\n1655#3,8:150\n*S KotlinDebug\n*F\n+ 1 CompositeFigureGridLayoutBase.kt\norg/jetbrains/letsPlot/core/plot/builder/layout/figure/composite/CompositeFigureGridLayoutBase$Companion\n*L\n114#1:142\n114#1:143,3\n122#1:146\n122#1:147,3\n131#1:150,8\n*E\n"})
    private static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        private final List<List<Integer>> indicesWithSharedAxis(ScaleSharePolicy sharePolicy, int elementCount, int ncols) {
            List<List<Integer>> list2;
            switch (WhenMappings.$EnumSwitchMapping$0[sharePolicy.ordinal()]) {
                case 1: {
                    list2 = CollectionsKt.listOf((Object)CollectionsKt.emptyList());
                    break;
                }
                case 2: {
                    ArrayList<Integer> arrayList = new ArrayList<Integer>(elementCount);
                    int n = 0;
                    while (n < elementCount) {
                        void it;
                        int n2;
                        int n3 = n2 = n++;
                        ArrayList<Integer> arrayList2 = arrayList;
                        boolean bl = false;
                        arrayList2.add((int)it);
                    }
                    list2 = CollectionsKt.listOf((Object)arrayList);
                    break;
                }
                case 3: {
                    void $this$mapTo$iv$iv;
                    Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)elementCount);
                    boolean $i$f$map = false;
                    Iterable it = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    Iterator iterator2 = $this$mapTo$iv$iv.iterator();
                    while (iterator2.hasNext()) {
                        void it2;
                        int item$iv$iv;
                        int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(TuplesKt.to((Object)FigureGridLayoutUtil.INSTANCE.indexToRow((int)it2, ncols), (Object)((int)it2)));
                    }
                    List indexByRow = (List)destination$iv$iv;
                    list2 = this.groupByFirst(indexByRow);
                    break;
                }
                case 4: {
                    Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)elementCount);
                    boolean $i$f$map = false;
                    Iterable $this$mapTo$iv$iv = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    Iterator iterator3 = $this$mapTo$iv$iv.iterator();
                    while (iterator3.hasNext()) {
                        int item$iv$iv;
                        int it2 = item$iv$iv = ((IntIterator)iterator3).nextInt();
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(TuplesKt.to((Object)FigureGridLayoutUtil.INSTANCE.indexToCol(it2, ncols), (Object)it2));
                    }
                    List indexByCol = (List)destination$iv$iv;
                    list2 = this.groupByFirst(indexByCol);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return list2;
        }

        /*
         * WARNING - void declaration
         */
        private final List<List<Integer>> groupByFirst(List<Pair<Integer, Integer>> pairs) {
            void pair2;
            Iterable $this$distinctBy$iv = pairs;
            boolean $i$f$distinctBy = false;
            HashSet<Integer> hashSet = new HashSet<Integer>();
            ArrayList list$iv = new ArrayList();
            for (Object e$iv : $this$distinctBy$iv) {
                Pair it = (Pair)e$iv;
                boolean bl = false;
                Integer key$iv = ((Number)it.getFirst()).intValue();
                if (!hashSet.add(key$iv)) continue;
                list$iv.add(e$iv);
            }
            int numGroups = ((List)list$iv).size();
            ArrayList arrayList = new ArrayList(numGroups);
            boolean n = false;
            while (pair2 < numGroups) {
                void var7_13 = list$iv = pair2++;
                ArrayList arrayList2 = arrayList;
                boolean bl = false;
                arrayList2.add(new ArrayList());
            }
            List groupsList = arrayList;
            for (Pair pair3 : pairs) {
                int group2 = ((Number)pair3.component1()).intValue();
                int value = ((Number)pair3.component2()).intValue();
                ((ArrayList)groupsList.get(group2)).add(value);
            }
            return groupsList;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ScaleSharePolicy.values().length];
                try {
                    nArray[ScaleSharePolicy.NONE.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ScaleSharePolicy.ALL.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ScaleSharePolicy.ROW.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ScaleSharePolicy.COL.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

