/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.layout;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.core.plot.base.layout.Thickness;
import org.jetbrains.letsPlot.core.plot.base.theme.AxisTheme;
import org.jetbrains.letsPlot.core.plot.builder.coord.CoordProvider;
import org.jetbrains.letsPlot.core.plot.builder.layout.PlotLayout;
import org.jetbrains.letsPlot.core.plot.builder.layout.PlotLayoutInfo;
import org.jetbrains.letsPlot.core.plot.builder.layout.PlotLayoutUtil;
import org.jetbrains.letsPlot.core.plot.builder.layout.TileLayout;
import org.jetbrains.letsPlot.core.plot.builder.layout.TileLayoutInfo;
import org.jetbrains.letsPlot.core.plot.builder.layout.util.Insets;
import org.jetbrains.letsPlot.core.plot.builder.scale.AxisPosition;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\nJ \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J \u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/layout/SingleTilePlotLayout;", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/PlotLayout;", "tileLayout", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/TileLayout;", "hAxisPosition", "Lorg/jetbrains/letsPlot/core/plot/builder/scale/AxisPosition;", "vAxisPosition", "hAxisTheme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/AxisTheme;", "vAxisTheme", "(Lorg/jetbrains/letsPlot/core/plot/builder/layout/TileLayout;Lorg/jetbrains/letsPlot/core/plot/builder/scale/AxisPosition;Lorg/jetbrains/letsPlot/core/plot/builder/scale/AxisPosition;Lorg/jetbrains/letsPlot/core/plot/base/theme/AxisTheme;Lorg/jetbrains/letsPlot/core/plot/base/theme/AxisTheme;)V", "insets", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/util/Insets;", "doLayout", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/PlotLayoutInfo;", "preferredSize", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "coordProvider", "Lorg/jetbrains/letsPlot/core/plot/builder/coord/CoordProvider;", "plotMargins", "Lorg/jetbrains/letsPlot/core/plot/base/layout/Thickness;", "layoutByGeomSize", "geomSize", "layoutOuterSize", "outerSize", "tileInfoToPlotInfo", "tileInfo", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/TileLayoutInfo;", "plot-builder"})
public final class SingleTilePlotLayout
implements PlotLayout {
    @NotNull
    private final TileLayout tileLayout;
    @NotNull
    private final Insets insets;

    public SingleTilePlotLayout(@NotNull TileLayout tileLayout, @NotNull AxisPosition hAxisPosition, @NotNull AxisPosition vAxisPosition, @NotNull AxisTheme hAxisTheme, @NotNull AxisTheme vAxisTheme) {
        Intrinsics.checkNotNullParameter((Object)tileLayout, (String)"tileLayout");
        Intrinsics.checkNotNullParameter((Object)((Object)hAxisPosition), (String)"hAxisPosition");
        Intrinsics.checkNotNullParameter((Object)((Object)vAxisPosition), (String)"vAxisPosition");
        Intrinsics.checkNotNullParameter((Object)hAxisTheme, (String)"hAxisTheme");
        Intrinsics.checkNotNullParameter((Object)vAxisTheme, (String)"vAxisTheme");
        this.tileLayout = tileLayout;
        this.insets = PlotLayoutUtil.INSTANCE.plotInsets(hAxisPosition, vAxisPosition, hAxisTheme, vAxisTheme);
    }

    @Override
    @NotNull
    public PlotLayoutInfo doLayout(@NotNull DoubleVector preferredSize, @NotNull CoordProvider coordProvider, @NotNull Thickness plotMargins) {
        Intrinsics.checkNotNullParameter((Object)preferredSize, (String)"preferredSize");
        Intrinsics.checkNotNullParameter((Object)coordProvider, (String)"coordProvider");
        Intrinsics.checkNotNullParameter((Object)plotMargins, (String)"plotMargins");
        return this.tileLayout.getInsideOut() ? this.layoutByGeomSize(preferredSize, coordProvider) : this.layoutOuterSize(preferredSize, coordProvider, plotMargins);
    }

    private final PlotLayoutInfo layoutOuterSize(DoubleVector outerSize, CoordProvider coordProvider, Thickness plotMargins) {
        DoubleVector tilePreferredSize = outerSize.subtract(this.insets.getLeftTop()).subtract(this.insets.getRightBottom()).subtract(new DoubleVector(plotMargins.width(), plotMargins.height()));
        TileLayoutInfo tileInfo = this.tileLayout.doLayout(tilePreferredSize, coordProvider).withOffset(this.insets.getLeftTop());
        return this.tileInfoToPlotInfo(tileInfo);
    }

    private final PlotLayoutInfo layoutByGeomSize(DoubleVector geomSize, CoordProvider coordProvider) {
        TileLayoutInfo tileInfo = this.tileLayout.doLayout(geomSize, coordProvider).withOffset(this.insets.getLeftTop()).withNormalizedOrigin();
        return this.tileInfoToPlotInfo(tileInfo);
    }

    private final PlotLayoutInfo tileInfoToPlotInfo(TileLayoutInfo tileInfo) {
        return new PlotLayoutInfo(CollectionsKt.listOf((Object)tileInfo), this.insets);
    }
}

