/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.layout;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.core.plot.base.guide.LegendPosition;
import org.jetbrains.letsPlot.core.plot.base.layout.Thickness;
import org.jetbrains.letsPlot.core.plot.base.render.svg.MultilineLabel;
import org.jetbrains.letsPlot.core.plot.base.theme.AxisTheme;
import org.jetbrains.letsPlot.core.plot.base.theme.LegendTheme;
import org.jetbrains.letsPlot.core.plot.base.theme.PlotTheme;
import org.jetbrains.letsPlot.core.plot.base.theme.Theme;
import org.jetbrains.letsPlot.core.plot.builder.layout.LayoutConstants;
import org.jetbrains.letsPlot.core.plot.builder.layout.LegendsBlockInfo;
import org.jetbrains.letsPlot.core.plot.builder.layout.PlotLabelSpecFactory;
import org.jetbrains.letsPlot.core.plot.builder.layout.PlotLayoutInfo;
import org.jetbrains.letsPlot.core.plot.builder.layout.TileLayoutInfo;
import org.jetbrains.letsPlot.core.plot.builder.layout.util.Insets;
import org.jetbrains.letsPlot.core.plot.builder.presentation.LabelSpec;
import org.jetbrains.letsPlot.core.plot.builder.scale.AxisPosition;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J`\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00072\b\u0010\t\u001a\u0004\u0018\u00010\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u00072\b\u0010\u000b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\rJ\u0016\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\rJR\u0010\u0014\u001a\u00020\u00042\u0014\u0010\u0015\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0004\u0012\u00020\u00170\u00162\u0014\u0010\u0018\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u0004JD\u0010\u001c\u001a\u00020\u00042\u0014\u0010\u0015\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0004\u0012\u00020\u00170\u00162\u0014\u0010\u0018\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u0004H\u0002J\u0018\u0010\u001d\u001a\u00020\u00042\b\u0010\t\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0010\u001a\u00020\u001eJ\u0018\u0010\u001f\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u00072\u0006\u0010!\u001a\u00020\u0017H\u0002J\u0018\u0010\"\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020#H\u0002J\u0016\u0010$\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020#J\u000e\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(J\u000e\u0010)\u001a\u00020&2\u0006\u0010'\u001a\u00020(J&\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020-2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u000200J`\u00102\u001a\u00020\u00042\u0006\u00103\u001a\u00020\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00072\b\u0010\t\u001a\u0004\u0018\u00010\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u00072\b\u0010\u000b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\rJ\u001d\u00104\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u00072\u0006\u0010!\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\b5J\u001e\u00106\u001a\b\u0012\u0004\u0012\u00020\u0004072\u0006\u0010 \u001a\u00020\u00072\u0006\u0010!\u001a\u00020\u0017H\u0002J\"\u00108\u001a\u00020\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0010\u001a\u00020\u001eJ\"\u00109\u001a\u00020:2\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010!\u001a\u00020\u00172\u0006\u0010;\u001a\u00020:H\u0002J'\u00109\u001a\u00020:2\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010!\u001a\u00020\u00172\u0006\u0010<\u001a\u00020=H\u0000\u00a2\u0006\u0002\b>JZ\u0010?\u001a\u00020\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00072\b\u0010\t\u001a\u0004\u0018\u00010\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u00072\b\u0010\u000b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\rH\u0002\u00a8\u0006@"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/layout/PlotLayoutUtil;", "", "()V", "addTitlesAndLegends", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "base", "title", "", "subtitle", "caption", "hAxisTitle", "vAxisTitle", "axisEnabled", "", "legendsBlockInfo", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/LegendsBlockInfo;", "theme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/Theme;", "flippedAxis", "axisMarginDimensions", "axisTitlesOriginOffset", "hAxisTitleInfo", "Lkotlin/Pair;", "Lorg/jetbrains/letsPlot/core/plot/builder/presentation/LabelSpec;", "vAxisTitleInfo", "hasTopAxisTitle", "hasLeftAxisTitle", "marginDimensions", "axisTitlesSizeDelta", "captionSizeDelta", "Lorg/jetbrains/letsPlot/core/plot/base/theme/PlotTheme;", "labelDimensions", "text", "labelSpec", "legendBlockDelta", "Lorg/jetbrains/letsPlot/core/plot/base/theme/LegendTheme;", "legendBlockLeftTopDelta", "overallGeomBounds", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "plotLayoutInfo", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/PlotLayoutInfo;", "overallTileBounds", "plotInsets", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/util/Insets;", "hAxisPosition", "Lorg/jetbrains/letsPlot/core/plot/builder/scale/AxisPosition;", "vAxisPosition", "hAxisTheme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/AxisTheme;", "vAxisTheme", "subtractTitlesAndLegends", "baseSize", "textDimensions", "textDimensions$plot_builder", "textLinesDimensions", "", "titleSizeDelta", "titleThickness", "", "margin", "margins", "Lorg/jetbrains/letsPlot/core/plot/base/layout/Thickness;", "titleThickness$plot_builder", "titlesAndLegendsSizeDelta", "plot-builder"})
@SourceDebugExtension(value={"SMAP\nPlotLayoutUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlotLayoutUtil.kt\norg/jetbrains/letsPlot/core/plot/builder/layout/PlotLayoutUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,285:1\n1549#2:286\n1620#2,3:287\n1789#2,3:290\n1549#2:294\n1620#2,3:295\n2661#2,7:298\n1549#2:305\n1620#2,3:306\n2661#2,7:309\n1#3:293\n*S KotlinDebug\n*F\n+ 1 PlotLayoutUtil.kt\norg/jetbrains/letsPlot/core/plot/builder/layout/PlotLayoutUtil\n*L\n60#1:286\n60#1:287,3\n71#1:290,3\n85#1:294\n85#1:295,3\n85#1:298,7\n92#1:305\n92#1:306,3\n92#1:309,7\n*E\n"})
public final class PlotLayoutUtil {
    @NotNull
    public static final PlotLayoutUtil INSTANCE = new PlotLayoutUtil();

    private PlotLayoutUtil() {
    }

    @NotNull
    public final Insets plotInsets(@NotNull AxisPosition hAxisPosition, @NotNull AxisPosition vAxisPosition, @NotNull AxisTheme hAxisTheme, @NotNull AxisTheme vAxisTheme) {
        Pair pair2;
        Pair pair3;
        Intrinsics.checkNotNullParameter((Object)((Object)hAxisPosition), (String)"hAxisPosition");
        Intrinsics.checkNotNullParameter((Object)((Object)vAxisPosition), (String)"vAxisPosition");
        Intrinsics.checkNotNullParameter((Object)hAxisTheme, (String)"hAxisTheme");
        Intrinsics.checkNotNullParameter((Object)vAxisTheme, (String)"vAxisTheme");
        double vPadding = hAxisTheme.showTitle() || hAxisTheme.showLabels() ? 0.0 : 10.0;
        double hPadding = vAxisTheme.showTitle() || vAxisTheme.showLabels() ? 0.0 : 10.0;
        switch (WhenMappings.$EnumSwitchMapping$0[vAxisPosition.ordinal()]) {
            case 1: {
                pair3 = new Pair((Object)hPadding, (Object)10.0);
                break;
            }
            case 2: {
                pair3 = new Pair((Object)10.0, (Object)hPadding);
                break;
            }
            case 3: {
                pair3 = new Pair((Object)hPadding, (Object)hPadding);
                break;
            }
            default: {
                throw new IllegalStateException("Illegal vertical axis position: " + (Object)((Object)vAxisPosition));
            }
        }
        Pair pair4 = pair3;
        double left = ((Number)pair4.component1()).doubleValue();
        double right = ((Number)pair4.component2()).doubleValue();
        switch (WhenMappings.$EnumSwitchMapping$0[hAxisPosition.ordinal()]) {
            case 4: {
                pair2 = new Pair((Object)vPadding, (Object)10.0);
                break;
            }
            case 5: {
                pair2 = new Pair((Object)10.0, (Object)vPadding);
                break;
            }
            case 6: {
                pair2 = new Pair((Object)vPadding, (Object)vPadding);
                break;
            }
            default: {
                throw new IllegalStateException("Illegal horizontal axis position: " + (Object)((Object)hAxisPosition));
            }
        }
        Pair pair5 = pair2;
        double top = ((Number)pair5.component1()).doubleValue();
        double bottom = ((Number)pair5.component2()).doubleValue();
        return new Insets(left, top, right, bottom);
    }

    private final DoubleVector labelDimensions(String text2, LabelSpec labelSpec) {
        if (((CharSequence)text2).length() == 0) {
            return new DoubleVector(0.0, labelSpec.height());
        }
        return new DoubleVector(labelSpec.width(text2), labelSpec.height());
    }

    /*
     * WARNING - void declaration
     */
    private final List<DoubleVector> textLinesDimensions(String text2, LabelSpec labelSpec) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = MultilineLabel.Companion.splitLines(text2);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void line2;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(INSTANCE.labelDimensions((String)line2, labelSpec));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final DoubleVector textDimensions$plot_builder(@NotNull String text2, @NotNull LabelSpec labelSpec) {
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)labelSpec, (String)"labelSpec");
        Iterable iterable = this.textLinesDimensions(text2, labelSpec);
        DoubleVector initial$iv = DoubleVector.Companion.getZERO();
        boolean $i$f$fold = false;
        DoubleVector accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void dv;
            DoubleVector doubleVector = (DoubleVector)element$iv;
            DoubleVector acc = accumulator$iv;
            boolean bl = false;
            accumulator$iv = PlotLayoutUtil.textDimensions$union(acc, (DoubleVector)dv);
        }
        return accumulator$iv;
    }

    private final double titleThickness(String title, LabelSpec labelSpec, double margin) {
        if (title == null) {
            return 0.0;
        }
        return this.textDimensions$plot_builder(title, labelSpec).getY() + margin;
    }

    public final double titleThickness$plot_builder(@Nullable String title, @NotNull LabelSpec labelSpec, @NotNull Thickness margins) {
        Intrinsics.checkNotNullParameter((Object)labelSpec, (String)"labelSpec");
        Intrinsics.checkNotNullParameter((Object)margins, (String)"margins");
        return this.titleThickness(title, labelSpec, margins.height());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final DoubleRectangle overallGeomBounds(@NotNull PlotLayoutInfo plotLayoutInfo) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)plotLayoutInfo, (String)"plotLayoutInfo");
        if (!(!((Collection)plotLayoutInfo.getTiles()).isEmpty())) {
            boolean $i$a$-require-PlotLayoutUtil$overallGeomBounds$22 = false;
            String $i$a$-require-PlotLayoutUtil$overallGeomBounds$22 = "Plot is empty";
            throw new IllegalArgumentException($i$a$-require-PlotLayoutUtil$overallGeomBounds$22.toString());
        }
        Iterable $this$map$iv = plotLayoutInfo.getTiles();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TileLayoutInfo tileLayoutInfo = (TileLayoutInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getAbsoluteOuterGeomBounds(DoubleVector.Companion.getZERO()));
        }
        Iterable $this$reduce$iv = (List)destination$iv$iv;
        boolean $i$f$reduce = false;
        Iterator iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void r1;
            DoubleRectangle $i$f$mapTo2 = (DoubleRectangle)iterator$iv.next();
            DoubleRectangle r0 = (DoubleRectangle)accumulator$iv;
            boolean bl = false;
            accumulator$iv = r0.union((DoubleRectangle)r1);
        }
        return (DoubleRectangle)accumulator$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final DoubleRectangle overallTileBounds(@NotNull PlotLayoutInfo plotLayoutInfo) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)plotLayoutInfo, (String)"plotLayoutInfo");
        if (!(!((Collection)plotLayoutInfo.getTiles()).isEmpty())) {
            boolean $i$a$-require-PlotLayoutUtil$overallTileBounds$22 = false;
            String $i$a$-require-PlotLayoutUtil$overallTileBounds$22 = "Plot is empty";
            throw new IllegalArgumentException($i$a$-require-PlotLayoutUtil$overallTileBounds$22.toString());
        }
        Iterable $this$map$iv = plotLayoutInfo.getTiles();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TileLayoutInfo tileLayoutInfo = (TileLayoutInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getAbsoluteBounds(DoubleVector.Companion.getZERO()));
        }
        Iterable $this$reduce$iv = (List)destination$iv$iv;
        boolean $i$f$reduce = false;
        Iterator iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void r1;
            DoubleRectangle $i$f$mapTo2 = (DoubleRectangle)iterator$iv.next();
            DoubleRectangle r0 = (DoubleRectangle)accumulator$iv;
            boolean bl = false;
            accumulator$iv = r0.union((DoubleRectangle)r1);
        }
        return (DoubleRectangle)accumulator$iv;
    }

    @NotNull
    public final DoubleVector subtractTitlesAndLegends(@NotNull DoubleVector baseSize, @Nullable String title, @Nullable String subtitle, @Nullable String caption, @Nullable String hAxisTitle, @Nullable String vAxisTitle, boolean axisEnabled, @NotNull LegendsBlockInfo legendsBlockInfo, @NotNull Theme theme2, boolean flippedAxis) {
        Intrinsics.checkNotNullParameter((Object)baseSize, (String)"baseSize");
        Intrinsics.checkNotNullParameter((Object)legendsBlockInfo, (String)"legendsBlockInfo");
        Intrinsics.checkNotNullParameter((Object)theme2, (String)"theme");
        DoubleVector delta = this.titlesAndLegendsSizeDelta(title, subtitle, caption, hAxisTitle, vAxisTitle, axisEnabled, legendsBlockInfo, theme2, flippedAxis);
        DoubleVector reduced = baseSize.subtract(delta);
        return new DoubleVector(Math.max(reduced.getX(), LayoutConstants.INSTANCE.getGEOM_MIN_SIZE().getX()), Math.max(reduced.getY(), LayoutConstants.INSTANCE.getGEOM_MIN_SIZE().getY()));
    }

    @NotNull
    public final DoubleVector addTitlesAndLegends(@NotNull DoubleVector base, @Nullable String title, @Nullable String subtitle, @Nullable String caption, @Nullable String hAxisTitle, @Nullable String vAxisTitle, boolean axisEnabled, @NotNull LegendsBlockInfo legendsBlockInfo, @NotNull Theme theme2, boolean flippedAxis) {
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        Intrinsics.checkNotNullParameter((Object)legendsBlockInfo, (String)"legendsBlockInfo");
        Intrinsics.checkNotNullParameter((Object)theme2, (String)"theme");
        DoubleVector delta = this.titlesAndLegendsSizeDelta(title, subtitle, caption, hAxisTitle, vAxisTitle, axisEnabled, legendsBlockInfo, theme2, flippedAxis);
        return base.add(delta);
    }

    private final DoubleVector titlesAndLegendsSizeDelta(String title, String subtitle, String caption, String hAxisTitle, String vAxisTitle, boolean axisEnabled, LegendsBlockInfo legendsBlockInfo, Theme theme2, boolean flippedAxis) {
        DoubleVector titleDelta = this.titleSizeDelta(title, subtitle, theme2.plot());
        DoubleVector axisTitlesDelta = this.axisTitlesSizeDelta((Pair<String, ? extends LabelSpec>)TuplesKt.to((Object)hAxisTitle, (Object)PlotLabelSpecFactory.INSTANCE.axisTitle(theme2.horizontalAxis(flippedAxis))), (Pair<String, ? extends LabelSpec>)TuplesKt.to((Object)vAxisTitle, (Object)PlotLabelSpecFactory.INSTANCE.axisTitle(theme2.verticalAxis(flippedAxis))), axisEnabled, this.axisMarginDimensions(theme2, flippedAxis));
        DoubleVector legendBlockDelta = this.legendBlockDelta(legendsBlockInfo, theme2.legend());
        DoubleVector captionDelta = this.captionSizeDelta(caption, theme2.plot());
        return titleDelta.add(axisTitlesDelta).add(legendBlockDelta).add(captionDelta);
    }

    @NotNull
    public final DoubleVector titleSizeDelta(@Nullable String title, @Nullable String subtitle, @NotNull PlotTheme theme2) {
        Intrinsics.checkNotNullParameter((Object)theme2, (String)"theme");
        return new DoubleVector(0.0, this.titleThickness$plot_builder(title, PlotLabelSpecFactory.INSTANCE.plotTitle(theme2), theme2.titleMargins()) + this.titleThickness$plot_builder(subtitle, PlotLabelSpecFactory.INSTANCE.plotSubtitle(theme2), theme2.subtitleMargins()));
    }

    @NotNull
    public final DoubleVector captionSizeDelta(@Nullable String caption, @NotNull PlotTheme theme2) {
        Intrinsics.checkNotNullParameter((Object)theme2, (String)"theme");
        return new DoubleVector(0.0, this.titleThickness$plot_builder(caption, PlotLabelSpecFactory.INSTANCE.plotCaption(theme2), theme2.captionMargins()));
    }

    @NotNull
    public final DoubleVector axisMarginDimensions(@NotNull Theme theme2, boolean flippedAxis) {
        Intrinsics.checkNotNullParameter((Object)theme2, (String)"theme");
        double width2 = theme2.verticalAxis(flippedAxis).titleMargins().width();
        double height = theme2.horizontalAxis(flippedAxis).titleMargins().height();
        return new DoubleVector(width2, height);
    }

    private final DoubleVector axisTitlesSizeDelta(Pair<String, ? extends LabelSpec> hAxisTitleInfo, Pair<String, ? extends LabelSpec> vAxisTitleInfo, boolean axisEnabled, DoubleVector marginDimensions) {
        DoubleVector doubleVector;
        if (axisEnabled) {
            double hAxisThickness = this.titleThickness((String)hAxisTitleInfo.getFirst(), (LabelSpec)hAxisTitleInfo.getSecond(), marginDimensions.getY());
            double vAxisThickness = this.titleThickness((String)vAxisTitleInfo.getFirst(), (LabelSpec)vAxisTitleInfo.getSecond(), marginDimensions.getX());
            doubleVector = new DoubleVector(vAxisThickness, hAxisThickness);
        } else {
            doubleVector = DoubleVector.Companion.getZERO();
        }
        return doubleVector;
    }

    @NotNull
    public final DoubleVector axisTitlesOriginOffset(@NotNull Pair<String, ? extends LabelSpec> hAxisTitleInfo, @NotNull Pair<String, ? extends LabelSpec> vAxisTitleInfo, boolean hasTopAxisTitle, boolean hasLeftAxisTitle, boolean axisEnabled, @NotNull DoubleVector marginDimensions) {
        DoubleVector doubleVector;
        Intrinsics.checkNotNullParameter(hAxisTitleInfo, (String)"hAxisTitleInfo");
        Intrinsics.checkNotNullParameter(vAxisTitleInfo, (String)"vAxisTitleInfo");
        Intrinsics.checkNotNullParameter((Object)marginDimensions, (String)"marginDimensions");
        if (axisEnabled) {
            double yOffset2 = hasTopAxisTitle ? this.titleThickness((String)hAxisTitleInfo.getFirst(), (LabelSpec)hAxisTitleInfo.getSecond(), marginDimensions.getY()) : 0.0;
            double xOffset2 = hasLeftAxisTitle ? this.titleThickness((String)vAxisTitleInfo.getFirst(), (LabelSpec)vAxisTitleInfo.getSecond(), marginDimensions.getX()) : 0.0;
            doubleVector = new DoubleVector(xOffset2, yOffset2);
        } else {
            doubleVector = DoubleVector.Companion.getZERO();
        }
        return doubleVector;
    }

    private final DoubleVector legendBlockDelta(LegendsBlockInfo legendsBlockInfo, LegendTheme theme2) {
        if (!theme2.position().isFixed()) {
            return DoubleVector.Companion.getZERO();
        }
        DoubleVector size2 = legendsBlockInfo.size();
        LegendPosition legendPosition = theme2.position();
        return (Intrinsics.areEqual((Object)legendPosition, (Object)LegendPosition.Companion.getLEFT()) ? true : Intrinsics.areEqual((Object)legendPosition, (Object)LegendPosition.Companion.getRIGHT())) ? new DoubleVector(size2.getX(), 0.0) : new DoubleVector(0.0, size2.getY());
    }

    @NotNull
    public final DoubleVector legendBlockLeftTopDelta(@NotNull LegendsBlockInfo legendsBlockInfo, @NotNull LegendTheme theme2) {
        Intrinsics.checkNotNullParameter((Object)legendsBlockInfo, (String)"legendsBlockInfo");
        Intrinsics.checkNotNullParameter((Object)theme2, (String)"theme");
        if (!theme2.position().isFixed()) {
            return DoubleVector.Companion.getZERO();
        }
        DoubleVector size2 = legendsBlockInfo.size();
        LegendPosition legendPosition = theme2.position();
        return Intrinsics.areEqual((Object)legendPosition, (Object)LegendPosition.Companion.getLEFT()) ? new DoubleVector(size2.getX(), 0.0) : (Intrinsics.areEqual((Object)legendPosition, (Object)LegendPosition.Companion.getTOP()) ? new DoubleVector(0.0, size2.getY()) : DoubleVector.Companion.getZERO());
    }

    private static final DoubleVector textDimensions$union(DoubleVector $this$textDimensions_u24union, DoubleVector p) {
        return new DoubleVector(Math.max($this$textDimensions_u24union.getX(), p.getX()), $this$textDimensions_u24union.getY() + p.getY());
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AxisPosition.values().length];
            try {
                nArray[AxisPosition.LEFT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AxisPosition.RIGHT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AxisPosition.LR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AxisPosition.TOP.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AxisPosition.BOTTOM.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AxisPosition.TB.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

