/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.frame;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.core.plot.base.Aes;
import org.jetbrains.letsPlot.core.plot.base.Aesthetics;
import org.jetbrains.letsPlot.core.plot.base.CoordinateSystem;
import org.jetbrains.letsPlot.core.plot.base.Geom;
import org.jetbrains.letsPlot.core.plot.base.PlotContext;
import org.jetbrains.letsPlot.core.plot.base.PositionAdjustment;
import org.jetbrains.letsPlot.core.plot.base.ScaleMapper;
import org.jetbrains.letsPlot.core.plot.base.render.svg.SvgComponent;
import org.jetbrains.letsPlot.core.plot.base.scale.ScaleBreaks;
import org.jetbrains.letsPlot.core.plot.base.theme.AxisTheme;
import org.jetbrains.letsPlot.core.plot.base.theme.PanelGridTheme;
import org.jetbrains.letsPlot.core.plot.base.theme.PanelTheme;
import org.jetbrains.letsPlot.core.plot.base.theme.Theme;
import org.jetbrains.letsPlot.core.plot.base.tooltip.GeomTargetCollector;
import org.jetbrains.letsPlot.core.plot.builder.AxisUtil;
import org.jetbrains.letsPlot.core.plot.builder.FrameOfReference;
import org.jetbrains.letsPlot.core.plot.builder.GeomLayer;
import org.jetbrains.letsPlot.core.plot.builder.LayerRendererUtil;
import org.jetbrains.letsPlot.core.plot.builder.SvgLayerRenderer;
import org.jetbrains.letsPlot.core.plot.builder.assemble.GeomContextBuilder;
import org.jetbrains.letsPlot.core.plot.builder.assemble.ImmutableGeomContext;
import org.jetbrains.letsPlot.core.plot.builder.guide.AxisComponent;
import org.jetbrains.letsPlot.core.plot.builder.guide.GridComponent;
import org.jetbrains.letsPlot.core.plot.builder.layout.AxisLayoutInfo;
import org.jetbrains.letsPlot.core.plot.builder.layout.GeomMarginsLayout;
import org.jetbrains.letsPlot.core.plot.builder.layout.TileLayoutInfo;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgRectElement;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0010\u0018\u0000 ?2\u00020\u0001:\u0001?BM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0004J\u0018\u0010$\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u001fH\u0014J\u0018\u0010(\u001a\u00020&2\u0006\u0010)\u001a\u00020*2\u0006\u0010'\u001a\u00020\u001fH\u0014J\u0010\u0010+\u001a\u00020&2\u0006\u0010'\u001a\u00020\u001fH\u0014J\u0010\u0010,\u001a\u00020&2\u0006\u0010'\u001a\u00020\u001fH\u0014J\u0018\u0010-\u001a\u00020&2\u0006\u0010.\u001a\u00020*2\u0006\u0010'\u001a\u00020\u001fH\u0014J\u0010\u0010/\u001a\u00020&2\u0006\u0010'\u001a\u00020\u001fH\u0014J\u0010\u00100\u001a\u00020&2\u0006\u0010'\u001a\u00020\u001fH\u0014J\u0010\u00101\u001a\u00020&2\u0006\u0010'\u001a\u00020\u001fH\u0016J\u0010\u00102\u001a\u00020&2\u0006\u0010'\u001a\u00020\u001fH\u0016J\u0018\u00103\u001a\u00020&2\u0006\u0010'\u001a\u00020\u001f2\u0006\u00104\u001a\u00020\u0006H\u0004J\u0018\u00105\u001a\u00020&2\u0006\u0010'\u001a\u00020\u001f2\u0006\u00106\u001a\u00020\u0010H\u0014J,\u00107\u001a\u000e\u0012\u0004\u0012\u000209\u0012\u0004\u0012\u00020:082\u0006\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020\u00032\u0006\u0010>\u001a\u00020\u0015H\u0014R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u0015X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\u00020\u0015X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0017R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/frame/SquareFrameOfReference;", "Lorg/jetbrains/letsPlot/core/plot/builder/FrameOfReference;", "hScaleBreaks", "Lorg/jetbrains/letsPlot/core/plot/base/scale/ScaleBreaks;", "vScaleBreaks", "adjustedDomain", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "coord", "Lorg/jetbrains/letsPlot/core/plot/base/CoordinateSystem;", "layoutInfo", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/TileLayoutInfo;", "marginsLayout", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/GeomMarginsLayout;", "theme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/Theme;", "flipAxis", "", "plotContext", "Lorg/jetbrains/letsPlot/core/plot/base/PlotContext;", "(Lorg/jetbrains/letsPlot/core/plot/base/scale/ScaleBreaks;Lorg/jetbrains/letsPlot/core/plot/base/scale/ScaleBreaks;Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;Lorg/jetbrains/letsPlot/core/plot/base/CoordinateSystem;Lorg/jetbrains/letsPlot/core/plot/builder/layout/TileLayoutInfo;Lorg/jetbrains/letsPlot/core/plot/builder/layout/GeomMarginsLayout;Lorg/jetbrains/letsPlot/core/plot/base/theme/Theme;ZLorg/jetbrains/letsPlot/core/plot/base/PlotContext;)V", "hAxisTheme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/AxisTheme;", "getHAxisTheme", "()Lorg/jetbrains/letsPlot/core/plot/base/theme/AxisTheme;", "isDebugDrawing", "()Z", "setDebugDrawing", "(Z)V", "vAxisTheme", "getVAxisTheme", "buildGeom", "Lorg/jetbrains/letsPlot/core/plot/base/render/svg/SvgComponent;", "layer", "Lorg/jetbrains/letsPlot/core/plot/builder/GeomLayer;", "targetCollector", "Lorg/jetbrains/letsPlot/core/plot/base/tooltip/GeomTargetCollector;", "buildGeomComponent", "doDrawHAxis", "", "parent", "doDrawHGrid", "hGridTheme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/PanelGridTheme;", "doDrawPanelBorder", "doDrawVAxis", "doDrawVGrid", "vGridTheme", "doFillBkgr", "doStrokeBkgr", "drawAfterGeomLayer", "drawBeforeGeomLayer", "drawDebugShapes", "geomBounds", "drawPanelAndAxis", "beforeGeomLayer", "prepareAxisData", "Lkotlin/Pair;", "Lorg/jetbrains/letsPlot/core/plot/builder/guide/AxisComponent$TickLabelAdjustments;", "Lorg/jetbrains/letsPlot/core/plot/builder/guide/AxisComponent$BreaksData;", "axisInfo", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/AxisLayoutInfo;", "scaleBreaks", "axisTheme", "Companion", "plot-builder"})
@SourceDebugExtension(value={"SMAP\nSquareFrameOfReference.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SquareFrameOfReference.kt\norg/jetbrains/letsPlot/core/plot/builder/frame/SquareFrameOfReference\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,373:1\n1855#2,2:374\n1855#2,2:376\n1855#2,2:378\n1855#2,2:380\n*S KotlinDebug\n*F\n+ 1 SquareFrameOfReference.kt\norg/jetbrains/letsPlot/core/plot/builder/frame/SquareFrameOfReference\n*L\n116#1:374,2\n141#1:376,2\n166#1:378,2\n177#1:380,2\n*E\n"})
public class SquareFrameOfReference
implements FrameOfReference {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ScaleBreaks hScaleBreaks;
    @NotNull
    private final ScaleBreaks vScaleBreaks;
    @NotNull
    private final DoubleRectangle adjustedDomain;
    @NotNull
    private final CoordinateSystem coord;
    @NotNull
    private final TileLayoutInfo layoutInfo;
    @NotNull
    private final GeomMarginsLayout marginsLayout;
    @NotNull
    private final Theme theme;
    private final boolean flipAxis;
    @NotNull
    private final PlotContext plotContext;
    private boolean isDebugDrawing;
    @NotNull
    private final AxisTheme hAxisTheme;
    @NotNull
    private final AxisTheme vAxisTheme;

    public SquareFrameOfReference(@NotNull ScaleBreaks hScaleBreaks, @NotNull ScaleBreaks vScaleBreaks, @NotNull DoubleRectangle adjustedDomain, @NotNull CoordinateSystem coord, @NotNull TileLayoutInfo layoutInfo, @NotNull GeomMarginsLayout marginsLayout, @NotNull Theme theme2, boolean flipAxis, @NotNull PlotContext plotContext) {
        Intrinsics.checkNotNullParameter((Object)hScaleBreaks, (String)"hScaleBreaks");
        Intrinsics.checkNotNullParameter((Object)vScaleBreaks, (String)"vScaleBreaks");
        Intrinsics.checkNotNullParameter((Object)adjustedDomain, (String)"adjustedDomain");
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        Intrinsics.checkNotNullParameter((Object)layoutInfo, (String)"layoutInfo");
        Intrinsics.checkNotNullParameter((Object)marginsLayout, (String)"marginsLayout");
        Intrinsics.checkNotNullParameter((Object)theme2, (String)"theme");
        Intrinsics.checkNotNullParameter((Object)plotContext, (String)"plotContext");
        this.hScaleBreaks = hScaleBreaks;
        this.vScaleBreaks = vScaleBreaks;
        this.adjustedDomain = adjustedDomain;
        this.coord = coord;
        this.layoutInfo = layoutInfo;
        this.marginsLayout = marginsLayout;
        this.theme = theme2;
        this.flipAxis = flipAxis;
        this.plotContext = plotContext;
        this.hAxisTheme = this.theme.horizontalAxis(this.flipAxis);
        this.vAxisTheme = this.theme.verticalAxis(this.flipAxis);
    }

    public final boolean isDebugDrawing() {
        return this.isDebugDrawing;
    }

    public final void setDebugDrawing(boolean bl) {
        this.isDebugDrawing = bl;
    }

    @NotNull
    protected final AxisTheme getHAxisTheme() {
        return this.hAxisTheme;
    }

    @NotNull
    protected final AxisTheme getVAxisTheme() {
        return this.vAxisTheme;
    }

    @Override
    public void drawBeforeGeomLayer(@NotNull SvgComponent parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.drawPanelAndAxis(parent, true);
    }

    @Override
    public void drawAfterGeomLayer(@NotNull SvgComponent parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.drawPanelAndAxis(parent, false);
    }

    protected void drawPanelAndAxis(@NotNull SvgComponent parent, boolean beforeGeomLayer) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        DoubleRectangle geomInnerBounds = this.layoutInfo.getGeomInnerBounds();
        PanelTheme panelTheme = this.theme.panel();
        PanelGridTheme hGridTheme = panelTheme.gridX(this.flipAxis);
        PanelGridTheme vGridTheme = panelTheme.gridY(this.flipAxis);
        boolean fillBkgr2 = panelTheme.showRect() && beforeGeomLayer;
        boolean strokeBkgr2 = panelTheme.showRect() && panelTheme.borderIsOntop() ^ beforeGeomLayer;
        boolean drawPanelBorder = panelTheme.showBorder() && panelTheme.borderIsOntop() ^ beforeGeomLayer;
        boolean drawHGrid = beforeGeomLayer ^ hGridTheme.isOntop();
        boolean drawVGrid = beforeGeomLayer ^ vGridTheme.isOntop();
        boolean drawHAxis = beforeGeomLayer ^ this.hAxisTheme.isOntop();
        boolean drawVAxis = beforeGeomLayer ^ this.vAxisTheme.isOntop();
        if (fillBkgr2) {
            this.doFillBkgr(parent);
        }
        if (drawHGrid) {
            this.doDrawHGrid(hGridTheme, parent);
        }
        if (drawVGrid) {
            this.doDrawVGrid(vGridTheme, parent);
        }
        if (drawHAxis) {
            this.doDrawHAxis(parent);
        }
        if (drawVAxis) {
            this.doDrawVAxis(parent);
        }
        if (strokeBkgr2) {
            this.doStrokeBkgr(parent);
        }
        if (drawPanelBorder) {
            this.doDrawPanelBorder(parent);
        }
        if (this.isDebugDrawing && !beforeGeomLayer) {
            this.drawDebugShapes(parent, geomInnerBounds);
        }
    }

    protected void doDrawPanelBorder(@NotNull SvgComponent parent) {
        SvgRectElement svgRectElement;
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        SvgRectElement $this$doDrawPanelBorder_u24lambda_u240 = svgRectElement = new SvgRectElement(this.layoutInfo.getGeomContentBounds());
        boolean bl = false;
        $this$doDrawPanelBorder_u24lambda_u240.strokeColor().set(this.theme.panel().borderColor());
        $this$doDrawPanelBorder_u24lambda_u240.strokeWidth().set(this.theme.panel().borderWidth());
        $this$doDrawPanelBorder_u24lambda_u240.fillOpacity().set(0.0);
        SvgRectElement panelBorder = svgRectElement;
        parent.add(panelBorder);
    }

    protected void doDrawVAxis(@NotNull SvgComponent parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Object[] objectArray = new AxisLayoutInfo[]{this.layoutInfo.getAxisInfos().getLeft(), this.layoutInfo.getAxisInfos().getRight()};
        Iterable $this$forEach$iv = CollectionsKt.listOfNotNull((Object[])objectArray);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AxisLayoutInfo axisInfo = (AxisLayoutInfo)element$iv;
            boolean bl = false;
            Pair<AxisComponent.TickLabelAdjustments, AxisComponent.BreaksData> pair2 = this.prepareAxisData(axisInfo, this.vScaleBreaks, this.vAxisTheme);
            AxisComponent.TickLabelAdjustments labelAdjustments = (AxisComponent.TickLabelAdjustments)pair2.component1();
            AxisComponent.BreaksData breaksData = (AxisComponent.BreaksData)pair2.component2();
            SvgComponent axisComponent = SquareFrameOfReference.Companion.buildAxis(breaksData, axisInfo, false, !this.layoutInfo.getVAxisShown(), this.vAxisTheme, labelAdjustments, this.isDebugDrawing);
            DoubleVector axisOrigin = this.marginsLayout.toAxisOrigin(this.layoutInfo.getGeomInnerBounds(), axisInfo.getOrientation(), this.coord.isPolar(), this.theme.panel().inset());
            axisComponent.moveTo(axisOrigin);
            parent.add(axisComponent);
        }
    }

    protected void doDrawHAxis(@NotNull SvgComponent parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Object[] objectArray = new AxisLayoutInfo[]{this.layoutInfo.getAxisInfos().getTop(), this.layoutInfo.getAxisInfos().getBottom()};
        Iterable $this$forEach$iv = CollectionsKt.listOfNotNull((Object[])objectArray);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AxisLayoutInfo axisInfo = (AxisLayoutInfo)element$iv;
            boolean bl = false;
            Pair<AxisComponent.TickLabelAdjustments, AxisComponent.BreaksData> pair2 = this.prepareAxisData(axisInfo, this.hScaleBreaks, this.hAxisTheme);
            AxisComponent.TickLabelAdjustments labelAdjustments = (AxisComponent.TickLabelAdjustments)pair2.component1();
            AxisComponent.BreaksData breaksData = (AxisComponent.BreaksData)pair2.component2();
            SvgComponent axisComponent = SquareFrameOfReference.Companion.buildAxis(breaksData, axisInfo, false, !this.layoutInfo.getHAxisShown(), this.hAxisTheme, labelAdjustments, this.isDebugDrawing);
            DoubleVector axisOrigin = this.marginsLayout.toAxisOrigin(this.layoutInfo.getGeomInnerBounds(), axisInfo.getOrientation(), this.coord.isPolar(), this.theme.panel().inset());
            axisComponent.moveTo(axisOrigin);
            parent.add(axisComponent);
        }
    }

    protected void doDrawVGrid(@NotNull PanelGridTheme vGridTheme, @NotNull SvgComponent parent) {
        Intrinsics.checkNotNullParameter((Object)vGridTheme, (String)"vGridTheme");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Object[] objectArray = new AxisLayoutInfo[]{this.layoutInfo.getAxisInfos().getLeft(), this.layoutInfo.getAxisInfos().getRight()};
        Iterable $this$forEach$iv = CollectionsKt.listOfNotNull((Object[])objectArray);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AxisLayoutInfo axisInfo = (AxisLayoutInfo)element$iv;
            boolean bl = false;
            AxisComponent.BreaksData breaksData = (AxisComponent.BreaksData)this.prepareAxisData(axisInfo, this.vScaleBreaks, this.vAxisTheme).component2();
            GridComponent gridComponent = new GridComponent(breaksData.getMajorGrid(), breaksData.getMinorGrid(), vGridTheme);
            DoubleVector gridOrigin = this.layoutInfo.getGeomContentBounds().getOrigin();
            gridComponent.moveTo(gridOrigin);
            parent.add(gridComponent);
        }
    }

    protected void doDrawHGrid(@NotNull PanelGridTheme hGridTheme, @NotNull SvgComponent parent) {
        Intrinsics.checkNotNullParameter((Object)hGridTheme, (String)"hGridTheme");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Object[] objectArray = new AxisLayoutInfo[]{this.layoutInfo.getAxisInfos().getTop(), this.layoutInfo.getAxisInfos().getBottom()};
        Iterable $this$forEach$iv = CollectionsKt.listOfNotNull((Object[])objectArray);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AxisLayoutInfo axisInfo = (AxisLayoutInfo)element$iv;
            boolean bl = false;
            AxisComponent.BreaksData breaksData = (AxisComponent.BreaksData)this.prepareAxisData(axisInfo, this.hScaleBreaks, this.hAxisTheme).component2();
            GridComponent gridComponent = new GridComponent(breaksData.getMajorGrid(), breaksData.getMinorGrid(), hGridTheme);
            DoubleVector gridOrigin = this.layoutInfo.getGeomContentBounds().getOrigin();
            gridComponent.moveTo(gridOrigin);
            parent.add(gridComponent);
        }
    }

    protected void doFillBkgr(@NotNull SvgComponent parent) {
        SvgRectElement svgRectElement;
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        SvgRectElement $this$doFillBkgr_u24lambda_u245 = svgRectElement = new SvgRectElement(this.layoutInfo.getGeomContentBounds());
        boolean bl = false;
        $this$doFillBkgr_u24lambda_u245.fillColor().set(this.theme.panel().rectFill());
        SvgRectElement panel = svgRectElement;
        parent.add(panel);
    }

    protected void doStrokeBkgr(@NotNull SvgComponent parent) {
        SvgRectElement svgRectElement;
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        SvgRectElement $this$doStrokeBkgr_u24lambda_u246 = svgRectElement = new SvgRectElement(this.layoutInfo.getGeomContentBounds());
        boolean bl = false;
        $this$doStrokeBkgr_u24lambda_u246.strokeColor().set(this.theme.panel().rectColor());
        $this$doStrokeBkgr_u24lambda_u246.strokeWidth().set(this.theme.panel().rectStrokeWidth());
        $this$doStrokeBkgr_u24lambda_u246.fillOpacity().set(0.0);
        SvgRectElement panelRectStroke = svgRectElement;
        parent.add(panelRectStroke);
    }

    @NotNull
    protected Pair<AxisComponent.TickLabelAdjustments, AxisComponent.BreaksData> prepareAxisData(@NotNull AxisLayoutInfo axisInfo, @NotNull ScaleBreaks scaleBreaks, @NotNull AxisTheme axisTheme) {
        Intrinsics.checkNotNullParameter((Object)axisInfo, (String)"axisInfo");
        Intrinsics.checkNotNullParameter((Object)scaleBreaks, (String)"scaleBreaks");
        Intrinsics.checkNotNullParameter((Object)axisTheme, (String)"axisTheme");
        AxisComponent.TickLabelAdjustments labelAdjustments = new AxisComponent.TickLabelAdjustments(axisInfo.getOrientation(), axisInfo.getTickLabelHorizontalAnchor(), axisInfo.getTickLabelVerticalAnchor(), axisInfo.getTickLabelRotationAngle(), axisInfo.getTickLabelAdditionalOffsets());
        AxisComponent.BreaksData breaksData = AxisUtil.INSTANCE.breaksData(scaleBreaks, this.coord, this.adjustedDomain, this.flipAxis, axisInfo.getOrientation(), axisTheme, labelAdjustments);
        return new Pair((Object)labelAdjustments, (Object)breaksData);
    }

    protected final void drawDebugShapes(@NotNull SvgComponent parent, @NotNull DoubleRectangle geomBounds) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)geomBounds, (String)"geomBounds");
        SquareFrameOfReference $this$drawDebugShapes_u24lambda_u247 = this;
        boolean bl = false;
        DoubleRectangle tileBounds = $this$drawDebugShapes_u24lambda_u247.layoutInfo.getGeomWithAxisBounds();
        SvgRectElement rect2 = new SvgRectElement(tileBounds);
        rect2.fillColor().set(Color.Companion.getBLACK());
        rect2.strokeWidth().set(0.0);
        rect2.fillOpacity().set(0.1);
        parent.add(rect2);
        SquareFrameOfReference $this$drawDebugShapes_u24lambda_u248 = this;
        boolean bl2 = false;
        SvgRectElement rect3 = new SvgRectElement(geomBounds);
        rect3.fillColor().set(Color.Companion.getPINK());
        rect3.strokeWidth().set(1.0);
        rect3.fillOpacity().set(0.5);
        parent.add(rect3);
    }

    @Override
    @NotNull
    public SvgComponent buildGeomComponent(@NotNull GeomLayer layer, @NotNull GeomTargetCollector targetCollector) {
        Intrinsics.checkNotNullParameter((Object)layer, (String)"layer");
        Intrinsics.checkNotNullParameter((Object)targetCollector, (String)"targetCollector");
        SvgComponent layerComponent = this.buildGeom(layer, targetCollector);
        layerComponent.moveTo(this.layoutInfo.getGeomContentBounds().getOrigin());
        layerComponent.clipBounds(new DoubleRectangle(DoubleVector.Companion.getZERO(), this.layoutInfo.getGeomContentBounds().getDimension()));
        return layerComponent;
    }

    @NotNull
    protected final SvgComponent buildGeom(@NotNull GeomLayer layer, @NotNull GeomTargetCollector targetCollector) {
        Intrinsics.checkNotNullParameter((Object)layer, (String)"layer");
        Intrinsics.checkNotNullParameter((Object)targetCollector, (String)"targetCollector");
        return Companion.buildGeom$plot_builder(this.plotContext, layer, this.adjustedDomain, this.coord, this.flipAxis, targetCollector, this.theme.panel().showRect() ? this.theme.panel().rectFill() : this.theme.plot().backgroundFill());
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J@\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\nH\u0002JE\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0000\u00a2\u0006\u0002\b\u001f\u00a8\u0006 "}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/frame/SquareFrameOfReference$Companion;", "", "()V", "buildAxis", "Lorg/jetbrains/letsPlot/core/plot/base/render/svg/SvgComponent;", "breaksData", "Lorg/jetbrains/letsPlot/core/plot/builder/guide/AxisComponent$BreaksData;", "info", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/AxisLayoutInfo;", "hideAxis", "", "hideAxisBreaks", "axisTheme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/AxisTheme;", "labelAdjustments", "Lorg/jetbrains/letsPlot/core/plot/builder/guide/AxisComponent$TickLabelAdjustments;", "isDebugDrawing", "buildGeom", "plotContext", "Lorg/jetbrains/letsPlot/core/plot/base/PlotContext;", "layer", "Lorg/jetbrains/letsPlot/core/plot/builder/GeomLayer;", "xyAesBounds", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "coord", "Lorg/jetbrains/letsPlot/core/plot/base/CoordinateSystem;", "flippedAxis", "targetCollector", "Lorg/jetbrains/letsPlot/core/plot/base/tooltip/GeomTargetCollector;", "backgroundColor", "Lorg/jetbrains/letsPlot/commons/values/Color;", "buildGeom$plot_builder", "plot-builder"})
    @SourceDebugExtension(value={"SMAP\nSquareFrameOfReference.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SquareFrameOfReference.kt\norg/jetbrains/letsPlot/core/plot/builder/frame/SquareFrameOfReference$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,373:1\n1#2:374\n1855#3,2:375\n*S KotlinDebug\n*F\n+ 1 SquareFrameOfReference.kt\norg/jetbrains/letsPlot/core/plot/builder/frame/SquareFrameOfReference$Companion\n*L\n308#1:375,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final SvgComponent buildAxis(AxisComponent.BreaksData breaksData, AxisLayoutInfo info, boolean hideAxis, boolean hideAxisBreaks, AxisTheme axisTheme, AxisComponent.TickLabelAdjustments labelAdjustments, boolean isDebugDrawing) {
            AxisComponent axis;
            block3: {
                axis = new AxisComponent(info.getAxisLength(), info.getOrientation(), breaksData, labelAdjustments, axisTheme, hideAxis, hideAxisBreaks);
                if (!isDebugDrawing) break block3;
                org.jetbrains.letsPlot.core.plot.builder.frame.SquareFrameOfReference$Companion.buildAxis$drawDebugRect(axis, info.getTickLabelsBounds(), Color.Companion.getGREEN());
                DoubleRectangle doubleRectangle = info.getTickLabelsTextBounds$plot_builder();
                if (doubleRectangle != null) {
                    DoubleRectangle it = doubleRectangle;
                    boolean bl = false;
                    org.jetbrains.letsPlot.core.plot.builder.frame.SquareFrameOfReference$Companion.buildAxis$drawDebugRect(axis, it, Color.Companion.getLIGHT_BLUE());
                }
                List<DoubleRectangle> list2 = info.getTickLabelBoundsList$plot_builder();
                if (list2 != null) {
                    Iterable $this$forEach$iv = list2;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        DoubleRectangle it = (DoubleRectangle)element$iv;
                        boolean bl = false;
                        org.jetbrains.letsPlot.core.plot.builder.frame.SquareFrameOfReference$Companion.buildAxis$drawDebugRect(axis, it, Color.Companion.getLIGHT_MAGENTA());
                    }
                }
            }
            return axis;
        }

        @NotNull
        public final SvgComponent buildGeom$plot_builder(@NotNull PlotContext plotContext, @NotNull GeomLayer layer, @NotNull DoubleRectangle xyAesBounds, @NotNull CoordinateSystem coord, boolean flippedAxis, @NotNull GeomTargetCollector targetCollector, @NotNull Color backgroundColor) {
            CoordinateSystem coordinateSystem;
            Intrinsics.checkNotNullParameter((Object)plotContext, (String)"plotContext");
            Intrinsics.checkNotNullParameter((Object)layer, (String)"layer");
            Intrinsics.checkNotNullParameter((Object)xyAesBounds, (String)"xyAesBounds");
            Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
            Intrinsics.checkNotNullParameter((Object)targetCollector, (String)"targetCollector");
            Intrinsics.checkNotNullParameter((Object)backgroundColor, (String)"backgroundColor");
            LayerRendererUtil.LayerRendererData rendererData = LayerRendererUtil.INSTANCE.createLayerRendererData(layer);
            boolean flippedAxis2 = layer.isYOrientation() ? !flippedAxis : flippedAxis;
            Map<Aes<?>, ScaleMapper<?>> aestheticMappers = rendererData.getAestheticMappers();
            Aesthetics aesthetics2 = rendererData.getAesthetics();
            boolean bl = layer.isYOrientation();
            if (bl) {
                coordinateSystem = coord.flip();
            } else if (!bl) {
                coordinateSystem = coord;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            CoordinateSystem coord2 = coordinateSystem;
            GeomTargetCollector it = targetCollector;
            boolean bl2 = false;
            it = flippedAxis2 ? it.withFlippedAxis() : it;
            boolean bl3 = false;
            GeomTargetCollector targetCollector2 = layer.isYOrientation() ? it.withYOrientation() : it;
            ImmutableGeomContext ctx2 = new GeomContextBuilder().flipped(flippedAxis2).aesthetics(aesthetics2).aestheticMappers(aestheticMappers).aesBounds(xyAesBounds).geomTargetCollector(targetCollector2).fontFamilyRegistry(layer.getFontFamilyRegistry()).annotations(rendererData.getAnnotations()).backgroundColor(backgroundColor).plotContext(plotContext).build();
            PositionAdjustment pos = rendererData.getPos();
            Geom geom2 = layer.getGeom();
            return new SvgLayerRenderer(aesthetics2, geom2, pos, coord2, ctx2);
        }

        private static final void buildAxis$drawDebugRect(AxisComponent axis, DoubleRectangle r, Color color) {
            SvgRectElement rect2 = new SvgRectElement(r);
            rect2.strokeColor().set(color);
            rect2.strokeWidth().set(1.0);
            rect2.fillOpacity().set(0.0);
            axis.add(rect2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

