/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.frame;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.core.plot.base.CoordinateSystem;
import org.jetbrains.letsPlot.core.plot.base.PlotContext;
import org.jetbrains.letsPlot.core.plot.base.Scale;
import org.jetbrains.letsPlot.core.plot.base.layout.Thickness;
import org.jetbrains.letsPlot.core.plot.base.theme.Theme;
import org.jetbrains.letsPlot.core.plot.builder.FrameOfReference;
import org.jetbrains.letsPlot.core.plot.builder.MarginSide;
import org.jetbrains.letsPlot.core.plot.builder.coord.CoordProvider;
import org.jetbrains.letsPlot.core.plot.builder.coord.PolarCoordProvider;
import org.jetbrains.letsPlot.core.plot.builder.frame.PolarFrameOfReference;
import org.jetbrains.letsPlot.core.plot.builder.frame.SquareFrameOfReferenceProvider;
import org.jetbrains.letsPlot.core.plot.builder.layout.AxisLayoutInfo;
import org.jetbrains.letsPlot.core.plot.builder.layout.AxisLayoutQuad;
import org.jetbrains.letsPlot.core.plot.builder.layout.GeomMarginsLayout;
import org.jetbrains.letsPlot.core.plot.builder.layout.TileLayout;
import org.jetbrains.letsPlot.core.plot.builder.layout.TileLayoutInfo;
import org.jetbrains.letsPlot.core.plot.builder.layout.TileLayoutProvider;
import org.jetbrains.letsPlot.core.plot.builder.layout.tile.InsideOutTileLayout;
import org.jetbrains.letsPlot.core.plot.builder.layout.tile.PolarTileLayout;
import org.jetbrains.letsPlot.core.plot.builder.scale.AxisPosition;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001!BQ\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010\u00a2\u0006\u0002\u0010\u0013J \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\nH\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0014R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\nX\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/frame/PolarFrameOfReferenceProvider;", "Lorg/jetbrains/letsPlot/core/plot/builder/frame/SquareFrameOfReferenceProvider;", "plotContext", "Lorg/jetbrains/letsPlot/core/plot/base/PlotContext;", "hScaleProto", "Lorg/jetbrains/letsPlot/core/plot/base/Scale;", "vScaleProto", "adjustedDomain", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "flipAxis", "", "theme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/Theme;", "marginsLayout", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/GeomMarginsLayout;", "domainByMargin", "", "Lorg/jetbrains/letsPlot/core/plot/builder/MarginSide;", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "(Lorg/jetbrains/letsPlot/core/plot/base/PlotContext;Lorg/jetbrains/letsPlot/core/plot/base/Scale;Lorg/jetbrains/letsPlot/core/plot/base/Scale;Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;ZLorg/jetbrains/letsPlot/core/plot/base/theme/Theme;Lorg/jetbrains/letsPlot/core/plot/builder/layout/GeomMarginsLayout;Ljava/util/Map;)V", "isPolar", "()Z", "createTileFrame", "Lorg/jetbrains/letsPlot/core/plot/builder/FrameOfReference;", "layoutInfo", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/TileLayoutInfo;", "coordProvider", "Lorg/jetbrains/letsPlot/core/plot/builder/coord/CoordProvider;", "debugDrawing", "createTileLayoutProvider", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/TileLayoutProvider;", "axisLayoutQuad", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/AxisLayoutQuad;", "MyTileLayoutProvider", "plot-builder"})
public final class PolarFrameOfReferenceProvider
extends SquareFrameOfReferenceProvider {
    @NotNull
    private final PlotContext plotContext;
    @NotNull
    private final Scale hScaleProto;
    @NotNull
    private final Scale vScaleProto;
    @NotNull
    private final DoubleRectangle adjustedDomain;
    @NotNull
    private final Theme theme;
    @NotNull
    private final GeomMarginsLayout marginsLayout;
    private final boolean isPolar;

    public PolarFrameOfReferenceProvider(@NotNull PlotContext plotContext, @NotNull Scale hScaleProto, @NotNull Scale vScaleProto, @NotNull DoubleRectangle adjustedDomain, boolean flipAxis, @NotNull Theme theme2, @NotNull GeomMarginsLayout marginsLayout, @NotNull Map<MarginSide, DoubleSpan> domainByMargin) {
        Intrinsics.checkNotNullParameter((Object)plotContext, (String)"plotContext");
        Intrinsics.checkNotNullParameter((Object)hScaleProto, (String)"hScaleProto");
        Intrinsics.checkNotNullParameter((Object)vScaleProto, (String)"vScaleProto");
        Intrinsics.checkNotNullParameter((Object)adjustedDomain, (String)"adjustedDomain");
        Intrinsics.checkNotNullParameter((Object)theme2, (String)"theme");
        Intrinsics.checkNotNullParameter((Object)marginsLayout, (String)"marginsLayout");
        Intrinsics.checkNotNullParameter(domainByMargin, (String)"domainByMargin");
        super(plotContext, hScaleProto, vScaleProto, adjustedDomain, flipAxis, AxisPosition.BOTTOM, AxisPosition.LEFT, theme2, marginsLayout, domainByMargin);
        this.plotContext = plotContext;
        this.hScaleProto = hScaleProto;
        this.vScaleProto = vScaleProto;
        this.adjustedDomain = adjustedDomain;
        this.theme = theme2;
        this.marginsLayout = marginsLayout;
        this.isPolar = true;
    }

    @Override
    protected boolean isPolar() {
        return this.isPolar;
    }

    @Override
    @NotNull
    protected TileLayoutProvider createTileLayoutProvider(@NotNull AxisLayoutQuad axisLayoutQuad) {
        Intrinsics.checkNotNullParameter((Object)axisLayoutQuad, (String)"axisLayoutQuad");
        return new MyTileLayoutProvider(axisLayoutQuad, this.adjustedDomain, this.marginsLayout, this.theme.panel().inset());
    }

    @Override
    @NotNull
    public FrameOfReference createTileFrame(@NotNull TileLayoutInfo layoutInfo, @NotNull CoordProvider coordProvider, boolean debugDrawing) {
        Intrinsics.checkNotNullParameter((Object)layoutInfo, (String)"layoutInfo");
        Intrinsics.checkNotNullParameter((Object)coordProvider, (String)"coordProvider");
        PolarCoordProvider coordProvider2 = (PolarCoordProvider)coordProvider;
        AxisLayoutInfo axisLayoutInfo = layoutInfo.getAxisInfos().getBottom();
        if (axisLayoutInfo == null) {
            throw new IllegalStateException("Bottom axis info is required for polar coordinate system.");
        }
        AxisLayoutInfo hAxisLayoutInfo = axisLayoutInfo;
        AxisLayoutInfo axisLayoutInfo2 = layoutInfo.getAxisInfos().getLeft();
        if (axisLayoutInfo2 == null) {
            throw new IllegalStateException("Left axis info is required for polar coordinate system.");
        }
        AxisLayoutInfo vAxisLayoutInfo = axisLayoutInfo2;
        DoubleVector client = new DoubleVector(hAxisLayoutInfo.getAxisLength(), vAxisLayoutInfo.getAxisLength());
        CoordinateSystem coord = coordProvider2.createCoordinateSystem(this.adjustedDomain, client);
        DoubleRectangle gridDomain = coordProvider2.gridDomain(this.adjustedDomain);
        Scale hScale = this.hScaleProto.with().breaks(hAxisLayoutInfo.getAxisBreaks().getDomainValues()).labels(hAxisLayoutInfo.getAxisBreaks().getLabels()).build();
        Scale vScale = this.vScaleProto.with().breaks(vAxisLayoutInfo.getAxisBreaks().getDomainValues()).labels(vAxisLayoutInfo.getAxisBreaks().getLabels()).build();
        PolarFrameOfReference tileFrameOfReference = new PolarFrameOfReference(this.plotContext, hScale.getScaleBreaks(), vScale.getScaleBreaks(), gridDomain, coord, layoutInfo, this.marginsLayout, this.theme, this.getFlipAxis());
        tileFrameOfReference.setDebugDrawing(debugDrawing);
        return tileFrameOfReference;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/frame/PolarFrameOfReferenceProvider$MyTileLayoutProvider;", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/TileLayoutProvider;", "axisLayoutQuad", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/AxisLayoutQuad;", "adjustedDomain", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "marginsLayout", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/GeomMarginsLayout;", "panelInset", "Lorg/jetbrains/letsPlot/core/plot/base/layout/Thickness;", "(Lorg/jetbrains/letsPlot/core/plot/builder/layout/AxisLayoutQuad;Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;Lorg/jetbrains/letsPlot/core/plot/builder/layout/GeomMarginsLayout;Lorg/jetbrains/letsPlot/core/plot/base/layout/Thickness;)V", "createInsideOutTileLayout", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/TileLayout;", "createTopDownTileLayout", "plot-builder"})
    private static final class MyTileLayoutProvider
    implements TileLayoutProvider {
        @NotNull
        private final AxisLayoutQuad axisLayoutQuad;
        @NotNull
        private final DoubleRectangle adjustedDomain;
        @NotNull
        private final GeomMarginsLayout marginsLayout;
        @NotNull
        private final Thickness panelInset;

        public MyTileLayoutProvider(@NotNull AxisLayoutQuad axisLayoutQuad, @NotNull DoubleRectangle adjustedDomain, @NotNull GeomMarginsLayout marginsLayout, @NotNull Thickness panelInset) {
            Intrinsics.checkNotNullParameter((Object)axisLayoutQuad, (String)"axisLayoutQuad");
            Intrinsics.checkNotNullParameter((Object)adjustedDomain, (String)"adjustedDomain");
            Intrinsics.checkNotNullParameter((Object)marginsLayout, (String)"marginsLayout");
            Intrinsics.checkNotNullParameter((Object)panelInset, (String)"panelInset");
            this.axisLayoutQuad = axisLayoutQuad;
            this.adjustedDomain = adjustedDomain;
            this.marginsLayout = marginsLayout;
            this.panelInset = panelInset;
        }

        @Override
        @NotNull
        public TileLayout createTopDownTileLayout() {
            return new PolarTileLayout(this.axisLayoutQuad, this.adjustedDomain.xRange(), this.adjustedDomain.yRange(), this.marginsLayout, this.panelInset);
        }

        @Override
        @NotNull
        public TileLayout createInsideOutTileLayout() {
            return new InsideOutTileLayout(this.axisLayoutQuad, this.adjustedDomain.xRange(), this.adjustedDomain.yRange(), this.marginsLayout);
        }
    }
}

