/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.frame;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.core.plot.base.CoordinateSystem;
import org.jetbrains.letsPlot.core.plot.base.PlotContext;
import org.jetbrains.letsPlot.core.plot.base.render.svg.SvgComponent;
import org.jetbrains.letsPlot.core.plot.base.scale.ScaleBreaks;
import org.jetbrains.letsPlot.core.plot.base.theme.PanelGridTheme;
import org.jetbrains.letsPlot.core.plot.base.theme.Theme;
import org.jetbrains.letsPlot.core.plot.base.tooltip.GeomTargetCollector;
import org.jetbrains.letsPlot.core.plot.builder.GeomLayer;
import org.jetbrains.letsPlot.core.plot.builder.PolarAxisUtil;
import org.jetbrains.letsPlot.core.plot.builder.coord.PolarCoordinateSystem;
import org.jetbrains.letsPlot.core.plot.builder.frame.SquareFrameOfReference;
import org.jetbrains.letsPlot.core.plot.builder.guide.AxisComponent;
import org.jetbrains.letsPlot.core.plot.builder.guide.GridComponent;
import org.jetbrains.letsPlot.core.plot.builder.guide.PolarAxisComponent;
import org.jetbrains.letsPlot.core.plot.builder.layout.AxisLayoutInfo;
import org.jetbrains.letsPlot.core.plot.builder.layout.GeomMarginsLayout;
import org.jetbrains.letsPlot.core.plot.builder.layout.TileLayoutInfo;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgCircleElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgGraphicsElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgNode;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgRectElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgShape;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001BM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u001c\u0010\u001b\u001a\u00020\u001c2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020 0\u001eH\u0002J\u0010\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020\u0016H\u0014J\u0018\u0010#\u001a\u00020 2\u0006\u0010$\u001a\u00020%2\u0006\u0010\"\u001a\u00020\u0016H\u0014J\u0010\u0010&\u001a\u00020 2\u0006\u0010\"\u001a\u00020\u0016H\u0014J\u0010\u0010'\u001a\u00020 2\u0006\u0010\"\u001a\u00020\u0016H\u0014J\u0018\u0010(\u001a\u00020 2\u0006\u0010)\u001a\u00020%2\u0006\u0010\"\u001a\u00020\u0016H\u0014J\u0010\u0010*\u001a\u00020 2\u0006\u0010\"\u001a\u00020\u0016H\u0014J\u0010\u0010+\u001a\u00020 2\u0006\u0010\"\u001a\u00020\u0016H\u0014J$\u0010,\u001a\u000e\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u00020/0-2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\u0005H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/frame/PolarFrameOfReference;", "Lorg/jetbrains/letsPlot/core/plot/builder/frame/SquareFrameOfReference;", "plotContext", "Lorg/jetbrains/letsPlot/core/plot/base/PlotContext;", "hScaleBreaks", "Lorg/jetbrains/letsPlot/core/plot/base/scale/ScaleBreaks;", "vScaleBreaks", "adjustedDomain", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "coord", "Lorg/jetbrains/letsPlot/core/plot/base/CoordinateSystem;", "layoutInfo", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/TileLayoutInfo;", "marginsLayout", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/GeomMarginsLayout;", "theme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/Theme;", "flipAxis", "", "(Lorg/jetbrains/letsPlot/core/plot/base/PlotContext;Lorg/jetbrains/letsPlot/core/plot/base/scale/ScaleBreaks;Lorg/jetbrains/letsPlot/core/plot/base/scale/ScaleBreaks;Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;Lorg/jetbrains/letsPlot/core/plot/base/CoordinateSystem;Lorg/jetbrains/letsPlot/core/plot/builder/layout/TileLayoutInfo;Lorg/jetbrains/letsPlot/core/plot/builder/layout/GeomMarginsLayout;Lorg/jetbrains/letsPlot/core/plot/base/theme/Theme;Z)V", "Lorg/jetbrains/letsPlot/core/plot/builder/coord/PolarCoordinateSystem;", "buildGeomComponent", "Lorg/jetbrains/letsPlot/core/plot/base/render/svg/SvgComponent;", "layer", "Lorg/jetbrains/letsPlot/core/plot/builder/GeomLayer;", "targetCollector", "Lorg/jetbrains/letsPlot/core/plot/base/tooltip/GeomTargetCollector;", "createPanelElement", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgNode;", "block", "Lkotlin/Function1;", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgShape;", "", "doDrawHAxis", "parent", "doDrawHGrid", "hGridTheme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/PanelGridTheme;", "doDrawPanelBorder", "doDrawVAxis", "doDrawVGrid", "vGridTheme", "doFillBkgr", "doStrokeBkgr", "prepareAxisData", "Lkotlin/Pair;", "Lorg/jetbrains/letsPlot/core/plot/builder/guide/AxisComponent$TickLabelAdjustments;", "Lorg/jetbrains/letsPlot/core/plot/builder/PolarAxisUtil$PolarBreaksData;", "axisInfo", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/AxisLayoutInfo;", "scaleBreaks", "plot-builder"})
@SourceDebugExtension(value={"SMAP\nPolarFrameOfReference.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PolarFrameOfReference.kt\norg/jetbrains/letsPlot/core/plot/builder/frame/PolarFrameOfReference\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,202:1\n1855#2,2:203\n1855#2,2:205\n1855#2,2:207\n1855#2,2:209\n*S KotlinDebug\n*F\n+ 1 PolarFrameOfReference.kt\norg/jetbrains/letsPlot/core/plot/builder/frame/PolarFrameOfReference\n*L\n56#1:203,2\n80#1:205,2\n104#1:207,2\n115#1:209,2\n*E\n"})
public final class PolarFrameOfReference
extends SquareFrameOfReference {
    @NotNull
    private final ScaleBreaks hScaleBreaks;
    @NotNull
    private final ScaleBreaks vScaleBreaks;
    @NotNull
    private final DoubleRectangle adjustedDomain;
    @NotNull
    private final TileLayoutInfo layoutInfo;
    @NotNull
    private final GeomMarginsLayout marginsLayout;
    @NotNull
    private final Theme theme;
    private final boolean flipAxis;
    @NotNull
    private final PolarCoordinateSystem coord;

    public PolarFrameOfReference(@NotNull PlotContext plotContext, @NotNull ScaleBreaks hScaleBreaks, @NotNull ScaleBreaks vScaleBreaks, @NotNull DoubleRectangle adjustedDomain, @NotNull CoordinateSystem coord, @NotNull TileLayoutInfo layoutInfo, @NotNull GeomMarginsLayout marginsLayout, @NotNull Theme theme2, boolean flipAxis) {
        Intrinsics.checkNotNullParameter((Object)plotContext, (String)"plotContext");
        Intrinsics.checkNotNullParameter((Object)hScaleBreaks, (String)"hScaleBreaks");
        Intrinsics.checkNotNullParameter((Object)vScaleBreaks, (String)"vScaleBreaks");
        Intrinsics.checkNotNullParameter((Object)adjustedDomain, (String)"adjustedDomain");
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        Intrinsics.checkNotNullParameter((Object)layoutInfo, (String)"layoutInfo");
        Intrinsics.checkNotNullParameter((Object)marginsLayout, (String)"marginsLayout");
        Intrinsics.checkNotNullParameter((Object)theme2, (String)"theme");
        super(hScaleBreaks, vScaleBreaks, adjustedDomain, coord, layoutInfo, marginsLayout, theme2, flipAxis, plotContext);
        this.hScaleBreaks = hScaleBreaks;
        this.vScaleBreaks = vScaleBreaks;
        this.adjustedDomain = adjustedDomain;
        this.layoutInfo = layoutInfo;
        this.marginsLayout = marginsLayout;
        this.theme = theme2;
        this.flipAxis = flipAxis;
        this.coord = (PolarCoordinateSystem)coord;
    }

    @Override
    protected void doDrawVAxis(@NotNull SvgComponent parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Object[] objectArray = new AxisLayoutInfo[]{this.layoutInfo.getAxisInfos().getLeft(), this.layoutInfo.getAxisInfos().getRight()};
        Iterable $this$forEach$iv = CollectionsKt.listOfNotNull((Object[])objectArray);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AxisLayoutInfo axisInfo = (AxisLayoutInfo)element$iv;
            boolean bl = false;
            Pair<AxisComponent.TickLabelAdjustments, PolarAxisUtil.PolarBreaksData> pair2 = this.prepareAxisData(axisInfo, this.vScaleBreaks);
            AxisComponent.TickLabelAdjustments labelAdjustments = (AxisComponent.TickLabelAdjustments)pair2.component1();
            PolarAxisUtil.PolarBreaksData breaksData = (PolarAxisUtil.PolarBreaksData)pair2.component2();
            PolarAxisComponent axisComponent = new PolarAxisComponent(axisInfo.getAxisLength(), axisInfo.getOrientation(), breaksData, labelAdjustments, this.getVAxisTheme(), !this.layoutInfo.getVAxisShown());
            DoubleVector axisOrigin = this.marginsLayout.toAxisOrigin(this.layoutInfo.getGeomInnerBounds(), axisInfo.getOrientation(), this.coord.isPolar(), this.theme.panel().inset());
            axisComponent.moveTo(axisOrigin);
            parent.add(axisComponent);
        }
    }

    @Override
    protected void doDrawHAxis(@NotNull SvgComponent parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Object[] objectArray = new AxisLayoutInfo[]{this.layoutInfo.getAxisInfos().getTop(), this.layoutInfo.getAxisInfos().getBottom()};
        Iterable $this$forEach$iv = CollectionsKt.listOfNotNull((Object[])objectArray);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AxisLayoutInfo axisInfo = (AxisLayoutInfo)element$iv;
            boolean bl = false;
            Pair<AxisComponent.TickLabelAdjustments, PolarAxisUtil.PolarBreaksData> pair2 = this.prepareAxisData(axisInfo, this.hScaleBreaks);
            AxisComponent.TickLabelAdjustments labelAdjustments = (AxisComponent.TickLabelAdjustments)pair2.component1();
            PolarAxisUtil.PolarBreaksData breaksData = (PolarAxisUtil.PolarBreaksData)pair2.component2();
            PolarAxisComponent axisComponent = new PolarAxisComponent(axisInfo.getAxisLength(), axisInfo.getOrientation(), breaksData, labelAdjustments, this.getHAxisTheme(), !this.layoutInfo.getHAxisShown());
            DoubleVector axisOrigin = this.marginsLayout.toAxisOrigin(this.layoutInfo.getGeomContentBounds(), axisInfo.getOrientation(), this.coord.isPolar(), this.theme.panel().inset());
            axisComponent.moveTo(axisOrigin);
            parent.add(axisComponent);
        }
    }

    @Override
    protected void doDrawVGrid(@NotNull PanelGridTheme vGridTheme, @NotNull SvgComponent parent) {
        Intrinsics.checkNotNullParameter((Object)vGridTheme, (String)"vGridTheme");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Object[] objectArray = new AxisLayoutInfo[]{this.layoutInfo.getAxisInfos().getLeft(), this.layoutInfo.getAxisInfos().getRight()};
        Iterable $this$forEach$iv = CollectionsKt.listOfNotNull((Object[])objectArray);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AxisLayoutInfo axisInfo = (AxisLayoutInfo)element$iv;
            boolean bl = false;
            PolarAxisUtil.PolarBreaksData breaksData = (PolarAxisUtil.PolarBreaksData)this.prepareAxisData(axisInfo, this.vScaleBreaks).component2();
            GridComponent gridComponent = new GridComponent(breaksData.getMajorGrid(), breaksData.getMinorGrid(), vGridTheme);
            DoubleVector gridOrigin = this.layoutInfo.getGeomContentBounds().getOrigin();
            gridComponent.moveTo(gridOrigin);
            parent.add(gridComponent);
        }
    }

    @Override
    protected void doDrawHGrid(@NotNull PanelGridTheme hGridTheme, @NotNull SvgComponent parent) {
        Intrinsics.checkNotNullParameter((Object)hGridTheme, (String)"hGridTheme");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Object[] objectArray = new AxisLayoutInfo[]{this.layoutInfo.getAxisInfos().getTop(), this.layoutInfo.getAxisInfos().getBottom()};
        Iterable $this$forEach$iv = CollectionsKt.listOfNotNull((Object[])objectArray);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AxisLayoutInfo axisInfo = (AxisLayoutInfo)element$iv;
            boolean bl = false;
            PolarAxisUtil.PolarBreaksData breaksData = (PolarAxisUtil.PolarBreaksData)this.prepareAxisData(axisInfo, this.hScaleBreaks).component2();
            GridComponent gridComponent = new GridComponent(breaksData.getMajorGrid(), breaksData.getMinorGrid(), hGridTheme);
            DoubleVector gridOrigin = this.layoutInfo.getGeomContentBounds().getOrigin();
            gridComponent.moveTo(gridOrigin);
            parent.add(gridComponent);
        }
    }

    @Override
    protected void doFillBkgr(@NotNull SvgComponent parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        SvgNode fillBkgr2 = this.createPanelElement((Function1<? super SvgShape, Unit>)((Function1)new Function1<SvgShape, Unit>(this){
            final /* synthetic */ PolarFrameOfReference this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull SvgShape it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                it.fillColor().set(PolarFrameOfReference.access$getTheme$p(this.this$0).panel().rectFill());
            }
        }));
        parent.add(fillBkgr2);
    }

    @Override
    protected void doStrokeBkgr(@NotNull SvgComponent parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        SvgNode strokeBkgr2 = this.createPanelElement((Function1<? super SvgShape, Unit>)((Function1)new Function1<SvgShape, Unit>(this){
            final /* synthetic */ PolarFrameOfReference this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull SvgShape it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                it.strokeColor().set(PolarFrameOfReference.access$getTheme$p(this.this$0).panel().rectColor());
                it.strokeWidth().set(PolarFrameOfReference.access$getTheme$p(this.this$0).panel().rectStrokeWidth());
                it.fillOpacity().set(0.0);
            }
        }));
        parent.add(strokeBkgr2);
    }

    @Override
    protected void doDrawPanelBorder(@NotNull SvgComponent parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        SvgNode border2 = this.createPanelElement((Function1<? super SvgShape, Unit>)((Function1)new Function1<SvgShape, Unit>(this){
            final /* synthetic */ PolarFrameOfReference this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull SvgShape it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                it.strokeColor().set(PolarFrameOfReference.access$getTheme$p(this.this$0).panel().borderColor());
                it.strokeWidth().set(PolarFrameOfReference.access$getTheme$p(this.this$0).panel().borderWidth());
                it.fillOpacity().set(0.0);
            }
        }));
        parent.add(border2);
    }

    private final SvgNode createPanelElement(Function1<? super SvgShape, Unit> block2) {
        SvgGraphicsElement svgGraphicsElement;
        boolean bl = this.coord.getTransformBkgr();
        if (bl) {
            SvgCircleElement svgCircleElement;
            SvgCircleElement $this$createPanelElement_u24lambda_u244 = svgCircleElement = new SvgCircleElement();
            boolean bl2 = false;
            $this$createPanelElement_u24lambda_u244.cx().set(this.layoutInfo.getGeomContentBounds().getCenter().getX());
            $this$createPanelElement_u24lambda_u244.cy().set(this.layoutInfo.getGeomContentBounds().getCenter().getY());
            $this$createPanelElement_u24lambda_u244.r().set(this.layoutInfo.getGeomContentBounds().getWidth() / (double)2 / 1.15);
            svgGraphicsElement = svgCircleElement;
        } else if (!bl) {
            svgGraphicsElement = new SvgRectElement(this.layoutInfo.getGeomInnerBounds());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        SvgRectElement shape = svgGraphicsElement;
        block2.invoke((Object)shape);
        return shape;
    }

    private final Pair<AxisComponent.TickLabelAdjustments, PolarAxisUtil.PolarBreaksData> prepareAxisData(AxisLayoutInfo axisInfo, ScaleBreaks scaleBreaks) {
        AxisComponent.TickLabelAdjustments labelAdjustments = new AxisComponent.TickLabelAdjustments(axisInfo.getOrientation(), axisInfo.getTickLabelHorizontalAnchor(), axisInfo.getTickLabelVerticalAnchor(), axisInfo.getTickLabelRotationAngle(), axisInfo.getTickLabelAdditionalOffsets());
        PolarAxisUtil.PolarBreaksData breaksData = PolarAxisUtil.INSTANCE.breaksData(scaleBreaks, this.coord, this.adjustedDomain, this.flipAxis, axisInfo.getOrientation(), labelAdjustments);
        return new Pair((Object)labelAdjustments, (Object)breaksData);
    }

    @Override
    @NotNull
    public SvgComponent buildGeomComponent(@NotNull GeomLayer layer, @NotNull GeomTargetCollector targetCollector) {
        Intrinsics.checkNotNullParameter((Object)layer, (String)"layer");
        Intrinsics.checkNotNullParameter((Object)targetCollector, (String)"targetCollector");
        SvgComponent layerComponent = this.buildGeom(layer, targetCollector);
        layerComponent.moveTo(this.layoutInfo.getGeomContentBounds().getOrigin());
        double r = this.layoutInfo.getGeomContentBounds().getWidth() / (double)2 / 1.15;
        layerComponent.clipCircle(this.layoutInfo.getGeomContentBounds().getDimension().mul(0.5), r);
        return layerComponent;
    }

    public static final /* synthetic */ Theme access$getTheme$p(PolarFrameOfReference $this) {
        return $this.theme;
    }
}

