/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.coord;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.core.plot.base.CoordinateSystem;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B'\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0010\u001a\u00020\u0001H\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J\u0010\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\f\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/coord/PolarCoordinateSystem;", "Lorg/jetbrains/letsPlot/core/plot/base/CoordinateSystem;", "coordinateSystem", "startAngle", "", "direction", "transformBkgr", "", "(Lorg/jetbrains/letsPlot/core/plot/base/CoordinateSystem;DDZ)V", "getDirection", "()D", "isLinear", "()Z", "isPolar", "getStartAngle", "getTransformBkgr", "flip", "toClient", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "p", "unitSize", "plot-builder"})
public final class PolarCoordinateSystem
implements CoordinateSystem {
    @NotNull
    private final CoordinateSystem coordinateSystem;
    private final double startAngle;
    private final double direction;
    private final boolean transformBkgr;

    public PolarCoordinateSystem(@NotNull CoordinateSystem coordinateSystem, double startAngle, double direction, boolean transformBkgr) {
        Intrinsics.checkNotNullParameter((Object)coordinateSystem, (String)"coordinateSystem");
        this.coordinateSystem = coordinateSystem;
        this.startAngle = startAngle;
        this.direction = direction;
        this.transformBkgr = transformBkgr;
    }

    public final double getStartAngle() {
        return this.startAngle;
    }

    public final double getDirection() {
        return this.direction;
    }

    public final boolean getTransformBkgr() {
        return this.transformBkgr;
    }

    @Override
    public boolean isLinear() {
        return false;
    }

    @Override
    public boolean isPolar() {
        return true;
    }

    @Override
    @Nullable
    public DoubleVector toClient(@NotNull DoubleVector p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        return this.coordinateSystem.toClient(p);
    }

    @Override
    @NotNull
    public DoubleVector unitSize(@NotNull DoubleVector p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        return this.coordinateSystem.unitSize(p);
    }

    @Override
    @NotNull
    public CoordinateSystem flip() {
        return new PolarCoordinateSystem(this.coordinateSystem.flip(), this.startAngle, this.direction, this.transformBkgr);
    }

    @Override
    @Nullable
    public DoubleRectangle toClient(@NotNull DoubleRectangle r) {
        return CoordinateSystem.DefaultImpls.toClient(this, r);
    }
}

