/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.assemble;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.core.plot.base.Aes;
import org.jetbrains.letsPlot.core.plot.base.PlotContext;
import org.jetbrains.letsPlot.core.plot.base.Scale;
import org.jetbrains.letsPlot.core.plot.base.ScaleMapper;
import org.jetbrains.letsPlot.core.plot.base.aes.AestheticsDefaults;
import org.jetbrains.letsPlot.core.plot.base.render.LegendKeyElementFactory;
import org.jetbrains.letsPlot.core.plot.base.theme.AxisTheme;
import org.jetbrains.letsPlot.core.plot.base.theme.FacetsTheme;
import org.jetbrains.letsPlot.core.plot.base.theme.LegendTheme;
import org.jetbrains.letsPlot.core.plot.builder.assemble.ColorBarAssembler;
import org.jetbrains.letsPlot.core.plot.builder.assemble.ColorBarOptions;
import org.jetbrains.letsPlot.core.plot.builder.assemble.GuideOptions;
import org.jetbrains.letsPlot.core.plot.builder.assemble.LegendAssembler;
import org.jetbrains.letsPlot.core.plot.builder.assemble.PlotFacets;
import org.jetbrains.letsPlot.core.plot.builder.assemble.PlotGeomTiles;
import org.jetbrains.letsPlot.core.plot.builder.assemble.PlotGuidesAssemblerUtil;
import org.jetbrains.letsPlot.core.plot.builder.assemble.tiles.GeomLayerInfo;
import org.jetbrains.letsPlot.core.plot.builder.layout.FacetedPlotLayout;
import org.jetbrains.letsPlot.core.plot.builder.layout.LegendBoxInfo;
import org.jetbrains.letsPlot.core.plot.builder.layout.PlotLayout;
import org.jetbrains.letsPlot.core.plot.builder.layout.SingleTilePlotLayout;
import org.jetbrains.letsPlot.core.plot.builder.layout.TileLayout;
import org.jetbrains.letsPlot.core.plot.builder.layout.TileLayoutProvider;
import org.jetbrains.letsPlot.core.plot.builder.scale.AxisPosition;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JX\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u001a\u0010\n\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r0\u000b2\u0016\u0010\u000e\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f\u0012\u0004\u0012\u00020\u000f0\u000b2\u0006\u0010\u0010\u001a\u00020\u0011JL\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u00042\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 J6\u0010\"\u001a\u00020#2\n\u0010$\u001a\u0006\u0012\u0002\b\u00030\f2\b\u0010%\u001a\u0004\u0018\u00010&2\u0016\u0010'\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f\u0012\u0004\u0012\u00020&0(H\u0002\u00a8\u0006)"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/assemble/PlotAssemblerUtil;", "", "()V", "createLegends", "", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/LegendBoxInfo;", "ctx", "Lorg/jetbrains/letsPlot/core/plot/base/PlotContext;", "geomTiles", "Lorg/jetbrains/letsPlot/core/plot/builder/assemble/PlotGeomTiles;", "scaleMappersNP", "", "Lorg/jetbrains/letsPlot/core/plot/base/Aes;", "Lorg/jetbrains/letsPlot/core/plot/base/ScaleMapper;", "guideOptionsMap", "Lorg/jetbrains/letsPlot/core/plot/builder/assemble/GuideOptions;", "theme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/LegendTheme;", "createPlotLayout", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/PlotLayout;", "layoutProviderByTile", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/TileLayoutProvider;", "insideOut", "", "facets", "Lorg/jetbrains/letsPlot/core/plot/builder/assemble/PlotFacets;", "facetsTheme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/FacetsTheme;", "hAxisPosition", "Lorg/jetbrains/letsPlot/core/plot/builder/scale/AxisPosition;", "vAxisPosition", "hAxisTheme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/AxisTheme;", "vAxisTheme", "updateAesRangeMap", "", "aes", "range", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "rangeByAes", "", "plot-builder"})
@SourceDebugExtension(value={"SMAP\nPlotAssemblerUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlotAssemblerUtil.kt\norg/jetbrains/letsPlot/core/plot/builder/assemble/PlotAssemblerUtil\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,178:1\n372#2,7:179\n372#2,7:186\n*S KotlinDebug\n*F\n+ 1 PlotAssemblerUtil.kt\norg/jetbrains/letsPlot/core/plot/builder/assemble/PlotAssemblerUtil\n*L\n95#1:179,7\n100#1:186,7\n*E\n"})
public final class PlotAssemblerUtil {
    @NotNull
    public static final PlotAssemblerUtil INSTANCE = new PlotAssemblerUtil();

    private PlotAssemblerUtil() {
    }

    private final void updateAesRangeMap(Aes<?> aes2, DoubleSpan range, Map<Aes<?>, DoubleSpan> rangeByAes) {
        DoubleSpan range2 = range;
        if (range2 != null) {
            DoubleSpan wasRange = rangeByAes.get(aes2);
            if (wasRange != null) {
                range2 = wasRange.union(range2);
            }
            rangeByAes.put(aes2, range2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<LegendBoxInfo> createLegends(@NotNull PlotContext ctx2, @NotNull PlotGeomTiles geomTiles, @NotNull Map<Aes<?>, ? extends ScaleMapper<?>> scaleMappersNP, @NotNull Map<Aes<?>, ? extends GuideOptions> guideOptionsMap, @NotNull LegendTheme theme2) {
        LegendBoxInfo boxInfo;
        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)geomTiles, (String)"geomTiles");
        Intrinsics.checkNotNullParameter(scaleMappersNP, (String)"scaleMappersNP");
        Intrinsics.checkNotNullParameter(guideOptionsMap, (String)"guideOptionsMap");
        Intrinsics.checkNotNullParameter((Object)theme2, (String)"theme");
        LinkedHashMap legendAssemblerByTitle = new LinkedHashMap();
        LinkedHashMap colorBarAssemblerByTitle = new LinkedHashMap();
        for (GeomLayerInfo layerInfo : geomTiles.coreLayerInfos()) {
            Object answer$iv;
            Object scale;
            HashMap layerConstantByAes = new HashMap();
            for (Aes<?> aes2 : layerInfo.renderedAes()) {
                if (!layerInfo.hasConstant(aes2)) continue;
                Map map2 = layerConstantByAes;
                Object obj = layerInfo.getConstant(aes2);
                Intrinsics.checkNotNull(obj);
                map2.put(aes2, obj);
            }
            LinkedHashMap aesListByScaleName = new LinkedHashMap();
            List<Aes<?>> aesList = PlotGuidesAssemblerUtil.INSTANCE.mappedRenderedAesToCreateGuides(layerInfo, guideOptionsMap);
            for (Aes<?> aes3 : aesList) {
                Object object;
                Object guideOptions;
                boolean colorBar = false;
                scale = ctx2.getScale(aes3);
                String scaleName = scale.getName();
                if (guideOptionsMap.containsKey(aes3)) {
                    guideOptions = guideOptionsMap.get(aes3);
                    if (guideOptions instanceof ColorBarOptions) {
                        PlotGuidesAssemblerUtil.INSTANCE.checkFitsColorBar(aes3, (Scale)scale);
                        colorBar = true;
                        Map map3 = colorBarAssemblerByTitle;
                        DoubleSpan doubleSpan = ctx2.overallTransformedDomain(aes3);
                        Object object2 = MapsKt.getValue(scaleMappersNP, aes3);
                        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type org.jetbrains.letsPlot.core.plot.base.ScaleMapper<org.jetbrains.letsPlot.commons.values.Color>");
                        ColorBarAssembler colorBarAssembler = PlotGuidesAssemblerUtil.INSTANCE.createColorBarAssembler(scaleName, doubleSpan, (Scale)scale, (ScaleMapper)object2, (ColorBarOptions)guideOptions, theme2);
                        map3.put(scaleName, colorBarAssembler);
                    }
                } else if (PlotGuidesAssemblerUtil.INSTANCE.fitsColorBar(aes3, (Scale)scale)) {
                    colorBar = true;
                    guideOptions = colorBarAssemblerByTitle;
                    DoubleSpan doubleSpan = ctx2.overallTransformedDomain(aes3);
                    Object object3 = MapsKt.getValue(scaleMappersNP, aes3);
                    Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type org.jetbrains.letsPlot.core.plot.base.ScaleMapper<org.jetbrains.letsPlot.commons.values.Color>");
                    ColorBarAssembler colorBarAssembler = PlotGuidesAssemblerUtil.INSTANCE.createColorBarAssembler(scaleName, doubleSpan, (Scale)scale, (ScaleMapper)object3, null, theme2);
                    guideOptions.put(scaleName, colorBarAssembler);
                }
                if (colorBar) continue;
                Map $this$getOrPut$iv = aesListByScaleName;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(scaleName);
                if (value$iv == null) {
                    boolean bl = false;
                    answer$iv = new ArrayList();
                    $this$getOrPut$iv.put(scaleName, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ((List)object).add(aes3);
            }
            for (String scaleName : aesListByScaleName.keySet()) {
                Object object;
                void $this$getOrPut$iv;
                scale = legendAssemblerByTitle;
                Intrinsics.checkNotNull((Object)scaleName);
                String key$iv = scaleName;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl = false;
                    answer$iv = new LegendAssembler(scaleName, guideOptionsMap, scaleMappersNP, theme2);
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                LegendAssembler legendAssembler = (LegendAssembler)object;
                List aesListForScaleName = (List)MapsKt.getValue((Map)aesListByScaleName, (Object)scaleName);
                LegendKeyElementFactory legendKeyFactory = layerInfo.getLegendKeyElementFactory();
                AestheticsDefaults aestheticsDefaults = layerInfo.getAestheticsDefaults();
                legendAssembler.addLayer(legendKeyFactory, aesListForScaleName, layerConstantByAes, aestheticsDefaults, ctx2, layerInfo.getColorByAes(), layerInfo.getFillByAes());
            }
        }
        ArrayList<LegendBoxInfo> legendBoxInfos = new ArrayList<LegendBoxInfo>();
        for (String legendTitle : colorBarAssemblerByTitle.keySet()) {
            Object v = colorBarAssemblerByTitle.get(legendTitle);
            Intrinsics.checkNotNull(v);
            boxInfo = ((ColorBarAssembler)v).createColorBar();
            if (boxInfo.isEmpty()) continue;
            legendBoxInfos.add(boxInfo);
        }
        for (String legendTitle : legendAssemblerByTitle.keySet()) {
            Object v = legendAssemblerByTitle.get(legendTitle);
            Intrinsics.checkNotNull(v);
            boxInfo = ((LegendAssembler)v).createLegend();
            if (boxInfo.isEmpty()) continue;
            legendBoxInfos.add(boxInfo);
        }
        return legendBoxInfos;
    }

    @NotNull
    public final PlotLayout createPlotLayout(@NotNull List<? extends TileLayoutProvider> layoutProviderByTile, boolean insideOut, @NotNull PlotFacets facets, @NotNull FacetsTheme facetsTheme, @NotNull AxisPosition hAxisPosition, @NotNull AxisPosition vAxisPosition, @NotNull AxisTheme hAxisTheme, @NotNull AxisTheme vAxisTheme) {
        PlotLayout plotLayout;
        Intrinsics.checkNotNullParameter(layoutProviderByTile, (String)"layoutProviderByTile");
        Intrinsics.checkNotNullParameter((Object)facets, (String)"facets");
        Intrinsics.checkNotNullParameter((Object)facetsTheme, (String)"facetsTheme");
        Intrinsics.checkNotNullParameter((Object)((Object)hAxisPosition), (String)"hAxisPosition");
        Intrinsics.checkNotNullParameter((Object)((Object)vAxisPosition), (String)"vAxisPosition");
        Intrinsics.checkNotNullParameter((Object)hAxisTheme, (String)"hAxisTheme");
        Intrinsics.checkNotNullParameter((Object)vAxisTheme, (String)"vAxisTheme");
        if (facets.isDefined()) {
            plotLayout = new FacetedPlotLayout(facets, layoutProviderByTile, facetsTheme.showStrip(), hAxisPosition, vAxisPosition, hAxisTheme, vAxisTheme);
        } else {
            TileLayout tileLayout = insideOut ? layoutProviderByTile.get(0).createInsideOutTileLayout() : layoutProviderByTile.get(0).createTopDownTileLayout();
            plotLayout = new SingleTilePlotLayout(tileLayout, hAxisPosition, vAxisPosition, hAxisTheme, vAxisTheme);
        }
        return plotLayout;
    }
}

