/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.algorithms.AdaptiveResampler;
import org.jetbrains.letsPlot.core.plot.base.scale.ScaleBreaks;
import org.jetbrains.letsPlot.core.plot.builder.AxisUtil;
import org.jetbrains.letsPlot.core.plot.builder.coord.PolarCoordinateSystem;
import org.jetbrains.letsPlot.core.plot.builder.guide.AxisComponent;
import org.jetbrains.letsPlot.core.plot.builder.guide.Orientation;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u0011\u0012B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J8\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/PolarAxisUtil;", "", "()V", "breaksData", "Lorg/jetbrains/letsPlot/core/plot/builder/PolarAxisUtil$PolarBreaksData;", "scaleBreaks", "Lorg/jetbrains/letsPlot/core/plot/base/scale/ScaleBreaks;", "coord", "Lorg/jetbrains/letsPlot/core/plot/builder/coord/PolarCoordinateSystem;", "gridDomain", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "flipAxis", "", "orientation", "Lorg/jetbrains/letsPlot/core/plot/builder/guide/Orientation;", "labelAdjustments", "Lorg/jetbrains/letsPlot/core/plot/builder/guide/AxisComponent$TickLabelAdjustments;", "Helper", "PolarBreaksData", "plot-builder"})
public final class PolarAxisUtil {
    @NotNull
    public static final PolarAxisUtil INSTANCE = new PolarAxisUtil();

    private PolarAxisUtil() {
    }

    @NotNull
    public final PolarBreaksData breaksData(@NotNull ScaleBreaks scaleBreaks, @NotNull PolarCoordinateSystem coord, @NotNull DoubleRectangle gridDomain, boolean flipAxis, @NotNull Orientation orientation, @NotNull AxisComponent.TickLabelAdjustments labelAdjustments) {
        Intrinsics.checkNotNullParameter((Object)scaleBreaks, (String)"scaleBreaks");
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        Intrinsics.checkNotNullParameter((Object)gridDomain, (String)"gridDomain");
        Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
        Intrinsics.checkNotNullParameter((Object)labelAdjustments, (String)"labelAdjustments");
        return new Helper(scaleBreaks, coord, gridDomain, flipAxis, orientation, labelAdjustments).breaksData();
    }

    public static /* synthetic */ PolarBreaksData breaksData$default(PolarAxisUtil polarAxisUtil, ScaleBreaks scaleBreaks, PolarCoordinateSystem polarCoordinateSystem, DoubleRectangle doubleRectangle, boolean bl, Orientation orientation, AxisComponent.TickLabelAdjustments tickLabelAdjustments, int n, Object object) {
        if ((n & 0x20) != 0) {
            tickLabelAdjustments = new AxisComponent.TickLabelAdjustments(orientation, null, null, 0.0, null, 30, null);
        }
        return polarAxisUtil.breaksData(scaleBreaks, polarCoordinateSystem, doubleRectangle, bl, orientation, tickLabelAdjustments);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0006\u0010\u001b\u001a\u00020\u001cJ\u001c\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u001eH\u0002J\"\u0010\"\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001f0\u001e0\u001e2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u001eH\u0002J\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0002J\u001c\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u001eH\u0002J\"\u0010%\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001f0\u001e0\u001e2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u001eH\u0002J\u001c\u0010&\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u001eH\u0002J\"\u0010'\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001f0\u001e0\u001e2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u001eH\u0002J\u0010\u0010(\u001a\u00020\u001f2\u0006\u0010)\u001a\u00020\u001fH\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006*"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/PolarAxisUtil$Helper;", "", "scaleBreaks", "Lorg/jetbrains/letsPlot/core/plot/base/scale/ScaleBreaks;", "coord", "Lorg/jetbrains/letsPlot/core/plot/builder/coord/PolarCoordinateSystem;", "gridDomain", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "flipAxis", "", "orientation", "Lorg/jetbrains/letsPlot/core/plot/builder/guide/Orientation;", "labelAdjustments", "Lorg/jetbrains/letsPlot/core/plot/builder/guide/AxisComponent$TickLabelAdjustments;", "(Lorg/jetbrains/letsPlot/core/plot/base/scale/ScaleBreaks;Lorg/jetbrains/letsPlot/core/plot/builder/coord/PolarCoordinateSystem;Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;ZLorg/jetbrains/letsPlot/core/plot/builder/guide/Orientation;Lorg/jetbrains/letsPlot/core/plot/builder/guide/AxisComponent$TickLabelAdjustments;)V", "getCoord", "()Lorg/jetbrains/letsPlot/core/plot/builder/coord/PolarCoordinateSystem;", "getFlipAxis", "()Z", "getGridDomain", "()Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "getLabelAdjustments", "()Lorg/jetbrains/letsPlot/core/plot/builder/guide/AxisComponent$TickLabelAdjustments;", "getOrientation", "()Lorg/jetbrains/letsPlot/core/plot/builder/guide/Orientation;", "getScaleBreaks", "()Lorg/jetbrains/letsPlot/core/plot/base/scale/ScaleBreaks;", "breaksData", "Lorg/jetbrains/letsPlot/core/plot/builder/PolarAxisUtil$PolarBreaksData;", "buildAngleBreaks", "", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "breaks", "", "buildAngleGrid", "buildAxis", "buildBreaks", "buildGrid", "buildRadiusBreaks", "buildRadiusGrid", "toClient", "v", "plot-builder"})
    @SourceDebugExtension(value={"SMAP\nPolarAxisUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PolarAxisUtil.kt\norg/jetbrains/letsPlot/core/plot/builder/PolarAxisUtil$Helper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,161:1\n1549#2:162\n1620#2,3:163\n1549#2:166\n1620#2,3:167\n1549#2:170\n1620#2,3:171\n1549#2:174\n1620#2,3:175\n1549#2:178\n1620#2,3:179\n1549#2:182\n1620#2,3:183\n1549#2:186\n1620#2,3:187\n1549#2:190\n1620#2,3:191\n766#2:194\n857#2,2:195\n1549#2:197\n1620#2,3:198\n766#2:201\n857#2,2:202\n1549#2:204\n1620#2,3:205\n1549#2:208\n1620#2,3:209\n*S KotlinDebug\n*F\n+ 1 PolarAxisUtil.kt\norg/jetbrains/letsPlot/core/plot/builder/PolarAxisUtil$Helper\n*L\n72#1:162\n72#1:163,3\n73#1:166\n73#1:167,3\n88#1:170\n88#1:171,3\n89#1:174\n89#1:175,3\n91#1:178\n91#1:179,3\n99#1:182\n99#1:183,3\n100#1:186\n100#1:187,3\n101#1:190\n101#1:191,3\n113#1:194\n113#1:195,2\n114#1:197\n114#1:198,3\n124#1:201\n124#1:202,2\n125#1:204\n125#1:205,3\n130#1:208\n130#1:209,3\n*E\n"})
    private static final class Helper {
        @NotNull
        private final ScaleBreaks scaleBreaks;
        @NotNull
        private final PolarCoordinateSystem coord;
        @NotNull
        private final DoubleRectangle gridDomain;
        private final boolean flipAxis;
        @NotNull
        private final Orientation orientation;
        @NotNull
        private final AxisComponent.TickLabelAdjustments labelAdjustments;

        public Helper(@NotNull ScaleBreaks scaleBreaks, @NotNull PolarCoordinateSystem coord, @NotNull DoubleRectangle gridDomain, boolean flipAxis, @NotNull Orientation orientation, @NotNull AxisComponent.TickLabelAdjustments labelAdjustments) {
            Intrinsics.checkNotNullParameter((Object)scaleBreaks, (String)"scaleBreaks");
            Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
            Intrinsics.checkNotNullParameter((Object)gridDomain, (String)"gridDomain");
            Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
            Intrinsics.checkNotNullParameter((Object)labelAdjustments, (String)"labelAdjustments");
            this.scaleBreaks = scaleBreaks;
            this.coord = coord;
            this.gridDomain = gridDomain;
            this.flipAxis = flipAxis;
            this.orientation = orientation;
            this.labelAdjustments = labelAdjustments;
        }

        public /* synthetic */ Helper(ScaleBreaks scaleBreaks, PolarCoordinateSystem polarCoordinateSystem, DoubleRectangle doubleRectangle, boolean bl, Orientation orientation, AxisComponent.TickLabelAdjustments tickLabelAdjustments, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 0x20) != 0) {
                tickLabelAdjustments = new AxisComponent.TickLabelAdjustments(orientation, null, null, 0.0, null, 30, null);
            }
            this(scaleBreaks, polarCoordinateSystem, doubleRectangle, bl, orientation, tickLabelAdjustments);
        }

        @NotNull
        public final ScaleBreaks getScaleBreaks() {
            return this.scaleBreaks;
        }

        @NotNull
        public final PolarCoordinateSystem getCoord() {
            return this.coord;
        }

        @NotNull
        public final DoubleRectangle getGridDomain() {
            return this.gridDomain;
        }

        public final boolean getFlipAxis() {
            return this.flipAxis;
        }

        @NotNull
        public final Orientation getOrientation() {
            return this.orientation;
        }

        @NotNull
        public final AxisComponent.TickLabelAdjustments getLabelAdjustments() {
            return this.labelAdjustments;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final PolarBreaksData breaksData() {
            void $this$mapTo$iv$iv;
            Collection collection;
            void $this$mapTo$iv$iv2;
            List list2;
            if (!(this.scaleBreaks.getTransformedValues().size() == this.scaleBreaks.getLabels().size())) {
                boolean $i$a$-check-PolarAxisUtil$Helper$breaksData$22 = false;
                String $i$a$-check-PolarAxisUtil$Helper$breaksData$22 = "Breaks and labels must have the same size";
                throw new IllegalStateException($i$a$-check-PolarAxisUtil$Helper$breaksData$22.toString());
            }
            List<Double> majorDomainBreaks = this.scaleBreaks.getTransformedValues();
            List majorLabels = this.scaleBreaks.getLabels();
            List<Double> minorDomainBreaks = AxisUtil.INSTANCE.minorDomainBreaks$plot_builder(majorDomainBreaks);
            List<DoubleVector> majorClientBreaks = this.buildBreaks(majorDomainBreaks);
            List<DoubleVector> minorClientBreaks = this.buildBreaks(minorDomainBreaks);
            List<List<DoubleVector>> majorGrid = this.buildGrid(majorDomainBreaks);
            List<List<DoubleVector>> minorGrid = this.buildGrid(minorDomainBreaks);
            List<DoubleVector> axisLine = this.buildAxis();
            if (majorClientBreaks.size() > 1 && ((DoubleVector)CollectionsKt.first(majorClientBreaks)).subtract((DoubleVector)CollectionsKt.last(majorClientBreaks)).length() <= 3.0) {
                List labels = CollectionsKt.toMutableList((Collection)majorLabels);
                labels.set(CollectionsKt.getLastIndex((List)labels), (String)labels.get(CollectionsKt.getLastIndex((List)labels)) + '/' + (String)labels.get(0));
                labels.set(0, "");
                list2 = labels;
            } else {
                list2 = majorLabels;
            }
            List labels = list2;
            DoubleVector center = this.toClient(this.gridDomain.getOrigin());
            double d = this.coord.getStartAngle();
            Iterable $this$map$iv = majorClientBreaks;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                DoubleVector doubleVector = (DoubleVector)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.subtract(center));
            }
            List list3 = (List)destination$iv$iv;
            Iterable $this$map$iv2 = minorClientBreaks;
            boolean $i$f$map2 = false;
            destination$iv$iv = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                DoubleVector bl = (DoubleVector)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(it.subtract(center));
            }
            List list4 = (List)destination$iv$iv2;
            return new PolarBreaksData(center, d, list3, labels, list4, majorGrid, minorGrid, axisLine);
        }

        private final DoubleVector toClient(DoubleVector v) {
            DoubleVector doubleVector = this.coord.toClient(v.flipIf(this.flipAxis));
            if (doubleVector == null) {
                throw new IllegalStateException("Unexpected null value".toString());
            }
            return doubleVector;
        }

        /*
         * WARNING - void declaration
         */
        private final List<DoubleVector> buildRadiusBreaks(List<Double> breaks) {
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            DoubleVector doubleVector = this.coord.toClient(this.gridDomain.getOrigin());
            Intrinsics.checkNotNull((Object)doubleVector);
            DoubleVector center = doubleVector;
            Iterable $this$map$iv = breaks;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void breakValue;
                double d = ((Number)item$iv$iv).doubleValue();
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new DoubleVector(this.gridDomain.xRange().getLowerEnd(), (double)breakValue));
            }
            $this$map$iv = (List)destination$iv$iv;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                DoubleVector breakValue = (DoubleVector)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this.toClient((DoubleVector)it));
            }
            $this$map$iv = (List)destination$iv$iv;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                DoubleVector it = (DoubleVector)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.rotateAround(center, this.coord.getStartAngle() * this.coord.getDirection()));
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        private final List<DoubleVector> buildAngleBreaks(List<Double> breaks) {
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            DoubleVector doubleVector = this.coord.toClient(this.gridDomain.getOrigin());
            Intrinsics.checkNotNull((Object)doubleVector);
            DoubleVector center = doubleVector;
            Iterable $this$map$iv = breaks;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                double d = ((Number)item$iv$iv).doubleValue();
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new DoubleVector((double)it, this.gridDomain.yRange().getUpperEnd()));
            }
            $this$map$iv = (List)destination$iv$iv;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                DoubleVector it = (DoubleVector)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this.toClient(it));
            }
            $this$map$iv = (List)destination$iv$iv;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                DoubleVector it = (DoubleVector)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.subtract(center).mul(1.0).add(center));
            }
            return (List)destination$iv$iv;
        }

        private final List<DoubleVector> buildBreaks(List<Double> breaks) {
            List<DoubleVector> list2;
            boolean bl = this.orientation.isHorizontal();
            if (bl) {
                list2 = this.buildAngleBreaks(breaks);
            } else if (!bl) {
                list2 = this.buildRadiusBreaks(breaks);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return list2;
        }

        /*
         * WARNING - void declaration
         */
        private final List<List<DoubleVector>> buildAngleGrid(List<Double> breaks) {
            void $this$mapTo$iv$iv;
            double it;
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv = breaks;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = ((Number)element$iv$iv).doubleValue();
                boolean bl = false;
                if (!this.gridDomain.xRange().contains(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void breakCoord;
                it = ((Number)item$iv$iv).doubleValue();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Object[] objectArray = new DoubleVector[]{this.toClient(new DoubleVector((double)breakCoord, this.gridDomain.yRange().getLowerEnd())), this.toClient(new DoubleVector((double)breakCoord, this.gridDomain.yRange().getUpperEnd()))};
                collection.add(CollectionsKt.listOf((Object[])objectArray));
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        private final List<List<DoubleVector>> buildRadiusGrid(List<Double> breaks) {
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            double it;
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv = breaks;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = ((Number)element$iv$iv).doubleValue();
                boolean bl = false;
                if (!this.gridDomain.yRange().contains(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = ((Number)item$iv$iv).doubleValue();
                collection = destination$iv$iv;
                boolean bl = false;
                Object[] objectArray = new DoubleVector[]{new DoubleVector(this.gridDomain.xRange().getLowerEnd(), it), new DoubleVector(this.gridDomain.xRange().getUpperEnd(), it)};
                collection.add(CollectionsKt.listOf((Object[])objectArray));
            }
            $this$map$iv = (List)destination$iv$iv;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void line2;
                List it2 = (List)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(AdaptiveResampler.Companion.resample((List<DoubleVector>)line2, 0.5, (Function1<? super DoubleVector, DoubleVector>)((Function1)new Function1<DoubleVector, DoubleVector>(this){
                    final /* synthetic */ Helper this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @Nullable
                    public final DoubleVector invoke(@NotNull DoubleVector it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return Helper.access$toClient(this.this$0, it);
                    }
                })));
            }
            return (List)destination$iv$iv;
        }

        private final List<DoubleVector> buildAxis() {
            List list2;
            boolean bl;
            boolean bl2 = bl = !this.orientation.isHorizontal();
            if (bl) {
                list2 = (List)CollectionsKt.single(this.buildAngleGrid(CollectionsKt.listOf((Object)this.gridDomain.xRange().getUpperEnd())));
            } else if (!bl) {
                list2 = (List)CollectionsKt.single(this.buildRadiusGrid(CollectionsKt.listOf((Object)this.gridDomain.yRange().getUpperEnd())));
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return list2;
        }

        private final List<List<DoubleVector>> buildGrid(List<Double> breaks) {
            List<List<DoubleVector>> list2;
            boolean bl = this.orientation.isHorizontal();
            if (bl) {
                list2 = this.buildAngleGrid(breaks);
            } else if (!bl) {
                list2 = this.buildRadiusGrid(breaks);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return list2;
        }

        public static final /* synthetic */ DoubleVector access$toClient(Helper $this, DoubleVector v) {
            return $this.toClient(v);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0011\u0018\u00002\u00020\u0001Bu\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0007\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u0012\u0012\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00070\u0007\u0012\u0012\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00070\u0007\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\u0002\u0010\u000eR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010R\u001d\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00070\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0010R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0010R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0010R\u001d\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00070\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/PolarAxisUtil$PolarBreaksData;", "", "center", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "startAngle", "", "majorBreaks", "", "majorLabels", "", "minorBreaks", "majorGrid", "minorGrid", "axisLine", "(Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;DLjava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "getAxisLine", "()Ljava/util/List;", "getCenter", "()Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "getMajorBreaks", "getMajorGrid", "getMajorLabels", "getMinorBreaks", "getMinorGrid", "getStartAngle", "()D", "plot-builder"})
    public static final class PolarBreaksData {
        @NotNull
        private final DoubleVector center;
        private final double startAngle;
        @NotNull
        private final List<DoubleVector> majorBreaks;
        @NotNull
        private final List<String> majorLabels;
        @NotNull
        private final List<DoubleVector> minorBreaks;
        @NotNull
        private final List<List<DoubleVector>> majorGrid;
        @NotNull
        private final List<List<DoubleVector>> minorGrid;
        @NotNull
        private final List<DoubleVector> axisLine;

        public PolarBreaksData(@NotNull DoubleVector center, double startAngle, @NotNull List<DoubleVector> majorBreaks, @NotNull List<String> majorLabels, @NotNull List<DoubleVector> minorBreaks, @NotNull List<? extends List<DoubleVector>> majorGrid, @NotNull List<? extends List<DoubleVector>> minorGrid, @NotNull List<DoubleVector> axisLine) {
            Intrinsics.checkNotNullParameter((Object)center, (String)"center");
            Intrinsics.checkNotNullParameter(majorBreaks, (String)"majorBreaks");
            Intrinsics.checkNotNullParameter(majorLabels, (String)"majorLabels");
            Intrinsics.checkNotNullParameter(minorBreaks, (String)"minorBreaks");
            Intrinsics.checkNotNullParameter(majorGrid, (String)"majorGrid");
            Intrinsics.checkNotNullParameter(minorGrid, (String)"minorGrid");
            Intrinsics.checkNotNullParameter(axisLine, (String)"axisLine");
            this.center = center;
            this.startAngle = startAngle;
            this.majorBreaks = majorBreaks;
            this.majorLabels = majorLabels;
            this.minorBreaks = minorBreaks;
            this.majorGrid = majorGrid;
            this.minorGrid = minorGrid;
            this.axisLine = axisLine;
        }

        @NotNull
        public final DoubleVector getCenter() {
            return this.center;
        }

        public final double getStartAngle() {
            return this.startAngle;
        }

        @NotNull
        public final List<DoubleVector> getMajorBreaks() {
            return this.majorBreaks;
        }

        @NotNull
        public final List<String> getMajorLabels() {
            return this.majorLabels;
        }

        @NotNull
        public final List<DoubleVector> getMinorBreaks() {
            return this.minorBreaks;
        }

        @NotNull
        public final List<List<DoubleVector>> getMajorGrid() {
            return this.majorGrid;
        }

        @NotNull
        public final List<List<DoubleVector>> getMinorGrid() {
            return this.minorGrid;
        }

        @NotNull
        public final List<DoubleVector> getAxisLine() {
            return this.axisLine;
        }
    }
}

